/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.sparqlify.database.MapStoreAccessor;
import org.aksw.sparqlify.database.MetaIndexFactory;
import org.aksw.sparqlify.database.PrefixConstraint;
import org.aksw.sparqlify.database.PrefixMapStoreAccessor;
import org.aksw.sparqlify.database.Table;
import org.apache.commons.collections15.Transformer;

public class PrefixIndexMetaFactory
implements MetaIndexFactory {
    public static Set<Class<?>> supportedConstraintClasses = new HashSet();
    private Transformer<Object, Set<String>> prefixExtractor;

    public Set<Class<?>> getSupportedConstraintClasses() {
        return supportedConstraintClasses;
    }

    public PrefixIndexMetaFactory(Transformer<Object, Set<String>> prefixExtractor) {
        this.prefixExtractor = prefixExtractor;
    }

    @Override
    public MapStoreAccessor create(Table table, List<String> columnNames) {
        int[] indexColumns = new int[columnNames.size()];
        for (int i = 0; i < indexColumns.length; ++i) {
            String columnName = columnNames.get(i);
            indexColumns[i] = table.getColumns().getIndex(columnName);
        }
        PrefixMapStoreAccessor accessor = new PrefixMapStoreAccessor(indexColumns, this.prefixExtractor);
        return accessor;
    }

    static {
        supportedConstraintClasses.add(PrefixConstraint.class);
    }
}

