/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aksw.sparqlify.database.AbstractIndex;
import org.aksw.sparqlify.database.IndexMetaNode;
import org.aksw.sparqlify.database.MapStoreAccessor;
import org.aksw.sparqlify.database.Table;

public class TreeIndex
extends AbstractIndex {
    private IndexMetaNode root;
    private Object store;

    public TreeIndex(Table table, IndexMetaNode root) {
        super(table, null, null);
        this.root = root;
        this.store = root.getFactory().createStore();
    }

    @Override
    public Object getStore() {
        return this.store;
    }

    public void add(List row) {
        this.add((List<Object>)row, this.root, this.store);
    }

    private void add(List row, List<IndexMetaNode> nodes, List<Object> stores) {
        Iterator<IndexMetaNode> itNode = nodes.iterator();
        Iterator<Object> itStore = stores.iterator();
        while (itNode.hasNext()) {
            IndexMetaNode node = itNode.next();
            Object store = itStore.next();
            this.add((List<Object>)row, node, store);
        }
    }

    private void add(List<Object> row, IndexMetaNode node, Object store) {
        List<IndexMetaNode> children = node.getChildren();
        MapStoreAccessor accessor = node.getFactory();
        Object value = accessor.get(store, row);
        switch (children.size()) {
            case 0: {
                ArrayList<List<Object>> rows = (ArrayList<List<Object>>)value;
                if (rows == null) {
                    rows = new ArrayList<List<Object>>();
                    accessor.put(store, row, rows);
                }
                rows.add(row);
                break;
            }
            case 1: {
                Object subStore = value;
                IndexMetaNode subNode = node.getChildren().iterator().next();
                if (subStore == null) {
                    subStore = subNode.getFactory().createStore();
                    accessor.put(store, row, subStore);
                }
                this.add(row, subNode, subStore);
                break;
            }
            default: {
                ArrayList<Object> subStores = (ArrayList<Object>)value;
                if (subStores == null) {
                    subStores = new ArrayList<Object>(children.size());
                    for (IndexMetaNode child : children) {
                        subStores.add(child.getFactory().createStore());
                    }
                    accessor.put(store, row, subStores);
                }
                this.add(row, children, (List<Object>)subStores);
            }
        }
    }

    @Override
    public IndexMetaNode getRoot() {
        return this.root;
    }

    public static TreeIndex attach(Table table, IndexMetaNode node) {
        TreeIndex index = new TreeIndex(table, node);
        table.addIndex(index);
        return index;
    }

    public String toString() {
        return "TreeIndex [root=" + this.root + ", store=" + this.store + "]";
    }
}

