/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.sparqlview;

import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.jena_sparql_api.views.IViewDef;
import org.aksw.jena_sparql_api.views.SparqlView;
import org.aksw.jena_sparql_api.views.VarBinding;
import org.aksw.jena_sparql_api.views.VarsMentioned;
import org.aksw.jena_sparql_api.views.ViewInstance;
import org.aksw.sparqlify.database.GetVarsMentioned;
import org.aksw.sparqlify.sparqlview.ViewInstanceJoin;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpSparqlViewPattern
extends OpExt
implements VarsMentioned {
    private ViewInstanceJoin<SparqlView> conjunction;

    public OpSparqlViewPattern(ViewInstanceJoin<SparqlView> conjunction) {
        super(OpSparqlViewPattern.class.getSimpleName());
        this.conjunction = conjunction;
    }

    public ViewInstanceJoin<SparqlView> getConjunction() {
        return this.conjunction;
    }

    public Op effectiveOp() {
        Op a = null;
        Op b = null;
        for (ViewInstance<SparqlView> instance : this.conjunction.getViewInstances()) {
            b = instance.getViewDefinition().getOp();
            HashMap renamer = new HashMap();
            HashSet constraints = new HashSet();
            HashMultimap extraProjection = HashMultimap.create();
            VarBinding varBinding = instance.getBinding();
            IBiSetMultimap<Var, Var> dest = varBinding.getViewVarToQueryVars();
            for (Map.Entry entry : dest.asMap().entrySet()) {
                Var x = null;
                for (Var var : (Collection)entry.getValue()) {
                    if (x == null) {
                        x = var;
                        continue;
                    }
                    extraProjection.put((Object)x, (Object)var);
                }
                renamer.put(entry.getKey(), x);
            }
            IViewDef renamed = instance.getViewDefinition().copyRenameVars((Map)renamer);
            b = ((SparqlView)renamed).getOp();
            VarExprList veList = new VarExprList();
            Map<Var, Node> keyToValue = varBinding.getQueryVarToConstant();
            if (!extraProjection.isEmpty() || !keyToValue.isEmpty()) {
                for (Map.Entry entry : extraProjection.entries()) {
                    veList.add((Var)entry.getValue(), (Expr)new ExprVar((Var)entry.getKey()));
                }
                for (Map.Entry entry : keyToValue.entrySet()) {
                    Node node = (Node)entry.getValue();
                    if (node == null) continue;
                    veList.add((Var)entry.getKey(), (Expr)NodeValue.makeNode((Node)node));
                }
                if (!veList.isEmpty()) {
                    b = OpExtend.extend((Op)b, (VarExprList)veList);
                }
            }
            if (a == null) {
                a = b;
                continue;
            }
            a = OpJoin.create((Op)a, (Op)b);
        }
        return a;
    }

    public QueryIterator eval(QueryIterator input, ExecutionContext execCxt) {
        return null;
    }

    public void outputArgs(IndentedWriter out, SerializationContext sCxt) {
        out.print(this.conjunction.getViewNames() + " " + this.conjunction.getRestrictions() + " " + this.conjunction);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conjunction == null ? 0 : this.conjunction.hashCode());
        return result;
    }

    public boolean equalTo(Op obj, NodeIsomorphismMap labelMap) {
        if (this == obj) {
            return true;
        }
        if (!super.equals((Object)obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpSparqlViewPattern other = (OpSparqlViewPattern)obj;
        return !(this.conjunction == null ? other.conjunction != null : !this.conjunction.equals(other.conjunction));
    }

    @Override
    public Set<Var> varsMentioned() {
        return GetVarsMentioned.getVarsMentioned(this.effectiveOp());
    }
}

