/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.sparqlview;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.jena_sparql_api.restriction.RestrictionImpl;
import org.aksw.jena_sparql_api.views.SparqlView;
import org.aksw.jena_sparql_api.views.TwoWayBinding;
import org.aksw.jena_sparql_api.views.VarDef;
import org.aksw.sparqlify.sparqlview.ViewInstanceOld;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;

public class SparqlViewInstance
extends ViewInstanceOld {
    private SparqlView instance;
    private SparqlView parent;

    public SparqlViewInstance(Quad queryQuad, Quad viewQuad, int instanceId, int subId, SparqlView parent, TwoWayBinding binding) {
        super(queryQuad, viewQuad, instanceId, subId, binding);
        this.parent = parent;
        throw new RuntimeException("If we come here, we need to fix the following line");
    }

    public SparqlViewInstance copy() {
        return new SparqlViewInstance(this.queryQuad, this.viewQuad, this.instanceId, this.subId, this.parent, this.binding.copySubstitute(null));
    }

    public SparqlView getInstance() {
        return this.instance;
    }

    public SparqlView getParent() {
        return this.parent;
    }

    public Expr getDefiningExpr(Var var) {
        Node parentName = (Node)this.renamer.inverse().get((Object)var);
        return this.parent.getBinding().get(parentName);
    }

    public List<Expr> getInferredDefiningExprs(Var var) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Var e : this.binding.getEquiMap().getEquivalences(var, true)) {
            Expr definingExpr = this.getDefiningExpr(e);
            if (definingExpr == null) continue;
            result.add(definingExpr);
        }
        Node constant = this.binding.getEquiMap().getKeyToValue().get(var);
        if (constant != null) {
            result.add((Expr)new E_Equals((Expr)new ExprVar(var), (Expr)NodeValue.makeNode((Node)constant)));
        }
        return result;
    }

    @Override
    public boolean isViewVariable(Var var) {
        return var.getName().startsWith("view");
    }

    @Override
    public SetMultimap<Var, Var> getQueryToParentBinding() {
        HashMultimap result = HashMultimap.create();
        for (Map.Entry entry : this.binding.getEquiMap().getEquivalences().entries()) {
            Var back = (Var)this.renamer.inverse().get(entry.getValue());
            if (back == null) continue;
            result.put(entry.getKey(), (Object)back);
        }
        return result;
    }

    @Override
    public SetMultimap<Var, Var> getParentToQueryBinding() {
        HashMultimap result = HashMultimap.create();
        for (Map.Entry entry : this.binding.getEquiMap().getEquivalences().entries()) {
            Var back = (Var)this.renamer.inverse().get(entry.getValue());
            if (back == null) continue;
            result.put((Object)back, entry.getKey());
        }
        return result;
    }

    @Override
    public QuadPattern getQueryQuads() {
        return this.queryQuads;
    }

    @Override
    public QuadPattern getViewQuads() {
        return this.viewQuads;
    }

    @Override
    public Quad getQueryQuad() {
        return this.queryQuad;
    }

    @Override
    public Quad getViewQuad() {
        return this.queryQuad;
    }

    @Override
    public int getInstanceId() {
        return this.instanceId;
    }

    @Override
    public BiMap<Node, Node> getRenamer() {
        return this.renamer;
    }

    @Override
    public TwoWayBinding getBinding() {
        return this.binding;
    }

    public Multimap<Var, VarDef> getSqlBinding() {
        HashMultimap result = HashMultimap.create();
        Map<Node, Expr> parentBinding = this.parent.getBinding();
        for (Map.Entry<Node, Expr> entry : parentBinding.entrySet()) {
            Var node = (Var)this.renamer.get((Object)entry.getKey());
            RestrictionImpl r = this.parent.getRestrictions().getRestriction((Var)entry.getKey());
            IBiSetMultimap reverse = this.binding.getEquiMap().getEquivalences().getInverse();
            Set queryVars = reverse.get((Object)node);
            for (Var queryVar : queryVars) {
                result.put((Object)queryVar, (Object)new VarDef(entry.getValue(), r));
            }
        }
        return result;
    }

    public String toString() {
        return this.parent.getName() + " " + this.queryQuad + " " + this.binding;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.instanceId;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + this.subId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparqlViewInstance other = (SparqlViewInstance)obj;
        if (this.instanceId != other.instanceId) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return this.subId == other.subId;
    }
}

