/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.sparqlview;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.aksw.commons.collections.CartesianProduct;
import org.aksw.commons.collections.stacks.NestedStack;
import org.aksw.commons.util.Pair;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.jena_sparql_api.exprs_ext.E_StrConcatPermissive;
import org.aksw.jena_sparql_api.normal_form.Clause;
import org.aksw.jena_sparql_api.restriction.RestrictionImpl;
import org.aksw.jena_sparql_api.restriction.RestrictionManagerImpl;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.aksw.jena_sparql_api.utils.ReplaceConstants;
import org.aksw.jena_sparql_api.utils.expr.NodeValueUtils;
import org.aksw.jena_sparql_api.views.Dialect;
import org.aksw.jena_sparql_api.views.MyOpAsQuery;
import org.aksw.jena_sparql_api.views.PrefixSet;
import org.aksw.jena_sparql_api.views.RdfTermType;
import org.aksw.jena_sparql_api.views.SparqlView;
import org.aksw.jena_sparql_api.views.TwoWayBinding;
import org.aksw.sparqlify.database.Constraint;
import org.aksw.sparqlify.database.EqualsConstraint;
import org.aksw.sparqlify.database.IndexMetaNode;
import org.aksw.sparqlify.database.IsPrefixOfConstraint;
import org.aksw.sparqlify.database.MetaIndexFactory;
import org.aksw.sparqlify.database.OpFilterIndexed;
import org.aksw.sparqlify.database.PrefixIndex;
import org.aksw.sparqlify.database.PrefixIndexMetaFactory;
import org.aksw.sparqlify.database.StartsWithConstraint;
import org.aksw.sparqlify.database.Table;
import org.aksw.sparqlify.database.TableBuilder;
import org.aksw.sparqlify.database.TreeIndex;
import org.aksw.sparqlify.database.VariableConstraint;
import org.aksw.sparqlify.sparqlview.ISparqlViewSystem;
import org.aksw.sparqlify.sparqlview.OpSparqlViewPattern;
import org.aksw.sparqlify.sparqlview.SparqlViewConjunction;
import org.aksw.sparqlify.sparqlview.SparqlViewInstance;
import org.aksw.sparqlify.sparqlview.ViewQuad;
import org.apache.commons.collections15.Transformer;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_StrConcat;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlViewSystem
implements ISparqlViewSystem {
    private Logger logger = LoggerFactory.getLogger(SparqlViewSystem.class);
    private int viewId = 1;
    private Table<Object> table;
    PrefixIndex<Object> idxTest;
    private Set<SparqlView> views = new HashSet<SparqlView>();
    private static final String[] columnNames = new String[]{"g_prefix", "s_prefix", "p_prefix", "o_prefix"};

    public SparqlViewSystem() {
        TableBuilder<Object> builder = new TableBuilder<Object>();
        builder.addColumn("g_prefix", String.class);
        builder.addColumn("s_prefix", String.class);
        builder.addColumn("p_prefix", String.class);
        builder.addColumn("o_type", Integer.class);
        builder.addColumn("o_prefix", String.class);
        builder.addColumn("view", ViewQuad.class);
        this.table = builder.create();
        Transformer<Object, Set<String>> prefixExtractor = new Transformer<Object, Set<String>>(){

            public Set<String> transform(Object input) {
                return Collections.singleton(input.toString());
            }
        };
        PrefixIndexMetaFactory factory = new PrefixIndexMetaFactory(prefixExtractor);
        IndexMetaNode root = IndexMetaNode.create(this.table, (MetaIndexFactory)factory, "s_prefix");
        IndexMetaNode s = IndexMetaNode.create(root, (MetaIndexFactory)factory, "p_prefix");
        TreeIndex.attach(this.table, root);
        IndexMetaNode root2 = IndexMetaNode.create(this.table, (MetaIndexFactory)factory, "p_prefix");
        IndexMetaNode s2 = IndexMetaNode.create(root2, (MetaIndexFactory)factory, "s_prefix");
        TreeIndex.attach(this.table, root2);
    }

    public static Query rewrite(Query query, SparqlViewSystem system, Dialect dialect) {
        Op rewrittenOp = system.getApplicableViews(query);
        Query result = MyOpAsQuery.asQuery(rewrittenOp, dialect);
        System.out.println("Rewritten query: " + result);
        return result;
    }

    @Override
    public void addView(SparqlView view) {
        ++this.viewId;
        Set<Var> vars = view.getVarsMentioned();
        HashMap<Node, Node> rename = new HashMap<Node, Node>();
        for (Var var : vars) {
            rename.put((Node)var, (Node)Var.alloc((String)("view" + this.viewId + "_" + var.getName())));
        }
        SparqlView copy = view.copySubstitute(rename);
        System.out.println("Renamed: " + copy);
        this.views.add(copy);
        this.index(copy);
    }

    public static Constraint deriveConstraint(Expr expr) {
        if (expr instanceof E_StrConcat || expr instanceof E_StrConcatPermissive) {
            return SparqlViewSystem.deriveConstraint(expr);
        }
        return null;
    }

    public static StartsWithConstraint deriveConstraint(E_StrConcat expr) {
        return SparqlViewSystem.deriveConstraint(expr);
    }

    public static StartsWithConstraint deriveConstraint(E_StrConcatPermissive expr) {
        return SparqlViewSystem.deriveConstraint(expr);
    }

    public static StartsWithConstraint deriveConstraintConcat(ExprFunction concat) {
        Expr arg;
        String prefix = "";
        Iterator iterator = concat.getArgs().iterator();
        while (iterator.hasNext() && (arg = (Expr)iterator.next()).isConstant()) {
            prefix = prefix + arg.getConstant().asUnquotedString();
        }
        return new StartsWithConstraint(prefix);
    }

    public Map<Var, RdfTermType> deriveTypeConstraints(SparqlView view) {
        HashMap<Var, RdfTermType> result = new HashMap<Var, RdfTermType>();
        for (Map.Entry<Node, Expr> entry : view.getBinding().entrySet()) {
            Var var = (Var)entry.getKey();
            ExprFunction termCtor = (ExprFunction)entry.getValue();
            String functionIri = termCtor.getFunctionSymbol().getSymbol();
            if (functionIri.equals("http://aksw.org/sparqlify/rdfTerm")) {
                Expr arg = termCtor.getArg(1);
                if (!arg.isConstant()) continue;
                Object o = NodeValueUtils.getValue((NodeValue)arg.getConstant());
                Number number = (Number)o;
                switch (number.intValue()) {
                    case 1: {
                        result.put(var, RdfTermType.URI);
                        break;
                    }
                    case 2: 
                    case 3: {
                        result.put(var, RdfTermType.LITERAL);
                    }
                }
                continue;
            }
            if (functionIri.equals("http://aksw.org/sparqlify/uri")) {
                result.put(var, RdfTermType.URI);
                continue;
            }
            if (!functionIri.equals("http://aksw.org/sparqlify/plainLiteral") && !functionIri.equals("http://aksw.org/sparqlify/typedLiteral")) continue;
            result.put(var, RdfTermType.LITERAL);
        }
        return result;
    }

    public void deriveRestrictions(SparqlView view) {
    }

    public static RdfTermType getType(Node node, RestrictionManagerImpl restrictions) {
        if (node.isVariable()) {
            RestrictionImpl r = restrictions.getRestriction((Var)node);
            if (r != null) {
                return r.getType();
            }
        } else {
            if (node.isURI()) {
                return RdfTermType.URI;
            }
            if (node.isLiteral()) {
                return RdfTermType.LITERAL;
            }
        }
        return RdfTermType.UNKNOWN;
    }

    private void index(SparqlView view) {
        if (view.getName().equals("lgd_node_tags_string")) {
            System.out.println("Debug");
        }
        RestrictionManagerImpl restrictions = new RestrictionManagerImpl();
        view.setRestrictions(restrictions);
        this.deriveRestrictions(view);
        for (Quad quad : view.getQuadPattern()) {
            ArrayList<Collection<Object>> collections = new ArrayList<Collection<Object>>();
            for (int i = 0; i < 4; ++i) {
                Node node = QuadUtils.getNode((Quad)quad, (int)i);
                if (i == 3) {
                    RdfTermType type = SparqlViewSystem.getType(node, restrictions);
                    switch (type) {
                        case URI: {
                            collections.add(Collections.singleton(1));
                            break;
                        }
                        case LITERAL: {
                            collections.add(Collections.singleton(2));
                            break;
                        }
                        default: {
                            collections.add(Arrays.asList(1, 2));
                        }
                    }
                }
                if (node.isVariable()) {
                    PrefixSet p = null;
                    if (p != null) {
                        collections.add(p.getSet());
                        continue;
                    }
                    collections.add(Collections.singleton(""));
                    continue;
                }
                if (node.isURI()) {
                    collections.add(Collections.singleton(node.getURI()));
                    continue;
                }
                throw new RuntimeException("Should not happen");
            }
            ViewQuad viewQuad = new ViewQuad(view, quad);
            CartesianProduct cartesian = new CartesianProduct(collections);
            for (List item : cartesian) {
                ArrayList<ViewQuad> row = new ArrayList<ViewQuad>(item);
                row.add(viewQuad);
                this.table.add(row);
            }
        }
    }

    @Override
    public Op getApplicableViews(Query query) {
        Op augmented;
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        op = ReplaceConstants.replace((Op)op);
        if (query.isSelectType() && query.isQueryResultStar()) {
            List vars = query.getProjectVars();
            op = new OpProject(op, vars);
        }
        System.out.println("Quad form:" + op);
        Op result = augmented = this._getApplicableViews(op);
        System.out.println(result);
        return result;
    }

    public static VariableConstraint deriveIsPrefixOfConstraint(Expr a, Expr b) {
        if (!a.isVariable() || !b.isConstant()) {
            return null;
        }
        Object value = NodeValueUtils.getValue((NodeValue)b.getConstant());
        return new VariableConstraint(a.getVarName(), new IsPrefixOfConstraint(value.toString()));
    }

    public static VariableConstraint deriveViewLookupConstraint(Expr expr) {
        if (expr instanceof E_Equals) {
            E_Equals e = (E_Equals)expr;
            VariableConstraint c = SparqlViewSystem.deriveIsPrefixOfConstraint(e.getArg1(), e.getArg2());
            if (c == null) {
                c = SparqlViewSystem.deriveIsPrefixOfConstraint(e.getArg2(), e.getArg1());
            }
            return c;
        }
        return null;
    }

    public List<SparqlViewConjunction> getApplicableViewsBase(OpQuadPattern op, RestrictionManagerImpl restrictions) {
        ArrayList<SparqlViewConjunction> result = new ArrayList<SparqlViewConjunction>();
        QuadPattern queryQuads = op.getPattern();
        Pair<NavigableMap<Integer, Set<Quad>>, Map<Quad, Set<ViewQuad>>> candidates = this.findQuadWithFewestViewCandidates(queryQuads, restrictions);
        NavigableMap nToQuads = (NavigableMap)candidates.getKey();
        Map quadToCandidates = (Map)candidates.getValue();
        ArrayList<Quad> order = new ArrayList<Quad>();
        for (Set quads : nToQuads.values()) {
            order.addAll(quads);
        }
        System.out.println("Order:\n" + Joiner.on((String)"\n").join(order));
        Set viewQuads = (Set)quadToCandidates.get(order.get(0));
        this.getApplicableViewsRec2(0, order, viewQuads, quadToCandidates, restrictions, null, result);
        return result;
    }

    public Set<ViewQuad> findCandidates(Quad quad, RestrictionManagerImpl restrictions) {
        HashSet constraints = new HashSet();
        Set quadVars = QuadUtils.getVarsMentioned((Quad)quad);
        Set<Clause> dnf = restrictions.getEffectiveDnf(quadVars);
        RestrictionImpl[] termRestriction = new RestrictionImpl[4];
        for (Clause clause : dnf) {
            HashMap<String, Constraint> hashMap = new HashMap<String, Constraint>();
            for (int i = 0; i < 4; ++i) {
                RestrictionImpl r;
                Node n = QuadUtils.getNode((Quad)quad, (int)i);
                if (!(n instanceof Var)) {
                    System.out.println("debug");
                }
                Var var = (Var)QuadUtils.getNode((Quad)quad, (int)i);
                termRestriction[i] = r = clause.getRestriction(var);
                if (r == null || !r.getType().equals((Object)RdfTermType.URI) || !r.hasConstant()) continue;
                String columnName = columnNames[i];
                hashMap.put(columnName, new IsPrefixOfConstraint(r.getNode().getURI()));
            }
            RestrictionImpl r = termRestriction[3];
            if (r != null) {
                switch (r.getType()) {
                    case URI: {
                        hashMap.put("o_type", new EqualsConstraint(1));
                        break;
                    }
                    case LITERAL: {
                        hashMap.put("o_type", new EqualsConstraint(2));
                    }
                }
            }
            constraints.add(hashMap);
        }
        if (constraints.isEmpty()) {
            constraints.add(new HashMap());
        }
        HashSet<ViewQuad> viewQuads = new HashSet<ViewQuad>();
        for (Map map : constraints) {
            Collection<List<Object>> rows = this.table.select(map);
            for (List<Object> row : rows) {
                ViewQuad viewQuad = (ViewQuad)row.get(row.size() - 1);
                viewQuads.add(viewQuad);
            }
        }
        return viewQuads;
    }

    public Pair<NavigableMap<Integer, Set<Quad>>, Map<Quad, Set<ViewQuad>>> findQuadWithFewestViewCandidates(QuadPattern queryQuads, RestrictionManagerImpl restrictions) {
        TreeMap<Integer, HashSet<Quad>> nToQuads = new TreeMap<Integer, HashSet<Quad>>();
        HashMap<Quad, Set<ViewQuad>> quadToCandidates = new HashMap<Quad, Set<ViewQuad>>();
        for (Quad quad : queryQuads) {
            if (quadToCandidates.containsKey(quad)) continue;
            Set<ViewQuad> viewQuads = this.findCandidates(quad, restrictions);
            int n = viewQuads.size();
            HashSet<Quad> nQuads = (HashSet<Quad>)nToQuads.get(n);
            if (nQuads == null) {
                nQuads = new HashSet<Quad>();
                nToQuads.put(n, nQuads);
            }
            nQuads.add(quad);
            quadToCandidates.put(quad, viewQuads);
        }
        return Pair.create(nToQuads, quadToCandidates);
    }

    public static List<String> getCandidateNames(NestedStack<SparqlViewInstance> instances) {
        ArrayList<String> viewNames = new ArrayList<String>();
        if (instances != null) {
            for (SparqlViewInstance instance : instances.asList()) {
                viewNames.add(instance.getParent().getName());
            }
        }
        return viewNames;
    }

    public void getApplicableViewsRec2(int index, List<Quad> quadOrder, Set<ViewQuad> viewQuads, Map<Quad, Set<ViewQuad>> candidates, RestrictionManagerImpl restrictions, NestedStack<SparqlViewInstance> instances, List<SparqlViewConjunction> result) {
        List<String> debug = Arrays.asList("view_nodes", "node_tags_resource_kv");
        ArrayList<String> viewNames = new ArrayList<String>();
        if (instances != null) {
            for (SparqlViewInstance instance : instances.asList()) {
                viewNames.add(instance.getParent().getName());
            }
        }
        if (index >= quadOrder.size()) {
            throw new RuntimeException("Should not happen");
        }
        int nextIndex = index + 1;
        boolean isRecursionEnd = nextIndex == quadOrder.size();
        Quad queryQuad = quadOrder.get(index);
        int subId = 0;
        for (ViewQuad viewQuad : viewQuads) {
            ++subId;
            String viewName = viewQuad.getView().getName();
            if (viewName.equals("view_nodes")) {
                System.out.println("debug");
            }
            if (viewNames.containsAll(debug) && viewName.equals("view_lgd_relation_specific_resources")) {
                System.out.println("debug");
            }
            if (viewName.equals("view_lgd_relation_specific_resources")) {
                System.out.println("debug");
            }
            RestrictionManagerImpl subRestrictions = new RestrictionManagerImpl(restrictions);
            RestrictionManagerImpl viewRestrictions = viewQuad.getView().getRestrictions();
            for (int i = 0; i < 4; ++i) {
                Var queryVar = (Var)QuadUtils.getNode((Quad)queryQuad, (int)i);
                Node viewNode = QuadUtils.getNode((Quad)viewQuad.getQuad(), (int)i);
                if (viewNode.isVariable()) {
                    Var viewVar = (Var)viewNode;
                    RestrictionImpl viewRs = viewRestrictions.getRestriction(viewVar);
                    if (viewRs != null) {
                        subRestrictions.stateRestriction(queryVar, viewRs);
                    }
                    if (subRestrictions.isUnsatisfiable() || subRestrictions.isUnsatisfiable()) {
                        break;
                    }
                } else {
                    subRestrictions.stateNode(queryVar, viewNode);
                }
                if (subRestrictions.isUnsatisfiable()) break;
            }
            if (subRestrictions.isUnsatisfiable()) continue;
            TwoWayBinding binding = TwoWayBinding.getVarMappingTwoWay(queryQuad, viewQuad.getQuad());
            int instanceId = index;
            SparqlViewInstance instance = new SparqlViewInstance(queryQuad, viewQuad.getQuad(), instanceId, subId, viewQuad.getView(), binding);
            NestedStack nextInstances = new NestedStack(instances, (Object)instance);
            if (isRecursionEnd) {
                System.out.println("got: " + SparqlViewSystem.getCandidateNames((NestedStack<SparqlViewInstance>)nextInstances));
                SparqlViewConjunction viewConjunction = new SparqlViewConjunction(nextInstances.asList(), subRestrictions);
                result.add(viewConjunction);
                continue;
            }
            Quad nextQuad = quadOrder.get(nextIndex);
            Set<ViewQuad> nextCandidates = this.findCandidates(nextQuad, subRestrictions);
            this.getApplicableViewsRec2(nextIndex, quadOrder, nextCandidates, candidates, subRestrictions, (NestedStack<SparqlViewInstance>)nextInstances, result);
        }
    }

    public Op getApplicableViews(OpQuadPattern op, RestrictionManagerImpl restrictions) {
        throw new RuntimeException("Dont use this class anymore");
    }

    public static boolean isSatisfiable(List<SparqlViewInstance> list) {
        TwoWayBinding completeBinding = new TwoWayBinding();
        boolean isOk = true;
        for (SparqlViewInstance item : list) {
            if (!completeBinding.isCompatible(item.getBinding())) {
                isOk = false;
                break;
            }
            completeBinding.addAll(item.getBinding());
        }
        return isOk;
    }

    public Op _getApplicableViews(Op op) {
        return this._getApplicableViews(op, new RestrictionManagerImpl());
    }

    public Op _getApplicableViews(Op op, RestrictionManagerImpl restrictions) {
        return (Op)MultiMethod.invoke((Object)this, (String)"getApplicableViews", (Object[])new Object[]{op, restrictions});
    }

    public Op getApplicableViews(OpProject op, RestrictionManagerImpl restrictions) {
        return new OpProject(this._getApplicableViews(op.getSubOp(), restrictions), op.getVars());
    }

    public Op getApplicableViews(OpOrder op, RestrictionManagerImpl restrictions) {
        return new OpOrder(this._getApplicableViews(op.getSubOp(), restrictions), op.getConditions());
    }

    public Op getApplicableViews(OpGroup op, RestrictionManagerImpl restrictions) {
        return new OpGroup(this._getApplicableViews(op.getSubOp(), restrictions), op.getGroupVars(), op.getAggregators());
    }

    public Op getApplicableViews(OpExtend op, RestrictionManagerImpl _restrictions) {
        return OpExtend.extend((Op)this._getApplicableViews(op.getSubOp()), (VarExprList)op.getVarExprList());
    }

    public Op getApplicableViews(OpFilter op, RestrictionManagerImpl restrictions) {
        RestrictionManagerImpl subRestrictions = new RestrictionManagerImpl(restrictions);
        for (Expr expr : op.getExprs()) {
            subRestrictions.stateExpr(expr);
        }
        return OpFilterIndexed.filter(subRestrictions, this._getApplicableViews(op.getSubOp(), subRestrictions));
    }

    public Op getApplicableViews(OpUnion op, RestrictionManagerImpl restrictions) {
        RestrictionManagerImpl subRestrictionsLeft = new RestrictionManagerImpl(restrictions);
        RestrictionManagerImpl subRestrictionsRight = new RestrictionManagerImpl(restrictions);
        return OpDisjunction.create((Op)this._getApplicableViews(op.getLeft(), subRestrictionsLeft), (Op)this._getApplicableViews(op.getRight(), subRestrictionsRight));
    }

    public Op getApplicableViews(OpJoin op, RestrictionManagerImpl restrictions) {
        return OpJoin.create((Op)this._getApplicableViews(op.getLeft(), restrictions), (Op)this._getApplicableViews(op.getRight(), restrictions));
    }

    public Op getApplicableViews(OpLeftJoin op, RestrictionManagerImpl restrictions) {
        Op left = this._getApplicableViews(op.getLeft(), restrictions);
        RestrictionManagerImpl subRestrictions = new RestrictionManagerImpl(restrictions);
        RestrictionManagerImpl moreRestrictions = SparqlViewSystem.getRestrictions2(left);
        if (moreRestrictions != null) {
            subRestrictions.stateRestriction(moreRestrictions);
        }
        if (op.getExprs() != null) {
            for (Expr expr : op.getExprs()) {
                subRestrictions.stateExpr(expr);
            }
        }
        Op right = this._getApplicableViews(op.getRight(), subRestrictions);
        return OpLeftJoin.create((Op)left, (Op)right, (ExprList)new ExprList());
    }

    public Op getApplicableViews(OpSlice op, RestrictionManagerImpl restrictions) {
        return new OpSlice(this._getApplicableViews(op.getSubOp(), restrictions), op.getStart(), op.getLength());
    }

    public Op getApplicableViews(OpDistinct op, RestrictionManagerImpl restrictions) {
        return new OpDistinct(this._getApplicableViews(op.getSubOp(), restrictions));
    }

    public static RestrictionManagerImpl getRestrictions2(Op op) {
        if (op instanceof OpFilterIndexed) {
            return ((OpFilterIndexed)op).getRestrictions();
        }
        if (op instanceof Op1) {
            return SparqlViewSystem.getRestrictions2(((Op1)op).getSubOp());
        }
        if (op instanceof OpJoin) {
            throw new RuntimeException("TODO Merge the restrictions of both sides of the join");
        }
        if (op instanceof OpLeftJoin) {
            return SparqlViewSystem.getRestrictions2(((OpLeftJoin)op).getLeft());
        }
        if (op instanceof OpDisjunction) {
            return null;
        }
        throw new RuntimeException("Should not happen");
    }

    public static List<RestrictionManagerImpl> getRestrictions(Op op) {
        ArrayList<RestrictionManagerImpl> result = new ArrayList<RestrictionManagerImpl>();
        SparqlViewSystem.getRestrictions(op, result);
        return result;
    }

    public static void getRestrictions(Op op, Collection<RestrictionManagerImpl> result) {
        if (op instanceof Op1) {
            SparqlViewSystem.getRestrictions(((Op1)op).getSubOp(), result);
        } else {
            if (op instanceof OpJoin) {
                throw new RuntimeException("TODO Merge the restrictions of both sides of the join");
            }
            if (op instanceof OpLeftJoin) {
                SparqlViewSystem.getRestrictions(((OpLeftJoin)op).getLeft(), result);
            } else if (op instanceof OpDisjunction) {
                OpDisjunction o = (OpDisjunction)op;
                for (Op subOp : o.getElements()) {
                    SparqlViewSystem.getRestrictions(subOp, result);
                }
            } else if (op instanceof OpSparqlViewPattern) {
                OpSparqlViewPattern o = (OpSparqlViewPattern)op;
                result.add(o.getConjunction().getRestrictions());
            } else {
                throw new RuntimeException("Should not happen");
            }
        }
    }

    @Override
    public Collection<SparqlView> getViews() {
        return this.views;
    }
}

