/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.sparqlview;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Map;
import org.aksw.jena_sparql_api.views.TwoWayBinding;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;

public class ViewInstanceOld {
    protected Quad queryQuad;
    protected Quad viewQuad;
    protected QuadPattern queryQuads = new QuadPattern();
    protected QuadPattern viewQuads = new QuadPattern();
    protected int instanceId;
    protected int subId;
    protected BiMap<Node, Node> renamer;
    protected TwoWayBinding binding;

    public ViewInstanceOld(Quad queryQuad, Quad viewQuad, int instanceId, int subId, TwoWayBinding binding) {
        this.queryQuad = queryQuad;
        this.viewQuad = viewQuad;
        this.queryQuads.add(queryQuad);
        this.viewQuads.add(viewQuad);
        this.instanceId = instanceId;
        this.subId = subId;
    }

    public boolean isViewVariable(Var var) {
        return var.getName().startsWith("view");
    }

    public SetMultimap<Var, Var> getQueryToParentBinding() {
        HashMultimap result = HashMultimap.create();
        for (Map.Entry entry : this.binding.getEquiMap().getEquivalences().entries()) {
            Var back = (Var)this.renamer.inverse().get(entry.getValue());
            if (back == null) continue;
            result.put(entry.getKey(), (Object)back);
        }
        return result;
    }

    public SetMultimap<Var, Var> getParentToQueryBinding() {
        HashMultimap result = HashMultimap.create();
        for (Map.Entry entry : this.binding.getEquiMap().getEquivalences().entries()) {
            Var back = (Var)this.renamer.inverse().get(entry.getValue());
            if (back == null) continue;
            result.put((Object)back, entry.getKey());
        }
        return result;
    }

    public QuadPattern getQueryQuads() {
        return this.queryQuads;
    }

    public QuadPattern getViewQuads() {
        return this.viewQuads;
    }

    public Quad getQueryQuad() {
        return this.queryQuad;
    }

    public Quad getViewQuad() {
        return this.queryQuad;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public BiMap<Node, Node> getRenamer() {
        return this.renamer;
    }

    public TwoWayBinding getBinding() {
        return this.binding;
    }
}

