/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.web.servlets;

import com.google.gson.Gson;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.concepts.Path;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.SparqlServiceFactory;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.jena_sparql_api.sparql_path.core.algorithm.ConceptPathFinder;
import org.aksw.jena_sparql_api.utils.SparqlFormatterUtils;
import org.aksw.jena_sparql_api.web.utils.AuthenticatorUtils;
import org.aksw.jena_sparql_api.web.utils.ThreadUtils;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.DatasetDescription;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@javax.ws.rs.Path(value="/path-finding")
public class PathFindingApi {
    @Autowired
    private SparqlServiceFactory sparqlServiceFactory;
    @Autowired
    private HttpServletRequest req;

    @GET
    @Produces(value={"application/json"})
    public void findPathsPost(@Suspended AsyncResponse asyncResponse, @QueryParam(value="service-uri") String serviceUri, @QueryParam(value="default-graph-uri") List<String> defaultGraphUris, @QueryParam(value="named-graph-uri") List<String> namedGraphUris, @QueryParam(value="source-element") String sourceElement, @QueryParam(value="source-var") String sourceVar, @QueryParam(value="target-element") String targetElement, @QueryParam(value="target-var") String targetVar, @QueryParam(value="js-service-uri") String joinSummaryServiceUri, @QueryParam(value="js-graph-uri") List<String> joinSummaryGraphUris, @QueryParam(value="query") String queryString, @QueryParam(value="n-paths") Integer nPaths, @QueryParam(value="max-hops") Integer maxHops) throws ClassNotFoundException, SQLException {
        this.findPaths(asyncResponse, serviceUri, defaultGraphUris, namedGraphUris, sourceElement, sourceVar, targetElement, targetVar, joinSummaryServiceUri, joinSummaryGraphUris, queryString, nPaths, maxHops);
    }

    @POST
    @Produces(value={"application/json"})
    public void findPathsGet(@Suspended AsyncResponse asyncResponse, @FormParam(value="service-uri") String serviceUri, @FormParam(value="default-graph-uri") List<String> defaultGraphUris, @FormParam(value="named-graph-uri") List<String> namedGraphUris, @FormParam(value="source-element") String sourceElement, @FormParam(value="source-var") String sourceVar, @FormParam(value="target-element") String targetElement, @FormParam(value="target-var") String targetVar, @FormParam(value="js-service-uri") String joinSummaryServiceUri, @FormParam(value="js-graph-uri") List<String> joinSummaryGraphUris, @FormParam(value="query") String queryString, @FormParam(value="n-paths") Integer nPaths, @FormParam(value="max-hops") Integer maxHops) throws ClassNotFoundException, SQLException {
        this.findPaths(asyncResponse, serviceUri, defaultGraphUris, namedGraphUris, sourceElement, sourceVar, targetElement, targetVar, joinSummaryServiceUri, joinSummaryGraphUris, queryString, nPaths, maxHops);
    }

    public void findPaths(final AsyncResponse response, final String serviceUri, final List<String> defaultGraphUris, final List<String> namedGraphUris, final String sourceElement, final String sourceVar, final String targetElement, final String targetVar, final String joinSummaryServiceUri, final List<String> joinSummaryGraphUris, final String queryString, final Integer nPaths, final Integer maxHops) throws ClassNotFoundException, SQLException {
        final HttpAuthenticator authenticator = AuthenticatorUtils.parseAuthenticator(this.req);
        ThreadUtils.start(response, new Runnable(){

            @Override
            public void run() {
                String result;
                Model joinSummaryModel;
                int _nPaths = nPaths != null ? nPaths : 3;
                int _maxHops = maxHops != null ? maxHops : 3;
                DatasetDescription datasetDescription = new DatasetDescription(defaultGraphUris, namedGraphUris);
                Concept sourceConcept = Concept.create((String)sourceElement, (String)sourceVar);
                Concept targetConcept = Concept.create((String)targetElement, (String)targetVar);
                SparqlService sparqlService = PathFindingApi.this.sparqlServiceFactory.createSparqlService(serviceUri, datasetDescription, (Object)authenticator);
                QueryExecutionFactory qef = sparqlService.getQueryExecutionFactory();
                List jss = joinSummaryGraphUris != null ? joinSummaryGraphUris : Collections.emptyList();
                DatasetDescription jsDs = new DatasetDescription(jss, Collections.emptyList());
                if (joinSummaryServiceUri != null && !joinSummaryServiceUri.isEmpty()) {
                    SparqlService jsSparqlService = PathFindingApi.this.sparqlServiceFactory.createSparqlService(joinSummaryServiceUri, jsDs, null);
                    QueryExecutionFactory jsQef = jsSparqlService.getQueryExecutionFactory();
                    joinSummaryModel = ConceptPathFinder.createJoinSummary((QueryExecutionFactory)jsQef);
                } else {
                    joinSummaryModel = ConceptPathFinder.createDefaultJoinSummaryModel((QueryExecutionFactory)qef);
                }
                List paths = ConceptPathFinder.findPaths((QueryExecutionFactory)qef, (Concept)sourceConcept, (Concept)targetConcept, (int)_nPaths, (int)_maxHops, (Model)joinSummaryModel);
                if (queryString != null && !queryString.isEmpty()) {
                    Model model = ConceptPathFinder.createModel((List)paths);
                    QueryExecutionFactoryModel pathSparqlService = new QueryExecutionFactoryModel(model);
                    QueryExecution qe = pathSparqlService.createQueryExecution(queryString);
                    ResultSet rs = qe.execSelect();
                    result = SparqlFormatterUtils._formatJson((ResultSet)rs);
                } else {
                    ArrayList<String> tmp = new ArrayList<String>();
                    for (Path path : paths) {
                        tmp.add(path.toPathString());
                    }
                    Gson gson = new Gson();
                    result = gson.toJson(tmp);
                }
                response.resume((Object)result);
            }
        });
    }
}

