/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.web.servlets;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.SparqlServiceFactory;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactory;
import org.aksw.jena_sparql_api.stmt.SparqlStmtUpdate;
import org.aksw.jena_sparql_api.web.servlets.SparqlEndpointBase;
import org.aksw.jena_sparql_api.web.utils.AuthenticatorUtils;
import org.aksw.jena_sparql_api.web.utils.DatasetDescriptionRequestUtils;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.springframework.util.Assert;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;

public abstract class ServletSparqlServiceBase
extends SparqlEndpointBase {
    @Context
    protected HttpServletRequest req;

    protected abstract SparqlServiceFactory getSparqlServiceFactory();

    protected String getServiceUri() {
        String result;
        try {
            result = ServletRequestUtils.getStringParameter((ServletRequest)this.req, (String)"service-uri");
        }
        catch (ServletRequestBindingException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    protected HttpAuthenticator getAuthenticator() {
        HttpAuthenticator result = AuthenticatorUtils.parseAuthenticator(this.req);
        return result;
    }

    protected DatasetDescription getDatasetDescription() {
        DatasetDescription result = DatasetDescriptionRequestUtils.extractDatasetDescriptionAny(this.req);
        return result;
    }

    @Override
    public QueryExecution createQueryExecution(Query query) {
        SparqlServiceFactory ssf = this.getSparqlServiceFactory();
        Assert.notNull((Object)ssf, (String)"Got null for SparqlServiceFactory");
        String serviceUri = this.getServiceUri();
        DatasetDescription datasetDescription = this.getDatasetDescription();
        HttpAuthenticator authenticator = this.getAuthenticator();
        SparqlService ss = ssf.createSparqlService(serviceUri, datasetDescription, (Object)authenticator);
        QueryExecution result = ss.getQueryExecutionFactory().createQueryExecution(query);
        return result;
    }

    @Override
    public UpdateProcessor createUpdateProcessor(SparqlStmtUpdate stmt) {
        UpdateProcessor result;
        SparqlServiceFactory ssf = this.getSparqlServiceFactory();
        Assert.notNull((Object)ssf, (String)"Got null for SparqlServiceFactory");
        String serviceUri = this.getServiceUri();
        DatasetDescription datasetDescription = this.getDatasetDescription();
        HttpAuthenticator authenticator = this.getAuthenticator();
        SparqlService ss = ssf.createSparqlService(serviceUri, datasetDescription, (Object)authenticator);
        UpdateExecutionFactory uef = ss.getUpdateExecutionFactory();
        if (stmt.isParsed()) {
            UpdateRequest updateRequest = stmt.getUpdateRequest();
            result = uef.createUpdateProcessor(updateRequest);
        } else {
            String updateRequestStr = stmt.getOriginalString();
            result = uef.createUpdateProcessor(updateRequestStr);
        }
        return result;
    }
}

