/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.web.servlets;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.ConnectionCallback;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.SparqlServiceFactory;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.UpdateRequestUtils;
import org.aksw.jena_sparql_api.web.servlets.StreamingOutputString;
import org.aksw.jena_sparql_api.web.utils.AuthenticatorUtils;
import org.aksw.jena_sparql_api.web.utils.ThreadUtils;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServletSparqlUpdateBase {
    private static final Logger logger = LoggerFactory.getLogger(ServletSparqlUpdateBase.class);
    @Context
    protected HttpServletRequest req;

    protected abstract SparqlServiceFactory getSparqlServiceFactory();

    @GET
    @Produces(value={"application/json"})
    public void executeUpdateGet(@Suspended AsyncResponse asyncResponse, @QueryParam(value="service-uri") String serviceUri, @QueryParam(value="update") String queryString, @QueryParam(value="using-graph-uri") List<String> usingGraphUris, @QueryParam(value="using-named-graph-uri") List<String> usingNamedGraphUris) throws Exception {
        this.executeUpdateAny(asyncResponse, serviceUri, queryString, usingGraphUris, usingNamedGraphUris);
    }

    @POST
    @Produces(value={"application/json"})
    public void executeUpdatePost(@Suspended AsyncResponse asyncResponse, @FormParam(value="service-uri") String serviceUri, @FormParam(value="update") String queryString, @FormParam(value="using-graph-uri") List<String> usingGraphUris, @FormParam(value="using-named-graph-uri") List<String> usingNamedGraphUris) throws Exception {
        this.executeUpdateAny(asyncResponse, serviceUri, queryString, usingGraphUris, usingNamedGraphUris);
    }

    public void executeUpdateAny(@Suspended AsyncResponse asyncResponse, String serviceUri, String queryString, List<String> usingGraphUris, List<String> usingNamedGraphUris) throws Exception {
        if (queryString == null) {
            StreamingOutputString so = StreamingOutputString.create("<error>No query specified. Append '?query=&lt;your SPARQL query&gt;'</error>");
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)so).build());
        } else {
            this.processUpdateAsync(asyncResponse, serviceUri, queryString, usingGraphUris, usingNamedGraphUris);
        }
    }

    public UpdateProcessor createUpdateProcessor(String serviceUri, String requestStr, List<String> usingGraphUris, List<String> usingNamedGraphUris) {
        HttpAuthenticator authenticator = AuthenticatorUtils.parseAuthenticator(this.req);
        SparqlServiceFactory ssf = this.getSparqlServiceFactory();
        UpdateProcessor result = ServletSparqlUpdateBase.createUpdateProcessor(ssf, serviceUri, requestStr, usingGraphUris, usingNamedGraphUris, authenticator);
        return result;
    }

    public static UpdateProcessor createUpdateProcessor(SparqlServiceFactory ssf, String serviceUri, String requestStr, List<String> usingGraphUris, List<String> usingNamedGraphUris, HttpAuthenticator authenticator) {
        DatasetDescription datasetDescription = new DatasetDescription(usingGraphUris, usingNamedGraphUris);
        SparqlService sparqlService = ssf.createSparqlService(serviceUri, datasetDescription, (Object)authenticator);
        UpdateExecutionFactory uef = sparqlService.getUpdateExecutionFactory();
        UpdateRequest updateRequest = UpdateRequestUtils.parse((String)requestStr);
        UpdateProcessor result = uef.createUpdateProcessor(updateRequest);
        return result;
    }

    public void processUpdateAsync(final AsyncResponse response, String serviceUri, String requestStr, List<String> usingGraphUris, List<String> usingNamedGraphUris) {
        UpdateProcessor updateProcessor = this.createUpdateProcessor(serviceUri, requestStr, usingGraphUris, usingNamedGraphUris);
        updateProcessor.execute();
        response.register((Object)new ConnectionCallback(){

            public void onDisconnect(AsyncResponse disconnect) {
                logger.debug("Client disconnected");
            }
        });
        response.register((Object)new CompletionCallback(){

            public void onComplete(Throwable t) {
                if (t == null) {
                    logger.debug("Successfully completed query execution");
                } else {
                    logger.debug("Failed query execution");
                }
            }
        });
        ThreadUtils.start(response, new Runnable(){

            @Override
            public void run() {
                try {
                    String result = "{\"success\": true}";
                    response.resume((Object)result);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

