/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.web.servlets;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.ConnectionCallback;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.aksw.jena_sparql_api.core.utils.QueryExecutionAndType;
import org.aksw.jena_sparql_api.stmt.SparqlParserConfig;
import org.aksw.jena_sparql_api.stmt.SparqlStmt;
import org.aksw.jena_sparql_api.stmt.SparqlStmtParser;
import org.aksw.jena_sparql_api.stmt.SparqlStmtParserImpl;
import org.aksw.jena_sparql_api.stmt.SparqlStmtQuery;
import org.aksw.jena_sparql_api.stmt.SparqlStmtUpdate;
import org.aksw.jena_sparql_api.web.servlets.ProcessQuery;
import org.aksw.jena_sparql_api.web.servlets.StreamingOutputString;
import org.aksw.jena_sparql_api.web.utils.ThreadUtils;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.update.UpdateProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SparqlEndpointBase {
    private static final Logger logger = LoggerFactory.getLogger(SparqlEndpointBase.class);
    protected SparqlStmtParser defaultSparqlStmtParser = SparqlStmtParserImpl.create((SparqlParserConfig)SparqlParserConfig.create((Syntax)Syntax.syntaxARQ), (boolean)true);

    protected SparqlStmtParser getSparqlStmtParser() {
        return this.defaultSparqlStmtParser;
    }

    @Deprecated
    public QueryExecution createQueryExecution(Query query, @Context HttpServletRequest req) {
        QueryExecutionAndType tmp = this.createQueryExecutionAndType(query.toString());
        QueryExecution result = tmp.getQueryExecution();
        return result;
    }

    public QueryExecution createQueryExecution(Query query) {
        throw new RuntimeException("Not implemented");
    }

    public QueryExecutionAndType createQueryExecutionAndType(String queryString) {
        Query query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        QueryExecution qe = this.createQueryExecution(query);
        QueryExecutionAndType result = new QueryExecutionAndType(qe, query.getQueryType());
        return result;
    }

    public QueryExecutionAndType createQueryExecutionAndType(Query query) {
        QueryExecution qe = this.createQueryExecution(query);
        QueryExecutionAndType result = new QueryExecutionAndType(qe, query.getQueryType());
        return result;
    }

    public SparqlStmt classifyStmt(String stmtStr) {
        SparqlStmtParser sparqlStmtParser = this.getSparqlStmtParser();
        SparqlStmt result = (SparqlStmt)sparqlStmtParser.apply((Object)stmtStr);
        return result;
    }

    public Response processQuery(HttpServletRequest req, String queryString, String format) throws Exception {
        StreamingOutput so = this.processQueryToStreaming(queryString, format);
        Response response = Response.ok((Object)so).build();
        return response;
    }

    public StreamingOutput processQueryToStreaming(String queryString, String format) throws Exception {
        QueryExecutionAndType qeAndType = this.createQueryExecutionAndType(queryString);
        StreamingOutput result = ProcessQuery.processQuery(qeAndType, format);
        return result;
    }

    @GET
    @Produces(value={"application/xml"})
    public void executeQueryXml(@Suspended AsyncResponse asyncResponse, @QueryParam(value="query") String queryString) {
        if (queryString == null) {
            StreamingOutputString so = StreamingOutputString.create("<error>No query specified. Append '?query=&lt;your SPARQL query&gt;'</error>");
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)so).build());
        } else {
            this.processStmtAsync(asyncResponse, queryString, "Xml");
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/xml"})
    public void executeQueryXmlPostAsync(@Suspended AsyncResponse asyncResponse, @FormParam(value="query") String queryString, @FormParam(value="update") String updateString) {
        if (queryString == null) {
            queryString = updateString;
        }
        if (queryString == null) {
            StreamingOutputString so = StreamingOutputString.create("<error>No query specified. Append '?query=&lt;your SPARQL query&gt;'</error>");
            asyncResponse.resume((Object)Response.ok((Object)so).build());
        } else {
            this.processStmtAsync(asyncResponse, queryString, "Xml");
        }
    }

    @GET
    @Produces(value={"application/json", "application/sparql-results+json"})
    public void executeQueryJson(@Suspended AsyncResponse asyncResponse, @QueryParam(value="query") String queryString) {
        this.processStmtAsync(asyncResponse, queryString, "Json");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json", "application/sparql-results+json"})
    public void executeQueryXmlPost(@Suspended AsyncResponse asyncResponse, @FormParam(value="query") String queryString, @FormParam(value="update") String updateStr) {
        if (queryString == null) {
            queryString = updateStr;
        }
        this.processStmtAsync(asyncResponse, queryString, "Json");
    }

    public void processStmtAsync(AsyncResponse response, String stmtStr, String format) {
        if (stmtStr == null) {
            throw new RuntimeException("No query/update statement provided");
        }
        SparqlStmt stmt = this.classifyStmt(stmtStr);
        if (stmt.isQuery()) {
            this.processQueryAsync(response, stmt.getAsQueryStmt(), format);
        } else if (stmt.isUpdateRequest()) {
            this.processUpdateAsync(response, stmt.getAsUpdateStmt());
        } else {
            throw new RuntimeException("Unknown request type: " + stmtStr);
        }
    }

    public void processQueryAsync(final AsyncResponse response, SparqlStmtQuery stmt, final String format) {
        final QueryExecutionAndType qeAndType = stmt.isParsed() ? this.createQueryExecutionAndType(stmt.getQuery()) : this.createQueryExecutionAndType(stmt.getOriginalString());
        response.register((Object)new ConnectionCallback(){

            public void onDisconnect(AsyncResponse disconnect) {
                logger.debug("Client disconnected");
                qeAndType.getQueryExecution().abort();
            }
        });
        response.register((Object)new CompletionCallback(){

            public void onComplete(Throwable t) {
                if (t == null) {
                    logger.debug("Successfully completed query execution");
                } else {
                    logger.debug("Failed query execution");
                }
                qeAndType.getQueryExecution().close();
            }
        });
        ThreadUtils.start(response, new Runnable(){

            @Override
            public void run() {
                try {
                    StreamingOutput result = ProcessQuery.processQuery(qeAndType, format);
                    response.resume((Object)result);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @GET
    @Produces(value={"application/rdf+xml"})
    public void executeQueryRdfXml(@Suspended AsyncResponse asyncResponse, @QueryParam(value="query") String queryString) {
        this.processStmtAsync(asyncResponse, queryString, "RdfXml");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/rdf+xml"})
    public void executeQueryRdfXmlPost(@Suspended AsyncResponse asyncResponse, @FormParam(value="query") String queryString) {
        this.processStmtAsync(asyncResponse, queryString, "RdfXml");
    }

    @GET
    @Produces(value={"application/sparql-results+xml"})
    public void executeQueryResultSetXml(@Suspended AsyncResponse asyncResponse, @QueryParam(value="query") String queryString) {
        this.processStmtAsync(asyncResponse, queryString, "Xml");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/sparql-results+xml"})
    public void executeQueryResultSetXmlPost(@Suspended AsyncResponse asyncResponse, @FormParam(value="query") String queryString) {
        this.processStmtAsync(asyncResponse, queryString, "Text");
    }

    @GET
    @Produces(value={"text/plain"})
    public void executeQueryText(@Suspended AsyncResponse asyncResponse, @QueryParam(value="query") String queryString) {
        this.processStmtAsync(asyncResponse, queryString, "Text");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public void executeQueryTextPost(@Suspended AsyncResponse asyncResponse, @FormParam(value="query") String queryString) {
        this.processStmtAsync(asyncResponse, queryString, "Text");
    }

    public UpdateProcessor createUpdateProcessor(SparqlStmtUpdate stmt) {
        throw new UnsupportedOperationException("The method for handling SPARQL update requests has not been overridden");
    }

    public void processUpdateAsync(final AsyncResponse response, SparqlStmtUpdate stmt) {
        UpdateProcessor updateProcessor = this.createUpdateProcessor(stmt.getAsUpdateStmt());
        updateProcessor.execute();
        response.register((Object)new ConnectionCallback(){

            public void onDisconnect(AsyncResponse disconnect) {
                logger.debug("Client disconnected");
            }
        });
        response.register((Object)new CompletionCallback(){

            public void onComplete(Throwable t) {
                if (t == null) {
                    logger.debug("Successfully completed query execution");
                } else {
                    logger.debug("Failed query execution");
                }
            }
        });
        ThreadUtils.start(response, new Runnable(){

            @Override
            public void run() {
                try {
                    String result = "{\"success\": true}";
                    response.resume((Object)result);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

