/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.web.utils;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.DatatypeConverter;
import org.aksw.commons.util.strings.StringUtils;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.atlas.web.auth.SimpleAuthenticator;

public class AuthenticatorUtils {
    public static HttpAuthenticator parseAuthenticator(HttpServletRequest req) {
        SimpleAuthenticator result = null;
        String authStr = (String)StringUtils.coalesce((Object[])new String[]{req.getHeader("Authorization"), req.getHeader("WWW-Authenticate")});
        if (authStr != null && authStr.startsWith("Basic")) {
            String base64Credentials = authStr.substring("Basic".length()).trim();
            String credentials = new String(DatatypeConverter.parseBase64Binary((String)base64Credentials));
            String[] values = credentials.split(":", 2);
            if (values.length == 2) {
                String username = values[0];
                char[] password = values[1].toCharArray();
                result = new SimpleAuthenticator(username, password);
            } else {
                throw new RuntimeException("Invalid header - got: " + Arrays.asList(values));
            }
        }
        return result;
    }
}

