/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.r2rml.jena.jdbc.impl;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.aksw.r2rml.jena.jdbc.api.NodeMapper;
import org.aksw.r2rml.jena.jdbc.impl.NodeMapperViaSqlDatatype;
import org.aksw.r2rml.jena.jdbc.impl.SqlDatatype;
import org.aksw.r2rml.jena.jdbc.impl.SqlDatatypeImpl;
import org.aksw.r2rml.jena.jdbc.impl.SqlTypeMapper;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_StrReplace;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.user.UserDefinedFunctionDefinition;

public class NaturalMappings {
    private static final Var x = Var.alloc((String)"x");
    public static final UserDefinedFunctionDefinition udfd_timestamp = new UserDefinedFunctionDefinition("urn:r2rml:timestamp", (Expr)new E_StrReplace((Expr)new ExprVar(x), (Expr)NodeValue.makeString((String)" "), (Expr)NodeValue.makeString((String)"T"), null), Arrays.asList(x));

    public static <K, V> void putValue(Map<K, V> map, V value, K ... keys) {
        for (K key : keys) {
            map.put(key, value);
        }
    }

    public static NodeMapper createNodeMapper(int sqlType) {
        SqlTypeMapper sqlTypeMapper = SqlTypeMapper.getInstance();
        return NaturalMappings.createNodeMapper(sqlType, sqlTypeMapper);
    }

    public static NodeMapper createNodeMapper(int sqlType, SqlTypeMapper sqlTypeMapper) {
        SqlDatatype sqlDatatype = sqlTypeMapper.getTypeBySqlType(sqlType);
        Objects.requireNonNull(sqlDatatype, "No SqlDatatype found for sqlType " + sqlType);
        return new NodeMapperViaSqlDatatype(sqlDatatype);
    }

    public static Set<SqlDatatype> getDefaultDatatypes(TypeMapper typeMapper) {
        LinkedHashMap<Integer, String> sqlToXsd = new LinkedHashMap<Integer, String>();
        NaturalMappings.registerSqlToXsdTypeMaps(sqlToXsd);
        LinkedHashSet<SqlDatatype> result = new LinkedHashSet<SqlDatatype>();
        for (Map.Entry e : sqlToXsd.entrySet()) {
            int sqlType = (Integer)e.getKey();
            String xsdIri = (String)e.getValue();
            RDFDatatype dtype = typeMapper.getTypeByName(xsdIri);
            Class sqlJavaClass = dtype.getJavaClass();
            Function<Object, Object> compatibilizer = null;
            Function<Object, String> lexicalFormizer = null;
            if (xsdIri.equals("http://www.w3.org/2001/XMLSchema#double") && sqlType != 8) {
                lexicalFormizer = o -> Float.toString(((Float)o).floatValue());
            }
            if (sqlType == 93) {
                lexicalFormizer = o -> {
                    String r = o.toString().replace(' ', 'T');
                    return r;
                };
            }
            result.add(new SqlDatatypeImpl(sqlType, sqlJavaClass, dtype, compatibilizer, lexicalFormizer, null));
        }
        return result;
    }

    public static void registerSqlToXsdTypeMaps(Map<Integer, String> sqlToXsd) {
        String xsd = "http://www.w3.org/2001/XMLSchema#";
        NaturalMappings.putValue(sqlToXsd, "http://www.w3.org/2001/XMLSchema#hexBinary", -2, -3, -4);
        NaturalMappings.putValue(sqlToXsd, "http://www.w3.org/2001/XMLSchema#decimal", 2, 3);
        NaturalMappings.putValue(sqlToXsd, "http://www.w3.org/2001/XMLSchema#integer", 5, 4, -5);
        NaturalMappings.putValue(sqlToXsd, "http://www.w3.org/2001/XMLSchema#double", 6, 7, 8);
        NaturalMappings.putValue(sqlToXsd, "http://www.w3.org/2001/XMLSchema#boolean", 16);
        NaturalMappings.putValue(sqlToXsd, "http://www.w3.org/2001/XMLSchema#date", 91);
        NaturalMappings.putValue(sqlToXsd, "http://www.w3.org/2001/XMLSchema#time", 92);
        NaturalMappings.putValue(sqlToXsd, "http://www.w3.org/2001/XMLSchema#dateTime", 93);
        NaturalMappings.putValue(sqlToXsd, "http://www.w3.org/2001/XMLSchema#string", 12, -1, -16);
        NaturalMappings.putValue(sqlToXsd, "http://www.w3.org/2001/XMLSchema#string", 1, -15);
    }

    private static /* synthetic */ Object lambda$getDefaultDatatypes$1(Object o) {
        Timestamp timestamp = (Timestamp)o;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp.getTime());
        calendar.clear(15);
        calendar.clear(16);
        XSDDateTime r = new XSDDateTime(calendar);
        return r;
    }
}

