/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.r2rml.jena.jdbc.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.aksw.r2rml.jena.jdbc.api.BindingMapper;
import org.aksw.r2rml.jena.jdbc.api.NodeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;

public class RowToBindingImpl
implements BindingMapper {
    protected int[] colIdxs;
    protected Var[] vars;
    protected boolean[] nullableVars;
    protected NodeMapper nodeMapper;

    public RowToBindingImpl(int[] colIdxs, Var[] vars, boolean[] nullableVars, NodeMapper nodeMapper) {
        this.colIdxs = colIdxs;
        this.vars = vars;
        this.nullableVars = nullableVars;
        this.nodeMapper = nodeMapper;
    }

    @Override
    public Binding map(ResultSet resultSet) throws SQLException {
        BindingMap result = BindingFactory.create();
        for (int i = 0; i < this.colIdxs.length; ++i) {
            int colIdx = this.colIdxs[i];
            Node node = this.nodeMapper.map(resultSet, colIdx);
            Var var = this.vars[i];
            if (node != null) {
                result.add(var, node);
                continue;
            }
            boolean isNullable = this.nullableVars[i];
            if (isNullable) continue;
            throw new RuntimeException("Attempted to leave non-nullable variable " + var + " unbound");
        }
        return result;
    }
}

