/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.r2rml.jena.jdbc.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.aksw.r2rml.jena.jdbc.api.NodeMapper;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;

public class RowToNodeViaTypeManager
implements NodeMapper {
    protected TypeMapper typeMapper;

    public RowToNodeViaTypeManager() {
        this(TypeMapper.getInstance());
    }

    public RowToNodeViaTypeManager(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    @Override
    public Node map(ResultSet resultSet, int columnIdx) throws SQLException {
        Node result;
        Object o = resultSet.getObject(columnIdx);
        if (o == null) {
            result = null;
        } else {
            RDFDatatype dtype = this.typeMapper.getTypeByValue(o);
            Objects.requireNonNull(dtype, "Could not obtain RDFDatatype for " + o + "of type " + o.getClass());
            result = NodeFactory.createLiteralByValue((Object)o, (RDFDatatype)dtype);
        }
        return result;
    }
}

