/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.r2rml.jena.jdbc.impl;

import java.util.function.Function;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.function.user.UserDefinedFunctionDefinition;

public interface SqlDatatype {
    public int getSqlType();

    public Class<?> getJavaClass();

    public RDFDatatype getRdfDatatype();

    public Function<Object, Object> getCompatibilizer();

    public Function<Object, String> getLexicalFormizer();

    public UserDefinedFunctionDefinition convertSqlToRdf();

    default public Function<Object, Node> getNodeMapper() {
        RDFDatatype rdfDatatype = this.getRdfDatatype();
        Function<Object, Object> compatibilizer = this.getCompatibilizer();
        Function<Object, String> lexicalFormizer = this.getLexicalFormizer();
        Function<Object, Node> result = compatibilizer != null ? obj -> {
            Object compat = compatibilizer.apply(obj);
            Node r = NodeFactory.createLiteralByValue(compat, (RDFDatatype)rdfDatatype);
            return r;
        } : (lexicalFormizer != null ? obj -> {
            String lexicalForm = (String)lexicalFormizer.apply(obj);
            Node r = NodeFactory.createLiteral((String)lexicalForm, (RDFDatatype)rdfDatatype);
            return r;
        } : obj -> {
            Node r = NodeFactory.createLiteralByValue((Object)obj, (RDFDatatype)rdfDatatype);
            return r;
        });
        return result;
    }
}

