/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.r2rml.jena.jdbc.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.aksw.r2rml.jena.jdbc.impl.NaturalMappings;
import org.aksw.r2rml.jena.jdbc.impl.SqlDatatype;
import org.apache.jena.datatypes.TypeMapper;

public class SqlTypeMapper {
    private static SqlTypeMapper INSTANCE = null;
    protected Map<Integer, SqlDatatype> indexBySqlType = new LinkedHashMap<Integer, SqlDatatype>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqlTypeMapper getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<SqlTypeMapper> clazz = SqlTypeMapper.class;
        synchronized (SqlTypeMapper.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = SqlTypeMapper.createDefault();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public SqlTypeMapper registerDatatype(SqlDatatype sqlDatatype) {
        int sqlType = sqlDatatype.getSqlType();
        this.indexBySqlType.put(sqlType, sqlDatatype);
        return this;
    }

    public SqlDatatype getTypeBySqlType(int sqlType) {
        return this.indexBySqlType.get(sqlType);
    }

    public static SqlTypeMapper createDefault() {
        TypeMapper typeMapper = TypeMapper.getInstance();
        Set<SqlDatatype> sqlDatatypes = NaturalMappings.getDefaultDatatypes(typeMapper);
        SqlTypeMapper result = new SqlTypeMapper();
        sqlDatatypes.forEach(result::registerDatatype);
        return result;
    }
}

