/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.r2rml.jena.jdbc.processor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.sql.codec.api.SqlCodec;
import org.aksw.r2rml.jena.arq.impl.R2rmlImporter;
import org.aksw.r2rml.jena.arq.impl.TriplesMapToSparqlMapping;
import org.aksw.r2rml.jena.arq.lib.R2rmlLib;
import org.aksw.r2rml.jena.domain.api.LogicalTable;
import org.aksw.r2rml.jena.domain.api.TriplesMap;
import org.aksw.r2rml.jena.jdbc.api.BindingMapper;
import org.aksw.r2rml.jena.jdbc.util.JdbcUtils;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R2rmlProcessorJdbc {
    private static final Logger logger = LoggerFactory.getLogger(R2rmlProcessorJdbc.class);

    public static Dataset processR2rml(Connection conn, Model r2rmlDocument, String baseIri, SqlCodec sqlCodec) throws SQLException {
        List rawTms = R2rmlLib.streamTriplesMaps((Model)r2rmlDocument).collect(Collectors.toList());
        ArrayList tms = new ArrayList(rawTms);
        for (TriplesMap tm : rawTms) {
            R2rmlLib.expandShortcuts((TriplesMap)tm);
            Map map = R2rmlLib.expandRefObjectMapsInPlace((TriplesMap)tm, (SqlCodec)sqlCodec);
            if (!map.isEmpty()) {
                map.values().forEach(R2rmlLib::expandShortcuts);
            }
            tms.addAll(map.values());
        }
        Dataset actualOutput = DatasetFactory.create();
        FunctionEnv env = R2rmlProcessorJdbc.createDefaultEnv();
        Query dummyQueryForBaseIri = new Query();
        dummyQueryForBaseIri.setBaseURI(baseIri);
        env.getContext().set(ARQConstants.sysCurrentQuery, (Object)dummyQueryForBaseIri);
        for (TriplesMap tm : tms) {
            String sqlQuery;
            LogicalTable lt = tm.getLogicalTable();
            TriplesMapToSparqlMapping mapping = R2rmlImporter.read((TriplesMap)tm, (String)baseIri);
            logger.debug("Generated Mapping: " + mapping);
            HashSet usedVars = new HashSet();
            mapping.getVarToExpr().getExprs().values().stream().forEach(e -> ExprVars.varsMentioned((Collection)usedVars, (Expr)e));
            Map<Var, String> usedVarToColumnName = usedVars.stream().collect(Collectors.toMap(v -> v, v -> (String)sqlCodec.forColumnName().decodeOrGetAsGiven((Object)v.getName())));
            if (lt.qualifiesAsBaseTableOrView()) {
                sqlQuery = "SELECT * FROM " + lt.asBaseTableOrView().getTableName();
            } else if (lt.qualifiesAsR2rmlView()) {
                sqlQuery = lt.asR2rmlView().getSqlQuery();
            } else {
                System.err.println("No logical table present");
                continue;
            }
            Statement stmt = conn.createStatement();
            Throwable throwable = null;
            try {
                ResultSet rs = stmt.executeQuery(sqlQuery);
                ResultSetMetaData rsmd = rs.getMetaData();
                Set<Var> nullableVars = usedVarToColumnName.keySet();
                BindingMapper bindingMapper = JdbcUtils.createDefaultBindingMapper(rsmd, usedVarToColumnName, nullableVars);
                while (rs.next()) {
                    Binding b = bindingMapper.map(rs);
                    Binding effectiveBinding = mapping.evalVars(b, env, true);
                    List<Quad> generatedQuads = mapping.evalQuads(effectiveBinding).collect(Collectors.toList());
                    generatedQuads.forEach(arg_0 -> ((DatasetGraph)actualOutput.asDatasetGraph()).add(arg_0));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt == null) continue;
                if (throwable != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stmt.close();
            }
        }
        return actualOutput;
    }

    public static FunctionEnv createDefaultEnv() {
        Context context = ARQ.getContext().copy();
        context.set(ARQConstants.sysCurrentTime, (Object)NodeFactoryExtra.nowAsDateTime());
        ExecutionContext env = new ExecutionContext(context, null, null, null);
        return env;
    }
}

