/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.r2rml.jena.jdbc.util;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.aksw.r2rml.jena.jdbc.api.BindingMapper;
import org.aksw.r2rml.jena.jdbc.api.NodeMapper;
import org.aksw.r2rml.jena.jdbc.impl.NaturalMappings;
import org.aksw.r2rml.jena.jdbc.impl.NodeMapperMultiplexer;
import org.aksw.r2rml.jena.jdbc.impl.RowToBindingImpl;
import org.aksw.r2rml.jena.jdbc.impl.SqlTypeMapper;
import org.apache.jena.ext.com.google.common.collect.BiMap;
import org.apache.jena.ext.com.google.common.collect.HashBiMap;
import org.apache.jena.ext.com.google.common.collect.Sets;
import org.apache.jena.sparql.core.Var;

public class JdbcUtils {
    public static NodeMapper createNodeMapper(ResultSetMetaData rsmd, int[] usedIdxs, SqlTypeMapper sqlTypeMapper) throws SQLException {
        int columnCount = rsmd.getColumnCount();
        NodeMapper[] targets = new NodeMapper[columnCount + 1];
        for (int i = 0; i < usedIdxs.length; ++i) {
            int colIdx = usedIdxs[i];
            int sqlType = rsmd.getColumnType(colIdx);
            targets[colIdx] = NaturalMappings.createNodeMapper(sqlType, sqlTypeMapper);
        }
        return new NodeMapperMultiplexer(targets);
    }

    public static <K, V, M extends Map<K, V>> M putNew(M map, K k, V v) {
        if (map.containsKey(k)) {
            V existingValue = map.get(v);
            throw new RuntimeException("Key " + k + " already mapped to " + existingValue);
        }
        map.put(k, v);
        return map;
    }

    public static Map<Var, Integer> createVarMapping(ResultSetMetaData rsmd, Map<Var, String> usedVarToColumnName) throws SQLException {
        int columnCount = rsmd.getColumnCount();
        LinkedHashSet<String> availableColumns = new LinkedHashSet<String>();
        LinkedHashMap<Var, Integer> colNameToIdx = new LinkedHashMap<Var, Integer>();
        BiMap columnNameToVar = HashBiMap.create(usedVarToColumnName).inverse();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = rsmd.getColumnName(i);
            availableColumns.add(columnName);
            Var usedVar = (Var)columnNameToVar.get(columnName);
            if (usedVar != null) {
                JdbcUtils.putNew(colNameToIdx, usedVar, i);
                continue;
            }
            Var secondaryMatch = usedVarToColumnName.entrySet().stream().filter(e -> ((String)e.getValue()).equalsIgnoreCase(columnName)).map(Map.Entry::getKey).findFirst().orElse(null);
            if (secondaryMatch == null) continue;
            JdbcUtils.putNew(colNameToIdx, secondaryMatch, i);
        }
        Sets.SetView invalidRefs = Sets.difference(usedVarToColumnName.keySet(), colNameToIdx.keySet());
        if (!invalidRefs.isEmpty()) {
            throw new RuntimeException("The following non-existent columns are referenced: " + invalidRefs + "; available: " + availableColumns);
        }
        return colNameToIdx;
    }

    public static BindingMapper createDefaultBindingMapper(ResultSetMetaData rsmd, Map<Var, String> usedVarToColumnName, Set<Var> nullableVars) throws SQLException {
        SqlTypeMapper sqlTypeMapper = SqlTypeMapper.getInstance();
        Map<Var, Integer> colNameToIdx = JdbcUtils.createVarMapping(rsmd, usedVarToColumnName);
        Function<int[], NodeMapper> nodeMapperFactory = usedIdxs -> {
            try {
                return JdbcUtils.createNodeMapper(rsmd, usedIdxs, sqlTypeMapper);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        };
        BindingMapper result = JdbcUtils.createBindingMapper(colNameToIdx, nodeMapperFactory, nullableVars);
        return result;
    }

    public static BindingMapper createBindingMapper(Map<Var, Integer> colNameToIdx, Function<int[], NodeMapper> nodeMapperFactory, Set<Var> nullableVars) throws SQLException {
        int n = colNameToIdx.size();
        int[] colIdxs = new int[n];
        Var[] vars = new Var[n];
        boolean[] nullable = new boolean[n];
        int i = 0;
        for (Map.Entry<Var, Integer> e : colNameToIdx.entrySet()) {
            Var var;
            vars[i] = var = e.getKey();
            colIdxs[i] = e.getValue();
            nullable[i] = nullableVars.contains(var);
            ++i;
        }
        NodeMapper nodeMapper = nodeMapperFactory.apply(colIdxs);
        RowToBindingImpl result = new RowToBindingImpl(colIdxs, vars, nullable, nodeMapper);
        return result;
    }
}

