/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.admin.standalone;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.aktin.broker.admin.standalone.Configuration;
import org.aktin.broker.auth.CascadedAuthProvider;
import org.aktin.broker.server.auth.AuthProvider;
import org.hsqldb.jdbc.JDBCDataSource;

public class DefaultConfiguration
implements Configuration {
    private static final Logger log = Logger.getLogger(DefaultConfiguration.class.getName());
    private static final String DEFAULT_AUTH_PROVIDER = "org.aktin.broker.auth.apikey.ApiKeyPropertiesAuthProvider,org.aktin.broker.auth.cred.CredentialTokenAuthProvider";
    private AuthProvider authProvider;

    public DefaultConfiguration() {
        String ap = System.getProperty("aktin.broker.auth.provider", DEFAULT_AUTH_PROVIDER);
        String[] aps = ap.split(",");
        if (aps.length == 1) {
            this.authProvider = this.loadProviderClass(aps[0]);
        } else {
            AuthProvider[] provs = new AuthProvider[aps.length];
            for (int i = 0; i < provs.length; ++i) {
                provs[i] = this.loadProviderClass(aps[i].trim());
            }
            this.authProvider = new CascadedAuthProvider(Arrays.asList(provs));
        }
    }

    @Override
    public long getWebsocketIdleTimeoutMillis() {
        return 1000 * Integer.valueOf(System.getProperty("aktin.broker.websocket.idletimeoutseconds", Integer.toString(7200)));
    }

    private AuthProvider loadProviderClass(String name) throws IllegalArgumentException {
        try {
            Constructor<?> c = Class.forName(name).getConstructor(new Class[0]);
            return (AuthProvider)c.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to instantiate auth provider class: " + name, e);
        }
    }

    @Override
    public int getPort() {
        return 8080;
    }

    @Override
    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    @Override
    public Path getBasePath() {
        return Paths.get(".", new String[0]);
    }

    @Override
    public Class<? extends DataSource> getJdbcDataSourceClass() throws ClassNotFoundException {
        String name = System.getProperty("aktin.broker.jdbc.datasource.class");
        Class<? extends DataSource> clazz = name != null ? Class.forName(name).asSubclass(DataSource.class) : DefaultConfiguration.getDefaultHsqlDataSource();
        return clazz;
    }

    public static String getDefaultHsqlJdbcUrl(Path basePath) {
        String path = basePath.resolve("broker").toString();
        return "jdbc:hsqldb:file:" + path + ";shutdown=false;user=admin;password=secret";
    }

    public static Class<? extends DataSource> getDefaultHsqlDataSource() {
        System.setProperty("hsqldb.reconfig_logging", "false");
        return JDBCDataSource.class;
    }

    @Override
    public String getJdbcUrl() {
        String url = System.getProperty("aktin.broker.jdbc.url");
        if (url == null) {
            url = DefaultConfiguration.getDefaultHsqlJdbcUrl(this.getBasePath());
            log.info("Generating JDBC URL for HSQLDB: " + url);
        } else {
            log.info("Using JDBC URL from system properties: " + url);
        }
        return url;
    }
}

