/*
 * Decompiled with CFR 0.152.
 */
package org.alephium.api;

import akka.util.ByteString;
import io.circe.Codec;
import io.circe.Codec$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.Printer;
import io.circe.Printer$;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.alephium.util.AVector;
import org.alephium.util.AVector$;
import org.alephium.util.Hex$;
import org.alephium.util.TimeStamp;
import org.alephium.util.TimeStamp$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Factory$;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class CirceUtils$ {
    public static final CirceUtils$ MODULE$ = new CirceUtils$();
    private static final Printer printer = Printer$.MODULE$.noSpaces().copy(true, Printer$.MODULE$.noSpaces().copy$default$2(), Printer$.MODULE$.noSpaces().copy$default$3(), Printer$.MODULE$.noSpaces().copy$default$4(), Printer$.MODULE$.noSpaces().copy$default$5(), Printer$.MODULE$.noSpaces().copy$default$6(), Printer$.MODULE$.noSpaces().copy$default$7(), Printer$.MODULE$.noSpaces().copy$default$8(), Printer$.MODULE$.noSpaces().copy$default$9(), Printer$.MODULE$.noSpaces().copy$default$10(), Printer$.MODULE$.noSpaces().copy$default$11(), Printer$.MODULE$.noSpaces().copy$default$12(), Printer$.MODULE$.noSpaces().copy$default$13(), Printer$.MODULE$.noSpaces().copy$default$14(), Printer$.MODULE$.noSpaces().copy$default$15(), Printer$.MODULE$.noSpaces().copy$default$16(), Printer$.MODULE$.noSpaces().copy$default$17(), Printer$.MODULE$.noSpaces().copy$default$18(), Printer$.MODULE$.noSpaces().copy$default$19(), Printer$.MODULE$.noSpaces().copy$default$20(), Printer$.MODULE$.noSpaces().copy$default$21());
    private static final Encoder<ByteString> byteStringEncoder = new Encoder<ByteString>(){
        private static final long serialVersionUID = 0L;

        public final <B> Encoder<B> contramap(Function1<B, ByteString> f) {
            return Encoder.contramap$((Encoder)this, f);
        }

        public final Encoder<ByteString> mapJson(Function1<Json, Json> f) {
            return Encoder.mapJson$((Encoder)this, f);
        }

        public final Json apply(ByteString a) {
            return CirceUtils$.org$alephium$api$CirceUtils$$$anonfun$byteStringEncoder$1(a);
        }
        {
            Encoder.$init$((Encoder)this);
        }
    };
    private static final Decoder<ByteString> byteStringDecoder = Decoder$.MODULE$.decodeString().emap((Function1 & Serializable)bs -> Hex$.MODULE$.from(bs).toRight((Function0 & Serializable)() -> new StringBuilder(20).append("Invalid hex string: ").append((String)bs).toString()));
    private static final Codec<InetAddress> inetAddressCodec = MODULE$.codecXemap((Function1 & Serializable)s -> MODULE$.createInetAddress((String)s), (Function1 & Serializable)x$2 -> x$2.getHostAddress(), Encoder$.MODULE$.encodeString(), Decoder$.MODULE$.decodeString());
    private static final Codec<InetSocketAddress> socketAddressCodec;
    private static final Encoder<TimeStamp> timestampEncoder;
    private static final Decoder<TimeStamp> timestampDecoder;
    private static final Codec<TimeStamp> timestampCodec;

    static {
        Encoder.AsObject encoder = Encoder$.MODULE$.forProduct2("addr", "port", (Function1 & Serializable)sAddr -> new Tuple2((Object)sAddr.getAddress(), (Object)BoxesRunTime.boxToInteger((int)sAddr.getPort())), MODULE$.inetAddressCodec(), Encoder$.MODULE$.encodeInt());
        Decoder decoder = Decoder$.MODULE$.forProduct2("addr", "port", (Function2 & Serializable)(x$3, x$4) -> CirceUtils$.$anonfun$socketAddressCodec$2(x$3, BoxesRunTime.unboxToInt((Object)x$4)), MODULE$.inetAddressCodec(), Decoder$.MODULE$.decodeInt()).emap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InetAddress iAddr = (InetAddress)tuple2._1();
            int port = tuple2._2$mcI$sp();
            Either<String, InetSocketAddress> either = MODULE$.createSocketAddress(iAddr, port);
            return either;
        });
        socketAddressCodec = Codec$.MODULE$.from(decoder, (Encoder)encoder);
        timestampEncoder = Encoder$.MODULE$.encodeLong().contramap((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)((TimeStamp)x$5).millis()));
        timestampDecoder = Decoder$.MODULE$.decodeLong().ensure((Function1)(JFunction1.mcZJ.sp & Serializable)x$6 -> x$6 >= 0L, (Function0 & Serializable)() -> "expect positive timestamp").map((Function1 & Serializable)millis -> new TimeStamp(TimeStamp$.MODULE$.unsafe(BoxesRunTime.unboxToLong((Object)millis))));
        timestampCodec = Codec$.MODULE$.from(MODULE$.timestampDecoder(), MODULE$.timestampEncoder());
    }

    public Printer printer() {
        return printer;
    }

    public String print(Json json) {
        return this.printer().print(json);
    }

    public <T, U> Codec<U> codecXmap(Function1<T, U> to, Function1<U, T> from, Codec<T> codec) {
        Encoder encoder = codec.contramap(from);
        Decoder decoder = codec.map(to);
        return Codec$.MODULE$.from(decoder, encoder);
    }

    public <T, U> Codec<U> codecXemap(Function1<T, Either<String, U>> to, Function1<U, T> from, Encoder<T> _encoder, Decoder<T> _decoder) {
        Encoder encoder = _encoder.contramap(from);
        Decoder decoder = _decoder.emap(to);
        return Codec$.MODULE$.from(decoder, encoder);
    }

    public <A> Encoder<Object> arrayEncoder(ClassTag<A> evidence$1, Encoder<A> encoder) {
        return new Encoder<Object>(encoder){
            private static final long serialVersionUID = 0L;
            private final Encoder encoder$1;

            public final <B> Encoder<B> contramap(Function1<B, Object> f) {
                return Encoder.contramap$((Encoder)this, f);
            }

            public final Encoder<Object> mapJson(Function1<Json, Json> f) {
                return Encoder.mapJson$((Encoder)this, f);
            }

            public final Json apply(Object a) {
                return CirceUtils$.org$alephium$api$CirceUtils$$$anonfun$arrayEncoder$1(a, this.encoder$1);
            }
            {
                this.encoder$1 = encoder$1;
                Encoder.$init$((Encoder)this);
            }
        };
    }

    public <A> Decoder<Object> arrayDecoder(ClassTag<A> evidence$2, Decoder<A> decoder) {
        return Decoder$.MODULE$.decodeArray(decoder, Factory$.MODULE$.arrayFactory(evidence$2));
    }

    public <A> Codec<Object> arrayCodec(ClassTag<A> evidence$3, Encoder<A> encoder, Decoder<A> decoder) {
        return Codec$.MODULE$.from(this.arrayDecoder(evidence$3, decoder), this.arrayEncoder(evidence$3, encoder));
    }

    public <A> Encoder<AVector<A>> avectorEncoder(ClassTag<A> evidence$4, Encoder<A> encoder) {
        return new Encoder<AVector<A>>(encoder){
            private static final long serialVersionUID = 0L;
            private final Encoder encoder$2;

            public final <B> Encoder<B> contramap(Function1<B, AVector<A>> f) {
                return Encoder.contramap$((Encoder)this, f);
            }

            public final Encoder<AVector<A>> mapJson(Function1<Json, Json> f) {
                return Encoder.mapJson$((Encoder)this, f);
            }

            public final Json apply(AVector<A> a) {
                return CirceUtils$.org$alephium$api$CirceUtils$$$anonfun$avectorEncoder$1(a, this.encoder$2);
            }
            {
                this.encoder$2 = encoder$2;
                Encoder.$init$((Encoder)this);
            }
        };
    }

    public <A> Decoder<AVector<A>> avectorDecoder(ClassTag<A> evidence$5, Decoder<A> decoder) {
        return Decoder$.MODULE$.decodeArray(decoder, Factory$.MODULE$.arrayFactory(evidence$5)).map((Function1 & Serializable)x$1 -> AVector$.MODULE$.unsafe(x$1, evidence$5));
    }

    public <A> Codec<AVector<A>> avectorCodec(ClassTag<A> evidence$6, Encoder<A> encoder, Decoder<A> decoder) {
        return Codec$.MODULE$.from(this.avectorDecoder(evidence$6, decoder), this.avectorEncoder(evidence$6, encoder));
    }

    public Encoder<ByteString> byteStringEncoder() {
        return byteStringEncoder;
    }

    public Decoder<ByteString> byteStringDecoder() {
        return byteStringDecoder;
    }

    public Codec<InetAddress> inetAddressCodec() {
        return inetAddressCodec;
    }

    private Either<String, InetAddress> createInetAddress(String s) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply((Object)InetAddress.getByName(s));
        }
        catch (Throwable e) {
            right = package$.MODULE$.Left().apply((Object)e.getMessage());
        }
        return right;
    }

    public Codec<InetSocketAddress> socketAddressCodec() {
        return socketAddressCodec;
    }

    private Either<String, InetSocketAddress> createSocketAddress(InetAddress address, int port) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply((Object)new InetSocketAddress(address, port));
        }
        catch (Throwable e) {
            left = package$.MODULE$.Left().apply((Object)e.getMessage());
        }
        return left;
    }

    public Encoder<TimeStamp> timestampEncoder() {
        return timestampEncoder;
    }

    public Decoder<TimeStamp> timestampDecoder() {
        return timestampDecoder;
    }

    public Codec<TimeStamp> timestampCodec() {
        return timestampCodec;
    }

    public static final /* synthetic */ Json org$alephium$api$CirceUtils$$$anonfun$arrayEncoder$1(Object as, Encoder encoder$1) {
        return Json$.MODULE$.fromValues((Iterable)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(as), (Function1 & Serializable)a -> encoder$1.apply(a), ClassTag$.MODULE$.apply(Json.class))));
    }

    public static final /* synthetic */ Json org$alephium$api$CirceUtils$$$anonfun$avectorEncoder$1(AVector as, Encoder encoder$2) {
        return Json$.MODULE$.fromValues((Iterable)as.toIterable().map((Function1 & Serializable)a -> encoder$2.apply(a)));
    }

    public static final /* synthetic */ Json org$alephium$api$CirceUtils$$$anonfun$byteStringEncoder$1(ByteString bs) {
        return Json$.MODULE$.fromString(Hex$.MODULE$.toHexString((IndexedSeq)bs));
    }

    public static final /* synthetic */ Tuple2 $anonfun$socketAddressCodec$2(InetAddress x$3, int x$4) {
        return new Tuple2((Object)x$3, (Object)BoxesRunTime.boxToInteger((int)x$4));
    }

    private CirceUtils$() {
    }
}

