/*
 * Decompiled with CFR 0.152.
 */
package org.alephium.api.model;

import akka.util.ByteString;
import java.io.Serializable;
import java.math.BigInteger;
import org.alephium.api.ApiError;
import org.alephium.api.model.Amount;
import org.alephium.api.model.Token;
import org.alephium.api.package$;
import org.alephium.crypto.BIP340SchnorrPublicKey;
import org.alephium.crypto.BIP340SchnorrPublicKey$;
import org.alephium.crypto.Blake2b;
import org.alephium.crypto.SecP256K1PublicKey;
import org.alephium.protocol.model.SchnorrAddress;
import org.alephium.protocol.model.TokenId;
import org.alephium.protocol.model.TokenId$;
import org.alephium.protocol.vm.LockupScript;
import org.alephium.protocol.vm.LockupScript$;
import org.alephium.protocol.vm.UnlockScript;
import org.alephium.protocol.vm.UnlockScript$;
import org.alephium.util.AVector;
import org.alephium.util.AVector$;
import org.alephium.util.Hex$;
import org.alephium.util.U256;
import org.alephium.util.U256$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.util.Either;
import sttp.model.StatusCode;

public final class BuildTxCommon$ {
    public static final BuildTxCommon$ MODULE$ = new BuildTxCommon$();

    public Either<ApiError<? extends StatusCode>, Tuple2<LockupScript.Asset, UnlockScript>> p2pkhLockPair(ByteString fromPublicKey) {
        Option option = org.alephium.protocol.package$.MODULE$.PublicKey().from(fromPublicKey);
        if (option instanceof Some) {
            SecP256K1PublicKey publicKey = (SecP256K1PublicKey)((Some)option).value();
            return scala.package$.MODULE$.Right().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LockupScript$.MODULE$.p2pkh(publicKey)), (Object)UnlockScript$.MODULE$.p2pkh(publicKey)));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Left().apply(package$.MODULE$.badRequest(new StringBuilder(30).append("Invalid SecP256K1 public key: ").append(Hex$.MODULE$.toHexString((IndexedSeq)fromPublicKey)).toString()));
        }
        throw new MatchError((Object)option);
    }

    public Either<ApiError<? extends StatusCode>, Tuple2<LockupScript.Asset, UnlockScript>> schnorrLockPair(ByteString fromPublicKey) {
        Option option = BIP340SchnorrPublicKey$.MODULE$.from(fromPublicKey);
        if (option instanceof Some) {
            BIP340SchnorrPublicKey publicKey = (BIP340SchnorrPublicKey)((Some)option).value();
            SchnorrAddress address = new SchnorrAddress(publicKey);
            return scala.package$.MODULE$.Right().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)address.lockupScript()), (Object)address.unlockScript()));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Left().apply(package$.MODULE$.badRequest(new StringBuilder(34).append("Invalid BIP340Schnorr public key: ").append(Hex$.MODULE$.toHexString((IndexedSeq)fromPublicKey)).toString()));
        }
        throw new MatchError((Object)option);
    }

    public Either<String, Tuple2<Option<U256>, AVector<Tuple2<TokenId, U256>>>> getAlphAndTokenAmounts(Option<Amount> attoAlphAmount, Option<AVector<Token>> tokensAmount) {
        Option alphAmountOpt = attoAlphAmount.map((Function1 & Serializable)x$1 -> new U256(x$1.value()));
        if (None$.MODULE$.equals(tokensAmount)) {
            return scala.package$.MODULE$.Right().apply((Object)new Tuple2((Object)alphAmountOpt, (Object)AVector$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class))));
        }
        if (tokensAmount instanceof Some) {
            return ((AVector)((Some)tokensAmount).value()).foldE((Object)new Tuple2((Object)alphAmountOpt, (Object)Predef$.MODULE$.Map().empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (x0$1 != null) {
                    Option option = (Option)x0$1._1();
                    Map tokenList = (Map)x0$1._2();
                    if (option instanceof Some) {
                        BigInteger alphAmount = ((U256)((Some)option).value()).v();
                        if (x1$1 != null) {
                            Blake2b blake2b = x1$1.id();
                            BigInteger tokenAmount = x1$1.amount();
                            Blake2b blake2b2 = TokenId$.MODULE$.alph();
                            if (!(blake2b2 != null ? !blake2b2.equals(blake2b) : blake2b != null)) {
                                return U256$.MODULE$.add$extension(alphAmount, tokenAmount).toRight((Function0 & Serializable)() -> "ALPH amount overflow").map((Function1 & Serializable)v -> BuildTxCommon$.$anonfun$getAlphAndTokenAmounts$4(tokenList, ((U256)v).v()));
                            }
                        }
                    }
                }
                if (x0$1 != null) {
                    Option option = (Option)x0$1._1();
                    Map tokenList = (Map)x0$1._2();
                    if (None$.MODULE$.equals(option) && x1$1 != null) {
                        Blake2b blake2b = x1$1.id();
                        BigInteger tokenAmount = x1$1.amount();
                        Blake2b blake2b3 = TokenId$.MODULE$.alph();
                        if (!(blake2b3 != null ? !blake2b3.equals(blake2b) : blake2b != null)) {
                            return scala.package$.MODULE$.Right().apply((Object)new Tuple2((Object)new Some((Object)new U256(tokenAmount)), (Object)tokenList));
                        }
                    }
                }
                if (x0$1 != null) {
                    Option alphOpt = (Option)x0$1._1();
                    Map tokenList = (Map)x0$1._2();
                    if (x1$1 != null) {
                        Blake2b tokenId = x1$1.id();
                        BigInteger tokenAmount = x1$1.amount();
                        if (tokenList.contains((Object)new TokenId(tokenId))) {
                            return U256$.MODULE$.add$extension(((U256)tokenList.apply((Object)new TokenId(tokenId))).v(), tokenAmount).toRight((Function0 & Serializable)() -> new StringBuilder(22).append("Token ").append(new TokenId(tokenId)).append(" amount overflow").toString()).map((Function1 & Serializable)v -> BuildTxCommon$.$anonfun$getAlphAndTokenAmounts$6(alphOpt, tokenList, tokenId, ((U256)v).v()));
                        }
                        return scala.package$.MODULE$.Right().apply((Object)new Tuple2((Object)alphOpt, (Object)tokenList.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TokenId(tokenId)), (Object)new U256(tokenAmount)))));
                    }
                }
                throw new MatchError((Object)tuple2);
            }).map((Function1 & Serializable)v -> new Tuple2(v._1(), (Object)AVector$.MODULE$.from((IterableOnce)v._2(), ClassTag$.MODULE$.apply(Tuple2.class))));
        }
        throw new MatchError(tokensAmount);
    }

    public static final /* synthetic */ Tuple2 $anonfun$getAlphAndTokenAmounts$4(Map tokenList$1, BigInteger v) {
        return new Tuple2((Object)new Some((Object)new U256(v)), (Object)tokenList$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$getAlphAndTokenAmounts$6(Option alphOpt$1, Map tokenList$2, Blake2b tokenId$1, BigInteger v) {
        return new Tuple2((Object)alphOpt$1, (Object)tokenList$2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TokenId(tokenId$1)), (Object)new U256(v))));
    }

    private BuildTxCommon$() {
    }
}

