/*
 * Decompiled with CFR 0.152.
 */
package org.alephium.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Blake3Java {
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();
    private static final int DEFAULT_HASH_LEN = 32;
    private static final int OUT_LEN = 32;
    private static final int KEY_LEN = 32;
    private static final int BLOCK_LEN = 64;
    private static final int CHUNK_LEN = 1024;
    private static final int CHUNK_START = 1;
    private static final int CHUNK_END = 2;
    private static final int PARENT = 4;
    private static final int ROOT = 8;
    private static final int KEYED_HASH = 16;
    private static final int DERIVE_KEY_CONTEXT = 32;
    private static final int DERIVE_KEY_MATERIAL = 64;
    private static final int[] IV = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final int[] MSG_PERMUTATION = new int[]{2, 6, 3, 10, 7, 0, 4, 13, 1, 11, 12, 5, 9, 14, 15, 8};
    private ChunkState chunkState;
    private int[] key;
    private final int[][] cvStack = new int[54][];
    private byte cvStackLen = 0;
    private int flags;

    private static int wrappingAdd(int n, int n2) {
        return n + n2;
    }

    private static int rotateRight(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    private static void g(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        nArray[n] = Blake3Java.wrappingAdd(Blake3Java.wrappingAdd(nArray[n], nArray[n2]), n5);
        nArray[n4] = Blake3Java.rotateRight(nArray[n4] ^ nArray[n], 16);
        nArray[n3] = Blake3Java.wrappingAdd(nArray[n3], nArray[n4]);
        nArray[n2] = Blake3Java.rotateRight(nArray[n2] ^ nArray[n3], 12);
        nArray[n] = Blake3Java.wrappingAdd(Blake3Java.wrappingAdd(nArray[n], nArray[n2]), n6);
        nArray[n4] = Blake3Java.rotateRight(nArray[n4] ^ nArray[n], 8);
        nArray[n3] = Blake3Java.wrappingAdd(nArray[n3], nArray[n4]);
        nArray[n2] = Blake3Java.rotateRight(nArray[n2] ^ nArray[n3], 7);
    }

    private static void roundFn(int[] nArray, int[] nArray2) {
        Blake3Java.g(nArray, 0, 4, 8, 12, nArray2[0], nArray2[1]);
        Blake3Java.g(nArray, 1, 5, 9, 13, nArray2[2], nArray2[3]);
        Blake3Java.g(nArray, 2, 6, 10, 14, nArray2[4], nArray2[5]);
        Blake3Java.g(nArray, 3, 7, 11, 15, nArray2[6], nArray2[7]);
        Blake3Java.g(nArray, 0, 5, 10, 15, nArray2[8], nArray2[9]);
        Blake3Java.g(nArray, 1, 6, 11, 12, nArray2[10], nArray2[11]);
        Blake3Java.g(nArray, 2, 7, 8, 13, nArray2[12], nArray2[13]);
        Blake3Java.g(nArray, 3, 4, 9, 14, nArray2[14], nArray2[15]);
    }

    private static int[] permute(int[] nArray) {
        int[] nArray2 = new int[16];
        for (int i = 0; i < 16; ++i) {
            nArray2[i] = nArray[MSG_PERMUTATION[i]];
        }
        return nArray2;
    }

    private static int[] compress(int[] nArray, int[] nArray2, long l, int n, int n2) {
        int n3 = (int)(l & 0xFFFFFFFFL);
        int n4 = (int)(l >> 32 & 0xFFFFFFFFL);
        int[] nArray3 = new int[]{nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], nArray[6], nArray[7], IV[0], IV[1], IV[2], IV[3], n3, n4, n, n2};
        Blake3Java.roundFn(nArray3, nArray2);
        nArray2 = Blake3Java.permute(nArray2);
        Blake3Java.roundFn(nArray3, nArray2);
        nArray2 = Blake3Java.permute(nArray2);
        Blake3Java.roundFn(nArray3, nArray2);
        nArray2 = Blake3Java.permute(nArray2);
        Blake3Java.roundFn(nArray3, nArray2);
        nArray2 = Blake3Java.permute(nArray2);
        Blake3Java.roundFn(nArray3, nArray2);
        nArray2 = Blake3Java.permute(nArray2);
        Blake3Java.roundFn(nArray3, nArray2);
        nArray2 = Blake3Java.permute(nArray2);
        Blake3Java.roundFn(nArray3, nArray2);
        for (int i = 0; i < 8; ++i) {
            int n5 = i;
            nArray3[n5] = nArray3[n5] ^ nArray3[i + 8];
            int n6 = i + 8;
            nArray3[n6] = nArray3[n6] ^ nArray[i];
        }
        return nArray3;
    }

    private static int[] wordsFromLEBytes(byte[] byArray) {
        int[] nArray = new int[byArray.length / 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = byteBuffer.getInt();
        }
        return nArray;
    }

    private Blake3Java() {
        this.initialize(IV, 0);
    }

    private Blake3Java(byte[] byArray) {
        this.initialize(Blake3Java.wordsFromLEBytes(byArray), 16);
    }

    private Blake3Java(String string) {
        Blake3Java blake3Java = new Blake3Java();
        blake3Java.initialize(IV, 32);
        blake3Java.update(string.getBytes(StandardCharsets.UTF_8));
        int[] nArray = Blake3Java.wordsFromLEBytes(blake3Java.digest());
        this.initialize(nArray, 64);
    }

    private void initialize(int[] nArray, int n) {
        this.chunkState = new ChunkState(nArray, 0L, n);
        this.key = nArray;
        this.flags = n;
    }

    public void update(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                if (n == byArray.length) {
                    this.update(byArray);
                    continue;
                }
                this.update(Arrays.copyOfRange(byArray, 0, n));
            }
        }
    }

    public void update(byte[] byArray) {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            if (this.chunkState.len() == 1024) {
                int[] nArray = this.chunkState.createNode().chainingValue();
                long l = this.chunkState.chunkCounter + 1L;
                this.addChunkChainingValue(nArray, l);
                this.chunkState = new ChunkState(this.key, l, this.flags);
            }
            int n2 = 1024 - this.chunkState.len();
            n = Math.min(n2, byArray.length - i);
            this.chunkState.update(Arrays.copyOfRange(byArray, i, i + n));
        }
    }

    public byte[] digest(int n) {
        Node node = this.chunkState.createNode();
        int n2 = this.cvStackLen;
        while (n2 > 0) {
            node = Blake3Java.parentNode(this.cvStack[--n2], node.chainingValue(), this.key, this.flags);
        }
        return node.rootOutputBytes(n);
    }

    public byte[] digest() {
        return this.digest(32);
    }

    public String hexdigest(int n) {
        return Blake3Java.bytesToHex(this.digest(n));
    }

    public String hexdigest() {
        return this.hexdigest(32);
    }

    private void pushStack(int[] nArray) {
        this.cvStack[this.cvStackLen] = nArray;
        this.cvStackLen = (byte)(this.cvStackLen + 1);
    }

    private int[] popStack() {
        this.cvStackLen = (byte)(this.cvStackLen - 1);
        return this.cvStack[this.cvStackLen];
    }

    private static Node parentNode(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2;
        int n3;
        int[] nArray4 = new int[16];
        int n4 = 0;
        int[] nArray5 = nArray;
        int n5 = nArray5.length;
        for (n3 = 0; n3 < n5; ++n3) {
            nArray4[n4] = n2 = nArray5[n3];
            ++n4;
        }
        nArray5 = nArray2;
        n5 = nArray5.length;
        for (n3 = 0; n3 < n5; ++n3) {
            nArray4[n4] = n2 = nArray5[n3];
            ++n4;
        }
        return new Node(nArray3, nArray4, 0L, 64, 4 | n);
    }

    private static int[] parentCV(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        return Blake3Java.parentNode(nArray, nArray2, nArray3, n).chainingValue();
    }

    private void addChunkChainingValue(int[] nArray, long l) {
        while ((l & 1L) == 0L) {
            nArray = Blake3Java.parentCV(this.popStack(), nArray, this.key, this.flags);
            l >>= 1;
        }
        this.pushStack(nArray);
    }

    private static String bytesToHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray[i * 2] = HEX_ARRAY[n >>> 4];
            cArray[i * 2 + 1] = HEX_ARRAY[n & 0xF];
        }
        return new String(cArray);
    }

    public static Blake3Java newInstance() {
        return new Blake3Java();
    }

    public static Blake3Java newKeyedHasher(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalStateException("Invalid key length");
        }
        return new Blake3Java(byArray);
    }

    public static Blake3Java newKeyDerivationHasher(String string) {
        return new Blake3Java(string);
    }

    private static class ChunkState {
        int[] chainingValue;
        long chunkCounter;
        byte[] block = new byte[64];
        byte blockLen = 0;
        byte blocksCompressed = 0;
        int flags;

        public ChunkState(int[] nArray, long l, int n) {
            this.chainingValue = nArray;
            this.chunkCounter = l;
            this.flags = n;
        }

        public int len() {
            return 64 * this.blocksCompressed + this.blockLen;
        }

        private int startFlag() {
            return this.blocksCompressed == 0 ? 1 : 0;
        }

        private void update(byte[] byArray) {
            int n;
            for (int i = 0; i < byArray.length; i += n) {
                if (this.blockLen == 64) {
                    int[] nArray = Blake3Java.wordsFromLEBytes(this.block);
                    this.chainingValue = Arrays.copyOfRange(Blake3Java.compress(this.chainingValue, nArray, this.chunkCounter, 64, this.flags | this.startFlag()), 0, 8);
                    this.blocksCompressed = (byte)(this.blocksCompressed + 1);
                    this.block = new byte[64];
                    this.blockLen = 0;
                }
                int n2 = 64 - this.blockLen;
                n = Math.min(n2, byArray.length - i);
                System.arraycopy(byArray, i, this.block, this.blockLen, n);
                this.blockLen = (byte)(this.blockLen + n);
            }
        }

        private Node createNode() {
            return new Node(this.chainingValue, Blake3Java.wordsFromLEBytes(this.block), this.chunkCounter, this.blockLen, this.flags | this.startFlag() | 2);
        }
    }

    private static class Node {
        int[] inputChainingValue;
        int[] blockWords;
        long counter;
        int blockLen;
        int flags;

        private Node(int[] nArray, int[] nArray2, long l, int n, int n2) {
            this.inputChainingValue = nArray;
            this.blockWords = nArray2;
            this.counter = l;
            this.blockLen = n;
            this.flags = n2;
        }

        private int[] chainingValue() {
            return Arrays.copyOfRange(Blake3Java.compress(this.inputChainingValue, this.blockWords, this.counter, this.blockLen, this.flags), 0, 8);
        }

        private byte[] rootOutputBytes(int n) {
            int n2 = Math.floorDiv(n, 64) + 1;
            byte[] byArray = new byte[n];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int[] nArray;
                for (int n4 : nArray = Blake3Java.compress(this.inputChainingValue, this.blockWords, i, this.blockLen, this.flags | 8)) {
                    byte[] byArray2 = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(n4).array();
                    int n5 = byArray2.length;
                    for (int j = 0; j < n5; ++j) {
                        byte by;
                        byArray[n3] = by = byArray2[j];
                        if (++n3 != n) continue;
                        return byArray;
                    }
                }
            }
            throw new IllegalStateException("Uh oh something has gone horribly wrong. Please create an issue on https://github.com/rctcwyvrn/blake3");
        }
    }
}

