/*
 * Decompiled with CFR 0.152.
 */
package org.alephium.crypto;

import akka.util.ByteString;
import java.math.BigInteger;
import org.alephium.crypto.PrivateKey;
import org.alephium.crypto.PublicKey;
import org.alephium.crypto.SecP256K1PrivateKey;
import org.alephium.crypto.SecP256K1PrivateKey$;
import org.alephium.crypto.SecP256K1PublicKey;
import org.alephium.crypto.SecP256K1Signature;
import org.alephium.crypto.SecP256K1Signature$;
import org.alephium.crypto.Signature;
import org.alephium.crypto.SignatureSchema;
import org.alephium.util.AVector;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import scala.Array;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.util.control.NonFatal$;

public final class SecP256K1$
implements SignatureSchema<SecP256K1PrivateKey, SecP256K1PublicKey, SecP256K1Signature> {
    public static final SecP256K1$ MODULE$ = new SecP256K1$();
    private static final X9ECParameters params;
    private static final ECCurve curve;
    private static final ECDomainParameters domain;
    private static final BigInteger halfCurveOrder;

    static {
        SignatureSchema.$init$(MODULE$);
        params = CustomNamedCurves.getByName((String)"secp256k1");
        curve = MODULE$.params().getCurve();
        domain = new ECDomainParameters(MODULE$.curve(), MODULE$.params().getG(), MODULE$.params().getN(), MODULE$.params().getH());
        halfCurveOrder = MODULE$.params().getN().shiftRight(1);
    }

    @Override
    public Signature sign(ByteString message, PrivateKey privateKey) {
        return SignatureSchema.sign$((SignatureSchema)this, message, privateKey);
    }

    @Override
    public Signature sign(AVector message, PrivateKey privateKey) {
        return SignatureSchema.sign$((SignatureSchema)this, message, privateKey);
    }

    @Override
    public boolean verify(ByteString message, Signature signature, PublicKey publicKey) {
        return SignatureSchema.verify$((SignatureSchema)this, message, signature, publicKey);
    }

    @Override
    public boolean verify(AVector message, Signature signature, PublicKey publicKey) {
        return SignatureSchema.verify$((SignatureSchema)this, message, signature, publicKey);
    }

    public X9ECParameters params() {
        return params;
    }

    public ECCurve curve() {
        return curve;
    }

    public ECDomainParameters domain() {
        return domain;
    }

    public BigInteger halfCurveOrder() {
        return halfCurveOrder;
    }

    public ECPoint point(ByteString bytes) {
        return this.curve().decodePoint((byte[])bytes.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
    }

    @Override
    public Tuple2<SecP256K1PrivateKey, SecP256K1PublicKey> generatePriPub() {
        SecP256K1PrivateKey privateKey = (SecP256K1PrivateKey)SecP256K1PrivateKey$.MODULE$.generate();
        return new Tuple2((Object)privateKey, (Object)privateKey.publicKey());
    }

    @Override
    public Tuple2<SecP256K1PrivateKey, SecP256K1PublicKey> secureGeneratePriPub() {
        SecP256K1PrivateKey privateKey = (SecP256K1PrivateKey)SecP256K1PrivateKey$.MODULE$.secureGenerate();
        return new Tuple2((Object)privateKey, (Object)privateKey.publicKey());
    }

    @Override
    public SecP256K1Signature sign(byte[] message, byte[] privateKey) {
        Object object;
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        BigInteger d = new BigInteger(1, privateKey);
        signer.init(true, (CipherParameters)new ECPrivateKeyParameters(d, this.domain()));
        BigInteger[] bigIntegerArray = signer.generateSignature(message);
        if (bigIntegerArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)bigIntegerArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
            throw new MatchError((Object)bigIntegerArray);
        }
        BigInteger r = (BigInteger)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        BigInteger s = (BigInteger)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        Tuple2 tuple2 = new Tuple2((Object)r, (Object)s);
        Tuple2 tuple22 = tuple2;
        BigInteger r2 = (BigInteger)tuple22._1();
        BigInteger s2 = (BigInteger)tuple22._2();
        return SecP256K1Signature$.MODULE$.from(r2, this.canonicalize(s2));
    }

    public boolean org$alephium$crypto$SecP256K1$$isCanonical(BigInteger s) {
        return s.compareTo(this.halfCurveOrder()) <= 0;
    }

    public BigInteger canonicalize(BigInteger s) {
        return this.org$alephium$crypto$SecP256K1$$isCanonical(s) ? s : this.params().getN().subtract(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean verify(byte[] message, byte[] signature, byte[] publicKey) {
        boolean bl;
        Tuple2<BigInteger, BigInteger> tuple2 = SecP256K1Signature$.MODULE$.decode(signature);
        if (tuple2 == null) throw new MatchError(tuple2);
        BigInteger r = (BigInteger)tuple2._1();
        BigInteger s = (BigInteger)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)r, (Object)s);
        Tuple2 tuple23 = tuple22;
        BigInteger r2 = (BigInteger)tuple23._1();
        BigInteger s2 = (BigInteger)tuple23._2();
        if (!this.org$alephium$crypto$SecP256K1$$isCanonical(s2)) return false;
        try {
            ECDSASigner signer = new ECDSASigner();
            ECPoint publicKeyPoint = this.curve().decodePoint(publicKey);
            signer.init(false, (CipherParameters)new ECPublicKeyParameters(publicKeyPoint, this.domain()));
            bl = signer.verifySignature(message, r2, s2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 == null) throw throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) throw throwable;
            return false;
        }
        if (!bl) return false;
        return true;
    }

    private SecP256K1$() {
    }
}

