/*
 * Decompiled with CFR 0.152.
 */
package org.alephium.crypto;

import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.alephium.crypto.AES;
import org.alephium.util.SecureAndSlowRandom$;
import scala.Array$;
import scala.Function0;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.util.Try;
import scala.util.Try$;

public final class AES$ {
    public static final AES$ MODULE$ = new AES$();
    private static final int saltByteLength = 64;
    private static final int ivByteLength = 64;
    private static final int authTagLength = 128;
    private static final String keyAlgorithm = "PBKDF2WithHmacSHA256";
    private static final int iterationCount = 10000;
    private static final int keyLength = 256;
    private static final String cipherAlgorithm = "AES";
    private static final String cipherTransformation = new StringBuilder(14).append(MODULE$.cipherAlgorithm()).append("/GCM/NoPadding").toString();

    private int saltByteLength() {
        return saltByteLength;
    }

    private int ivByteLength() {
        return ivByteLength;
    }

    private int authTagLength() {
        return authTagLength;
    }

    private String keyAlgorithm() {
        return keyAlgorithm;
    }

    private int iterationCount() {
        return iterationCount;
    }

    private int keyLength() {
        return keyLength;
    }

    private String cipherAlgorithm() {
        return cipherAlgorithm;
    }

    private String cipherTransformation() {
        return cipherTransformation;
    }

    public AES.Encrypted encrypt(ByteString data, String password) {
        byte[] salt = this.randomBytesOf(this.saltByteLength());
        byte[] iv = this.randomBytesOf(this.ivByteLength());
        byte[] encrypted = this.initCipher(1, password, salt, iv).doFinal((byte[])data.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
        return new AES.Encrypted(this.byteString(encrypted), this.byteString(salt), this.byteString(iv));
    }

    public Try<ByteString> decrypt(AES.Encrypted encrypted, String password) {
        Cipher cipher = this.initCipher(2, password, (byte[])encrypted.salt().toArray((ClassTag)ClassTag$.MODULE$.Byte()), (byte[])encrypted.iv().toArray((ClassTag)ClassTag$.MODULE$.Byte()));
        return Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.byteString(cipher.doFinal((byte[])encrypted.encrypted().toArray((ClassTag)ClassTag$.MODULE$.Byte()))));
    }

    private byte[] randomBytesOf(int length) {
        byte[] array = (byte[])Array$.MODULE$.ofDim(length, (ClassTag)ClassTag$.MODULE$.Byte());
        SecureAndSlowRandom$.MODULE$.source().nextBytes(array);
        return array;
    }

    private Cipher initCipher(int mode, String password, byte[] salt, byte[] iv) {
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, this.iterationCount(), this.keyLength());
        byte[] key = SecretKeyFactory.getInstance(this.keyAlgorithm()).generateSecret(keySpec).getEncoded();
        SecretKeySpec derivedKey = new SecretKeySpec(key, this.cipherAlgorithm());
        GCMParameterSpec parameters = new GCMParameterSpec(this.authTagLength(), iv);
        Cipher cipher = Cipher.getInstance(this.cipherTransformation());
        cipher.init(mode, (Key)derivedKey, parameters);
        return cipher;
    }

    private ByteString byteString(byte[] array) {
        return ByteString$.MODULE$.fromArrayUnsafe(array);
    }

    private AES$() {
    }
}

