/*
 * Decompiled with CFR 0.152.
 */
package org.alephium.crypto;

import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.alephium.crypto.BIP340SchnorrPrivateKey;
import org.alephium.crypto.BIP340SchnorrPrivateKey$;
import org.alephium.crypto.BIP340SchnorrPublicKey;
import org.alephium.crypto.BIP340SchnorrSignature;
import org.alephium.crypto.BIP340SchnorrSignature$;
import org.alephium.crypto.Byte32;
import org.alephium.crypto.Byte32$;
import org.alephium.crypto.PrivateKey;
import org.alephium.crypto.PublicKey;
import org.alephium.crypto.SecP256K1CurveCommon;
import org.alephium.crypto.Sha256;
import org.alephium.crypto.Sha256$;
import org.alephium.crypto.Signature;
import org.alephium.crypto.SignatureSchema;
import org.alephium.serde.RandomBytes;
import org.alephium.util.AVector;
import org.alephium.util.U256$;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class BIP340Schnorr$
implements SecP256K1CurveCommon,
SignatureSchema<BIP340SchnorrPrivateKey, BIP340SchnorrPublicKey, BIP340SchnorrSignature> {
    public static final BIP340Schnorr$ MODULE$ = new BIP340Schnorr$();
    private static Sha256 auxTag;
    private static Sha256 nonceTag;
    private static Sha256 challengeTag;
    private static BigInteger ySqOrder;
    private static final BigInteger three;
    private static BigInteger four;
    private static final BigInteger seven;
    private static X9ECParameters params;
    private static ECDomainParameters domain;
    private static BigInteger halfCurveOrder;
    private static SecP256K1Curve curve;
    private static volatile byte bitmap$0;

    static {
        SecP256K1CurveCommon.$init$(MODULE$);
        SignatureSchema.$init$(MODULE$);
        three = BigInteger.valueOf(3L);
        four = BigInteger.valueOf(4L);
        seven = BigInteger.valueOf(7L);
    }

    @Override
    public Signature sign(ByteString message, PrivateKey privateKey) {
        return SignatureSchema.sign$((SignatureSchema)this, message, privateKey);
    }

    @Override
    public Signature sign(RandomBytes bytes, PrivateKey privateKey) {
        return SignatureSchema.sign$((SignatureSchema)this, bytes, privateKey);
    }

    @Override
    public Signature sign(AVector message, PrivateKey privateKey) {
        return SignatureSchema.sign$((SignatureSchema)this, message, privateKey);
    }

    @Override
    public boolean verify(ByteString message, Signature signature, PublicKey publicKey) {
        return SignatureSchema.verify$((SignatureSchema)this, message, signature, publicKey);
    }

    @Override
    public boolean verify(AVector message, Signature signature, PublicKey publicKey) {
        return SignatureSchema.verify$((SignatureSchema)this, message, signature, publicKey);
    }

    @Override
    public X9ECParameters params() {
        return params;
    }

    @Override
    public ECDomainParameters domain() {
        return domain;
    }

    @Override
    public BigInteger halfCurveOrder() {
        return halfCurveOrder;
    }

    @Override
    public SecP256K1Curve curve() {
        return curve;
    }

    @Override
    public void org$alephium$crypto$SecP256K1CurveCommon$_setter_$params_$eq(X9ECParameters x$1) {
        params = x$1;
    }

    @Override
    public void org$alephium$crypto$SecP256K1CurveCommon$_setter_$domain_$eq(ECDomainParameters x$1) {
        domain = x$1;
    }

    @Override
    public void org$alephium$crypto$SecP256K1CurveCommon$_setter_$halfCurveOrder_$eq(BigInteger x$1) {
        halfCurveOrder = x$1;
    }

    @Override
    public void org$alephium$crypto$SecP256K1CurveCommon$_setter_$curve_$eq(SecP256K1Curve x$1) {
        curve = x$1;
    }

    public BIP340SchnorrPrivateKey privateKeyUnsafe(ByteString bytes) {
        Predef$.MODULE$.assume(bytes.length() == 32);
        BigInteger dMod = new BigInteger(1, bytes.toArrayUnsafe()).mod(this.params().getN());
        return new BIP340SchnorrPrivateKey(U256$.MODULE$.toBytes$extension(U256$.MODULE$.unsafe(dMod)));
    }

    @Override
    public Tuple2<BIP340SchnorrPrivateKey, BIP340SchnorrPublicKey> generatePriPub() {
        BIP340SchnorrPrivateKey privateKey = (BIP340SchnorrPrivateKey)BIP340SchnorrPrivateKey$.MODULE$.generate();
        return new Tuple2((Object)privateKey, (Object)privateKey.publicKey());
    }

    @Override
    public Tuple2<BIP340SchnorrPrivateKey, BIP340SchnorrPublicKey> secureGeneratePriPub() {
        BIP340SchnorrPrivateKey privateKey = (BIP340SchnorrPrivateKey)BIP340SchnorrPrivateKey$.MODULE$.secureGenerate();
        return new Tuple2((Object)privateKey, (Object)privateKey.publicKey());
    }

    @Override
    public BIP340SchnorrSignature sign(byte[] message, byte[] privateKey) {
        return this.sign(message, privateKey, ((Byte32)Byte32$.MODULE$.generate()).bytes().toArrayUnsafe());
    }

    public BIP340SchnorrSignature sign(byte[] message, byte[] privateKey, byte[] auxRandom) {
        Predef$.MODULE$.require(message.length == 32);
        BigInteger d0 = new BigInteger(1, privateKey);
        Predef$.MODULE$.require(d0.compareTo(BigInteger.ZERO) > 0 && d0.compareTo(this.params().getN()) < 0);
        Predef$.MODULE$.require(auxRandom.length == 32);
        ECPoint P = this.params().getG().multiply(d0).normalize();
        ByteString pBytes = ByteString$.MODULE$.fromArrayUnsafe(P.getAffineXCoord().getEncoded());
        Predef$.MODULE$.require(!P.isInfinity());
        BigInteger d = P.getAffineYCoord().testBitZero() ? this.params().getN().subtract(d0) : d0;
        ByteString k0Msg = this.xorBytes(this.toByte32(d), this.taggedHash(this.auxTag(), auxRandom).bytes()).$plus$plus(pBytes).$plus$plus(ByteString$.MODULE$.fromArrayUnsafe(message));
        Sha256 k0Hash = this.taggedHash(this.nonceTag(), k0Msg.toArrayUnsafe());
        BigInteger k0 = new BigInteger(1, k0Hash.bytes().toArrayUnsafe()).mod(this.params().getN());
        Predef$.MODULE$.require(!BoxesRunTime.equalsNumNum((Number)k0, (Number)BigInteger.ZERO));
        ECPoint R = this.params().getG().multiply(k0).normalize();
        Predef$.MODULE$.require(!R.isInfinity());
        ByteString rBytes = ByteString$.MODULE$.fromArrayUnsafe(R.getAffineXCoord().getEncoded());
        BigInteger k = R.getAffineYCoord().testBitZero() ? this.params().getN().subtract(k0) : k0;
        ByteString eMsg = rBytes.$plus$plus(pBytes).$plus$plus(ByteString$.MODULE$.fromArrayUnsafe(message));
        Sha256 eHash = this.taggedHash(this.challengeTag(), eMsg.toArrayUnsafe());
        BigInteger e = new BigInteger(1, eHash.bytes().toArrayUnsafe()).mod(this.params().getN());
        ByteString sig = rBytes.$plus$plus(this.toByte32(k.add(e.multiply(d)).mod(this.params().getN())));
        return (BIP340SchnorrSignature)BIP340SchnorrSignature$.MODULE$.unsafe().apply((Object)sig);
    }

    private ByteString xorBytes(ByteString bytes0, ByteString bytes1) {
        Predef$.MODULE$.assume(bytes0.length() == bytes1.length());
        byte[] result = (byte[])Array$.MODULE$.tabulate(bytes0.length(), (Function1 & Serializable)k -> BoxesRunTime.boxToByte((byte)BIP340Schnorr$.$anonfun$xorBytes$1(bytes0, bytes1, BoxesRunTime.unboxToInt((Object)k))), (ClassTag)ClassTag$.MODULE$.Byte());
        return ByteString$.MODULE$.fromArrayUnsafe(result);
    }

    public ByteString toByte32(BigInteger n) {
        return U256$.MODULE$.toBytes$extension(U256$.MODULE$.unsafe(n));
    }

    private Sha256 auxTag$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 1) == 0) {
                auxTag = (Sha256)Sha256$.MODULE$.hash((Seq<Object>)ByteString$.MODULE$.fromString("BIP0340/aux", StandardCharsets.UTF_8));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return auxTag;
    }

    private Sha256 auxTag() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.auxTag$lzycompute();
        }
        return auxTag;
    }

    private Sha256 nonceTag$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 2) == 0) {
                nonceTag = (Sha256)Sha256$.MODULE$.hash((Seq<Object>)ByteString$.MODULE$.fromString("BIP0340/nonce", StandardCharsets.UTF_8));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return nonceTag;
    }

    private Sha256 nonceTag() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.nonceTag$lzycompute();
        }
        return nonceTag;
    }

    private Sha256 challengeTag$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 4) == 0) {
                challengeTag = (Sha256)Sha256$.MODULE$.hash((Seq<Object>)ByteString$.MODULE$.fromString("BIP0340/challenge", StandardCharsets.UTF_8));
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return challengeTag;
    }

    private Sha256 challengeTag() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.challengeTag$lzycompute();
        }
        return challengeTag;
    }

    private Sha256 taggedHash(Sha256 tagHash, byte[] message) {
        return (Sha256)Sha256$.MODULE$.hash((Seq<Object>)tagHash.bytes().$plus$plus(tagHash.bytes()).$plus$plus(ByteString$.MODULE$.fromArrayUnsafe(message)));
    }

    @Override
    public boolean verify(byte[] message, byte[] signature, byte[] publicKey) {
        boolean bl;
        block5: {
            try {
                Predef$.MODULE$.require(message.length == 32);
                Predef$.MODULE$.require(signature.length == 64);
                Predef$.MODULE$.require(publicKey.length == 32);
                ECPoint P = this.liftX(publicKey);
                BigInteger r = new BigInteger(1, signature, 0, 32);
                BigInteger s = new BigInteger(1, signature, 32, 32);
                if (r.compareTo(this.curve().getQ()) >= 0 || s.compareTo(this.params().getN()) >= 0) {
                    bl = false;
                    break block5;
                }
                ByteString eMsg = ByteString$.MODULE$.fromArrayUnsafe(signature, 0, 32).$plus$plus(ByteString$.MODULE$.fromArrayUnsafe(publicKey)).$plus$plus(ByteString$.MODULE$.fromArrayUnsafe(message));
                Sha256 eHash = this.taggedHash(this.challengeTag(), eMsg.toArrayUnsafe());
                BigInteger e = new BigInteger(1, eHash.bytes().toArrayUnsafe()).mod(this.params().getN());
                ECPoint R = this.params().getG().multiply(s).add(P.multiply(this.params().getN().subtract(e))).normalize();
                if (R.isInfinity() || R.getAffineYCoord().testBitZero() || !BoxesRunTime.equalsNumNum((Number)R.getAffineXCoord().toBigInteger(), (Number)r)) {
                    bl = false;
                    break block5;
                }
                return true;
            }
            catch (Throwable throwable) {
                if (throwable != null && !NonFatal$.MODULE$.unapply(throwable).isEmpty()) {
                    return false;
                }
                throw throwable;
            }
        }
        return bl;
    }

    private BigInteger three() {
        return three;
    }

    private BigInteger four() {
        return four;
    }

    private BigInteger seven() {
        return seven;
    }

    private BigInteger ySqOrder$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 8) == 0) {
                ySqOrder = this.curve().getQ().add(BigInteger.ONE).divide(this.four());
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        four = null;
        return ySqOrder;
    }

    private BigInteger ySqOrder() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.ySqOrder$lzycompute();
        }
        return ySqOrder;
    }

    private ECPoint liftX(byte[] xRaw) {
        BigInteger x = new BigInteger(1, xRaw);
        Predef$.MODULE$.require(x.compareTo(this.curve().getQ()) < 0);
        BigInteger ySq = x.modPow(this.three(), this.curve().getQ()).add(this.seven()).mod(this.curve().getQ());
        BigInteger y0 = ySq.modPow(this.ySqOrder(), this.curve().getQ());
        Predef$.MODULE$.require(BoxesRunTime.equalsNumNum((Number)y0.modPow(BigInteger.TWO, this.curve().getQ()), (Number)ySq));
        BigInteger y = y0.testBit(0) ? this.curve().getQ().subtract(y0) : y0;
        return this.curve().createPoint(x, y);
    }

    public static final /* synthetic */ byte $anonfun$xorBytes$1(ByteString bytes0$1, ByteString bytes1$1, int k) {
        return (byte)(bytes0$1.apply(k) ^ bytes1$1.apply(k));
    }

    private BIP340Schnorr$() {
    }
}

