/*
 * Decompiled with CFR 0.152.
 */
package org.alephium.crypto;

import akka.util.ByteString;
import akka.util.ByteString$;
import java.math.BigInteger;
import org.alephium.crypto.BIP340Schnorr$;
import org.alephium.crypto.BIP340SchnorrPrivateKey$;
import org.alephium.crypto.BIP340SchnorrPublicKey;
import org.alephium.crypto.PrivateKey;
import org.alephium.serde.RandomBytes;
import org.alephium.serde.Serde;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000593AAC\u0006\u0001%!AQ\u0004\u0001BC\u0002\u0013\u0005a\u0004\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003 \u0011\u0015A\u0003\u0001\"\u0001*\u0011\u0015a\u0003\u0001\"\u0003.\u0011\u00151\u0004\u0001\"\u00018\u000f\u0015Y4\u0002#\u0001=\r\u0015Q1\u0002#\u0001>\u0011\u0015As\u0001\"\u0001I\u0011\u0015Iu\u0001\"\u0011K\u0005]\u0011\u0015\nU\u001a5aM\u001b\u0007N\\8seB\u0013\u0018N^1uK.+\u0017P\u0003\u0002\r\u001b\u000511M]=qi>T!AD\b\u0002\u0011\u0005dW\r\u001d5jk6T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0004\u0001MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u001b75\t1\"\u0003\u0002\u001d\u0017\tQ\u0001K]5wCR,7*Z=\u0002\u000b\tLH/Z:\u0016\u0003}\u0001\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\tU$\u0018\u000e\u001c\u0006\u0002I\u0005!\u0011m[6b\u0013\t1\u0013E\u0001\u0006CsR,7\u000b\u001e:j]\u001e\faAY=uKN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002+WA\u0011!\u0004\u0001\u0005\u0006;\r\u0001\raH\u0001\nO\u0016$()[4J]R$\u0012A\f\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nA!\\1uQ*\t1'\u0001\u0003kCZ\f\u0017BA\u001b1\u0005)\u0011\u0015nZ%oi\u0016<WM]\u0001\naV\u0014G.[2LKf,\u0012\u0001\u000f\t\u00035eJ!AO\u0006\u0003-\tK\u0005k\r\u001b1'\u000eDgn\u001c:s!V\u0014G.[2LKf\fqCQ%QgQ\u00024k\u00195o_J\u0014\bK]5wCR,7*Z=\u0011\u0005i91CA\u0004?!\ryTI\u000b\b\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u00056\tQa]3sI\u0016L!\u0001R!\u0002\u0017I\u000bg\u000eZ8n\u0005f$Xm]\u0005\u0003\r\u001e\u0013\u0011bQ8na\u0006t\u0017n\u001c8\u000b\u0005\u0011\u000bE#\u0001\u001f\u0002\r1,gn\u001a;i+\u0005Y\u0005C\u0001\u000bM\u0013\tiUCA\u0002J]R\u0004")
public class BIP340SchnorrPrivateKey
implements PrivateKey {
    private final ByteString bytes;

    public static int length() {
        return BIP340SchnorrPrivateKey$.MODULE$.length();
    }

    public static Serde<BIP340SchnorrPrivateKey> serde() {
        return BIP340SchnorrPrivateKey$.MODULE$.serde();
    }

    public static Object secureGenerate() {
        return BIP340SchnorrPrivateKey$.MODULE$.secureGenerate();
    }

    public static Object generate() {
        return BIP340SchnorrPrivateKey$.MODULE$.generate();
    }

    public static Option<BIP340SchnorrPrivateKey> from(ByteString bytes) {
        return BIP340SchnorrPrivateKey$.MODULE$.from(bytes);
    }

    public static Option<BIP340SchnorrPrivateKey> from(IndexedSeq<Object> bytes) {
        return BIP340SchnorrPrivateKey$.MODULE$.from(bytes);
    }

    public static Object allOne() {
        return BIP340SchnorrPrivateKey$.MODULE$.allOne();
    }

    public static Object zero() {
        return BIP340SchnorrPrivateKey$.MODULE$.zero();
    }

    public static Function1<BIP340SchnorrPrivateKey, ByteString> toBytes() {
        return BIP340SchnorrPrivateKey$.MODULE$.toBytes();
    }

    public static Function1<ByteString, BIP340SchnorrPrivateKey> unsafe() {
        return BIP340SchnorrPrivateKey$.MODULE$.unsafe();
    }

    public byte last() {
        return RandomBytes.last$((RandomBytes)this);
    }

    public byte beforeLast() {
        return RandomBytes.beforeLast$((RandomBytes)this);
    }

    public int hashCode() {
        return RandomBytes.hashCode$((RandomBytes)this);
    }

    public boolean equals(Object obj) {
        return RandomBytes.equals$((RandomBytes)this, (Object)obj);
    }

    public String toString() {
        return RandomBytes.toString$((RandomBytes)this);
    }

    public String toHexString() {
        return RandomBytes.toHexString$((RandomBytes)this);
    }

    public String shortHex() {
        return RandomBytes.shortHex$((RandomBytes)this);
    }

    public int toRandomIntUnsafe() {
        return RandomBytes.toRandomIntUnsafe$((RandomBytes)this);
    }

    public ByteString bytes() {
        return this.bytes;
    }

    private BigInteger getBigInt() {
        return new BigInteger(1, (byte[])this.bytes().toArray((ClassTag)ClassTag$.MODULE$.Byte()));
    }

    public BIP340SchnorrPublicKey publicKey() {
        BigInteger d = this.getBigInt();
        byte[] xCoord = BIP340Schnorr$.MODULE$.params().getG().multiply(d).normalize().getAffineXCoord().getEncoded();
        return new BIP340SchnorrPublicKey(ByteString$.MODULE$.fromArrayUnsafe(xCoord));
    }

    public BIP340SchnorrPrivateKey(ByteString bytes) {
        this.bytes = bytes;
        RandomBytes.$init$((RandomBytes)this);
    }
}

