/*
 * Decompiled with CFR 0.152.
 */
package org.alephium.crypto;

import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import java.math.BigInteger;
import org.alephium.crypto.Keccak256;
import org.alephium.crypto.Keccak256$;
import org.alephium.crypto.PrivateKey;
import org.alephium.crypto.PublicKey;
import org.alephium.crypto.SecP256K1CurveCommon;
import org.alephium.crypto.SecP256K1PrivateKey;
import org.alephium.crypto.SecP256K1PrivateKey$;
import org.alephium.crypto.SecP256K1PublicKey;
import org.alephium.crypto.SecP256K1Signature;
import org.alephium.crypto.SecP256K1Signature$;
import org.alephium.crypto.Signature;
import org.alephium.crypto.SignatureSchema;
import org.alephium.serde.RandomBytes;
import org.alephium.util.AVector;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.util.control.NonFatal$;

public final class SecP256K1$
implements SecP256K1CurveCommon,
SignatureSchema<SecP256K1PrivateKey, SecP256K1PublicKey, SecP256K1Signature> {
    public static final SecP256K1$ MODULE$ = new SecP256K1$();
    private static X9ECParameters params;
    private static ECDomainParameters domain;
    private static BigInteger halfCurveOrder;
    private static SecP256K1Curve curve;

    static {
        SecP256K1CurveCommon.$init$(MODULE$);
        SignatureSchema.$init$(MODULE$);
    }

    @Override
    public Signature sign(ByteString message, PrivateKey privateKey) {
        return SignatureSchema.sign$((SignatureSchema)this, message, privateKey);
    }

    @Override
    public Signature sign(RandomBytes bytes, PrivateKey privateKey) {
        return SignatureSchema.sign$((SignatureSchema)this, bytes, privateKey);
    }

    @Override
    public Signature sign(AVector message, PrivateKey privateKey) {
        return SignatureSchema.sign$((SignatureSchema)this, message, privateKey);
    }

    @Override
    public boolean verify(ByteString message, Signature signature, PublicKey publicKey) {
        return SignatureSchema.verify$((SignatureSchema)this, message, signature, publicKey);
    }

    @Override
    public boolean verify(AVector message, Signature signature, PublicKey publicKey) {
        return SignatureSchema.verify$((SignatureSchema)this, message, signature, publicKey);
    }

    @Override
    public X9ECParameters params() {
        return params;
    }

    @Override
    public ECDomainParameters domain() {
        return domain;
    }

    @Override
    public BigInteger halfCurveOrder() {
        return halfCurveOrder;
    }

    @Override
    public SecP256K1Curve curve() {
        return curve;
    }

    @Override
    public void org$alephium$crypto$SecP256K1CurveCommon$_setter_$params_$eq(X9ECParameters x$1) {
        params = x$1;
    }

    @Override
    public void org$alephium$crypto$SecP256K1CurveCommon$_setter_$domain_$eq(ECDomainParameters x$1) {
        domain = x$1;
    }

    @Override
    public void org$alephium$crypto$SecP256K1CurveCommon$_setter_$halfCurveOrder_$eq(BigInteger x$1) {
        halfCurveOrder = x$1;
    }

    @Override
    public void org$alephium$crypto$SecP256K1CurveCommon$_setter_$curve_$eq(SecP256K1Curve x$1) {
        curve = x$1;
    }

    public ECPoint point(ByteString bytes) {
        return this.curve().decodePoint((byte[])bytes.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
    }

    @Override
    public Tuple2<SecP256K1PrivateKey, SecP256K1PublicKey> generatePriPub() {
        SecP256K1PrivateKey privateKey = (SecP256K1PrivateKey)SecP256K1PrivateKey$.MODULE$.generate();
        return new Tuple2((Object)privateKey, (Object)privateKey.publicKey());
    }

    @Override
    public Tuple2<SecP256K1PrivateKey, SecP256K1PublicKey> secureGeneratePriPub() {
        SecP256K1PrivateKey privateKey = (SecP256K1PrivateKey)SecP256K1PrivateKey$.MODULE$.secureGenerate();
        return new Tuple2((Object)privateKey, (Object)privateKey.publicKey());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SecP256K1Signature sign(byte[] message, byte[] privateKey) {
        void var8_8;
        void var7_7;
        Object object;
        block3: {
            BigInteger[] bigIntegerArray;
            block2: {
                ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
                BigInteger d = new BigInteger(1, privateKey);
                signer.init(true, (CipherParameters)new ECPrivateKeyParameters(d, this.domain()));
                bigIntegerArray = signer.generateSignature(message);
                if (bigIntegerArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)bigIntegerArray))) break block2;
                new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object));
                if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) break block3;
            }
            throw new MatchError((Object)bigIntegerArray);
        }
        BigInteger r = (BigInteger)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        BigInteger s = (BigInteger)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        return SecP256K1Signature$.MODULE$.from((BigInteger)var7_7, this.canonicalize((BigInteger)var8_8));
    }

    public boolean org$alephium$crypto$SecP256K1$$isCanonical(BigInteger s) {
        return s.compareTo(this.halfCurveOrder()) <= 0;
    }

    public BigInteger canonicalize(BigInteger s) {
        if (this.org$alephium$crypto$SecP256K1$$isCanonical(s)) {
            return s;
        }
        return this.params().getN().subtract(s);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean verify(byte[] message, byte[] signature, byte[] publicKey) {
        void var6_6;
        Tuple2<BigInteger, BigInteger> tuple2 = SecP256K1Signature$.MODULE$.decode(signature);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        BigInteger r = (BigInteger)tuple2._1();
        BigInteger s = (BigInteger)tuple2._2();
        if (this.org$alephium$crypto$SecP256K1$$isCanonical((BigInteger)var6_6)) {
            boolean bl;
            try {
                void var5_5;
                ECDSASigner signer = new ECDSASigner();
                ECPoint publicKeyPoint = this.curve().decodePoint(publicKey);
                signer.init(false, (CipherParameters)new ECPublicKeyParameters(publicKeyPoint, this.domain()));
                bl = signer.verifySignature(message, (BigInteger)var5_5, (BigInteger)var6_6);
            }
            catch (Throwable throwable) {
                if (throwable != null && !NonFatal$.MODULE$.unapply(throwable).isEmpty()) {
                    bl = false;
                }
                throw throwable;
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    public Option<ByteString> ethEcRecover(ByteString messageHash, ByteString sigBytes) {
        try {
            return new Some((Object)this.ethEcRecoverUnsafe(messageHash, sigBytes));
        }
        catch (Throwable throwable) {
            if (throwable != null && !NonFatal$.MODULE$.unapply(throwable).isEmpty()) {
                return None$.MODULE$;
            }
            throw throwable;
        }
    }

    public ByteString ethEcRecoverUnsafe(ByteString messageHash, ByteString sigBytes) {
        Predef$.MODULE$.require(messageHash.length() == 32, (Function0 & Serializable)() -> "Invalid message hash length");
        Predef$.MODULE$.require(sigBytes.length() == 65, (Function0 & Serializable)() -> "Invalid sig data length");
        int recId = (sigBytes.last() & 0xFF) - 27;
        Predef$.MODULE$.require(recId == 0 || recId == 1, (Function0 & Serializable)() -> "Invalid v, 27/28 expected");
        BigInteger r = new BigInteger(1, (byte[])sigBytes.take(32).toArray((ClassTag)ClassTag$.MODULE$.Byte()));
        BigInteger s = new BigInteger(1, (byte[])sigBytes.slice(32, 64).toArray((ClassTag)ClassTag$.MODULE$.Byte()));
        BigInteger n = this.params().getN();
        Predef$.MODULE$.require(r.signum() == 1 && r.compareTo(n) < 0, (Function0 & Serializable)() -> "Invalid r");
        Predef$.MODULE$.require(s.signum() == 1 && s.compareTo(n) < 0, (Function0 & Serializable)() -> "Invalid s");
        BigInteger i = BigInteger.valueOf((long)recId / 2L);
        BigInteger x = r.add(i.multiply(n));
        BigInteger prime = this.curve().getQ();
        Predef$.MODULE$.require(x.compareTo(prime) < 0, (Function0 & Serializable)() -> "Cannot have point co-ordinates larger than this as everything takes place modulo Q.");
        ECPoint R = this.decompressKey(x, (recId & 1) == 1);
        Predef$.MODULE$.require(R.multiply(n).isInfinity(), (Function0 & Serializable)() -> "point cannot be at infinity");
        BigInteger e = new BigInteger(1, (byte[])messageHash.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = r.modInverse(n);
        BigInteger srInv = rInv.multiply(s).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        byte[] qBytes = ECAlgorithms.sumOfTwoMultiplies((ECPoint)this.params().getG(), (BigInteger)eInvrInv, (ECPoint)R, (BigInteger)srInv).getEncoded(false);
        ByteString publiKey = ByteString$.MODULE$.fromArrayUnsafe(qBytes, 1, qBytes.length - 1);
        return ((Keccak256)Keccak256$.MODULE$.hash((Seq<Object>)publiKey)).bytes().drop(12);
    }

    private ECPoint decompressKey(BigInteger xBN, boolean yBit) {
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(xBN, 1 + x9.getByteLength((ECCurve)this.curve()));
        compEnc[0] = yBit ? 3 : 2;
        return this.curve().decodePoint(compEnc);
    }

    private SecP256K1$() {
    }
}

