/*
 * Decompiled with CFR 0.152.
 */
package org.alephium.crypto;

import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import java.math.BigInteger;
import org.alephium.crypto.PrivateKey;
import org.alephium.crypto.SecP256K1$;
import org.alephium.crypto.SecP256K1PrivateKey$;
import org.alephium.crypto.SecP256K1PublicKey;
import org.alephium.crypto.SecP256K1PublicKey$;
import org.alephium.serde.RandomBytes;
import org.alephium.serde.Serde;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005e3A\u0001D\u0007\u0001)!Aq\u0004\u0001BC\u0002\u0013\u0005\u0001\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003\"\u0011\u0015Q\u0003\u0001\"\u0001,\u0011\u0015q\u0003\u0001\"\u00030\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015\u0011\u0005\u0001\"\u0001D\u000f\u00151U\u0002#\u0001H\r\u0015aQ\u0002#\u0001I\u0011\u0015Q\u0013\u0002\"\u0001T\u0011\u0015!\u0016\u0002\"\u0011V\u0005M\u0019Vm\u0019)3kYZ\u0015\u0007\u0015:jm\u0006$XmS3z\u0015\tqq\"\u0001\u0004def\u0004Ho\u001c\u0006\u0003!E\t\u0001\"\u00197fa\"LW/\u001c\u0006\u0002%\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\taR$D\u0001\u000e\u0013\tqRB\u0001\u0006Qe&4\u0018\r^3LKf\fQAY=uKN,\u0012!\t\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nA!\u001e;jY*\ta%\u0001\u0003bW.\f\u0017B\u0001\u0015$\u0005)\u0011\u0015\u0010^3TiJLgnZ\u0001\u0007Ef$Xm\u001d\u0011\u0002\rqJg.\u001b;?)\taS\u0006\u0005\u0002\u001d\u0001!)qd\u0001a\u0001C\u0005Iq-\u001a;CS\u001eLe\u000e\u001e\u000b\u0002aA\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0005[\u0006$\bNC\u00016\u0003\u0011Q\u0017M^1\n\u0005]\u0012$A\u0003\"jO&sG/Z4fe\u00061\u0011n\u001d.fe>,\u0012A\u000f\t\u0003-mJ!\u0001P\f\u0003\u000f\t{w\u000e\\3b]\u0006I\u0001/\u001e2mS\u000e\\U-_\u000b\u0002\u007fA\u0011A\u0004Q\u0005\u0003\u00036\u0011!cU3d!J*dgS\u0019Qk\nd\u0017nY&fs\u0006\u0019\u0011\r\u001a3\u0015\u00051\"\u0005\"B#\b\u0001\u0004a\u0013\u0001\u0002;iCR\f1cU3d!J*dgS\u0019Qe&4\u0018\r^3LKf\u0004\"\u0001H\u0005\u0014\u0005%I\u0005c\u0001&QY9\u00111JT\u0007\u0002\u0019*\u0011QjD\u0001\u0006g\u0016\u0014H-Z\u0005\u0003\u001f2\u000b1BU1oI>l')\u001f;fg&\u0011\u0011K\u0015\u0002\n\u0007>l\u0007/\u00198j_:T!a\u0014'\u0015\u0003\u001d\u000ba\u0001\\3oORDW#\u0001,\u0011\u0005Y9\u0016B\u0001-\u0018\u0005\rIe\u000e\u001e")
public class SecP256K1PrivateKey
implements PrivateKey {
    private final ByteString bytes;

    public static int length() {
        return SecP256K1PrivateKey$.MODULE$.length();
    }

    public static Serde<SecP256K1PrivateKey> serde() {
        return SecP256K1PrivateKey$.MODULE$.serde();
    }

    public static Object secureGenerate() {
        return SecP256K1PrivateKey$.MODULE$.secureGenerate();
    }

    public static Object generate() {
        return SecP256K1PrivateKey$.MODULE$.generate();
    }

    public static Option<SecP256K1PrivateKey> from(ByteString bytes) {
        return SecP256K1PrivateKey$.MODULE$.from(bytes);
    }

    public static Option<SecP256K1PrivateKey> from(IndexedSeq<Object> bytes) {
        return SecP256K1PrivateKey$.MODULE$.from(bytes);
    }

    public static Object allOne() {
        return SecP256K1PrivateKey$.MODULE$.allOne();
    }

    public static Object zero() {
        return SecP256K1PrivateKey$.MODULE$.zero();
    }

    public static Function1<SecP256K1PrivateKey, ByteString> toBytes() {
        return SecP256K1PrivateKey$.MODULE$.toBytes();
    }

    public static Function1<ByteString, SecP256K1PrivateKey> unsafe() {
        return SecP256K1PrivateKey$.MODULE$.unsafe();
    }

    public byte last() {
        return RandomBytes.last$((RandomBytes)this);
    }

    public byte beforeLast() {
        return RandomBytes.beforeLast$((RandomBytes)this);
    }

    public int hashCode() {
        return RandomBytes.hashCode$((RandomBytes)this);
    }

    public boolean equals(Object obj) {
        return RandomBytes.equals$((RandomBytes)this, (Object)obj);
    }

    public String toString() {
        return RandomBytes.toString$((RandomBytes)this);
    }

    public String toHexString() {
        return RandomBytes.toHexString$((RandomBytes)this);
    }

    public String shortHex() {
        return RandomBytes.shortHex$((RandomBytes)this);
    }

    public int toRandomIntUnsafe() {
        return RandomBytes.toRandomIntUnsafe$((RandomBytes)this);
    }

    public ByteString bytes() {
        return this.bytes;
    }

    private BigInteger getBigInt() {
        return new BigInteger(1, (byte[])this.bytes().toArray((ClassTag)ClassTag$.MODULE$.Byte()));
    }

    public boolean isZero() {
        return BoxesRunTime.equalsNumNum((Number)this.getBigInt(), (Number)BigInteger.ZERO);
    }

    public SecP256K1PublicKey publicKey() {
        BigInteger bigInt = this.getBigInt();
        byte[] publicKey = SecP256K1$.MODULE$.params().getG().multiply(bigInt).getEncoded(true);
        return (SecP256K1PublicKey)SecP256K1PublicKey$.MODULE$.unsafe().apply((Object)ByteString$.MODULE$.fromArrayUnsafe(publicKey));
    }

    public SecP256K1PrivateKey add(SecP256K1PrivateKey that) {
        BigInteger thatBigInt;
        BigInteger thisBigInt = this.getBigInt();
        byte[] result = (byte[])ArrayOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.byteArrayOps(thisBigInt.add(thatBigInt = that.getBigInt()).mod(SecP256K1$.MODULE$.params().getN()).toByteArray()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SecP256K1PrivateKey.$anonfun$add$1(BoxesRunTime.unboxToByte((Object)x$1))));
        Predef$.MODULE$.assume(result.length <= SecP256K1PrivateKey$.MODULE$.length());
        byte[] buffer = (byte[])Array$.MODULE$.ofDim(SecP256K1PrivateKey$.MODULE$.length(), (ClassTag)ClassTag$.MODULE$.Byte());
        System.arraycopy(result, 0, buffer, buffer.length - result.length, result.length);
        return (SecP256K1PrivateKey)SecP256K1PrivateKey$.MODULE$.unsafe().apply((Object)ByteString$.MODULE$.fromArrayUnsafe(buffer));
    }

    public static final /* synthetic */ boolean $anonfun$add$1(byte x$1) {
        return x$1 == (byte)0;
    }

    public SecP256K1PrivateKey(ByteString bytes) {
        this.bytes = bytes;
        RandomBytes.$init$((RandomBytes)this);
    }
}

