/*
 * Decompiled with CFR 0.152.
 */
package org.alephium.crypto.wallet;

import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.alephium.crypto.Sha256;
import org.alephium.crypto.Sha256$;
import org.alephium.crypto.wallet.Mnemonic;
import org.alephium.crypto.wallet.Mnemonic$Size$;
import org.alephium.util.AVector;
import org.alephium.util.AVector$;
import org.alephium.util.Bits$;
import org.alephium.util.SecureAndSlowRandom$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class Mnemonic$
implements Serializable {
    public static final Mnemonic$ MODULE$ = new Mnemonic$();
    private static AVector<String> englishWordlist;
    private static final Seq<Object> entropySizes;
    private static final String pbkdf2Algorithm;
    private static final int pbkdf2Iterations;
    private static final int pbkdf2KeyLength;
    private static volatile boolean bitmap$0;

    static {
        entropySizes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{16, 20, 24, 28, 32}));
        pbkdf2Algorithm = "PBKDF2WithHmacSHA512";
        pbkdf2Iterations = 2048;
        pbkdf2KeyLength = 512;
    }

    public Seq<Object> entropySizes() {
        return entropySizes;
    }

    public String pbkdf2Algorithm() {
        return pbkdf2Algorithm;
    }

    public int pbkdf2Iterations() {
        return pbkdf2Iterations;
    }

    public int pbkdf2KeyLength() {
        return pbkdf2KeyLength;
    }

    private AVector<String> englishWordlist$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                InputStream stream = this.getClass().getResourceAsStream("/bip39_english_wordlist.txt");
                englishWordlist = AVector$.MODULE$.from((IterableOnce)Source$.MODULE$.fromInputStream(stream, "UTF-8").getLines().to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Iterable())), ClassTag$.MODULE$.apply(String.class));
                bitmap$0 = true;
            }
        }
        return englishWordlist;
    }

    public AVector<String> englishWordlist() {
        if (!bitmap$0) {
            return this.englishWordlist$lzycompute();
        }
        return englishWordlist;
    }

    public Option<Mnemonic> generate(int size2) {
        return Mnemonic$Size$.MODULE$.apply(size2).map((Function1 & Serializable)size -> new Mnemonic((AVector<String>)Mnemonic$.MODULE$.generate(((Mnemonic.Size)size).value())));
    }

    public AVector generate(int size) {
        int typeIndex = Mnemonic$Size$.MODULE$.list().indexWhere((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Mnemonic$.$anonfun$generate$2(size, ((Mnemonic.Size)x$1).value())));
        int entropySize = BoxesRunTime.unboxToInt((Object)this.entropySizes().apply(typeIndex));
        byte[] rawEntropy = (byte[])Array$.MODULE$.ofDim(entropySize, (ClassTag)ClassTag$.MODULE$.Byte());
        SecureAndSlowRandom$.MODULE$.source().nextBytes(rawEntropy);
        ByteString entropy = ByteString$.MODULE$.fromArrayUnsafe(rawEntropy);
        return this.fromEntropyUnsafe(entropy);
    }

    private boolean validateWords(String[] words) {
        return Mnemonic$Size$.MODULE$.validate(words.length) && ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])words), (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)Mnemonic$.$anonfun$validateWords$1(elem)));
    }

    public Option<Mnemonic> from(String input) {
        String[] words = input.split(" ");
        return Option$.MODULE$.when(this.validateWords(words), (Function0 & Serializable)() -> new Mnemonic((AVector<String>)AVector$.MODULE$.unsafe((Object)words, ClassTag$.MODULE$.apply(String.class))));
    }

    public AVector<String> unsafe(AVector<String> words) {
        return words;
    }

    public boolean validateEntropy(ByteString entropy) {
        return this.entropySizes().contains((Object)BoxesRunTime.boxToInteger((int)entropy.length()));
    }

    public AVector unsafe(ByteString entropy) {
        ByteString checkSum = ((Sha256)Sha256$.MODULE$.hash((Seq<Object>)entropy)).bytes().take(1);
        return AVector$.MODULE$.from$mBc$sp((IterableOnce)entropy.$plus$plus(checkSum), (ClassTag)ClassTag$.MODULE$.Byte()).flatMap$mZcB$sp((Function1 & Serializable)object -> Bits$.MODULE$.from(BoxesRunTime.unboxToByte((Object)object)), (ClassTag)ClassTag$.MODULE$.Boolean()).take$mcZ$sp(entropy.length() * 8 + entropy.length() / 4).grouped$mcZ$sp(11).map$mIc$sp((Function1 & Serializable)bits -> BoxesRunTime.boxToInteger((int)Bits$.MODULE$.toInt(bits)), (ClassTag)ClassTag$.MODULE$.Int()).map$mcI$sp((Function1 & Serializable)i -> Mnemonic$.$anonfun$unsafe$3(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(String.class));
    }

    public AVector fromEntropyUnsafe(ByteString entropy) {
        Predef$.MODULE$.assume(this.validateEntropy(entropy));
        return this.unsafe(entropy);
    }

    public Option<Mnemonic> from(ByteString entropy) {
        return Option$.MODULE$.when(this.validateEntropy(entropy), (Function0 & Serializable)() -> new Mnemonic((AVector<String>)Mnemonic$.MODULE$.unsafe(entropy)));
    }

    private AVector<String> apply(AVector<String> words) {
        return words;
    }

    public Option<AVector<String>> unapply(AVector<String> x$0) {
        new Mnemonic(x$0);
        return new Some(x$0);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Mnemonic$.class);
    }

    public final ByteString toSeed$extension(AVector<String> $this, Option<String> passphraseOpt) {
        char[] mnemonic = this.toLongString$extension($this).toCharArray();
        byte[] extendedPass = new StringBuilder(8).append("mnemonic").append(passphraseOpt.getOrElse((Function0 & Serializable)() -> "")).toString().getBytes(StandardCharsets.UTF_8);
        PBEKeySpec spec = new PBEKeySpec(mnemonic, extendedPass, this.pbkdf2Iterations(), this.pbkdf2KeyLength());
        SecretKeyFactory factory = SecretKeyFactory.getInstance(this.pbkdf2Algorithm());
        return ByteString$.MODULE$.fromArrayUnsafe(factory.generateSecret(spec).getEncoded());
    }

    public final String toLongString$extension(AVector $this) {
        return $this.mkString(" ");
    }

    public final AVector<String> copy$extension(AVector<String> $this, AVector<String> words) {
        return words;
    }

    public final AVector<String> copy$default$1$extension(AVector<String> $this) {
        return $this;
    }

    public final String productPrefix$extension(AVector $this) {
        return "Mnemonic";
    }

    public final int productArity$extension(AVector $this) {
        return 1;
    }

    public final Object productElement$extension(AVector $this, int x$1) {
        switch (x$1) {
            case 0: {
                return $this;
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public final Iterator<Object> productIterator$extension(AVector<String> $this) {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)new Mnemonic($this));
    }

    public final boolean canEqual$extension(AVector $this, Object x$1) {
        return x$1 instanceof AVector;
    }

    public final String productElementName$extension(AVector $this, int x$1) {
        switch (x$1) {
            case 0: {
                return "words";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public final int hashCode$extension(AVector $this) {
        return $this.hashCode();
    }

    public final boolean equals$extension(AVector $this, Object x$1) {
        if (x$1 instanceof Mnemonic) {
            AVector<String> aVector = x$1 == null ? null : ((Mnemonic)x$1).words();
            AVector aVector2 = $this;
            if (!(aVector2 != null ? !aVector2.equals(aVector) : aVector != null)) {
                return true;
            }
        }
        return false;
    }

    public final String toString$extension(AVector $this) {
        return ScalaRunTime$.MODULE$._toString((Product)new Mnemonic((AVector<String>)$this));
    }

    public static final /* synthetic */ boolean $anonfun$generate$2(int size$2, int x$1) {
        return x$1 == size$2;
    }

    public static final /* synthetic */ boolean $anonfun$validateWords$1(String elem) {
        return MODULE$.englishWordlist().contains((Object)elem);
    }

    public static final /* synthetic */ String $anonfun$unsafe$3(int i) {
        return (String)MODULE$.englishWordlist().apply(i);
    }

    private Mnemonic$() {
    }
}

