/*
 * Decompiled with CFR 0.152.
 */
package org.alephium.io;

import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import org.alephium.crypto.Blake2b;
import org.alephium.io.InMemorySparseMerkleTrie;
import org.alephium.io.KeyValueStorage;
import org.alephium.io.SparseMerkleTrie;
import org.alephium.serde.Serde;
import org.alephium.serde.package$;
import org.alephium.util.Bytes$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class SparseMerkleTrie$ {
    public static final SparseMerkleTrie$ MODULE$ = new SparseMerkleTrie$();

    public byte getHighNibble(byte by) {
        return (byte)((by & 0xF0) >> 4);
    }

    public byte getLowNibble(byte by) {
        return (byte)(by & 0xF);
    }

    public int getNibble(ByteString nibbles, int index) {
        Predef$.MODULE$.assume(index >= 0 && index < nibbles.length());
        return Bytes$.MODULE$.toPosInt(nibbles.apply(index));
    }

    public <K> ByteString toNibbles(K key, Serde<K> evidence$1) {
        return this.bytes2Nibbles(package$.MODULE$.serialize(key, evidence$1));
    }

    public ByteString bytes2Nibbles(ByteString bytes) {
        byte[] nibbles = (byte[])Array$.MODULE$.ofDim(bytes.length() * 2, (ClassTag)ClassTag$.MODULE$.Byte());
        IntRef index = IntRef.create((int)0);
        bytes.foreach$mVc$sp((Function1 & Serializable)object -> {
            SparseMerkleTrie$.$anonfun$bytes2Nibbles$1(nibbles, index, BoxesRunTime.unboxToByte((Object)object));
            return BoxedUnit.UNIT;
        });
        return ByteString$.MODULE$.fromArrayUnsafe(nibbles);
    }

    public ByteString nibbles2Bytes(ByteString nibbles) {
        Predef$.MODULE$.assume(nibbles.length() % 2 == 0);
        byte[] bytes = (byte[])Array$.MODULE$.tabulate(nibbles.length() / 2, (Function1 & Serializable)i -> BoxesRunTime.boxToByte((byte)SparseMerkleTrie$.$anonfun$nibbles2Bytes$1(nibbles, BoxesRunTime.unboxToInt((Object)i))), (ClassTag)ClassTag$.MODULE$.Byte());
        return ByteString$.MODULE$.fromArrayUnsafe(bytes);
    }

    public <K, V> SparseMerkleTrie<K, V> unsafe(KeyValueStorage<Blake2b, SparseMerkleTrie.Node> storage, K genesisKey, V genesisValue, Serde<K> evidence$2, Serde<V> evidence$3) {
        ByteString genesisPath = this.bytes2Nibbles(package$.MODULE$.serialize(genesisKey, evidence$2));
        ByteString genesisData = package$.MODULE$.serialize(genesisValue, evidence$3);
        SparseMerkleTrie.LeafNode genesisNode = new SparseMerkleTrie.LeafNode(genesisPath, genesisData);
        storage.putUnsafe(genesisNode.hash(), genesisNode);
        return new SparseMerkleTrie<K, V>(genesisNode.hash(), storage, evidence$2, evidence$3);
    }

    public <K, V> SparseMerkleTrie<K, V> apply(Blake2b rootHash, KeyValueStorage<Blake2b, SparseMerkleTrie.Node> storage, Serde<K> evidence$4, Serde<V> evidence$5) {
        return new SparseMerkleTrie<K, V>(rootHash, storage, evidence$4, evidence$5);
    }

    public <K, V> InMemorySparseMerkleTrie<K, V> inMemoryUnsafe(KeyValueStorage<Blake2b, SparseMerkleTrie.Node> storage, K genesisKey, V genesisValue, Serde<K> evidence$6, Serde<V> evidence$7) {
        ByteString genesisPath = this.bytes2Nibbles(package$.MODULE$.serialize(genesisKey, evidence$6));
        ByteString genesisData = package$.MODULE$.serialize(genesisValue, evidence$7);
        SparseMerkleTrie.LeafNode genesisNode = new SparseMerkleTrie.LeafNode(genesisPath, genesisData);
        storage.putUnsafe(genesisNode.hash(), genesisNode);
        return new InMemorySparseMerkleTrie<K, V>(genesisNode.hash(), storage, (Map<Blake2b, SparseMerkleTrie.Node>)((Map)Map$.MODULE$.empty()), evidence$6, evidence$7);
    }

    public <K, V> InMemorySparseMerkleTrie<K, V> inMemory(Blake2b rootHash, KeyValueStorage<Blake2b, SparseMerkleTrie.Node> storage, Serde<K> evidence$8, Serde<V> evidence$9) {
        return new InMemorySparseMerkleTrie<K, V>(rootHash, storage, (Map<Blake2b, SparseMerkleTrie.Node>)((Map)Map$.MODULE$.empty()), evidence$8, evidence$9);
    }

    public static final /* synthetic */ void $anonfun$bytes2Nibbles$1(byte[] nibbles$2, IntRef index$1, byte by) {
        nibbles$2[2 * index$1.elem] = MODULE$.getHighNibble(by);
        nibbles$2[2 * index$1.elem + 1] = MODULE$.getLowNibble(by);
        ++index$1.elem;
    }

    public static final /* synthetic */ byte $anonfun$nibbles2Bytes$1(ByteString nibbles$3, int i) {
        byte high = nibbles$3.apply(2 * i);
        byte low = nibbles$3.apply(2 * i + 1);
        return (byte)(high << 4 | low);
    }

    private SparseMerkleTrie$() {
    }
}

