/*
 * Decompiled with CFR 0.152.
 */
package org.alephium.io;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.alephium.io.IOError;
import org.alephium.serde.SerdeError;
import org.rocksdb.RocksDBException;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.package$;
import scala.util.Either;

public final class IOUtils$ {
    public static final IOUtils$ MODULE$ = new IOUtils$();

    public void createDirUnsafe(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
    }

    public void clearUnsafe(Path path2) {
        if (Files.exists(path2, new LinkOption[0]) && Files.isDirectory(path2, new LinkOption[0])) {
            Files.list(path2).forEach(path -> MODULE$.removeUnsafe((Path)path));
            return;
        }
    }

    public void removeUnsafe(Path path2) {
        if (Files.exists(path2, new LinkOption[0])) {
            if (Files.isDirectory(path2, new LinkOption[0])) {
                Files.list(path2).forEach(path -> MODULE$.removeUnsafe((Path)path));
            }
            Files.delete(path2);
            return;
        }
    }

    public <T> Either<IOError, T> tryExecute(Function0<T> f) {
        try {
            return package$.MODULE$.Right().apply(f.apply());
        }
        catch (Throwable x$1) {
            PartialFunction<Throwable, Either<IOError, T>> catchExpr$1 = this.error();
            if (catchExpr$1.isDefinedAt((Object)x$1)) {
                return (Either)catchExpr$1.apply((Object)x$1);
            }
            throw x$1;
        }
    }

    public <T> Either<IOError, T> tryExecuteF(Function0<Either<IOError, T>> f) {
        try {
            return (Either)f.apply();
        }
        catch (Throwable x$2) {
            PartialFunction<Throwable, Either<IOError, T>> catchExpr$2 = this.error();
            if (catchExpr$2.isDefinedAt((Object)x$2)) {
                return (Either)catchExpr$2.apply((Object)x$2);
            }
            throw x$2;
        }
    }

    public <T> PartialFunction<Throwable, Either<IOError, T>> error() {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof IOException) {
                    IOException iOException = (IOException)x1;
                    return (B1)package$.MODULE$.Left().apply((Object)new IOError.JavaIO(iOException));
                }
                if (x1 instanceof SecurityException) {
                    SecurityException securityException = (SecurityException)x1;
                    return (B1)package$.MODULE$.Left().apply((Object)new IOError.JavaSecurity(securityException));
                }
                if (x1 instanceof RocksDBException) {
                    RocksDBException rocksDBException = (RocksDBException)x1;
                    return (B1)package$.MODULE$.Left().apply((Object)new IOError.RocksDB(rocksDBException));
                }
                if (x1 instanceof SerdeError) {
                    SerdeError serdeError = (SerdeError)x1;
                    return (B1)package$.MODULE$.Left().apply((Object)new IOError.Serde(serdeError));
                }
                if (x1 instanceof IOError.KeyNotFound) {
                    IOError.KeyNotFound keyNotFound = (IOError.KeyNotFound)x1;
                    return (B1)package$.MODULE$.Left().apply((Object)keyNotFound);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                if (x1 instanceof IOException) {
                    return true;
                }
                if (x1 instanceof SecurityException) {
                    return true;
                }
                if (x1 instanceof RocksDBException) {
                    return true;
                }
                if (x1 instanceof SerdeError) {
                    return true;
                }
                return x1 instanceof IOError.KeyNotFound;
            }
        };
    }

    private IOUtils$() {
    }
}

