/*
 * Decompiled with CFR 0.152.
 */
package org.alephium.io;

import akka.util.ByteString;
import java.io.Serializable;
import org.alephium.crypto.Blake2b;
import org.alephium.io.IOError;
import org.alephium.io.KeyValueStorage;
import org.alephium.io.SparseMerkleTrie;
import org.alephium.io.SparseMerkleTrie$;
import org.alephium.io.SparseMerkleTrieBase;
import org.alephium.serde.Serde;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001\u0002\t\u0012\u0005aA\u0001B\r\u0001\u0003\u0002\u0004%\ta\r\u0005\tu\u0001\u0011\t\u0019!C\u0001w!Aa\b\u0001B\u0001B\u0003&A\u0007\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u00111Q\u0005\u0001\"A\u0001\u0006\u000b\u0005\t\u0015!\u0003L\u0011!\u0019\u0006AaA!\u0002\u0017!\u0006\u0002\u0003.\u0001\u0005\u0007\u0005\u000b1B.\t\u000bq\u0003A\u0011A/\t\u000b\u0019\u0004A\u0011A4\t\u000bE\u0004A\u0011\u0001:\t\u000ba\u0004A\u0011A=\t\u000bu\u0004A\u0011\u0001@\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u00111\u0004\u0001\u0005\u0002\u0005u\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0002\u0019\u0013:lU-\\8ssN\u0003\u0018M]:f\u001b\u0016\u00148\u000e\\3Ue&,'B\u0001\n\u0014\u0003\tIwN\u0003\u0002\u0015+\u0005A\u0011\r\\3qQ&,XNC\u0001\u0017\u0003\ry'oZ\u0002\u0001+\rI\u0002%L\n\u0003\u0001i\u0001Ra\u0007\u000f\u001fY=j\u0011!E\u0005\u0003;E\u0011Ac\u00159beN,W*\u001a:lY\u0016$&/[3CCN,\u0007CA\u0010!\u0019\u0001!Q!\t\u0001C\u0002\t\u0012\u0011aS\t\u0003G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012qAT8uQ&tw\r\u0005\u0002%U%\u00111&\n\u0002\u0004\u0003:L\bCA\u0010.\t\u0015q\u0003A1\u0001#\u0005\u00051\u0006C\u0001\u00131\u0013\t\tTE\u0001\u0003V]&$\u0018\u0001\u0003:p_RD\u0015m\u001d5\u0016\u0003Q\u0002\"!\u000e\u001d\u000e\u0003YR!aN\n\u0002\r\r\u0014\u0018\u0010\u001d;p\u0013\tIdGA\u0004CY\u0006\\WM\r2\u0002\u0019I|w\u000e\u001e%bg\"|F%Z9\u0015\u0005=b\u0004bB\u001f\u0003\u0003\u0003\u0005\r\u0001N\u0001\u0004q\u0012\n\u0014!\u0003:p_RD\u0015m\u001d5!\u0003\u001d\u0019Ho\u001c:bO\u0016\u0004BaG!5\u0007&\u0011!)\u0005\u0002\u0010\u0017\u0016Lh+\u00197vKN#xN]1hKB\u0011Ai\u0012\b\u00037\u0015K!AR\t\u0002!M\u0003\u0018M]:f\u001b\u0016\u00148\u000e\\3Ue&,\u0017B\u0001%J\u0005\u0011qu\u000eZ3\u000b\u0005\u0019\u000b\u0012aL8sO\u0012\nG.\u001a9iSVlG%[8%\u0013:lU-\\8ssN\u0003\u0018M]:f\u001b\u0016\u00148\u000e\\3Ue&,G\u0005J2bG\",\u0007\u0003\u0002'Ri\rk\u0011!\u0014\u0006\u0003\u001d>\u000bq!\\;uC\ndWM\u0003\u0002QK\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ik%aA'ba\u0006YQM^5eK:\u001cW\rJ\u00195!\r)\u0006LH\u0007\u0002-*\u0011qkE\u0001\u0006g\u0016\u0014H-Z\u0005\u00033Z\u0013QaU3sI\u0016\f1\"\u001a<jI\u0016t7-\u001a\u00132kA\u0019Q\u000b\u0017\u0017\u0002\rqJg.\u001b;?)\u0011q&m\u00193\u0015\u0007}\u0003\u0017\r\u0005\u0003\u001c\u0001ya\u0003\"B*\t\u0001\b!\u0006\"\u0002.\t\u0001\bY\u0006\"\u0002\u001a\t\u0001\u0004!\u0004\"B \t\u0001\u0004\u0001\u0005\"B3\t\u0001\u0004Y\u0015!B2bG\",\u0017aB4fi:{G-\u001a\u000b\u0003Q>\u00042!\u001b7D\u001d\tY\".\u0003\u0002l#\u00059\u0001/Y2lC\u001e,\u0017BA7o\u0005!IuJU3tk2$(BA6\u0012\u0011\u0015\u0001\u0018\u00021\u00015\u0003\u0011A\u0017m\u001d5\u0002\u0019\u0005\u0004\b\u000f\\=BGRLwN\\:\u0015\u0005=\u001a\b\"\u0002;\u000b\u0001\u0004)\u0018A\u0002:fgVdG\u000f\u0005\u0002Em&\u0011q/\u0013\u0002\u0012)JLW-\u00169eCR,\u0017i\u0019;j_:\u001c\u0018A\u0002:f[>4X\r\u0006\u0002{wB\u0019\u0011\u000e\\\u0018\t\u000bq\\\u0001\u0019\u0001\u0010\u0002\u0007-,\u00170A\u0005sK6|g/\u001a*boR\u0011!p \u0005\u0007y2\u0001\r!!\u0001\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005!Q\u000f^5m\u0015\t\tY!\u0001\u0003bW.\f\u0017\u0002BA\b\u0003\u000b\u0011!BQ=uKN#(/\u001b8h\u0003\r\u0001X\u000f\u001e\u000b\u0006u\u0006U\u0011q\u0003\u0005\u0006y6\u0001\rA\b\u0005\u0007\u00033i\u0001\u0019\u0001\u0017\u0002\u000bY\fG.^3\u0002\rA,HOU1x)\u0015Q\u0018qDA\u0011\u0011\u0019ah\u00021\u0001\u0002\u0002!9\u0011\u0011\u0004\bA\u0002\u0005\u0005\u0011A\u00049feNL7\u000f^%o\u0005\u0006$8\r\u001b\u000b\u0003\u0003O\u0001B!\u001b7\u0002*A)1$a\u000b\u001fY%\u0019\u0011QF\t\u0003!M\u0003\u0018M]:f\u001b\u0016\u00148\u000e\\3Ue&,\u0007")
public final class InMemorySparseMerkleTrie<K, V>
extends SparseMerkleTrieBase<K, V, BoxedUnit> {
    private Blake2b rootHash;
    private final KeyValueStorage<Blake2b, SparseMerkleTrie.Node> storage;
    public final Map<Blake2b, SparseMerkleTrie.Node> org$alephium$io$InMemorySparseMerkleTrie$$cache;
    private final Serde<K> evidence$14;
    private final Serde<V> evidence$15;

    @Override
    public Blake2b rootHash() {
        return this.rootHash;
    }

    public void rootHash_$eq(Blake2b x$1) {
        this.rootHash = x$1;
    }

    @Override
    public Either<IOError, SparseMerkleTrie.Node> getNode(Blake2b hash) {
        Option option = this.org$alephium$io$InMemorySparseMerkleTrie$$cache.get((Object)hash);
        if (option instanceof Some) {
            SparseMerkleTrie.Node node = (SparseMerkleTrie.Node)((Some)option).value();
            return package$.MODULE$.Right().apply((Object)node);
        }
        if (None$.MODULE$.equals(option)) {
            return this.storage.get(hash);
        }
        throw new MatchError((Object)option);
    }

    public void applyActions(SparseMerkleTrie.TrieUpdateActions result) {
        result.toAdd().foreach((Function1 & Serializable)node -> $this.org$alephium$io$InMemorySparseMerkleTrie$$cache.put((Object)node.hash(), node));
        result.nodeOpt().foreach((Function1 & Serializable)node -> {
            this.rootHash_$eq(node.hash());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Either<IOError, BoxedUnit> remove(K key) {
        return this.removeRaw(org.alephium.serde.package$.MODULE$.serialize(key, this.evidence$14));
    }

    public Either<IOError, BoxedUnit> removeRaw(ByteString key) {
        ByteString nibbles = SparseMerkleTrie$.MODULE$.bytes2Nibbles(key);
        return this.remove(this.rootHash(), nibbles).map((Function1 & Serializable)result -> {
            this.applyActions(result);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Either<IOError, BoxedUnit> put(K key, V value) {
        return this.putRaw(org.alephium.serde.package$.MODULE$.serialize(key, this.evidence$14), org.alephium.serde.package$.MODULE$.serialize(value, this.evidence$15));
    }

    public Either<IOError, BoxedUnit> putRaw(ByteString key, ByteString value) {
        ByteString nibbles = SparseMerkleTrie$.MODULE$.bytes2Nibbles(key);
        return this.put(this.rootHash(), nibbles, value).map((Function1 & Serializable)result -> {
            this.applyActions(result);
            return BoxedUnit.UNIT;
        });
    }

    public Either<IOError, SparseMerkleTrie<K, V>> persistInBatch() {
        return this.storage.putBatch((Function1<Function2<Blake2b, SparseMerkleTrie.Node, BoxedUnit>, BoxedUnit>)(Function1 & Serializable)accumulatePut -> {
            this.preOrderTraversal$1(accumulatePut);
            return BoxedUnit.UNIT;
        }).map((Function1 & Serializable)x$16 -> SparseMerkleTrie$.MODULE$.apply(this.rootHash(), $this.storage, $this.evidence$14, $this.evidence$15));
    }

    private final void preOrderTraversal$1(Function2 accumulatePut) {
        Queue queue = (Queue)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Blake2b[]{this.rootHash()}));
        while (queue.nonEmpty()) {
            SparseMerkleTrie.Node node;
            Blake2b current = (Blake2b)queue.dequeue();
            boolean bl = false;
            Some some = null;
            Option option = this.org$alephium$io$InMemorySparseMerkleTrie$$cache.get((Object)current);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                SparseMerkleTrie.Node node2 = (SparseMerkleTrie.Node)some.value();
                if (node2 instanceof SparseMerkleTrie.BranchNode) {
                    SparseMerkleTrie.BranchNode branchNode = (SparseMerkleTrie.BranchNode)node2;
                    accumulatePut.apply((Object)current, (Object)branchNode);
                    branchNode.children().foreach((Function1 & Serializable)childOpt -> {
                        childOpt.foreach((Function1 & Serializable)elem -> queue$1.enqueue(elem));
                        return BoxedUnit.UNIT;
                    });
                    continue;
                }
            }
            if (bl && (node = (SparseMerkleTrie.Node)some.value()) instanceof SparseMerkleTrie.LeafNode) {
                SparseMerkleTrie.LeafNode leafNode = (SparseMerkleTrie.LeafNode)node;
                BoxedUnit cfr_ignored_0 = (BoxedUnit)accumulatePut.apply((Object)current, (Object)leafNode);
                continue;
            }
            if (None$.MODULE$.equals(option)) continue;
            throw new MatchError((Object)option);
        }
    }

    public InMemorySparseMerkleTrie(Blake2b rootHash, KeyValueStorage<Blake2b, SparseMerkleTrie.Node> storage, Map<Blake2b, SparseMerkleTrie.Node> cache, Serde<K> evidence$14, Serde<V> evidence$15) {
        this.rootHash = rootHash;
        this.storage = storage;
        this.org$alephium$io$InMemorySparseMerkleTrie$$cache = cache;
        this.evidence$14 = evidence$14;
        this.evidence$15 = evidence$15;
        super(evidence$14, evidence$15);
    }
}

