/*
 * Decompiled with CFR 0.152.
 */
package org.alephium.io;

import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import org.alephium.crypto.Blake2b;
import org.alephium.io.IOError;
import org.alephium.io.IOError$;
import org.alephium.io.IOError$Serde$;
import org.alephium.io.MutableKV;
import org.alephium.io.SparseMerkleTrie;
import org.alephium.io.SparseMerkleTrie$;
import org.alephium.io.SparseMerkleTrie$Node$;
import org.alephium.serde.Serde;
import org.alephium.serde.SerdeError;
import org.alephium.util.AVector;
import org.alephium.util.AVector$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t]a!\u0002\u000e\u001c\u0003\u0003\u0011\u0003\u0002C \u0001\u0005\u0007\u0005\u000b1\u0002!\t\u0011\u0019\u0003!1!Q\u0001\f\u001dCQ\u0001\u0013\u0001\u0005\u0002%CQA\u0014\u0001\u0007\u0002=CQA\u0016\u0001\u0007\u0002]CQ\u0001\u001b\u0001\u0005\u0002%DQ!\u001c\u0001\u0005\u00029DQ\u0001\u001e\u0001\u0005\u0002UDa!\u001c\u0001\u0005\u0002\u0005\r\u0001BB7\u0001\t\u0003\tY\u0001C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011q\u0005\u0001\u0005\u0012\u0005%\u0002bBA\u0014\u0001\u0011E\u0011q\u0007\u0005\b\u00033\u0002A\u0011AA.\u0011\u001d\ti\b\u0001C\t\u0003\u007fBq!! \u0001\t#\t9\tC\u0004\u0002\u0012\u0002!\t\"a%\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005}\u0006bBAh\u0001\u0011E\u0011\u0011\u001b\u0005\b\u0003\u001f\u0004A\u0011CAp\u0011\u001d\ty\r\u0001C\t\u0003gDq!a4\u0001\t#\ti\u0010C\u0004\u0003\b\u0001!\tA!\u0003\u0003)M\u0003\u0018M]:f\u001b\u0016\u00148\u000e\\3Ue&,')Y:f\u0015\taR$\u0001\u0002j_*\u0011adH\u0001\tC2,\u0007\u000f[5v[*\t\u0001%A\u0002pe\u001e\u001c\u0001!\u0006\u0003$aij4c\u0001\u0001%UA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\u0004Ra\u000b\u0017/sqj\u0011aG\u0005\u0003[m\u0011\u0011\"T;uC\ndWm\u0013,\u0011\u0005=\u0002D\u0002\u0001\u0003\u0006c\u0001\u0011\rA\r\u0002\u0002\u0017F\u00111G\u000e\t\u0003KQJ!!\u000e\u0014\u0003\u000f9{G\u000f[5oOB\u0011QeN\u0005\u0003q\u0019\u00121!\u00118z!\ty#\bB\u0003<\u0001\t\u0007!GA\u0001W!\tyS\bB\u0003?\u0001\t\u0007!GA\u0001U\u0003-)g/\u001b3f]\u000e,G%\r\u0019\u0011\u0007\u0005#e&D\u0001C\u0015\t\u0019U$A\u0003tKJ$W-\u0003\u0002F\u0005\n)1+\u001a:eK\u0006YQM^5eK:\u001cW\rJ\u00192!\r\tE)O\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)#2a\u0013'N!\u0015Y\u0003AL\u001d=\u0011\u0015y4\u0001q\u0001A\u0011\u001515\u0001q\u0001H\u0003!\u0011xn\u001c;ICNDW#\u0001)\u0011\u0005E#V\"\u0001*\u000b\u0005Mk\u0012AB2ssB$x.\u0003\u0002V%\n9!\t\\1lKJ\u0012\u0017aB4fi:{G-\u001a\u000b\u00031\u001a\u00042!\u0017/`\u001d\tY#,\u0003\u0002\\7\u00059\u0001/Y2lC\u001e,\u0017BA/_\u0005!IuJU3tk2$(BA.\u001c!\t\u00017M\u0004\u0002,C&\u0011!mG\u0001\u0011'B\f'o]3NKJ\\G.\u001a+sS\u0016L!\u0001Z3\u0003\t9{G-\u001a\u0006\u0003EnAQaZ\u0003A\u0002A\u000bA\u0001[1tQ\u0006\u0019q-\u001a;\u0015\u0005)\\\u0007cA-]s!)AN\u0002a\u0001]\u0005\u00191.Z=\u0002\r\u001d,Go\u00149u)\ty7\u000fE\u0002Z9B\u00042!J9:\u0013\t\u0011hE\u0001\u0004PaRLwN\u001c\u0005\u0006Y\u001e\u0001\rAL\u0001\nO\u0016$x\n\u001d;SC^$2A^A\u0001!\rIFl\u001e\t\u0004KED\bCA=\u007f\u001b\u0005Q(BA>}\u0003\u0011)H/\u001b7\u000b\u0003u\fA!Y6lC&\u0011qP\u001f\u0002\u000b\u0005f$Xm\u0015;sS:<\u0007\"\u00027\t\u0001\u0004AH#\u0002<\u0002\u0006\u0005\u001d\u0001\"B4\n\u0001\u0004\u0001\u0006BBA\u0005\u0013\u0001\u0007\u00010A\u0004oS\n\u0014G.Z:\u0015\u000bY\fi!!\u0005\t\r\u0005=!\u00021\u0001`\u0003\u0011qw\u000eZ3\t\r\u0005%!\u00021\u0001y\u0003\u0019)\u00070[:ugR!\u0011qCA\u0010!\u0011IF,!\u0007\u0011\u0007\u0015\nY\"C\u0002\u0002\u001e\u0019\u0012qAQ8pY\u0016\fg\u000eC\u0003m\u0017\u0001\u0007a&\u0001\u0005fq&\u001cHOU1x)\u0011\t9\"!\n\t\u000b1d\u0001\u0019\u0001=\u0002\rI,Wn\u001c<f)\u0019\tY#a\r\u00026A!\u0011\fXA\u0017!\r\u0001\u0017qF\u0005\u0004\u0003c)'!\u0005+sS\u0016,\u0006\u000fZ1uK\u0006\u001bG/[8og\")q-\u0004a\u0001!\"1\u0011\u0011B\u0007A\u0002a$\u0002\"a\u000b\u0002:\u0005m\u0012Q\b\u0005\u0006O:\u0001\r\u0001\u0015\u0005\u0007\u0003\u001fq\u0001\u0019A0\t\r\u0005%a\u00021\u0001yQ\u001dq\u0011\u0011IA)\u0003'\u0002B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0003mC:<'BAA&\u0003\u0011Q\u0017M^1\n\t\u0005=\u0013Q\t\u0002\u0011'V\u0004\bO]3tg^\u000b'O\\5oON\fQA^1mk\u0016d#!!\u0016\"\u0005\u0005]\u0013aI8sO::\u0018M\u001d;sK6|g/\u001a:/o\u0006\u0014Ho\u001d\u0018PaRLwN\u001c)beRL\u0017\r\\\u0001\u0018Q\u0006tG\r\\3DQ&dG-\u00169eCR,'+Z:vYR$\"\"a\u000b\u0002^\u0005\u0005\u00141NA;\u0011\u0019\tyf\u0004a\u0001!\u0006Q!M]1oG\"D\u0015m\u001d5\t\u000f\u0005\rt\u00021\u0001\u0002f\u0005Q!M]1oG\"tu\u000eZ3\u0011\u0007\u0001\f9'C\u0002\u0002j\u0015\u0014!B\u0011:b]\u000eDgj\u001c3f\u0011\u001d\tig\u0004a\u0001\u0003_\naA\\5cE2,\u0007cA\u0013\u0002r%\u0019\u00111\u000f\u0014\u0003\u0007%sG\u000fC\u0004\u0002x=\u0001\r!!\f\u0002\rI,7/\u001e7uQ\u001dy\u0011\u0011IA)\u0003wb#!!\u0016\u0002\u0007A,H\u000f\u0006\u0005\u0002,\u0005\u0005\u00151QAC\u0011\u00159\u0007\u00031\u0001Q\u0011\u0019\tI\u0001\u0005a\u0001q\"1\u0011\u0011\u000b\tA\u0002a$\"\"a\u000b\u0002\n\u0006-\u0015QRAH\u0011\u00159\u0017\u00031\u0001Q\u0011\u0019\ty!\u0005a\u0001?\"1\u0011\u0011B\tA\u0002aDa!!\u0015\u0012\u0001\u0004A\u0018A\u00022sC:\u001c\u0007\u000e\u0006\u0007\u0002,\u0005U\u0015qSAM\u0003;\u000by\nC\u0003h%\u0001\u0007\u0001\u000b\u0003\u0004\u0002\u0010I\u0001\ra\u0018\u0005\b\u00037\u0013\u0002\u0019AA8\u0003-\u0011'/\u00198dQ&sG-\u001a=\t\r\u0005%!\u00031\u0001y\u0011\u0019\t\tF\u0005a\u0001q\u00061q-\u001a;BY2$b!!*\u00028\u0006m\u0006\u0003B-]\u0003O\u0003b!!+\u0002.\u0006EVBAAV\u0015\tYX$\u0003\u0003\u00020\u0006-&aB!WK\u000e$xN\u001d\t\u0006K\u0005Mf&O\u0005\u0004\u0003k3#A\u0002+va2,'\u0007\u0003\u0004\u0002:N\u0001\r\u0001_\u0001\u0007aJ,g-\u001b=\t\u000f\u0005u6\u00031\u0001\u0002p\u0005AQ.\u0019=O_\u0012,7\u000f\u0006\u0005\u0002&\u0006\u0005\u00171YAc\u0011\u0019\tI\f\u0006a\u0001q\"9\u0011Q\u0018\u000bA\u0002\u0005=\u0004bBAd)\u0001\u0007\u0011\u0011Z\u0001\naJ,G-[2bi\u0016\u0004r!JAf]e\nI\"C\u0002\u0002N\u001a\u0012\u0011BR;oGRLwN\u001c\u001a\u0002\u0013\u001d,G/\u00117m%\u0006<H\u0003DAS\u0003'\f).a6\u0002\\\u0006u\u0007BBA]+\u0001\u0007\u0001\u0010C\u0003h+\u0001\u0007\u0001\u000b\u0003\u0004\u0002ZV\u0001\r\u0001_\u0001\u0004C\u000e\u001c\u0007bBA_+\u0001\u0007\u0011q\u000e\u0005\b\u0003\u000f,\u0002\u0019AAe)1\t)+!9\u0002d\u0006\u0015\u0018q]Au\u0011\u0019\tIL\u0006a\u0001q\"1\u0011q\u0002\fA\u0002}Ca!!7\u0017\u0001\u0004A\bbBA_-\u0001\u0007\u0011q\u000e\u0005\b\u0003\u000f4\u0002\u0019AAeQ\u001d1\u0012\u0011IA)\u0003[d#!a<\"\u0005\u0005E\u0018!I8sO::\u0018M\u001d;sK6|g/\u001a:/o\u0006\u0014Ho\u001d\u0018Ji\u0016\u0014\u0018M\u00197f\u001fB\u001cHCCAS\u0003k\f90!?\u0002|\")qm\u0006a\u0001!\"1\u0011\u0011\\\fA\u0002aDq!!0\u0018\u0001\u0004\ty\u0007C\u0004\u0002H^\u0001\r!!3\u0015\u0015\u0005\u0015\u0016q B\u0001\u0005\u0007\u0011)\u0001C\u0004\u0002\u0010a\u0001\r!!\u001a\t\r\u0005e\u0007\u00041\u0001y\u0011\u001d\ti\f\u0007a\u0001\u0003_Bq!a2\u0019\u0001\u0004\tI-A\u0007eKN,'/[1mSj,7J\u0016\u000b\t\u0003K\u0013YA!\u0004\u0003\u0016!1\u0011\u0011B\rA\u0002aDq!a\u0004\u001a\u0001\u0004\u0011y\u0001E\u0002a\u0005#I1Aa\u0005f\u0005!aU-\u00194O_\u0012,\u0007bBAd3\u0001\u0007\u0011\u0011\u001a")
public abstract class SparseMerkleTrieBase<K, V, T>
implements MutableKV<K, V, T> {
    private final Serde<K> evidence$10;
    private final Serde<V> evidence$11;

    public abstract Blake2b rootHash();

    public abstract Either<IOError, SparseMerkleTrie.Node> getNode(Blake2b var1);

    @Override
    public Either<IOError, V> get(K key) {
        return this.getOpt(key).flatMap((Function1 & Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return package$.MODULE$.Left().apply((Object)IOError$.MODULE$.keyNotFound(key, "SparseMerkleTrie.get"));
            }
            if (x0$1 instanceof Some) {
                Object value = ((Some)x0$1).value();
                return package$.MODULE$.Right().apply(value);
            }
            throw new MatchError(x0$1);
        });
    }

    @Override
    public Either<IOError, Option<V>> getOpt(K key) {
        return this.getOptRaw(org.alephium.serde.package$.MODULE$.serialize(key, this.evidence$10)).flatMap((Function1 & Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return package$.MODULE$.Right().apply((Object)None$.MODULE$);
            }
            if (x0$1 instanceof Some) {
                ByteString bytes = (ByteString)((Some)x0$1).value();
                Either either = org.alephium.serde.package$.MODULE$.deserialize(bytes, $this.evidence$11);
                if (either instanceof Left) {
                    SerdeError error2 = (SerdeError)((Left)either).value();
                    return package$.MODULE$.Left().apply((Object)new IOError.Serde(error2));
                }
                if (either instanceof Right) {
                    Object value = ((Right)either).value();
                    return package$.MODULE$.Right().apply((Object)new Some(value));
                }
                throw new MatchError((Object)either);
            }
            throw new MatchError(x0$1);
        });
    }

    public Either<IOError, Option<ByteString>> getOptRaw(ByteString key) {
        ByteString nibbles = SparseMerkleTrie$.MODULE$.bytes2Nibbles(key);
        return this.getOpt(this.rootHash(), nibbles);
    }

    public Either<IOError, Option<ByteString>> getOpt(Blake2b hash, ByteString nibbles) {
        return this.getNode(hash).flatMap((Function1 & Serializable)x$3 -> this.getOpt((SparseMerkleTrie.Node)x$3, nibbles));
    }

    public Either<IOError, Option<ByteString>> getOpt(SparseMerkleTrie.Node node, ByteString nibbles) {
        if (node instanceof SparseMerkleTrie.BranchNode) {
            SparseMerkleTrie.BranchNode branchNode = (SparseMerkleTrie.BranchNode)node;
            ByteString path = branchNode.path();
            AVector<Option<Blake2b>> children = branchNode.children();
            Predef$.MODULE$.assume(nibbles.length() > path.length());
            if (path.equals(nibbles.take(path.length()))) {
                Option option = (Option)children.apply(SparseMerkleTrie$.MODULE$.getNibble(nibbles, path.length()));
                if (option instanceof Some) {
                    Blake2b childHash = (Blake2b)((Some)option).value();
                    return this.getOpt(childHash, nibbles.drop(path.length() + 1));
                }
                if (None$.MODULE$.equals(option)) {
                    return package$.MODULE$.Right().apply((Object)None$.MODULE$);
                }
                throw new MatchError((Object)option);
            }
            return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        if (node instanceof SparseMerkleTrie.LeafNode) {
            SparseMerkleTrie.LeafNode leafNode = (SparseMerkleTrie.LeafNode)node;
            ByteString path = leafNode.path();
            ByteString data = leafNode.data();
            ByteString byteString = path;
            if (!(byteString != null ? !byteString.equals(nibbles) : nibbles != null)) {
                return package$.MODULE$.Right().apply((Object)new Some((Object)data));
            }
            return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        throw new MatchError((Object)node);
    }

    @Override
    public Either<IOError, Object> exists(K key) {
        return this.existRaw(org.alephium.serde.package$.MODULE$.serialize(key, this.evidence$10));
    }

    public Either<IOError, Object> existRaw(ByteString key) {
        return this.getOptRaw(key).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.nonEmpty()));
    }

    public Either<IOError, SparseMerkleTrie.TrieUpdateActions> remove(Blake2b hash, ByteString nibbles) {
        return this.getNode(hash).flatMap((Function1 & Serializable)x$5 -> this.remove(hash, (SparseMerkleTrie.Node)x$5, nibbles));
    }

    public Either<IOError, SparseMerkleTrie.TrieUpdateActions> remove(Blake2b hash, SparseMerkleTrie.Node node, ByteString nibbles) {
        if (node instanceof SparseMerkleTrie.BranchNode) {
            SparseMerkleTrie.BranchNode branchNode = (SparseMerkleTrie.BranchNode)node;
            ByteString path = branchNode.path();
            AVector<Option<Blake2b>> children = branchNode.children();
            Predef$.MODULE$.assume(nibbles.length() > path.length());
            int nibble = SparseMerkleTrie$.MODULE$.getNibble(nibbles, path.length());
            Option childOpt = (Option)children.apply(nibble);
            if (path.equals(nibbles.take(path.length())) && childOpt.nonEmpty()) {
                ByteString restNibbles = nibbles.drop(path.length() + 1);
                Blake2b childHash = (Blake2b)childOpt.get();
                return this.remove(childHash, restNibbles).flatMap((Function1 & Serializable)result -> this.handleChildUpdateResult(hash, branchNode, nibble, (SparseMerkleTrie.TrieUpdateActions)result));
            }
            return package$.MODULE$.Left().apply((Object)IOError$.MODULE$.keyNotFound(hash, "SparseMerkleTrie.remove"));
        }
        if (node instanceof SparseMerkleTrie.LeafNode) {
            SparseMerkleTrie.LeafNode leafNode = (SparseMerkleTrie.LeafNode)node;
            ByteString byteString = leafNode.path();
            if (!(byteString != null ? !byteString.equals(nibbles) : nibbles != null)) {
                return package$.MODULE$.Right().apply((Object)new SparseMerkleTrie.TrieUpdateActions((Option<SparseMerkleTrie.Node>)None$.MODULE$, (AVector<Blake2b>)AVector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Blake2b[]{leafNode.hash()}), ClassTag$.MODULE$.apply(Blake2b.class)), (AVector<SparseMerkleTrie.Node>)AVector$.MODULE$.empty(ClassTag$.MODULE$.apply(SparseMerkleTrie.Node.class))));
            }
            return package$.MODULE$.Left().apply((Object)IOError$.MODULE$.keyNotFound(hash, "SparseMerkleTrie.remove"));
        }
        throw new MatchError((Object)node);
    }

    public Either<IOError, SparseMerkleTrie.TrieUpdateActions> handleChildUpdateResult(Blake2b branchHash, SparseMerkleTrie.BranchNode branchNode, int nibble, SparseMerkleTrie.TrieUpdateActions result) {
        Option oldChildOptHash;
        AVector<Option<Blake2b>> children = branchNode.children();
        Option childOptHash = result.nodeOpt().map((Function1 & Serializable)x$6 -> x$6.hash());
        AVector newChildren = children.replace(nibble, (Object)childOptHash);
        if (childOptHash.isEmpty() && newChildren.map$mIc$sp((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)SparseMerkleTrieBase.$anonfun$handleChildUpdateResult$2(x$7)), (ClassTag)ClassTag$.MODULE$.Int()).sum$mcI$sp((Numeric)Numeric.IntIsIntegral$.MODULE$) == 1) {
            int onlyChildIndex = newChildren.indexWhere((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.nonEmpty()));
            Blake2b onlyChildHash = (Blake2b)((Option)children.apply(onlyChildIndex)).get();
            return this.getNode(onlyChildHash).map((Function1 & Serializable)onlyChild -> {
                SparseMerkleTrie.Node newNode = onlyChild.preExtend(branchNode.path().$plus$plus(ByteString$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{(byte)onlyChildIndex}))));
                AVector toDelete = result.toDelete().$plus$plus(AVector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Blake2b[]{onlyChildHash, branchHash}), ClassTag$.MODULE$.apply(Blake2b.class)));
                return new SparseMerkleTrie.TrieUpdateActions((Option<SparseMerkleTrie.Node>)new Some((Object)newNode), (AVector<Blake2b>)toDelete, (AVector<SparseMerkleTrie.Node>)result.toAdd().$colon$plus((Object)newNode));
            });
        }
        Option option = oldChildOptHash = (Option)children.apply(nibble);
        if (option == null || !option.equals(childOptHash)) {
            SparseMerkleTrie.BranchNode newBranchNode = new SparseMerkleTrie.BranchNode(branchNode.path(), (AVector<Option<Blake2b>>)newChildren);
            AVector toDelete = oldChildOptHash.isEmpty() ? result.toDelete().$colon$plus((Object)branchHash) : result.toDelete().$plus$plus(AVector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Blake2b[]{(Blake2b)oldChildOptHash.get(), branchHash}), ClassTag$.MODULE$.apply(Blake2b.class)));
            return package$.MODULE$.Right().apply((Object)new SparseMerkleTrie.TrieUpdateActions((Option<SparseMerkleTrie.Node>)new Some((Object)newBranchNode), (AVector<Blake2b>)toDelete, (AVector<SparseMerkleTrie.Node>)result.toAdd().$colon$plus((Object)newBranchNode)));
        }
        return package$.MODULE$.Right().apply((Object)new SparseMerkleTrie.TrieUpdateActions((Option<SparseMerkleTrie.Node>)new Some((Object)branchNode), (AVector<Blake2b>)AVector$.MODULE$.empty(ClassTag$.MODULE$.apply(Blake2b.class)), (AVector<SparseMerkleTrie.Node>)AVector$.MODULE$.empty(ClassTag$.MODULE$.apply(SparseMerkleTrie.Node.class))));
    }

    public Either<IOError, SparseMerkleTrie.TrieUpdateActions> put(Blake2b hash, ByteString nibbles, ByteString value) {
        Predef$.MODULE$.assume(nibbles.nonEmpty());
        return this.getNode(hash).flatMap((Function1 & Serializable)x$10 -> this.put(hash, (SparseMerkleTrie.Node)x$10, nibbles, value));
    }

    public Either<IOError, SparseMerkleTrie.TrieUpdateActions> put(Blake2b hash, SparseMerkleTrie.Node node, ByteString nibbles, ByteString value) {
        ByteString path = node.path();
        Predef$.MODULE$.assume(path.length() <= nibbles.length());
        int branchIndex = node.path().indices().indexWhere((Function1)(JFunction1.mcZI.sp & Serializable)i -> nibbles.apply(i) != path.apply(i));
        if (branchIndex == -1) {
            if (node instanceof SparseMerkleTrie.BranchNode) {
                SparseMerkleTrie.BranchNode branchNode = (SparseMerkleTrie.BranchNode)node;
                AVector<Option<Blake2b>> children = branchNode.children();
                int nibble = SparseMerkleTrie$.MODULE$.getNibble(nibbles, path.length());
                ByteString nibblesRight = nibbles.drop(path.length() + 1);
                Option option = (Option)children.apply(nibble);
                if (option instanceof Some) {
                    Blake2b childHash = (Blake2b)((Some)option).value();
                    return this.put(childHash, nibblesRight, value).flatMap((Function1 & Serializable)result -> this.handleChildUpdateResult(hash, branchNode, nibble, (SparseMerkleTrie.TrieUpdateActions)result));
                }
                if (None$.MODULE$.equals(option)) {
                    SparseMerkleTrie.LeafNode newLeaf = new SparseMerkleTrie.LeafNode(nibblesRight, value);
                    SparseMerkleTrie.BranchNode newBranch = branchNode.replace(nibble, newLeaf.hash());
                    return package$.MODULE$.Right().apply((Object)new SparseMerkleTrie.TrieUpdateActions((Option<SparseMerkleTrie.Node>)new Some((Object)newBranch), (AVector<Blake2b>)AVector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Blake2b[]{hash}), ClassTag$.MODULE$.apply(Blake2b.class)), (AVector<SparseMerkleTrie.Node>)AVector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SparseMerkleTrie.Node[]{newBranch, newLeaf}), ClassTag$.MODULE$.apply(SparseMerkleTrie.Node.class))));
                }
                throw new MatchError((Object)option);
            }
            if (node instanceof SparseMerkleTrie.LeafNode) {
                SparseMerkleTrie.LeafNode leafNode = (SparseMerkleTrie.LeafNode)node;
                Predef$.MODULE$.assume(path.length() == nibbles.length());
                ByteString byteString = leafNode.data();
                if (!(byteString != null ? !byteString.equals(value) : value != null)) {
                    return package$.MODULE$.Right().apply((Object)new SparseMerkleTrie.TrieUpdateActions((Option<SparseMerkleTrie.Node>)new Some((Object)leafNode), (AVector<Blake2b>)AVector$.MODULE$.empty(ClassTag$.MODULE$.apply(Blake2b.class)), (AVector<SparseMerkleTrie.Node>)AVector$.MODULE$.empty(ClassTag$.MODULE$.apply(SparseMerkleTrie.Node.class))));
                }
                SparseMerkleTrie.LeafNode newLeaf = new SparseMerkleTrie.LeafNode(path, value);
                return package$.MODULE$.Right().apply((Object)new SparseMerkleTrie.TrieUpdateActions((Option<SparseMerkleTrie.Node>)new Some((Object)newLeaf), (AVector<Blake2b>)AVector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Blake2b[]{leafNode.hash()}), ClassTag$.MODULE$.apply(Blake2b.class)), (AVector<SparseMerkleTrie.Node>)AVector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SparseMerkleTrie.Node[]{newLeaf}), ClassTag$.MODULE$.apply(SparseMerkleTrie.Node.class))));
            }
            throw new MatchError((Object)node);
        }
        return this.branch(hash, node, branchIndex, nibbles, value);
    }

    public Either<IOError, SparseMerkleTrie.TrieUpdateActions> branch(Blake2b hash, SparseMerkleTrie.Node node, int branchIndex, ByteString nibbles, ByteString value) {
        ByteString path = node.path();
        ByteString prefix = path.take(branchIndex);
        int nibble1 = SparseMerkleTrie$.MODULE$.getNibble(path, branchIndex);
        SparseMerkleTrie.Node node1 = node.preCut(branchIndex + 1);
        ByteString nibblesRight = nibbles.drop(branchIndex + 1);
        int nibble2 = SparseMerkleTrie$.MODULE$.getNibble(nibbles, branchIndex);
        SparseMerkleTrie.LeafNode newLeaf = new SparseMerkleTrie.LeafNode(nibblesRight, value);
        SparseMerkleTrie.BranchNode branchNode = SparseMerkleTrie$Node$.MODULE$.branch(prefix, nibble1, node1, nibble2, newLeaf);
        AVector toAdd = AVector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SparseMerkleTrie.Node[]{branchNode, node1, newLeaf}), ClassTag$.MODULE$.apply(SparseMerkleTrie.Node.class));
        return package$.MODULE$.Right().apply((Object)new SparseMerkleTrie.TrieUpdateActions((Option<SparseMerkleTrie.Node>)new Some((Object)branchNode), (AVector<Blake2b>)AVector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Blake2b[]{hash}), ClassTag$.MODULE$.apply(Blake2b.class)), (AVector<SparseMerkleTrie.Node>)toAdd));
    }

    public Either<IOError, AVector<Tuple2<K, V>>> getAll(ByteString prefix, int maxNodes) {
        ByteString prefixNibbles = SparseMerkleTrie$.MODULE$.bytes2Nibbles(prefix);
        return this.getAllRaw(prefixNibbles, this.rootHash(), ByteString$.MODULE$.empty(), maxNodes, (Function2 & Serializable)(x$11, x$12) -> BoxesRunTime.boxToBoolean((boolean)SparseMerkleTrieBase.$anonfun$getAll$1(x$11, x$12)));
    }

    public Either<IOError, AVector<Tuple2<K, V>>> getAll(ByteString prefix, int maxNodes, Function2<K, V, Object> predicate) {
        ByteString prefixNibbles = SparseMerkleTrie$.MODULE$.bytes2Nibbles(prefix);
        return this.getAllRaw(prefixNibbles, this.rootHash(), ByteString$.MODULE$.empty(), maxNodes, predicate);
    }

    public Either<IOError, AVector<Tuple2<K, V>>> getAllRaw(ByteString prefix, Blake2b hash, ByteString acc, int maxNodes, Function2<K, V, Object> predicate) {
        if (prefix.isEmpty()) {
            return this.getAllRaw(hash, acc, maxNodes, predicate);
        }
        return this.getNode(hash).flatMap((Function1 & Serializable)x$13 -> this.getAllRaw(prefix, (SparseMerkleTrie.Node)x$13, acc, maxNodes, predicate));
    }

    public Either<IOError, AVector<Tuple2<K, V>>> getAllRaw(ByteString prefix, SparseMerkleTrie.Node node, ByteString acc, int maxNodes, Function2<K, V, Object> predicate) {
        if (node instanceof SparseMerkleTrie.BranchNode) {
            SparseMerkleTrie.BranchNode branchNode = (SparseMerkleTrie.BranchNode)node;
            if (branchNode.path().length() >= prefix.length()) {
                if (branchNode.path().startsWith((IterableOnce)prefix, branchNode.path().startsWith$default$2())) {
                    return this.getAllRaw(branchNode, acc, maxNodes, predicate);
                }
                return package$.MODULE$.Right().apply((Object)AVector$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
            }
            if (prefix.startsWith((IterableOnce)branchNode.path(), prefix.startsWith$default$2())) {
                ByteString prefixRest = prefix.drop(branchNode.path().length());
                byte nibble = prefixRest.head();
                Predef$.MODULE$.assume(nibble >= 0 && nibble < 16);
                Option option = (Option)branchNode.children().apply((int)nibble);
                if (option instanceof Some) {
                    Blake2b child = (Blake2b)((Some)option).value();
                    return this.getAllRaw(prefixRest.tail(), child, acc.$plus$plus(branchNode.path()).$plus$plus(ByteString$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{nibble}))), maxNodes, predicate);
                }
                if (None$.MODULE$.equals(option)) {
                    return package$.MODULE$.Right().apply((Object)AVector$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
                }
                throw new MatchError((Object)option);
            }
            return package$.MODULE$.Right().apply((Object)AVector$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        }
        if (node instanceof SparseMerkleTrie.LeafNode) {
            SparseMerkleTrie.LeafNode leafNode = (SparseMerkleTrie.LeafNode)node;
            ByteString byteString = leafNode.path().take(prefix.length());
            if (byteString != null && byteString.equals(prefix)) {
                return this.deserializeKV(acc.$plus$plus(leafNode.path()), leafNode, predicate);
            }
            return package$.MODULE$.Right().apply((Object)AVector$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        }
        throw new MatchError((Object)node);
    }

    public Either<IOError, AVector<Tuple2<K, V>>> getAllRaw(Blake2b hash, ByteString acc, int maxNodes, Function2<K, V, Object> predicate) {
        return this.getNode(hash).flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof SparseMerkleTrie.BranchNode) {
                SparseMerkleTrie.BranchNode branchNode = (SparseMerkleTrie.BranchNode)x0$1;
                return this.getAllRaw(branchNode, acc, maxNodes, predicate);
            }
            if (x0$1 instanceof SparseMerkleTrie.LeafNode) {
                SparseMerkleTrie.LeafNode leafNode = (SparseMerkleTrie.LeafNode)x0$1;
                return this.deserializeKV(acc.$plus$plus(leafNode.path()), leafNode, predicate);
            }
            throw new MatchError(x0$1);
        });
    }

    public Either<IOError, AVector<Tuple2<K, V>>> getAllRaw(SparseMerkleTrie.BranchNode node, ByteString acc, int maxNodes, Function2<K, V, Object> predicate) {
        return node.children().foldWithIndexE((Object)AVector$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)), (Function3 & Serializable)(x0$1, x1$1, x2$1) -> SparseMerkleTrieBase.$anonfun$getAllRaw$3(this, maxNodes, acc, node, predicate, x0$1, x1$1, BoxesRunTime.unboxToInt((Object)x2$1)));
    }

    public Either<IOError, AVector<Tuple2<K, V>>> deserializeKV(ByteString nibbles, SparseMerkleTrie.LeafNode node, Function2<K, V, Object> predicate) {
        return org.alephium.serde.package$.MODULE$.deserialize(SparseMerkleTrie$.MODULE$.nibbles2Bytes(nibbles), this.evidence$10).flatMap((Function1 & Serializable)key -> org.alephium.serde.package$.MODULE$.deserialize(node.data(), $this.evidence$11).map((Function1 & Serializable)value -> {
            if (BoxesRunTime.unboxToBoolean((Object)predicate.apply(key, value))) {
                return AVector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), value)}), ClassTag$.MODULE$.apply(Tuple2.class));
            }
            return AVector$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class));
        })).left().map((Function1)IOError$Serde$.MODULE$);
    }

    public static final /* synthetic */ int $anonfun$handleChildUpdateResult$4(Blake2b x$8) {
        return 1;
    }

    public static final /* synthetic */ int $anonfun$handleChildUpdateResult$2(Option x$7) {
        return BoxesRunTime.unboxToInt((Object)x$7.fold((Function0)(JFunction0.mcI.sp & Serializable)() -> 0, (Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)SparseMerkleTrieBase.$anonfun$handleChildUpdateResult$4(x$8))));
    }

    public static final /* synthetic */ boolean $anonfun$getAll$1(Object x$11, Object x$12) {
        return true;
    }

    public static final /* synthetic */ Either $anonfun$getAllRaw$3(SparseMerkleTrieBase $this, int maxNodes$3, ByteString acc$3, SparseMerkleTrie.BranchNode node$1, Function2 predicate$3, AVector x0$1, Option x1$1, int x2$1) {
        int restNodes = maxNodes$3 - x0$1.length();
        if (x1$1 instanceof Some) {
            Blake2b child = (Blake2b)((Some)x1$1).value();
            if (restNodes > 0) {
                return $this.getAllRaw(child, acc$3.$plus$plus(node$1.path()).$plus$plus(ByteString$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{(byte)x2$1}))), restNodes, predicate$3).map((Function1 & Serializable)x$14 -> x0$1.$plus$plus(x$14));
            }
        }
        return package$.MODULE$.Right().apply((Object)x0$1);
    }

    public SparseMerkleTrieBase(Serde<K> evidence$10, Serde<V> evidence$11) {
        this.evidence$10 = evidence$10;
        this.evidence$11 = evidence$11;
    }
}

