/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import java.util.Optional;
import java.util.Stack;
import javax.sql.XADataSource;
import org.alfasoftware.morf.jdbc.AbstractDatabaseType;
import org.alfasoftware.morf.jdbc.JdbcUrlElements;
import org.alfasoftware.morf.jdbc.SqlDialect;
import org.alfasoftware.morf.jdbc.oracle.OracleDialect;
import org.alfasoftware.morf.jdbc.oracle.OracleMetaDataProvider;
import org.alfasoftware.morf.metadata.Schema;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Oracle
extends AbstractDatabaseType {
    private static final Log log = LogFactory.getLog(Oracle.class);
    public static final String IDENTIFIER = "ORACLE";

    public Oracle() {
        super("oracle.jdbc.driver.OracleDriver", IDENTIFIER);
    }

    public String formatJdbcUrl(JdbcUrlElements jdbcUrlElements) {
        return "jdbc:oracle:thin:@" + jdbcUrlElements.getHostName() + (jdbcUrlElements.getPort() == 0 ? "" : ":" + jdbcUrlElements.getPort()) + "/" + jdbcUrlElements.getInstanceName();
    }

    public Schema openSchema(Connection connection, String databaseName, String schemaName) {
        if (StringUtils.isEmpty((String)schemaName)) {
            throw new IllegalStateException("No schema name has been provided, but a schema name is required when connecting to Oracle");
        }
        return new OracleMetaDataProvider(connection, schemaName);
    }

    public boolean canTrace() {
        return true;
    }

    public XADataSource getXADataSource(String jdbcUrl, String username, String password) {
        try {
            log.info((Object)"Initialising Oracle XA data source...");
            XADataSource dataSource = (XADataSource)Class.forName("oracle.jdbc.xa.client.OracleXADataSource").newInstance();
            dataSource.getClass().getMethod("setURL", String.class).invoke((Object)dataSource, jdbcUrl);
            dataSource.getClass().getMethod("setUser", String.class).invoke((Object)dataSource, username);
            dataSource.getClass().getMethod("setPassword", String.class).invoke((Object)dataSource, password);
            return dataSource;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create Oracle XA data source", e);
        }
    }

    public SqlDialect sqlDialect(String schemaName) {
        return new OracleDialect(schemaName);
    }

    public boolean matchesProduct(String product) {
        return product.equalsIgnoreCase("Oracle");
    }

    public Exception reclassifyException(Exception e) {
        int errorCode;
        Optional<Integer> xaErrorCode = this.getErrorCodeFromOracleXAException(e);
        if (xaErrorCode.isPresent()) {
            if (xaErrorCode.get() == 60 || xaErrorCode.get() == 2049) {
                return new SQLTransientException(e.getMessage(), null, xaErrorCode.get(), e);
            }
            return new SQLException(e.getMessage(), null, xaErrorCode.get(), e);
        }
        if (e instanceof SQLException && !(e instanceof SQLTransientException) && ((errorCode = ((SQLException)e).getErrorCode()) == 60 || errorCode == 2049)) {
            return new SQLTransientException(e.getMessage(), ((SQLException)e).getSQLState(), errorCode, e);
        }
        return e;
    }

    private Optional<Integer> getErrorCodeFromOracleXAException(Throwable exception) {
        try {
            if ("oracle.jdbc.xa.OracleXAException".equals(exception.getClass().getName())) {
                return Optional.of((Integer)exception.getClass().getMethod("getOracleError", new Class[0]).invoke((Object)exception, new Object[0]));
            }
            if (exception.getCause() != null) {
                return this.getErrorCodeFromOracleXAException(exception.getCause());
            }
            return Optional.empty();
        }
        catch (Exception e) {
            log.error((Object)"Exception when trying to extract error code", exception);
            throw new RuntimeException(e);
        }
    }

    public Optional<JdbcUrlElements> extractJdbcUrl(String jdbcUrl) {
        Stack splitURL = this.splitJdbcUrl(jdbcUrl);
        String scheme = (String)splitURL.pop();
        if (!scheme.equalsIgnoreCase("oracle")) {
            return Optional.empty();
        }
        splitURL.pop();
        splitURL.pop();
        if (!((String)splitURL.pop()).equals(":@")) {
            throw new IllegalArgumentException("Expected '@' to follow the scheme name in [" + jdbcUrl + "]");
        }
        JdbcUrlElements.Builder connectionDetails = this.extractHostAndPort(splitURL);
        String path = this.extractPath(splitURL);
        connectionDetails.withInstanceName(path);
        return Optional.of(connectionDetails.build());
    }
}

