/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.oracle;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.alfasoftware.morf.jdbc.DatabaseType;
import org.alfasoftware.morf.jdbc.NamedParameterPreparedStatement;
import org.alfasoftware.morf.jdbc.SqlDialect;
import org.alfasoftware.morf.jdbc.SqlScriptExecutor;
import org.alfasoftware.morf.metadata.Column;
import org.alfasoftware.morf.metadata.DataType;
import org.alfasoftware.morf.metadata.Index;
import org.alfasoftware.morf.metadata.SchemaUtils;
import org.alfasoftware.morf.metadata.Table;
import org.alfasoftware.morf.metadata.View;
import org.alfasoftware.morf.sql.AbstractSelectStatement;
import org.alfasoftware.morf.sql.DirectPathQueryHint;
import org.alfasoftware.morf.sql.Hint;
import org.alfasoftware.morf.sql.InsertStatement;
import org.alfasoftware.morf.sql.OptimiseForRowCount;
import org.alfasoftware.morf.sql.ParallelQueryHint;
import org.alfasoftware.morf.sql.SelectFirstStatement;
import org.alfasoftware.morf.sql.SelectStatement;
import org.alfasoftware.morf.sql.SqlUtils;
import org.alfasoftware.morf.sql.UpdateStatement;
import org.alfasoftware.morf.sql.UseImplicitJoinOrder;
import org.alfasoftware.morf.sql.UseIndex;
import org.alfasoftware.morf.sql.UseParallelDml;
import org.alfasoftware.morf.sql.element.AliasedField;
import org.alfasoftware.morf.sql.element.BlobFieldLiteral;
import org.alfasoftware.morf.sql.element.ConcatenatedField;
import org.alfasoftware.morf.sql.element.Direction;
import org.alfasoftware.morf.sql.element.FieldReference;
import org.alfasoftware.morf.sql.element.Function;
import org.alfasoftware.morf.sql.element.NullValueHandling;
import org.alfasoftware.morf.sql.element.SqlParameter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class OracleDialect
extends SqlDialect {
    private static final Log log = LogFactory.getLog(OracleDialect.class);
    public static final String NULLS_FIRST = "NULLS FIRST";
    public static final String NULLS_LAST = "NULLS LAST";
    public static final String DEFAULT_NULL_ORDER = "NULLS FIRST";

    public OracleDialect(String schemaName) {
        super(schemaName);
    }

    public Collection<String> truncateTableStatements(Table table) {
        String mainTruncate = "TRUNCATE TABLE " + this.schemaNamePrefix() + table.getName();
        if (table.isTemporary()) {
            return Arrays.asList(mainTruncate);
        }
        return Arrays.asList(mainTruncate + " REUSE STORAGE");
    }

    public Collection<String> internalTableDeploymentStatements(Table table) {
        return this.tableDeploymentStatements(table, false);
    }

    private Collection<String> tableDeploymentStatements(Table table, boolean asSelect) {
        return ImmutableList.builder().add((Object)this.createTableStatement(table, asSelect)).addAll(this.buildRemainingStatementsAndComments(table)).build();
    }

    private String createTableStatement(Table table, boolean asSelect) {
        StringBuilder createTableStatement = new StringBuilder();
        createTableStatement.append("CREATE ");
        if (table.isTemporary()) {
            createTableStatement.append("GLOBAL TEMPORARY ");
        }
        createTableStatement.append("TABLE ");
        String truncatedTableName = this.truncatedTableName(table.getName());
        createTableStatement.append(this.schemaNamePrefix());
        createTableStatement.append(truncatedTableName);
        createTableStatement.append(" (");
        boolean first = true;
        for (Column column : table.columns()) {
            if (!first) {
                createTableStatement.append(", ");
            }
            createTableStatement.append(column.getName());
            if (asSelect) {
                createTableStatement.append(" " + this.sqlRepresentationOfColumnType(column, true, true, false));
            } else {
                createTableStatement.append(" " + this.sqlRepresentationOfColumnType(column));
            }
            first = false;
        }
        if (!SchemaUtils.primaryKeysForTable((Table)table).isEmpty()) {
            createTableStatement.append(", ");
            createTableStatement.append(this.primaryKeyConstraint(table));
        }
        createTableStatement.append(")");
        if (table.isTemporary()) {
            createTableStatement.append(" ON COMMIT PRESERVE ROWS");
        }
        if (asSelect) {
            createTableStatement.append(" PARALLEL NOLOGGING");
        }
        return createTableStatement.toString();
    }

    private Collection<String> createColumnComments(Table table) {
        ArrayList columnComments = Lists.newArrayList();
        for (Column column : table.columns()) {
            columnComments.add(this.columnComment(column, this.truncatedTableName(table.getName())));
        }
        return columnComments;
    }

    private Column findAutonumberedColumn(Table table) {
        Column sequence = null;
        for (Column column : table.columns()) {
            if (!column.isAutoNumbered()) continue;
            sequence = column;
            break;
        }
        return sequence;
    }

    private String commentOnTable(String truncatedTableName) {
        return "COMMENT ON TABLE " + this.schemaNamePrefix() + truncatedTableName + " IS '" + "REALNAME" + ":[" + truncatedTableName + "]'";
    }

    private String primaryKeyConstraint(String tableName, List<String> newPrimaryKeyColumns) {
        return "CONSTRAINT " + this.primaryKeyConstraintName(tableName) + " PRIMARY KEY (" + Joiner.on((String)", ").join(newPrimaryKeyColumns) + ")";
    }

    private String primaryKeyConstraint(Table table) {
        return this.primaryKeyConstraint(table.getName(), SchemaUtils.namesOfColumns((List)SchemaUtils.primaryKeysForTable((Table)table)));
    }

    public Collection<String> dropStatements(Table table) {
        for (Column column : table.columns()) {
            if (!column.isAutoNumbered()) continue;
            return Arrays.asList(this.dropTrigger(table), "DROP TABLE " + this.schemaNamePrefix() + table.getName(), this.dropSequence(table));
        }
        return Arrays.asList("DROP TABLE " + this.schemaNamePrefix() + table.getName());
    }

    private String dropSequence(Table table) {
        String sequenceName = this.sequenceName(table.getName());
        return "DECLARE \n" + "  query CHAR(255); \n" + "BEGIN \n" + "  select queryField into query from SYS.DUAL D left outer join (\n" + "    select concat('drop sequence " + this.schemaNamePrefix() + "', sequence_name) as queryField \n" + "    from ALL_SEQUENCES S \n" + "    where S.sequence_owner='" + this.getSchemaName().toUpperCase() + "' AND S.sequence_name = '" + sequenceName.toUpperCase() + "' \n" + "  ) on 1 = 1; \n" + "  IF query is not null THEN \n" + "    execute immediate query; \n" + "  END IF; \n" + "END;";
    }

    private String createNewSequence(Table table, Column onColumn) {
        int autoNumberStart = onColumn.getAutoNumberStart() == -1 ? 1 : onColumn.getAutoNumberStart();
        return "CREATE SEQUENCE " + this.schemaNamePrefix() + this.sequenceName(table.getName()) + " START WITH " + autoNumberStart + " CACHE 2000";
    }

    private String createSequenceStartingFromExistingData(Table table, Column onColumn) {
        String tableName = this.schemaNamePrefix() + this.truncatedTableName(table.getName());
        String sequenceName = this.schemaNamePrefix() + this.sequenceName(table.getName());
        return "DECLARE query CHAR(255); \n" + "BEGIN \n" + "  SELECT 'CREATE SEQUENCE " + sequenceName + " START WITH ' || TO_CHAR(GREATEST(" + onColumn.getAutoNumberStart() + ", MAX(id)+1)) || ' CACHE 2000' INTO QUERY FROM \n" + "    (SELECT MAX(" + onColumn.getName() + ") AS id FROM " + tableName + " UNION SELECT 0 AS id FROM SYS.DUAL); \n" + "  EXECUTE IMMEDIATE query; \n" + "END;";
    }

    private List<String> createTrigger(Table table, Column onColumn) {
        ArrayList<String> createTriggerStatements = new ArrayList<String>();
        createTriggerStatements.add(String.format("ALTER SESSION SET CURRENT_SCHEMA = %s", this.getSchemaName()));
        String tableName = this.truncatedTableName(table.getName());
        String sequenceName = this.sequenceName(table.getName());
        String triggerName = this.schemaNamePrefix() + this.triggerName(table.getName());
        createTriggerStatements.add("CREATE TRIGGER " + triggerName + " \n" + "BEFORE INSERT ON " + tableName + " FOR EACH ROW \n" + "BEGIN \n" + "  IF (:new." + onColumn.getName() + " IS NULL) THEN \n" + "    SELECT " + sequenceName + ".nextval \n" + "    INTO :new." + onColumn.getName() + " \n" + "    FROM DUAL; \n" + "  END IF; \n" + "END;");
        return createTriggerStatements;
    }

    private String dropTrigger(Table table) {
        String triggerName = this.schemaNamePrefix() + this.triggerName(table.getName());
        return "DECLARE \n" + "  e exception; \n" + "  pragma exception_init(e,-4080); \n" + "BEGIN \n" + "  EXECUTE IMMEDIATE 'DROP TRIGGER " + triggerName + "'; \n" + "EXCEPTION \n" + "  WHEN e THEN \n" + "    null; \n" + "END;";
    }

    public Collection<String> dropStatements(View view) {
        return Arrays.asList("BEGIN FOR i IN (SELECT null FROM all_views WHERE OWNER='" + this.getSchemaName().toUpperCase() + "' AND VIEW_NAME='" + view.getName().toUpperCase() + "') LOOP EXECUTE IMMEDIATE 'DROP VIEW " + this.schemaNamePrefix() + view.getName() + "'; END LOOP; END;");
    }

    public void postInsertWithPresetAutonumStatements(Table table, SqlScriptExecutor executor, Connection connection, boolean insertingUnderAutonumLimit) {
        if (insertingUnderAutonumLimit) {
            return;
        }
        executor.execute(this.rebuildSequenceAndTrigger(table, this.getAutoIncrementColumnForTable(table)), connection);
    }

    private Collection<String> rebuildSequenceAndTrigger(Table table, Column sequence) {
        if (sequence == null) {
            return Lists.newArrayList((Object[])new String[]{this.dropTrigger(table)});
        }
        ArrayList<String> statements = new ArrayList<String>();
        statements.add(this.dropTrigger(table));
        statements.add(this.dropSequence(table));
        statements.add(this.createSequenceStartingFromExistingData(table, sequence));
        statements.addAll(this.createTrigger(table, sequence));
        return statements;
    }

    private String primaryKeyConstraintName(String tableName) {
        return this.truncatedTableNameWithSuffix(tableName, "_PK");
    }

    private String sequenceName(String tableName) {
        return this.truncatedTableNameWithSuffix(tableName, "_SQ").toUpperCase();
    }

    private String triggerName(String tableName) {
        return this.truncatedTableNameWithSuffix(tableName, "_TG").toUpperCase();
    }

    private String truncatedTableName(String tableName) {
        return StringUtils.substring((String)tableName, (int)0, (int)30);
    }

    private String truncatedTableNameWithSuffix(String tableName, String suffix) {
        return StringUtils.substring((String)tableName, (int)0, (int)27) + StringUtils.substring((String)suffix, (int)0, (int)3);
    }

    protected String makeStringLiteral(String literalValue) {
        if (StringUtils.isEmpty((CharSequence)literalValue)) {
            return "NULL";
        }
        return String.format("N'%s'", super.escapeSql(literalValue));
    }

    protected String getColumnRepresentation(DataType dataType, int width, int scale) {
        switch (dataType) {
            case STRING: {
                return String.format("NVARCHAR2(%d)", width);
            }
            case DECIMAL: {
                return String.format("DECIMAL(%d,%d)", width, scale);
            }
            case DATE: {
                return "DATE";
            }
            case BOOLEAN: {
                return "DECIMAL(1,0)";
            }
            case INTEGER: {
                return "INTEGER";
            }
            case BIG_INTEGER: {
                return "NUMBER(19)";
            }
            case BLOB: {
                return "BLOB";
            }
            case CLOB: {
                return "NCLOB";
            }
        }
        throw new UnsupportedOperationException("Cannot map column with type [" + dataType + "]");
    }

    protected void prepareBooleanParameter(NamedParameterPreparedStatement statement, Boolean boolVal, SqlParameter parameter) throws SQLException {
        statement.setBigDecimal(SqlUtils.parameter((String)parameter.getImpliedName()).type(DataType.DECIMAL).width(1), boolVal == null ? null : (boolVal != false ? BigDecimal.ONE : BigDecimal.ZERO));
    }

    public String connectionTestStatement() {
        return "select 1 from dual";
    }

    public DatabaseType getDatabaseType() {
        return DatabaseType.Registry.findByIdentifier((String)"ORACLE");
    }

    protected String getSqlFrom(ConcatenatedField concatenatedField) {
        ArrayList<String> sql = new ArrayList<String>();
        for (AliasedField field : concatenatedField.getConcatenationFields()) {
            sql.add(this.getSqlFrom(field));
        }
        return StringUtils.join(sql, (String)" || ");
    }

    protected String getSqlForIsNull(Function function) {
        return "nvl(" + this.getSqlFrom((AliasedField)function.getArguments().get(0)) + ", " + this.getSqlFrom((AliasedField)function.getArguments().get(1)) + ") ";
    }

    public List<String> buildSQLToStartTracing(String identifier) {
        return Arrays.asList("ALTER SESSION SET tracefile_identifier = '" + identifier + "'", "ALTER SESSION SET EVENTS '10046 TRACE NAME CONTEXT FOREVER, LEVEL 8'");
    }

    public List<String> buildSQLToStopTracing() {
        return Arrays.asList("ALTER SESSION SET EVENTS '10046 TRACE NAME CONTEXT OFF'");
    }

    protected String getSqlForOrderByFieldNullValueHandling(FieldReference orderByField) {
        if (orderByField.getNullValueHandling().isPresent()) {
            switch ((NullValueHandling)orderByField.getNullValueHandling().get()) {
                case FIRST: {
                    return " NULLS FIRST";
                }
                case LAST: {
                    return " NULLS LAST";
                }
            }
            return "";
        }
        if (orderByField.getDirection() != null) {
            return Direction.ASCENDING.equals((Object)orderByField.getDirection()) ? " NULLS FIRST" : " NULLS LAST";
        }
        return " " + this.defaultNullOrder();
    }

    protected String defaultNullOrder() {
        return "NULLS FIRST";
    }

    public Collection<String> addIndexStatements(Table table, Index index) {
        return ImmutableList.of((Object)((String)Iterables.getOnlyElement(this.indexDeploymentStatements(table, index)) + " PARALLEL NOLOGGING"), (Object)this.indexPostDeploymentStatements(index));
    }

    protected Collection<String> indexDeploymentStatements(Table table, Index index) {
        StringBuilder createIndexStatement = new StringBuilder();
        createIndexStatement.append("CREATE ");
        if (index.isUnique()) {
            createIndexStatement.append("UNIQUE ");
        }
        createIndexStatement.append("INDEX ").append(this.schemaNamePrefix()).append(index.getName()).append(" ON ").append(this.schemaNamePrefix()).append(this.truncatedTableName(table.getName())).append(" (").append(Joiner.on((String)", ").join((Iterable)index.columnNames())).append(")");
        return Collections.singletonList(createIndexStatement.toString());
    }

    private String indexPostDeploymentStatements(Index index) {
        return "ALTER INDEX " + this.schemaNamePrefix() + index.getName() + " NOPARALLEL LOGGING";
    }

    public Collection<String> alterTableAddColumnStatements(Table table, Column column) {
        ArrayList<String> result = new ArrayList<String>();
        String truncatedTableName = this.truncatedTableName(table.getName());
        result.add(String.format("ALTER TABLE %s%s ADD (%s %s)", this.schemaNamePrefix(), truncatedTableName, column.getName(), this.sqlRepresentationOfColumnType(column, true)));
        result.add(this.columnComment(column, truncatedTableName));
        return result;
    }

    public Collection<String> changePrimaryKeyColumns(Table table, List<String> oldPrimaryKeyColumns, List<String> newPrimaryKeyColumns) {
        ArrayList<String> result = new ArrayList<String>();
        String tableName = table.getName();
        if (!oldPrimaryKeyColumns.isEmpty()) {
            result.add(this.dropPrimaryKeyConstraint(tableName));
            for (String columnName : oldPrimaryKeyColumns) {
                result.add(this.makeColumnNotNull(tableName, columnName));
            }
        }
        if (!newPrimaryKeyColumns.isEmpty()) {
            result.add(this.generatePrimaryKeyStatement(newPrimaryKeyColumns, table.getName()));
        }
        return result;
    }

    private String makeColumnNotNull(String tableName, String columnName) {
        StringBuilder statement = new StringBuilder();
        statement.append("DECLARE \n").append("  e EXCEPTION; \n").append("  pragma exception_init(e,-1442); \n").append("BEGIN \n").append("  EXECUTE immediate 'ALTER TABLE ").append(this.schemaNamePrefix()).append(tableName).append(" MODIFY (").append(columnName).append(" NOT NULL)'; \n").append("EXCEPTION \n").append("WHEN e THEN \n").append("  NULL; \n").append("END;");
        if (log.isDebugEnabled()) {
            log.debug((Object)statement.toString());
        }
        return statement.toString();
    }

    public Collection<String> alterTableChangeColumnStatements(Table table, Column oldColumn, Column newColumn) {
        StringBuilder statement;
        boolean includeColumnType;
        boolean includeNullability;
        String sqlRepresentationOfColumnType;
        boolean recreatePrimaryKey;
        ArrayList<String> result = new ArrayList<String>();
        Table oldTable = this.oldTableForChangeColumn(table, oldColumn, newColumn);
        String truncatedTableName = this.truncatedTableName(oldTable.getName());
        boolean bl = recreatePrimaryKey = oldColumn.isPrimaryKey() || newColumn.isPrimaryKey();
        if (recreatePrimaryKey && !SchemaUtils.primaryKeysForTable((Table)oldTable).isEmpty()) {
            result.add(this.dropPrimaryKeyConstraint(truncatedTableName));
        }
        for (Index index : oldTable.indexes()) {
            for (String column : index.columnNames()) {
                if (!column.equalsIgnoreCase(oldColumn.getName())) continue;
                result.addAll(this.indexDropStatements(oldTable, index));
            }
        }
        if (!newColumn.getName().equalsIgnoreCase(oldColumn.getName())) {
            result.add("ALTER TABLE " + this.schemaNamePrefix() + truncatedTableName + " RENAME COLUMN " + oldColumn.getName() + " TO " + newColumn.getName());
        }
        if (!StringUtils.isBlank((CharSequence)(sqlRepresentationOfColumnType = this.sqlRepresentationOfColumnType(newColumn, includeNullability = newColumn.isNullable() != oldColumn.isNullable(), true, includeColumnType = newColumn.getType() != oldColumn.getType() || newColumn.getWidth() != oldColumn.getWidth() || newColumn.getScale() != oldColumn.getScale())))) {
            statement = new StringBuilder().append("ALTER TABLE ").append(this.schemaNamePrefix()).append(truncatedTableName).append(" MODIFY (").append(newColumn.getName()).append(' ').append(sqlRepresentationOfColumnType).append(")");
            result.add(statement.toString());
        }
        if (!StringUtils.isBlank((CharSequence)oldColumn.getDefaultValue()) && StringUtils.isBlank((CharSequence)newColumn.getDefaultValue())) {
            statement = new StringBuilder().append("ALTER TABLE ").append(this.schemaNamePrefix()).append(truncatedTableName).append(" MODIFY (").append(newColumn.getName()).append(" DEFAULT NULL").append(")");
            result.add(statement.toString());
        }
        if (recreatePrimaryKey && !SchemaUtils.primaryKeysForTable((Table)table).isEmpty()) {
            result.add(this.generatePrimaryKeyStatement(SchemaUtils.namesOfColumns((List)SchemaUtils.primaryKeysForTable((Table)table)), truncatedTableName));
        }
        for (Index index : table.indexes()) {
            for (String column : index.columnNames()) {
                if (!column.equalsIgnoreCase(newColumn.getName())) continue;
                result.addAll(this.addIndexStatements(table, index));
            }
        }
        result.add(this.columnComment(newColumn, truncatedTableName));
        return result;
    }

    private String generatePrimaryKeyStatement(List<String> columnNames, String tableName) {
        StringBuilder primaryKeyStatement = new StringBuilder();
        primaryKeyStatement.append("ALTER TABLE ").append(this.schemaNamePrefix()).append(tableName).append(" ADD ").append(this.primaryKeyConstraint(tableName, columnNames));
        return primaryKeyStatement.toString();
    }

    private String dropPrimaryKeyConstraint(String tableName) {
        return "ALTER TABLE " + this.schemaNamePrefix() + tableName + " DROP PRIMARY KEY DROP INDEX";
    }

    private String columnComment(Column column, String tableName) {
        StringBuilder comment = new StringBuilder("COMMENT ON COLUMN " + this.schemaNamePrefix() + tableName + "." + column.getName() + " IS '" + "REALNAME" + ":[" + column.getName() + "]/TYPE:[" + column.getType().toString() + "]");
        if (column.isAutoNumbered()) {
            int autoNumberStart = column.getAutoNumberStart() == -1 ? 1 : column.getAutoNumberStart();
            comment.append("/AUTONUMSTART:[" + autoNumberStart + "]");
        }
        comment.append("'");
        return comment.toString();
    }

    public Collection<String> alterTableDropColumnStatements(Table table, Column column) {
        ArrayList<String> result = new ArrayList<String>();
        String truncatedTableName = this.truncatedTableName(table.getName());
        StringBuilder statement = new StringBuilder().append("ALTER TABLE ").append(this.schemaNamePrefix()).append(truncatedTableName).append(" SET UNUSED").append(" (").append(column.getName()).append(")");
        result.add(statement.toString());
        return result;
    }

    public Collection<String> indexDropStatements(Table table, Index indexToBeRemoved) {
        StringBuilder statement = new StringBuilder();
        statement.append("DROP INDEX ").append(this.schemaNamePrefix()).append(indexToBeRemoved.getName());
        return Arrays.asList(statement.toString());
    }

    protected String getSqlForYYYYMMDDToDate(Function function) {
        return "TO_DATE(" + this.getSqlFrom((AliasedField)function.getArguments().get(0)) + ", 'yyyymmdd')";
    }

    protected String getSqlForDateToYyyymmdd(Function function) {
        return String.format("TO_NUMBER(TO_CHAR(%s, 'yyyymmdd'))", this.getSqlFrom((AliasedField)function.getArguments().get(0)));
    }

    protected String getSqlForDateToYyyymmddHHmmss(Function function) {
        return String.format("TO_NUMBER(TO_CHAR(%s, 'yyyymmddHH24MISS'))", this.getSqlFrom((AliasedField)function.getArguments().get(0)));
    }

    protected String getSqlForNow(Function function) {
        return "SYSTIMESTAMP AT TIME ZONE 'UTC'";
    }

    protected String getSqlForDaysBetween(AliasedField toDate, AliasedField fromDate) {
        return String.format("(%s) - (%s)", this.getSqlFrom(toDate), this.getSqlFrom(fromDate));
    }

    protected String getSqlForMonthsBetween(AliasedField toDate, AliasedField fromDate) {
        String toDateStr = this.getSqlFrom(toDate);
        String fromDateStr = this.getSqlFrom(fromDate);
        return "(EXTRACT(YEAR FROM " + toDateStr + ") - EXTRACT(YEAR FROM " + fromDateStr + ")) * 12+ (EXTRACT(MONTH FROM " + toDateStr + ") - EXTRACT(MONTH FROM " + fromDateStr + "))+ CASE WHEN " + toDateStr + " > " + fromDateStr + " THEN CASE WHEN EXTRACT(DAY FROM " + toDateStr + ") >= EXTRACT(DAY FROM " + fromDateStr + ") THEN 0 WHEN EXTRACT(MONTH FROM " + toDateStr + ") <> EXTRACT(MONTH FROM " + toDateStr + " + 1) THEN 0 ELSE -1 END ELSE CASE WHEN EXTRACT(MONTH FROM " + fromDateStr + ") <> EXTRACT(MONTH FROM " + fromDateStr + " + 1) THEN 0 WHEN EXTRACT(DAY FROM " + fromDateStr + ") >= EXTRACT(DAY FROM " + toDateStr + ") THEN 0 ELSE 1 END END\n";
    }

    protected String getSubstringFunctionName() {
        return "SUBSTR";
    }

    protected String getSqlForAddDays(Function function) {
        return String.format("(%s) + (%s)", this.getSqlFrom((AliasedField)function.getArguments().get(0)), this.getSqlFrom((AliasedField)function.getArguments().get(1)));
    }

    protected String getSqlForAddMonths(Function function) {
        return "ADD_MONTHS(" + this.getSqlFrom((AliasedField)function.getArguments().get(0)) + ", " + this.getSqlFrom((AliasedField)function.getArguments().get(1)) + ")";
    }

    public Collection<String> renameTableStatements(Table fromTable, Table toTable) {
        String from = this.truncatedTableName(fromTable.getName());
        String fromConstraint = this.primaryKeyConstraintName(fromTable.getName());
        String to = this.truncatedTableName(toTable.getName());
        String toConstraint = this.primaryKeyConstraintName(toTable.getName());
        ArrayList<String> statements = new ArrayList<String>();
        if (!SchemaUtils.primaryKeysForTable((Table)fromTable).isEmpty()) {
            statements.add("ALTER TABLE " + this.schemaNamePrefix() + from + " RENAME CONSTRAINT " + fromConstraint + " TO " + toConstraint);
            statements.add("ALTER INDEX " + this.schemaNamePrefix() + fromConstraint + " RENAME TO " + toConstraint);
        }
        statements.add("ALTER TABLE " + this.schemaNamePrefix() + from + " RENAME TO " + to);
        statements.add(this.commentOnTable(to));
        return statements;
    }

    public Collection<String> addTableFromStatements(Table table, SelectStatement selectStatement) {
        ImmutableList.Builder result = ImmutableList.builder();
        result.add((Object)(this.createTableStatement(table, true) + " AS " + this.convertStatementToSQL(selectStatement)));
        result.add((Object)("ALTER TABLE " + this.schemaNamePrefix() + table.getName() + " NOPARALLEL LOGGING"));
        if (!SchemaUtils.primaryKeysForTable((Table)table).isEmpty()) {
            result.add((Object)("ALTER INDEX " + this.schemaNamePrefix() + this.primaryKeyConstraintName(table.getName()) + " NOPARALLEL LOGGING"));
        }
        result.addAll(this.buildRemainingStatementsAndComments(table));
        return result.build();
    }

    private Collection<String> buildRemainingStatementsAndComments(Table table) {
        ArrayList statements = Lists.newArrayList();
        Column sequence = this.findAutonumberedColumn(table);
        if (sequence != null) {
            statements.add(this.dropTrigger(table));
            statements.add(this.dropSequence(table));
            statements.add(this.createNewSequence(table, sequence));
            statements.addAll(this.createTrigger(table, sequence));
        }
        String truncatedTableName = this.truncatedTableName(table.getName());
        statements.add(this.commentOnTable(truncatedTableName));
        statements.addAll(this.createColumnComments(table));
        return statements;
    }

    public String formatSqlStatement(String sqlStatement) {
        StringBuilder builder = new StringBuilder(sqlStatement);
        if (sqlStatement.endsWith("END;")) {
            builder.append(System.getProperty("line.separator"));
            builder.append("/");
        } else {
            builder.append(";");
        }
        return this.splitSqlStatement(builder.toString());
    }

    private String splitSqlStatement(String sqlStatement) {
        StringBuilder sql = new StringBuilder();
        if (sqlStatement.length() >= 2500) {
            int splitAt = sqlStatement.lastIndexOf(32, 2498);
            if (splitAt == -1) {
                log.warn((Object)"SQL statement greater than 2499 characters in length but unable to find white space (\" \") to split on.");
                sql.append(sqlStatement);
            } else {
                sql.append(sqlStatement.substring(0, splitAt));
                sql.append(System.getProperty("line.separator"));
                sql.append(this.splitSqlStatement(sqlStatement.substring(splitAt + 1)));
            }
        } else {
            sql.append(sqlStatement);
        }
        return sql.toString();
    }

    protected String getSqlForRandom() {
        return "dbms_random.value";
    }

    protected String getSqlForRandomString(Function function) {
        return String.format("dbms_random.string('A', %s)", this.getSqlFrom((AliasedField)function.getArguments().get(0)));
    }

    protected String getSqlforBlobLength(Function function) {
        return String.format("dbms_lob.getlength(%s)", this.getSqlFrom((AliasedField)function.getArguments().get(0)));
    }

    protected String getFromDummyTable() {
        return " FROM dual";
    }

    protected String getSqlFrom(SelectFirstStatement stmt) {
        StringBuilder result = new StringBuilder("SELECT MIN(");
        result.append(this.getSqlFrom((AliasedField)stmt.getFields().get(0))).append(") KEEP (DENSE_RANK FIRST");
        this.appendOrderBy(result, (AbstractSelectStatement)stmt);
        result.append(")");
        this.appendFrom(result, (AbstractSelectStatement)stmt);
        this.appendJoins(result, (AbstractSelectStatement)stmt, this.innerJoinKeyword((AbstractSelectStatement)stmt));
        this.appendWhere(result, (AbstractSelectStatement)stmt);
        return result.toString().trim();
    }

    protected String getSqlFrom(BlobFieldLiteral field) {
        return String.format("HEXTORAW('%s')", field.getValue());
    }

    protected String selectStatementPreFieldDirectives(SelectStatement selectStatement) {
        if (selectStatement.getHints().isEmpty()) {
            return super.selectStatementPreFieldDirectives(selectStatement);
        }
        StringBuilder builder = new StringBuilder().append("/*+");
        for (Hint hint : selectStatement.getHints()) {
            if (hint instanceof OptimiseForRowCount) {
                builder.append(" FIRST_ROWS(").append(((OptimiseForRowCount)hint).getRowCount()).append(")");
            }
            if (hint instanceof UseIndex) {
                UseIndex useIndex = (UseIndex)hint;
                builder.append(" INDEX(").append(StringUtils.isEmpty((CharSequence)useIndex.getTable().getAlias()) ? useIndex.getTable().getName() : useIndex.getTable().getAlias()).append(" ").append(useIndex.getIndexName()).append(")");
            }
            if (hint instanceof UseImplicitJoinOrder) {
                builder.append(" ORDERED");
            }
            if (!(hint instanceof ParallelQueryHint)) continue;
            builder.append(" PARALLEL");
            ParallelQueryHint parallelQueryHint = (ParallelQueryHint)hint;
            builder.append(parallelQueryHint.getDegreeOfParallelism().map(d -> " " + d).orElse(""));
        }
        return builder.append(" */ ").toString();
    }

    protected String updateStatementPreTableDirectives(UpdateStatement updateStatement) {
        for (Hint hint : updateStatement.getHints()) {
            if (!(hint instanceof UseParallelDml)) continue;
            return "/*+ ENABLE_PARALLEL_DML PARALLEL */ ";
        }
        return "";
    }

    public Collection<String> rebuildTriggers(Table table) {
        return this.rebuildSequenceAndTrigger(table, this.getAutoIncrementColumnForTable(table));
    }

    public int fetchSizeForBulkSelects() {
        return 200;
    }

    public boolean usesNVARCHARforStrings() {
        return true;
    }

    public boolean supportsWindowFunctions() {
        return true;
    }

    protected String getSqlForLastDayOfMonth(AliasedField date) {
        return "LAST_DAY(" + this.getSqlFrom(date) + ")";
    }

    public Collection<String> getSqlForAnalyseTable(Table table) {
        return ImmutableList.of((Object)("BEGIN \nDBMS_STATS.GATHER_TABLE_STATS(ownname=> '" + this.getSchemaName() + "', tabname=>'" + table.getName() + "', cascade=>true, degree=>DBMS_STATS.AUTO_DEGREE, no_invalidate=>false); \nEND;"));
    }

    protected Optional<String> getDeleteLimitWhereClause(int limit) {
        return Optional.of("ROWNUM <= " + limit);
    }

    protected String getSqlForInsertInto(InsertStatement insertStatement) {
        return "INSERT " + this.insertStatementPreIntoDirectives(insertStatement) + "INTO ";
    }

    private String insertStatementPreIntoDirectives(InsertStatement insertStatement) {
        if (insertStatement.getHints().isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder().append("/*+");
        for (Hint hint : insertStatement.getHints()) {
            if (!(hint instanceof DirectPathQueryHint)) continue;
            builder.append(" APPEND");
        }
        return builder.append(" */ ").toString();
    }
}

