/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.oracle;

import java.lang.reflect.InvocationTargetException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import java.util.Optional;
import javax.sql.DataSource;
import org.alfasoftware.morf.jdbc.DatabaseType;
import org.alfasoftware.morf.jdbc.DatabaseTypeIdentifier;
import org.alfasoftware.morf.jdbc.DatabaseTypeIdentifierTestUtils;
import org.alfasoftware.morf.jdbc.JdbcUrlElements;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestOracleDatabaseType {
    private DatabaseType databaseType;

    @Before
    public void setup() {
        this.databaseType = DatabaseType.Registry.findByIdentifier((String)"ORACLE");
    }

    @Test(expected=IllegalStateException.class)
    public void openingSchemaOfOracleWithoutSchemaNameShouldThrowISE() {
        this.databaseType.openSchema(null, null, null);
    }

    @Test(expected=IllegalStateException.class)
    public void openingSchemaOfOracleWithEmptySchemaNameShouldThrowISE() {
        this.databaseType.openSchema(null, null, "");
    }

    @Test
    public void testOracleUrlFormatting() {
        Assert.assertEquals((String)"Oracle database url", (Object)"jdbc:oracle:thin:@localhost/null", (Object)this.databaseType.formatJdbcUrl(JdbcUrlElements.forDatabaseType((String)"ORACLE").withHost("localhost").withDatabaseName("data").build()));
    }

    @Test
    public void testIdentifyFromMetaData() throws SQLException {
        DataSource dataSource = DatabaseTypeIdentifierTestUtils.mockDataSourceFor((String)"FictiousDB", (String)"9.9.9", (int)9, (int)9);
        Assert.assertEquals(Optional.empty(), (Object)new DatabaseTypeIdentifier(dataSource).identifyFromMetaData());
        ((Connection)Mockito.verify((Object)dataSource.getConnection())).close();
        Assert.assertEquals((Object)this.databaseType, new DatabaseTypeIdentifier(DatabaseTypeIdentifierTestUtils.mockDataSourceFor((String)"Oracle", (String)"Oracle Database 10g Enterprise Edition Release 10.2.0.3.0 - Production\nWith the Partitioning, OLAP and Data Mining options", (int)10, (int)2)).identifyFromMetaData().get());
        Assert.assertEquals((Object)this.databaseType, new DatabaseTypeIdentifier(DatabaseTypeIdentifierTestUtils.mockDataSourceFor((String)"Oracle", (String)"Oracle Database 11g Enterprise Edition Release 11.2.0.1.0 - 64bit Production\nWith the Partitioning, OLAP, Data Mining and Real Application Testing options", (int)11, (int)2)).identifyFromMetaData().get());
    }

    @Test
    public void testBuildConnectionDetailsFromOracle() {
        JdbcUrlElements result = (JdbcUrlElements)this.databaseType.extractJdbcUrl("jdbc:oracle:thin:@anoraclehost.co.uk:1251/instance").get();
        Assert.assertEquals((String)"Should have the correct type", (Object)"ORACLE", (Object)result.getDatabaseType());
        Assert.assertEquals((String)"Should have the correct host", (Object)"anoraclehost.co.uk", (Object)result.getHostName());
        Assert.assertEquals((String)"Should have the correct port", (long)1251L, (long)result.getPort());
        Assert.assertEquals((String)"Should have the correct instance name", (Object)"instance", (Object)result.getInstanceName());
    }

    @Test
    public void testBuildConnectionDetailsFromOracleNoPort() {
        JdbcUrlElements result = (JdbcUrlElements)this.databaseType.extractJdbcUrl("jdbc:oracle:thin:@anoraclehost.co.uk/instance").get();
        Assert.assertEquals((String)"Should have the correct type", (Object)"ORACLE", (Object)result.getDatabaseType());
        Assert.assertEquals((String)"Should have the correct host", (Object)"anoraclehost.co.uk", (Object)result.getHostName());
        Assert.assertEquals((String)"Should have the correct instance name", (Object)"instance", (Object)result.getInstanceName());
    }

    @Test
    public void testUrlRoundTrips() {
        this.comparerUrlRoundtrips(JdbcUrlElements.forDatabaseType((String)"ORACLE").withHost("hostname").withPort(1521).withInstanceName("instanceName").build());
        this.comparerUrlRoundtrips(JdbcUrlElements.forDatabaseType((String)"ORACLE").withHost("hostname").withInstanceName("instanceName").build());
    }

    private void comparerUrlRoundtrips(JdbcUrlElements jdbcUrlElements) {
        String jdbcURL = this.databaseType.formatJdbcUrl(jdbcUrlElements);
        JdbcUrlElements cd = (JdbcUrlElements)this.databaseType.extractJdbcUrl(jdbcURL).get();
        Assert.assertEquals((Object)jdbcUrlElements, (Object)cd);
    }

    @Test
    public void testExceptionReclassification() {
        SQLException genericSqlException = new SQLException();
        Assert.assertSame((Object)genericSqlException, (Object)this.databaseType.reclassifyException((Exception)genericSqlException));
        Assert.assertThat((Object)this.databaseType.reclassifyException((Exception)new BatchUpdateException("reason", "state", 1, new int[0])), (Matcher)Matchers.instanceOf(SQLException.class));
        Assert.assertThat((Object)this.databaseType.reclassifyException((Exception)new BatchUpdateException("reason", "state", 60, new int[0])), (Matcher)Matchers.instanceOf(SQLTransientException.class));
        Assert.assertThat((Object)this.databaseType.reclassifyException((Exception)new BatchUpdateException("reason", "state", 2049, new int[0])), (Matcher)Matchers.instanceOf(SQLTransientException.class));
        Assume.assumeTrue((String)"Only test further if OracleXAException is on the classpath", (this.oracleXaException(0) != null ? 1 : 0) != 0);
        Assert.assertThat((Object)this.databaseType.reclassifyException(this.oracleXaException(1)), (Matcher)Matchers.instanceOf(SQLException.class));
        Assert.assertThat((Object)this.databaseType.reclassifyException(this.oracleXaException(60)), (Matcher)Matchers.instanceOf(SQLTransientException.class));
        Assert.assertThat((Object)this.databaseType.reclassifyException(this.oracleXaException(2049)), (Matcher)Matchers.instanceOf(SQLTransientException.class));
    }

    private Exception oracleXaException(int code) {
        try {
            return (Exception)this.getClass().getClassLoader().loadClass("oracle.jdbc.xa.OracleXAException").getConstructor(Integer.TYPE).newInstance(code);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }
}

