/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.oracle;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfasoftware.morf.jdbc.AbstractSqlDialectTest;
import org.alfasoftware.morf.jdbc.NamedParameterPreparedStatement;
import org.alfasoftware.morf.jdbc.SqlDialect;
import org.alfasoftware.morf.jdbc.SqlScriptExecutor;
import org.alfasoftware.morf.jdbc.oracle.OracleDialect;
import org.alfasoftware.morf.metadata.Column;
import org.alfasoftware.morf.metadata.DataType;
import org.alfasoftware.morf.metadata.SchemaUtils;
import org.alfasoftware.morf.sql.CustomHint;
import org.alfasoftware.morf.sql.OracleCustomHint;
import org.alfasoftware.morf.sql.SqlUtils;
import org.alfasoftware.morf.sql.element.Direction;
import org.alfasoftware.morf.sql.element.SqlParameter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestOracleDialect
extends AbstractSqlDialectTest {
    private static final String LONG_TABLE_NAME_TRUNCATED_30 = "tableWithANameThatExceedsTwent";
    private static final String LONG_TABLE_NAME_TRUNCATED_27 = "tableWithANameThatExceedsTw";
    private final ArgumentCaptor<List<String>> listCaptor = ArgumentCaptor.forClass(List.class);

    protected SqlDialect createTestDialect() {
        return new OracleDialect("testschema");
    }

    protected List<String> expectedCreateTableStatements() {
        return Arrays.asList("CREATE TABLE TESTSCHEMA.Test (id NUMBER(19) NOT NULL, version INTEGER DEFAULT 0, stringField NVARCHAR2(3), intField INTEGER, floatField DECIMAL(13,2) NOT NULL, dateField DATE, booleanField DECIMAL(1,0), charField NVARCHAR2(1), blobField BLOB, bigIntegerField NUMBER(19) DEFAULT 12345, clobField NCLOB, CONSTRAINT Test_PK PRIMARY KEY (id) USING INDEX (CREATE UNIQUE INDEX TESTSCHEMA.Test_PK ON TESTSCHEMA.Test (id)))", "COMMENT ON TABLE TESTSCHEMA.Test IS 'REALNAME:[Test]'", "COMMENT ON COLUMN TESTSCHEMA.Test.id IS 'REALNAME:[id]/TYPE:[BIG_INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.Test.version IS 'REALNAME:[version]/TYPE:[INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.Test.stringField IS 'REALNAME:[stringField]/TYPE:[STRING]'", "COMMENT ON COLUMN TESTSCHEMA.Test.intField IS 'REALNAME:[intField]/TYPE:[INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.Test.floatField IS 'REALNAME:[floatField]/TYPE:[DECIMAL]'", "COMMENT ON COLUMN TESTSCHEMA.Test.dateField IS 'REALNAME:[dateField]/TYPE:[DATE]'", "COMMENT ON COLUMN TESTSCHEMA.Test.booleanField IS 'REALNAME:[booleanField]/TYPE:[BOOLEAN]'", "COMMENT ON COLUMN TESTSCHEMA.Test.charField IS 'REALNAME:[charField]/TYPE:[STRING]'", "COMMENT ON COLUMN TESTSCHEMA.Test.blobField IS 'REALNAME:[blobField]/TYPE:[BLOB]'", "COMMENT ON COLUMN TESTSCHEMA.Test.bigIntegerField IS 'REALNAME:[bigIntegerField]/TYPE:[BIG_INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.Test.clobField IS 'REALNAME:[clobField]/TYPE:[CLOB]'", "CREATE UNIQUE INDEX TESTSCHEMA.Test_NK ON TESTSCHEMA.Test (stringField)", "CREATE UNIQUE INDEX TESTSCHEMA.Test_1 ON TESTSCHEMA.Test (intField, floatField)", "CREATE TABLE TESTSCHEMA.Alternate (id NUMBER(19) NOT NULL, version INTEGER DEFAULT 0, stringField NVARCHAR2(3), CONSTRAINT Alternate_PK PRIMARY KEY (id) USING INDEX (CREATE UNIQUE INDEX TESTSCHEMA.Alternate_PK ON TESTSCHEMA.Alternate (id)))", "COMMENT ON TABLE TESTSCHEMA.Alternate IS 'REALNAME:[Alternate]'", "COMMENT ON COLUMN TESTSCHEMA.Alternate.id IS 'REALNAME:[id]/TYPE:[BIG_INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.Alternate.version IS 'REALNAME:[version]/TYPE:[INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.Alternate.stringField IS 'REALNAME:[stringField]/TYPE:[STRING]'", "CREATE INDEX TESTSCHEMA.Alternate_1 ON TESTSCHEMA.Alternate (stringField)", "CREATE TABLE TESTSCHEMA.NonNull (id NUMBER(19) NOT NULL, version INTEGER DEFAULT 0, stringField NVARCHAR2(3) NOT NULL, intField DECIMAL(8,0) NOT NULL, booleanField DECIMAL(1,0) NOT NULL, dateField DATE NOT NULL, blobField BLOB NOT NULL, CONSTRAINT NonNull_PK PRIMARY KEY (id) USING INDEX (CREATE UNIQUE INDEX TESTSCHEMA.NonNull_PK ON TESTSCHEMA.NonNull (id)))", "COMMENT ON TABLE TESTSCHEMA.NonNull IS 'REALNAME:[NonNull]'", "COMMENT ON COLUMN TESTSCHEMA.NonNull.id IS 'REALNAME:[id]/TYPE:[BIG_INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.NonNull.version IS 'REALNAME:[version]/TYPE:[INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.NonNull.stringField IS 'REALNAME:[stringField]/TYPE:[STRING]'", "COMMENT ON COLUMN TESTSCHEMA.NonNull.intField IS 'REALNAME:[intField]/TYPE:[DECIMAL]'", "COMMENT ON COLUMN TESTSCHEMA.NonNull.booleanField IS 'REALNAME:[booleanField]/TYPE:[BOOLEAN]'", "COMMENT ON COLUMN TESTSCHEMA.NonNull.dateField IS 'REALNAME:[dateField]/TYPE:[DATE]'", "COMMENT ON COLUMN TESTSCHEMA.NonNull.blobField IS 'REALNAME:[blobField]/TYPE:[BLOB]'", "CREATE TABLE TESTSCHEMA.CompositePrimaryKey (id NUMBER(19) NOT NULL, version INTEGER DEFAULT 0, stringField NVARCHAR2(3) NOT NULL, secondPrimaryKey NVARCHAR2(3) NOT NULL, CONSTRAINT CompositePrimaryKey_PK PRIMARY KEY (id, secondPrimaryKey) USING INDEX (CREATE UNIQUE INDEX TESTSCHEMA.CompositePrimaryKey_PK ON TESTSCHEMA.CompositePrimaryKey (id, secondPrimaryKey)))", "COMMENT ON TABLE TESTSCHEMA.CompositePrimaryKey IS 'REALNAME:[CompositePrimaryKey]'", "COMMENT ON COLUMN TESTSCHEMA.CompositePrimaryKey.id IS 'REALNAME:[id]/TYPE:[BIG_INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.CompositePrimaryKey.version IS 'REALNAME:[version]/TYPE:[INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.CompositePrimaryKey.stringField IS 'REALNAME:[stringField]/TYPE:[STRING]'", "COMMENT ON COLUMN TESTSCHEMA.CompositePrimaryKey.secondPrimaryKey IS 'REALNAME:[secondPrimaryKey]/TYPE:[STRING]'", "CREATE TABLE TESTSCHEMA.AutoNumber (intField NUMBER(19), CONSTRAINT AutoNumber_PK PRIMARY KEY (intField) USING INDEX (CREATE UNIQUE INDEX TESTSCHEMA.AutoNumber_PK ON TESTSCHEMA.AutoNumber (intField)))", "DECLARE \n  e exception; \n  pragma exception_init(e,-4080); \nBEGIN \n  EXECUTE IMMEDIATE 'DROP TRIGGER TESTSCHEMA.AUTONUMBER_TG'; \nEXCEPTION \n  WHEN e THEN \n    null; \nEND;", "DECLARE \n  query CHAR(255); \nBEGIN \n  select queryField into query from SYS.DUAL D left outer join (\n    select concat('drop sequence TESTSCHEMA.', sequence_name) as queryField \n    from ALL_SEQUENCES S \n    where S.sequence_owner='TESTSCHEMA' AND S.sequence_name = 'AUTONUMBER_SQ' \n  ) on 1 = 1; \n  IF query is not null THEN \n    execute immediate query; \n  END IF; \nEND;", "CREATE SEQUENCE TESTSCHEMA.AUTONUMBER_SQ START WITH 5 CACHE 2000", "ALTER SESSION SET CURRENT_SCHEMA = testschema", "CREATE TRIGGER TESTSCHEMA.AUTONUMBER_TG \nBEFORE INSERT ON AutoNumber FOR EACH ROW \nBEGIN \n  IF (:new.intField IS NULL) THEN \n    SELECT AUTONUMBER_SQ.nextval \n    INTO :new.intField \n    FROM DUAL; \n  END IF; \nEND;", "COMMENT ON TABLE TESTSCHEMA.AutoNumber IS 'REALNAME:[AutoNumber]'", "COMMENT ON COLUMN TESTSCHEMA.AutoNumber.intField IS 'REALNAME:[intField]/TYPE:[BIG_INTEGER]/AUTONUMSTART:[5]'");
    }

    protected List<String> expectedCreateTemporaryTableStatements() {
        return Arrays.asList("CREATE GLOBAL TEMPORARY TABLE TESTSCHEMA.TempTest (id NUMBER(19) NOT NULL, version INTEGER DEFAULT 0, stringField NVARCHAR2(3), intField INTEGER, floatField DECIMAL(13,2) NOT NULL, dateField DATE, booleanField DECIMAL(1,0), charField NVARCHAR2(1), blobField BLOB, bigIntegerField NUMBER(19) DEFAULT 12345, clobField NCLOB, CONSTRAINT TempTest_PK PRIMARY KEY (id) USING INDEX (CREATE UNIQUE INDEX TESTSCHEMA.TempTest_PK ON TESTSCHEMA.TempTest (id))) ON COMMIT PRESERVE ROWS", "COMMENT ON TABLE TESTSCHEMA.TempTest IS 'REALNAME:[TempTest]'", "COMMENT ON COLUMN TESTSCHEMA.TempTest.id IS 'REALNAME:[id]/TYPE:[BIG_INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.TempTest.version IS 'REALNAME:[version]/TYPE:[INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.TempTest.stringField IS 'REALNAME:[stringField]/TYPE:[STRING]'", "COMMENT ON COLUMN TESTSCHEMA.TempTest.intField IS 'REALNAME:[intField]/TYPE:[INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.TempTest.floatField IS 'REALNAME:[floatField]/TYPE:[DECIMAL]'", "COMMENT ON COLUMN TESTSCHEMA.TempTest.dateField IS 'REALNAME:[dateField]/TYPE:[DATE]'", "COMMENT ON COLUMN TESTSCHEMA.TempTest.booleanField IS 'REALNAME:[booleanField]/TYPE:[BOOLEAN]'", "COMMENT ON COLUMN TESTSCHEMA.TempTest.charField IS 'REALNAME:[charField]/TYPE:[STRING]'", "COMMENT ON COLUMN TESTSCHEMA.TempTest.blobField IS 'REALNAME:[blobField]/TYPE:[BLOB]'", "COMMENT ON COLUMN TESTSCHEMA.TempTest.bigIntegerField IS 'REALNAME:[bigIntegerField]/TYPE:[BIG_INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.TempTest.clobField IS 'REALNAME:[clobField]/TYPE:[CLOB]'", "CREATE UNIQUE INDEX TESTSCHEMA.TempTest_NK ON TESTSCHEMA.TempTest (stringField)", "CREATE INDEX TESTSCHEMA.TempTest_1 ON TESTSCHEMA.TempTest (intField, floatField)", "CREATE GLOBAL TEMPORARY TABLE TESTSCHEMA.TempAlternate (id NUMBER(19) NOT NULL, version INTEGER DEFAULT 0, stringField NVARCHAR2(3), CONSTRAINT TempAlternate_PK PRIMARY KEY (id) USING INDEX (CREATE UNIQUE INDEX TESTSCHEMA.TempAlternate_PK ON TESTSCHEMA.TempAlternate (id))) ON COMMIT PRESERVE ROWS", "COMMENT ON TABLE TESTSCHEMA.TempAlternate IS 'REALNAME:[TempAlternate]'", "COMMENT ON COLUMN TESTSCHEMA.TempAlternate.id IS 'REALNAME:[id]/TYPE:[BIG_INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.TempAlternate.version IS 'REALNAME:[version]/TYPE:[INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.TempAlternate.stringField IS 'REALNAME:[stringField]/TYPE:[STRING]'", "CREATE INDEX TESTSCHEMA.TempAlternate_1 ON TESTSCHEMA.TempAlternate (stringField)", "CREATE GLOBAL TEMPORARY TABLE TESTSCHEMA.TempNonNull (id NUMBER(19) NOT NULL, version INTEGER DEFAULT 0, stringField NVARCHAR2(3) NOT NULL, intField DECIMAL(8,0) NOT NULL, booleanField DECIMAL(1,0) NOT NULL, dateField DATE NOT NULL, blobField BLOB NOT NULL, CONSTRAINT TempNonNull_PK PRIMARY KEY (id) USING INDEX (CREATE UNIQUE INDEX TESTSCHEMA.TempNonNull_PK ON TESTSCHEMA.TempNonNull (id))) ON COMMIT PRESERVE ROWS", "COMMENT ON TABLE TESTSCHEMA.TempNonNull IS 'REALNAME:[TempNonNull]'", "COMMENT ON COLUMN TESTSCHEMA.TempNonNull.id IS 'REALNAME:[id]/TYPE:[BIG_INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.TempNonNull.version IS 'REALNAME:[version]/TYPE:[INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.TempNonNull.stringField IS 'REALNAME:[stringField]/TYPE:[STRING]'", "COMMENT ON COLUMN TESTSCHEMA.TempNonNull.intField IS 'REALNAME:[intField]/TYPE:[DECIMAL]'", "COMMENT ON COLUMN TESTSCHEMA.TempNonNull.booleanField IS 'REALNAME:[booleanField]/TYPE:[BOOLEAN]'", "COMMENT ON COLUMN TESTSCHEMA.TempNonNull.dateField IS 'REALNAME:[dateField]/TYPE:[DATE]'", "COMMENT ON COLUMN TESTSCHEMA.TempNonNull.blobField IS 'REALNAME:[blobField]/TYPE:[BLOB]'");
    }

    protected List<String> expectedCreateTableStatementsWithLongTableName() {
        return Arrays.asList("CREATE TABLE TESTSCHEMA.tableWithANameThatExceedsTwent (id NUMBER(19) NOT NULL, version INTEGER DEFAULT 0, stringField NVARCHAR2(3), intField DECIMAL(8,0), floatField DECIMAL(13,2) NOT NULL, dateField DATE, booleanField DECIMAL(1,0), charField NVARCHAR2(1), CONSTRAINT tableWithANameThatExceedsTw_PK PRIMARY KEY (id) USING INDEX (CREATE UNIQUE INDEX TESTSCHEMA.tableWithANameThatExceedsTw_PK ON TESTSCHEMA.tableWithANameThatExceedsTwent (id)))", "COMMENT ON TABLE TESTSCHEMA.tableWithANameThatExceedsTwent IS 'REALNAME:[tableWithANameThatExceedsTwent]'", "COMMENT ON COLUMN TESTSCHEMA.tableWithANameThatExceedsTwent.id IS 'REALNAME:[id]/TYPE:[BIG_INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.tableWithANameThatExceedsTwent.version IS 'REALNAME:[version]/TYPE:[INTEGER]'", "COMMENT ON COLUMN TESTSCHEMA.tableWithANameThatExceedsTwent.stringField IS 'REALNAME:[stringField]/TYPE:[STRING]'", "COMMENT ON COLUMN TESTSCHEMA.tableWithANameThatExceedsTwent.intField IS 'REALNAME:[intField]/TYPE:[DECIMAL]'", "COMMENT ON COLUMN TESTSCHEMA.tableWithANameThatExceedsTwent.floatField IS 'REALNAME:[floatField]/TYPE:[DECIMAL]'", "COMMENT ON COLUMN TESTSCHEMA.tableWithANameThatExceedsTwent.dateField IS 'REALNAME:[dateField]/TYPE:[DATE]'", "COMMENT ON COLUMN TESTSCHEMA.tableWithANameThatExceedsTwent.booleanField IS 'REALNAME:[booleanField]/TYPE:[BOOLEAN]'", "COMMENT ON COLUMN TESTSCHEMA.tableWithANameThatExceedsTwent.charField IS 'REALNAME:[charField]/TYPE:[STRING]'", "CREATE UNIQUE INDEX TESTSCHEMA.Test_NK ON TESTSCHEMA.tableWithANameThatExceedsTwent (stringField)", "CREATE INDEX TESTSCHEMA.Test_1 ON TESTSCHEMA.tableWithANameThatExceedsTwent (intField, floatField)");
    }

    protected List<String> expectedDropTableStatements() {
        return Arrays.asList("DROP TABLE TESTSCHEMA.Test");
    }

    protected List<String> expectedDropTempTableStatements() {
        return Arrays.asList("DROP TABLE TESTSCHEMA.TempTest");
    }

    protected List<String> expectedTruncateTableStatements() {
        return Arrays.asList("TRUNCATE TABLE TESTSCHEMA.Test REUSE STORAGE");
    }

    protected List<String> expectedTruncateTempTableStatements() {
        return Arrays.asList("TRUNCATE TABLE TESTSCHEMA.TempTest");
    }

    protected List<String> expectedDeleteAllFromTableStatements() {
        return Arrays.asList("DELETE FROM TESTSCHEMA.Test");
    }

    protected String expectedParameterisedInsertStatement() {
        return "INSERT INTO TESTSCHEMA.Test (id, version, stringField, intField, floatField, dateField, booleanField, charField, blobField, bigIntegerField, clobField) VALUES (5, :version, N'Escap''d', 7, :floatField, 20100405, 1, :charField, :blobField, :bigIntegerField, :clobField)";
    }

    protected String expectedParameterisedInsertStatementWithTableInDifferentSchema() {
        return "INSERT INTO MYSCHEMA.Test (id, version, stringField, intField, floatField, dateField, booleanField, charField, blobField, bigIntegerField, clobField) VALUES (5, :version, N'Escap''d', 7, :floatField, 20100405, 1, :charField, :blobField, :bigIntegerField, :clobField)";
    }

    protected List<String> expectedAutoGenerateIdStatement() {
        return ImmutableList.of((Object)"DELETE FROM TESTSCHEMA.idvalues where name = 'Test'", (Object)"INSERT INTO TESTSCHEMA.idvalues (name, value) VALUES('Test', (SELECT COALESCE(MAX(id) + 1, 1) AS CurrentValue FROM TESTSCHEMA.Test))", (Object)"INSERT INTO TESTSCHEMA.Test (version, stringField, id) SELECT version, stringField, (SELECT COALESCE(value, 0) FROM TESTSCHEMA.idvalues WHERE (name = N'Test')) + Other.id FROM TESTSCHEMA.Other");
    }

    protected List<String> expectedInsertWithIdAndVersion() {
        return Arrays.asList("DELETE FROM TESTSCHEMA.idvalues where name = 'Test'", "INSERT INTO TESTSCHEMA.idvalues (name, value) VALUES('Test', (SELECT COALESCE(MAX(id) + 1, 1) AS CurrentValue FROM TESTSCHEMA.Test))", "INSERT INTO TESTSCHEMA.Test (stringField, id, version) SELECT stringField, (SELECT COALESCE(value, 0) FROM TESTSCHEMA.idvalues WHERE (name = N'Test')) + Other.id, 0 AS version FROM TESTSCHEMA.Other");
    }

    protected void verifyPostInsertStatementsNotInsertingUnderAutonumLimit(SqlScriptExecutor sqlScriptExecutor, Connection connection) {
        ((SqlScriptExecutor)Mockito.verify((Object)sqlScriptExecutor, (VerificationMode)Mockito.times((int)2))).execute((Iterable)this.listCaptor.capture(), (Connection)ArgumentMatchers.eq((Object)connection));
        Assert.assertThat((Object)((List)this.listCaptor.getAllValues().get(0)), (Matcher)Matchers.contains((Object[])new String[]{"DECLARE \n  e exception; \n  pragma exception_init(e,-4080); \nBEGIN \n  EXECUTE IMMEDIATE 'DROP TRIGGER TESTSCHEMA.TEST_TG'; \nEXCEPTION \n  WHEN e THEN \n    null; \nEND;"}));
        Assert.assertThat((Object)((List)this.listCaptor.getAllValues().get(1)), (Matcher)Matchers.contains((Object[])new String[]{"DECLARE \n  e exception; \n  pragma exception_init(e,-4080); \nBEGIN \n  EXECUTE IMMEDIATE 'DROP TRIGGER TESTSCHEMA.AUTONUMBER_TG'; \nEXCEPTION \n  WHEN e THEN \n    null; \nEND;", "DECLARE \n  query CHAR(255); \nBEGIN \n  select queryField into query from SYS.DUAL D left outer join (\n    select concat('drop sequence TESTSCHEMA.', sequence_name) as queryField \n    from ALL_SEQUENCES S \n    where S.sequence_owner='TESTSCHEMA' AND S.sequence_name = 'AUTONUMBER_SQ' \n  ) on 1 = 1; \n  IF query is not null THEN \n    execute immediate query; \n  END IF; \nEND;", "DECLARE query CHAR(255); \nBEGIN \n  SELECT 'CREATE SEQUENCE TESTSCHEMA.AUTONUMBER_SQ START WITH ' || TO_CHAR(GREATEST(5, MAX(id)+1)) || ' CACHE 2000' INTO QUERY FROM \n    (SELECT MAX(intField) AS id FROM TESTSCHEMA.AutoNumber UNION SELECT 0 AS id FROM SYS.DUAL); \n  EXECUTE IMMEDIATE query; \nEND;", "ALTER SESSION SET CURRENT_SCHEMA = testschema", "CREATE TRIGGER TESTSCHEMA.AUTONUMBER_TG \nBEFORE INSERT ON AutoNumber FOR EACH ROW \nBEGIN \n  IF (:new.intField IS NULL) THEN \n    SELECT AUTONUMBER_SQ.nextval \n    INTO :new.intField \n    FROM DUAL; \n  END IF; \nEND;"}));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{sqlScriptExecutor});
    }

    protected String tableName(String baseName) {
        return "TESTSCHEMA." + baseName;
    }

    protected String stringLiteralPrefix() {
        return "N";
    }

    protected String likeEscapeSuffix() {
        return " ESCAPE '\\'";
    }

    protected List<String> expectedSpecifiedValueInsert() {
        return Arrays.asList("DELETE FROM TESTSCHEMA.idvalues where name = 'Test'", "INSERT INTO TESTSCHEMA.idvalues (name, value) VALUES('Test', (SELECT COALESCE(MAX(id) + 1, 1) AS CurrentValue FROM TESTSCHEMA.Test))", "INSERT INTO TESTSCHEMA.Test (stringField, intField, floatField, dateField, booleanField, charField, id, version, blobField, bigIntegerField, clobField) VALUES (N'Escap''d', 7, 11.25, 20100405, 1, N'X', (SELECT COALESCE(value, 1) FROM TESTSCHEMA.idvalues WHERE (name = N'Test')), 0, null, 12345, null)");
    }

    protected List<String> expectedSpecifiedValueInsertWithTableInDifferentSchema() {
        return Arrays.asList("DELETE FROM TESTSCHEMA.idvalues where name = 'Test'", "INSERT INTO TESTSCHEMA.idvalues (name, value) VALUES('Test', (SELECT COALESCE(MAX(id) + 1, 1) AS CurrentValue FROM MYSCHEMA.Test))", "INSERT INTO MYSCHEMA.Test (stringField, intField, floatField, dateField, booleanField, charField, id, version, blobField, bigIntegerField, clobField) VALUES (N'Escap''d', 7, 11.25, 20100405, 1, N'X', (SELECT COALESCE(value, 1) FROM TESTSCHEMA.idvalues WHERE (name = N'Test')), 0, null, 12345, null)");
    }

    protected String expectedParameterisedInsertStatementWithNoColumnValues() {
        return "INSERT INTO TESTSCHEMA.Test (id, version, stringField, intField, floatField, dateField, booleanField, charField, blobField, bigIntegerField, clobField) VALUES (:id, :version, :stringField, :intField, :floatField, :dateField, :booleanField, :charField, :blobField, :bigIntegerField, :clobField)";
    }

    protected String expectedEmptyStringInsertStatement() {
        return "INSERT INTO TESTSCHEMA.Test (stringField, id, version, intField, floatField, dateField, booleanField, charField, blobField, bigIntegerField, clobField) VALUES (NULL, (SELECT COALESCE(value, 1) FROM TESTSCHEMA.idvalues WHERE (name = N'Test')), 0, 0, 0, null, 0, NULL, null, 12345, null)";
    }

    protected String expectedSelectWithConcatenation1() {
        return "SELECT assetDescriptionLine1 || N' ' || assetDescriptionLine2 AS assetDescription FROM TESTSCHEMA.schedule";
    }

    protected String expectedSelectWithConcatenation2() {
        return "SELECT assetDescriptionLine1 || N'XYZ' || assetDescriptionLine2 AS assetDescription FROM TESTSCHEMA.schedule";
    }

    protected String expectedConcatenationWithCase() {
        return "SELECT assetDescriptionLine1 || CASE WHEN (taxVariationIndicator = N'Y') THEN exposureCustomerNumber ELSE invoicingCustomerNumber END AS test FROM TESTSCHEMA.schedule";
    }

    protected String expectedConcatenationWithFunction() {
        return "SELECT assetDescriptionLine1 || MAX(scheduleStartDate) AS test FROM TESTSCHEMA.schedule";
    }

    protected String expectedConcatenationWithMultipleFieldLiterals() {
        return "SELECT N'ABC' || N' ' || N'DEF' AS assetDescription FROM TESTSCHEMA.schedule";
    }

    protected String expectedNestedConcatenations() {
        return "SELECT field1 || field2 || N'XYZ' AS test FROM TESTSCHEMA.schedule";
    }

    protected String expectedIsNull() {
        return "nvl(N'A', N'B') ";
    }

    protected String expectedMathsPlus() {
        return "1 + 1";
    }

    protected String expectedMathsMinus() {
        return "1 - 1";
    }

    protected String expectedMathsDivide() {
        return "1 / 1";
    }

    protected String expectedMathsMultiply() {
        return "1 * 1";
    }

    protected String expectedStringCast() {
        return "CAST(value AS NVARCHAR2(10))";
    }

    protected String expectedBigIntCast() {
        return "CAST(value AS NUMBER(19))";
    }

    protected String expectedBigIntFunctionCast() {
        return "CAST(MIN(value) AS NUMBER(19))";
    }

    protected String expectedBooleanCast() {
        return "CAST(value AS DECIMAL(1,0))";
    }

    protected String expectedDateCast() {
        return "CAST(value AS DATE)";
    }

    protected String expectedDecimalCast() {
        return "CAST(value AS DECIMAL(10,2))";
    }

    protected String expectedIntegerCast() {
        return "CAST(value AS INTEGER)";
    }

    protected String expectedStringLiteralToIntegerCast() {
        return "CAST(" + this.stringLiteralPrefix() + "'1234567890' AS INTEGER)";
    }

    protected String expectedSelectWithUnion() {
        return "SELECT stringField FROM TESTSCHEMA.Other UNION SELECT stringField FROM TESTSCHEMA.Test UNION ALL SELECT stringField FROM TESTSCHEMA.Alternate ORDER BY stringField NULLS FIRST";
    }

    protected String nullOrder() {
        return "NULLS FIRST";
    }

    protected List<String> expectedAlterTableAddStringColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD (stringField_new NVARCHAR2(6) NULL)", "COMMENT ON COLUMN TESTSCHEMA.Test.stringField_new IS 'REALNAME:[stringField_new]/TYPE:[STRING]'");
    }

    protected List<String> expectedAlterTableAlterStringColumnStatement() {
        return Arrays.asList("DROP INDEX TESTSCHEMA.Test_NK", "ALTER TABLE TESTSCHEMA.Test MODIFY (stringField NVARCHAR2(6))", "CREATE UNIQUE INDEX TESTSCHEMA.Test_NK ON TESTSCHEMA.Test (stringField) PARALLEL NOLOGGING", "ALTER INDEX TESTSCHEMA.Test_NK NOPARALLEL LOGGING", "COMMENT ON COLUMN TESTSCHEMA.Test.stringField IS 'REALNAME:[stringField]/TYPE:[STRING]'");
    }

    protected List<String> expectedAlterTableAddBigIntegerColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD (bigIntegerField_new NUMBER(19) NULL)", "COMMENT ON COLUMN TESTSCHEMA.Test.bigIntegerField_new IS 'REALNAME:[bigIntegerField_new]/TYPE:[BIG_INTEGER]'");
    }

    protected List<String> expectedAlterTableAlterBigIntegerColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test MODIFY (bigIntegerField DEFAULT NULL)", "COMMENT ON COLUMN TESTSCHEMA.Test.bigIntegerField IS 'REALNAME:[bigIntegerField]/TYPE:[BIG_INTEGER]'");
    }

    protected List<String> expectedAlterTableAddBlobColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD (blobField_new BLOB NULL)", "COMMENT ON COLUMN TESTSCHEMA.Test.blobField_new IS 'REALNAME:[blobField_new]/TYPE:[BLOB]'");
    }

    protected List<String> expectedAlterTableAlterBlobColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test MODIFY (blobField  NOT NULL)", "COMMENT ON COLUMN TESTSCHEMA.Test.blobField IS 'REALNAME:[blobField]/TYPE:[BLOB]'");
    }

    protected List<String> expectedAddIndexStatementsOnSingleColumn() {
        return Arrays.asList("CREATE INDEX TESTSCHEMA.indexName ON TESTSCHEMA.Test (id) PARALLEL NOLOGGING", "ALTER INDEX TESTSCHEMA.indexName NOPARALLEL LOGGING");
    }

    protected List<String> expectedAddIndexStatementsOnMultipleColumns() {
        return Arrays.asList("CREATE INDEX TESTSCHEMA.indexName ON TESTSCHEMA.Test (id, version) PARALLEL NOLOGGING", "ALTER INDEX TESTSCHEMA.indexName NOPARALLEL LOGGING");
    }

    protected List<String> expectedAddIndexStatementsUnique() {
        return Arrays.asList("CREATE UNIQUE INDEX TESTSCHEMA.indexName ON TESTSCHEMA.Test (id) PARALLEL NOLOGGING", "ALTER INDEX TESTSCHEMA.indexName NOPARALLEL LOGGING");
    }

    protected List<String> expectedAddIndexStatementsUniqueNullable() {
        return Arrays.asList("CREATE UNIQUE INDEX TESTSCHEMA.indexName ON TESTSCHEMA.Test (stringField, intField, floatField, dateField) PARALLEL NOLOGGING", "ALTER INDEX TESTSCHEMA.indexName NOPARALLEL LOGGING");
    }

    protected List<String> expectedAlterTableAlterColumnFromNotNullableToNotNullableStatement() {
        return Arrays.asList("DROP INDEX TESTSCHEMA.Test_1", "ALTER TABLE TESTSCHEMA.Test MODIFY (floatField DECIMAL(20,3))", "CREATE UNIQUE INDEX TESTSCHEMA.Test_1 ON TESTSCHEMA.Test (intField, floatField) PARALLEL NOLOGGING", "ALTER INDEX TESTSCHEMA.Test_1 NOPARALLEL LOGGING", "COMMENT ON COLUMN TESTSCHEMA.Test.floatField IS 'REALNAME:[floatField]/TYPE:[DECIMAL]'");
    }

    protected List<String> expectedAlterTableAlterBooleanColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test MODIFY (booleanField  NOT NULL)", "COMMENT ON COLUMN TESTSCHEMA.Test.booleanField IS 'REALNAME:[booleanField]/TYPE:[BOOLEAN]'");
    }

    protected List<String> expectedAlterTableAddBooleanColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD (booleanField_new DECIMAL(1,0) NULL)", "COMMENT ON COLUMN TESTSCHEMA.Test.booleanField_new IS 'REALNAME:[booleanField_new]/TYPE:[BOOLEAN]'");
    }

    protected List<String> expectedAlterTableAddIntegerColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD (intField_new INTEGER NULL)", "COMMENT ON COLUMN TESTSCHEMA.Test.intField_new IS 'REALNAME:[intField_new]/TYPE:[INTEGER]'");
    }

    protected List<String> expectedAlterTableAlterIntegerColumnStatement() {
        return Arrays.asList("DROP INDEX TESTSCHEMA.Test_1", "ALTER TABLE TESTSCHEMA.Test MODIFY (intField  NOT NULL)", "CREATE UNIQUE INDEX TESTSCHEMA.Test_1 ON TESTSCHEMA.Test (intField, floatField) PARALLEL NOLOGGING", "ALTER INDEX TESTSCHEMA.Test_1 NOPARALLEL LOGGING", "COMMENT ON COLUMN TESTSCHEMA.Test.intField IS 'REALNAME:[intField]/TYPE:[INTEGER]'");
    }

    protected List<String> expectedAlterTableAddDateColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD (dateField_new DATE NULL)", "COMMENT ON COLUMN TESTSCHEMA.Test.dateField_new IS 'REALNAME:[dateField_new]/TYPE:[DATE]'");
    }

    protected List<String> expectedAlterTableAlterDateColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test MODIFY (dateField  NOT NULL)", "COMMENT ON COLUMN TESTSCHEMA.Test.dateField IS 'REALNAME:[dateField]/TYPE:[DATE]'");
    }

    protected List<String> expectedAlterTableAddDecimalColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD (floatField_new DECIMAL(6,3) NULL)", "COMMENT ON COLUMN TESTSCHEMA.Test.floatField_new IS 'REALNAME:[floatField_new]/TYPE:[DECIMAL]'");
    }

    protected List<String> expectedAlterTableAlterDecimalColumnStatement() {
        return Arrays.asList("DROP INDEX TESTSCHEMA.Test_1", "ALTER TABLE TESTSCHEMA.Test MODIFY (floatField DECIMAL(14,3) NULL)", "CREATE UNIQUE INDEX TESTSCHEMA.Test_1 ON TESTSCHEMA.Test (intField, floatField) PARALLEL NOLOGGING", "ALTER INDEX TESTSCHEMA.Test_1 NOPARALLEL LOGGING", "COMMENT ON COLUMN TESTSCHEMA.Test.floatField IS 'REALNAME:[floatField]/TYPE:[DECIMAL]'");
    }

    protected List<String> expectedAlterTableAddColumnNotNullableStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD (dateField_new DATE DEFAULT DATE '2010-01-01' NOT NULL)", "COMMENT ON COLUMN TESTSCHEMA.Test.dateField_new IS 'REALNAME:[dateField_new]/TYPE:[DATE]'");
    }

    protected List<String> expectedAlterTableAlterColumnFromNullableToNotNullableStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test MODIFY (dateField  NOT NULL)", "COMMENT ON COLUMN TESTSCHEMA.Test.dateField IS 'REALNAME:[dateField]/TYPE:[DATE]'");
    }

    protected List<String> expectedAlterTableAlterColumnFromNotNullableToNullableStatement() {
        return Arrays.asList("DROP INDEX TESTSCHEMA.Test_1", "ALTER TABLE TESTSCHEMA.Test MODIFY (floatField DECIMAL(20,3) NULL)", "CREATE UNIQUE INDEX TESTSCHEMA.Test_1 ON TESTSCHEMA.Test (intField, floatField) PARALLEL NOLOGGING", "ALTER INDEX TESTSCHEMA.Test_1 NOPARALLEL LOGGING", "COMMENT ON COLUMN TESTSCHEMA.Test.floatField IS 'REALNAME:[floatField]/TYPE:[DECIMAL]'");
    }

    protected List<String> expectedAlterTableAddColumnWithDefaultStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD (floatField_new DECIMAL(6,3) DEFAULT 20.33 NULL)", "COMMENT ON COLUMN TESTSCHEMA.Test.floatField_new IS 'REALNAME:[floatField_new]/TYPE:[DECIMAL]'");
    }

    protected List<String> expectedAlterTableAlterColumnWithDefaultStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test MODIFY (bigIntegerField  DEFAULT 54321)", "COMMENT ON COLUMN TESTSCHEMA.Test.bigIntegerField IS 'REALNAME:[bigIntegerField]/TYPE:[BIG_INTEGER]'");
    }

    protected List<String> expectedAlterTableDropColumnWithDefaultStatement() {
        return Collections.singletonList("ALTER TABLE TESTSCHEMA.Test SET UNUSED (bigIntegerField)");
    }

    protected List<String> expectedChangeIndexFollowedByChangeOfAssociatedColumnStatement() {
        return Arrays.asList("DROP INDEX TESTSCHEMA.Test_1", "CREATE INDEX TESTSCHEMA.Test_1 ON TESTSCHEMA.Test (intField) PARALLEL NOLOGGING", "ALTER INDEX TESTSCHEMA.Test_1 NOPARALLEL LOGGING", "DROP INDEX TESTSCHEMA.Test_1", "ALTER TABLE TESTSCHEMA.Test MODIFY (intField  NOT NULL)", "CREATE INDEX TESTSCHEMA.Test_1 ON TESTSCHEMA.Test (INTFIELD) PARALLEL NOLOGGING", "ALTER INDEX TESTSCHEMA.Test_1 NOPARALLEL LOGGING", "COMMENT ON COLUMN TESTSCHEMA.Test.intField IS 'REALNAME:[intField]/TYPE:[INTEGER]'");
    }

    protected List<String> expectedIndexDropStatements() {
        return Arrays.asList("DROP INDEX TESTSCHEMA.indexName");
    }

    protected List<String> expectedAlterColumnMakePrimaryStatements() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test DROP PRIMARY KEY DROP INDEX", "ALTER TABLE TESTSCHEMA.Test ADD CONSTRAINT Test_PK PRIMARY KEY (id, dateField) USING INDEX (CREATE UNIQUE INDEX TESTSCHEMA.Test_PK ON TESTSCHEMA.Test (id, dateField))", "COMMENT ON COLUMN TESTSCHEMA.Test.dateField IS 'REALNAME:[dateField]/TYPE:[DATE]'");
    }

    protected List<String> expectedAlterPrimaryKeyColumnCompositeKeyStatements() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.CompositePrimaryKey DROP PRIMARY KEY DROP INDEX", "ALTER TABLE TESTSCHEMA.CompositePrimaryKey MODIFY (secondPrimaryKey NVARCHAR2(5))", "ALTER TABLE TESTSCHEMA.CompositePrimaryKey ADD CONSTRAINT CompositePrimaryKey_PK PRIMARY KEY (id, secondPrimaryKey) USING INDEX (CREATE UNIQUE INDEX TESTSCHEMA.CompositePrimaryKey_PK ON TESTSCHEMA.CompositePrimaryKey (id, secondPrimaryKey))", "COMMENT ON COLUMN TESTSCHEMA.CompositePrimaryKey.secondPrimaryKey IS 'REALNAME:[secondPrimaryKey]/TYPE:[STRING]'");
    }

    protected List<String> expectedAlterRemoveColumnFromCompositeKeyStatements() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.CompositePrimaryKey DROP PRIMARY KEY DROP INDEX", "ALTER TABLE TESTSCHEMA.CompositePrimaryKey MODIFY (secondPrimaryKey NVARCHAR2(5) NULL)", "ALTER TABLE TESTSCHEMA.CompositePrimaryKey ADD CONSTRAINT CompositePrimaryKey_PK PRIMARY KEY (id) USING INDEX (CREATE UNIQUE INDEX TESTSCHEMA.CompositePrimaryKey_PK ON TESTSCHEMA.CompositePrimaryKey (id))", "COMMENT ON COLUMN TESTSCHEMA.CompositePrimaryKey.secondPrimaryKey IS 'REALNAME:[secondPrimaryKey]/TYPE:[STRING]'");
    }

    protected List<String> expectedAlterPrimaryKeyColumnStatements() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test DROP PRIMARY KEY DROP INDEX", "ALTER TABLE TESTSCHEMA.Test RENAME COLUMN id TO renamedId", "ALTER TABLE TESTSCHEMA.Test ADD CONSTRAINT Test_PK PRIMARY KEY (renamedId) USING INDEX (CREATE UNIQUE INDEX TESTSCHEMA.Test_PK ON TESTSCHEMA.Test (renamedId))", "COMMENT ON COLUMN TESTSCHEMA.Test.renamedId IS 'REALNAME:[renamedId]/TYPE:[BIG_INTEGER]'");
    }

    protected List<String> expectedAlterColumnRenamingAndChangingNullability() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Other RENAME COLUMN floatField TO blahField", "ALTER TABLE TESTSCHEMA.Other MODIFY (blahField DECIMAL(20,3) NULL)", "COMMENT ON COLUMN TESTSCHEMA.Other.blahField IS 'REALNAME:[blahField]/TYPE:[DECIMAL]'");
    }

    protected List<String> expectedAlterColumnChangingLengthAndCase() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Other MODIFY (FloatField DECIMAL(20,3))", "COMMENT ON COLUMN TESTSCHEMA.Other.FloatField IS 'REALNAME:[FloatField]/TYPE:[DECIMAL]'");
    }

    protected String varCharCast(String value) {
        return value;
    }

    protected List<String> expectedAlterTableAddStringColumnWithDefaultStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD (stringField_with_default NVARCHAR2(6) DEFAULT N'N' NOT NULL)", "COMMENT ON COLUMN TESTSCHEMA.Test.stringField_with_default IS 'REALNAME:[stringField_with_default]/TYPE:[STRING]'");
    }

    protected List<String> expectedAutonumberUpdate() {
        return Arrays.asList("MERGE INTO TESTSCHEMA.Autonumber A USING (SELECT COALESCE(MAX(id) + 1, 1) AS CurrentValue FROM TESTSCHEMA.TestTable) S ON (A.id = 'TestTable') WHEN MATCHED THEN UPDATE SET A.value = S.CurrentValue WHERE A.value < S.CurrentValue WHEN NOT MATCHED THEN INSERT (id, value) VALUES ('TestTable', S.CurrentValue)");
    }

    protected String expectedUpdateWithSelectMinimum() {
        String value1 = this.varCharCast("'S'");
        String value2 = this.varCharCast("'Y'");
        return "UPDATE " + this.tableName("Other") + " O SET intField = (SELECT MIN(intField) FROM " + this.tableName("Test") + " T WHERE ((T.charField = " + this.stringLiteralPrefix() + value1 + ") AND (T.stringField = O.stringField) AND (T.intField = O.intField))) WHERE (stringField = " + this.stringLiteralPrefix() + value2 + ")";
    }

    protected String expectedUpdateUsingAliasedDestinationTable() {
        return "UPDATE " + this.tableName("FloatingRateRate") + " A SET settlementFrequency = (SELECT settlementFrequency FROM " + this.tableName("FloatingRateDetail") + " B WHERE (A.floatingRateDetailId = B.id))";
    }

    protected String expectedYYYYMMDDToDate() {
        return "TO_DATE(" + this.stringLiteralPrefix() + "'20100101', 'yyyymmdd')";
    }

    protected String expectedDateToYyyymmdd() {
        return "TO_NUMBER(TO_CHAR(testField, 'yyyymmdd'))";
    }

    protected String expectedBlobLiteral(String value) {
        return String.format("HEXTORAW(%s)", super.expectedBlobLiteral(value));
    }

    protected String expectedDateToYyyymmddHHmmss() {
        return "TO_NUMBER(TO_CHAR(testField, 'yyyymmddHH24MISS'))";
    }

    protected String expectedNow() {
        return "SYSTIMESTAMP AT TIME ZONE 'UTC'";
    }

    protected String expectedDaysBetween() {
        return "SELECT (dateTwo) - (dateOne) FROM " + this.tableName("MyTable");
    }

    protected List<String> expectedDropViewStatements() {
        return Arrays.asList("BEGIN FOR i IN (SELECT null FROM all_views WHERE OWNER='TESTSCHEMA' AND VIEW_NAME='TESTVIEW') LOOP EXECUTE IMMEDIATE 'DROP VIEW " + this.tableName("TestView") + "'; END LOOP; END;");
    }

    protected String expectedSubstring() {
        return "SELECT SUBSTR(field1, 1, 3) FROM " + this.tableName("schedule");
    }

    protected List<String> expectedAutonumberUpdateForNonIdColumn() {
        return Arrays.asList("MERGE INTO TESTSCHEMA.Autonumber A USING (SELECT COALESCE(MAX(generatedColumn) + 1, 1) AS CurrentValue FROM TESTSCHEMA.TestTable) S ON (A.id = 'TestTable') WHEN MATCHED THEN UPDATE SET A.value = S.CurrentValue WHERE A.value < S.CurrentValue WHEN NOT MATCHED THEN INSERT (id, value) VALUES ('TestTable', S.CurrentValue)");
    }

    protected String expectedStringFunctionCast() {
        return "CAST(MIN(field) AS NVARCHAR2(8))";
    }

    protected void verifyBooleanPrepareStatementParameter() throws SQLException {
        SqlParameter booleanColumn = SqlUtils.parameter((Column)SchemaUtils.column((String)"booleanColumn", (DataType)DataType.BOOLEAN));
        ArgumentCaptor parameterCaptor = ArgumentCaptor.forClass(SqlParameter.class);
        Object nullCheck = null;
        ((NamedParameterPreparedStatement)Mockito.verify((Object)this.callPrepareStatementParameter(booleanColumn, null))).setBigDecimal((SqlParameter)parameterCaptor.capture(), (BigDecimal)ArgumentMatchers.eq(nullCheck));
        Assert.assertEquals((String)"Name of mapped boolean parameter", (Object)"booleanColumn", (Object)((SqlParameter)parameterCaptor.getValue()).getImpliedName());
        Assert.assertEquals((String)"Type of mapped boolean parameter", (Object)DataType.DECIMAL, (Object)((SqlParameter)parameterCaptor.getValue()).getMetadata().getType());
        Assert.assertEquals((String)"Length of mapped boolean parameter", (long)1L, (long)((SqlParameter)parameterCaptor.getValue()).getMetadata().getWidth());
        NamedParameterPreparedStatement mockStatement = this.callPrepareStatementParameter(booleanColumn, "true");
        ArgumentCaptor bigDecimalCapture = ArgumentCaptor.forClass(BigDecimal.class);
        ((NamedParameterPreparedStatement)Mockito.verify((Object)mockStatement)).setBigDecimal((SqlParameter)ArgumentMatchers.any(SqlParameter.class), (BigDecimal)bigDecimalCapture.capture());
        Assert.assertTrue((String)("BigDecimal not correctly set on statement.  Expected 1, was: " + bigDecimalCapture.getValue()), (((BigDecimal)bigDecimalCapture.getValue()).compareTo(new BigDecimal(1)) == 0 ? 1 : 0) != 0);
        mockStatement = this.callPrepareStatementParameter(booleanColumn, "false");
        bigDecimalCapture = ArgumentCaptor.forClass(BigDecimal.class);
        ((NamedParameterPreparedStatement)Mockito.verify((Object)mockStatement)).setBigDecimal((SqlParameter)ArgumentMatchers.any(SqlParameter.class), (BigDecimal)bigDecimalCapture.capture());
        Assert.assertTrue((String)("BigDecimal not correctly set on statement.  Expected 0, was: " + bigDecimalCapture.getValue()), (((BigDecimal)bigDecimalCapture.getValue()).compareTo(new BigDecimal(0)) == 0 ? 1 : 0) != 0);
    }

    protected String expectedMergeSimple() {
        return "MERGE INTO TESTSCHEMA.foo USING (SELECT somewhere.newId AS id, somewhere.newBar AS bar FROM TESTSCHEMA.somewhere) xmergesource ON (foo.id = xmergesource.id) WHEN MATCHED THEN UPDATE SET bar = xmergesource.bar WHEN NOT MATCHED THEN INSERT (id, bar) VALUES (xmergesource.id, xmergesource.bar)";
    }

    protected String expectedMergeComplex() {
        return "MERGE INTO TESTSCHEMA.foo USING (SELECT somewhere.newId AS id, join.joinBar AS bar FROM TESTSCHEMA.somewhere INNER JOIN TESTSCHEMA.join ON (somewhere.newId = join.joinId)) xmergesource ON (foo.id = xmergesource.id) WHEN MATCHED THEN UPDATE SET bar = xmergesource.bar WHEN NOT MATCHED THEN INSERT (id, bar) VALUES (xmergesource.id, xmergesource.bar)";
    }

    protected String expectedMergeSourceInDifferentSchema() {
        return "MERGE INTO TESTSCHEMA.foo USING (SELECT somewhere.newId AS id, somewhere.newBar AS bar FROM MYSCHEMA.somewhere) xmergesource ON (foo.id = xmergesource.id) WHEN MATCHED THEN UPDATE SET bar = xmergesource.bar WHEN NOT MATCHED THEN INSERT (id, bar) VALUES (xmergesource.id, xmergesource.bar)";
    }

    protected String expectedMergeTargetInDifferentSchema() {
        return "MERGE INTO MYSCHEMA.foo USING (SELECT somewhere.newId AS id, somewhere.newBar AS bar FROM TESTSCHEMA.somewhere) xmergesource ON (foo.id = xmergesource.id) WHEN MATCHED THEN UPDATE SET bar = xmergesource.bar WHEN NOT MATCHED THEN INSERT (id, bar) VALUES (xmergesource.id, xmergesource.bar)";
    }

    protected String expectedMergeForAllPrimaryKeys() {
        return "MERGE INTO TESTSCHEMA.foo USING (SELECT somewhere.newId AS id FROM TESTSCHEMA.somewhere) xmergesource ON (foo.id = xmergesource.id) WHEN NOT MATCHED THEN INSERT (id) VALUES (xmergesource.id)";
    }

    protected String expectedMergeWithUpdateExpressions() {
        return "MERGE INTO TESTSCHEMA.foo USING (SELECT somewhere.newId AS id, somewhere.newBar AS bar FROM TESTSCHEMA.somewhere) xmergesource ON (foo.id = xmergesource.id) WHEN MATCHED THEN UPDATE SET bar = xmergesource.bar + foo.bar WHEN NOT MATCHED THEN INSERT (id, bar) VALUES (xmergesource.id, xmergesource.bar)";
    }

    protected String expectedAddDays() {
        return "(testField) + (-20)";
    }

    protected String expectedAddMonths() {
        return "ADD_MONTHS(testField, -3)";
    }

    protected List<String> expectedAlterRemoveColumnFromSimpleKeyStatements() {
        return Collections.singletonList("ALTER TABLE TESTSCHEMA.Test SET UNUSED (id)");
    }

    protected List<String> expectedRenameTableStatements() {
        return ImmutableList.of((Object)"ALTER TABLE TESTSCHEMA.Test RENAME CONSTRAINT Test_PK TO Renamed_PK", (Object)"ALTER INDEX TESTSCHEMA.Test_PK RENAME TO Renamed_PK", (Object)"ALTER TABLE TESTSCHEMA.Test RENAME TO Renamed", (Object)"COMMENT ON TABLE TESTSCHEMA.Renamed IS 'REALNAME:[Renamed]'");
    }

    protected List<String> getRenamingTableWithLongNameStatements() {
        return ImmutableList.of((Object)"ALTER TABLE TESTSCHEMA.123456789012345678901234567890 RENAME CONSTRAINT 123456789012345678901234567_PK TO Blah_PK", (Object)"ALTER INDEX TESTSCHEMA.123456789012345678901234567_PK RENAME TO Blah_PK", (Object)"ALTER TABLE TESTSCHEMA.123456789012345678901234567890 RENAME TO Blah", (Object)"COMMENT ON TABLE TESTSCHEMA.Blah IS 'REALNAME:[Blah]'");
    }

    protected List<String> expectedRenameIndexStatements() {
        return ImmutableList.of((Object)"ALTER INDEX TESTSCHEMA.Test_1 RENAME TO Test_2");
    }

    protected List<String> expectedRenameTempIndexStatements() {
        return ImmutableList.of((Object)"ALTER INDEX TESTSCHEMA.TempTest_1 RENAME TO TempTest_2");
    }

    protected void expectedSqlStatementFormat() {
        String statement1 = this.getTestDialect().formatSqlStatement("END;");
        String statement2 = this.getTestDialect().formatSqlStatement("BEGIN");
        String statement3 = this.getTestDialect().formatSqlStatement(Strings.repeat((String)"a", (int)2498) + " " + Strings.repeat((String)"b", (int)2497) + " " + Strings.repeat((String)"c", (int)2497));
        Assert.assertEquals((String)("The statement separator should be [END;" + System.getProperty("line.separator") + "/]"), (Object)("END;" + System.getProperty("line.separator") + "/"), (Object)statement1);
        Assert.assertEquals((String)"The statement separator should be [BEGIN;]", (Object)"BEGIN;", (Object)statement2);
        this.assertLengthOfLinesInStringLessThan2500Characters(statement3);
    }

    protected Collection<String> expectedAnalyseTableSql() {
        return ImmutableList.of((Object)"BEGIN \nDBMS_STATS.GATHER_TABLE_STATS(ownname=> 'testschema', tabname=>'TempTest', cascade=>true, degree=>DBMS_STATS.AUTO_DEGREE, no_invalidate=>false); \nEND;");
    }

    private void assertLengthOfLinesInStringLessThan2500Characters(String lines) {
        if (lines.length() < 2500) {
            return;
        }
        int newLine = lines.indexOf(System.getProperty("line.separator"));
        if (newLine >= 0 && newLine < 2500) {
            this.assertLengthOfLinesInStringLessThan2500Characters(lines.substring(newLine + 1));
        } else {
            Assert.fail((String)"Line length should not be greater than 2499 characters");
        }
    }

    protected String expectedLeftPad() {
        return "SELECT LPAD(stringField, 10, N'j') FROM TESTSCHEMA.Test";
    }

    protected String expectedRandomFunction() {
        return "dbms_random.value";
    }

    protected String expectedRandomString() {
        return "dbms_random.string('A', 10)";
    }

    protected String expectedSelectFirstOrderByNullsLastDesc() {
        return "SELECT MIN(stringField) KEEP (DENSE_RANK FIRST ORDER BY stringField DESC NULLS LAST) FROM " + this.tableName("Alternate");
    }

    protected String expectedSelectLiteralWithWhereClauseString() {
        return "SELECT N'LITERAL' FROM dual WHERE (N'ONE' = N'ONE')";
    }

    public List<String> expectedAddTableFromStatements() {
        return ImmutableList.of((Object)"CREATE TABLE TESTSCHEMA.SomeTable (someField  NOT NULL, otherField  NOT NULL, CONSTRAINT SomeTable_PK PRIMARY KEY (someField) USING INDEX (CREATE UNIQUE INDEX TESTSCHEMA.SomeTable_PK ON TESTSCHEMA.SomeTable (someField))) PARALLEL NOLOGGING AS SELECT someField, otherField FROM TESTSCHEMA.OtherTable", (Object)"ALTER TABLE TESTSCHEMA.SomeTable NOPARALLEL LOGGING", (Object)"ALTER INDEX TESTSCHEMA.SomeTable_PK NOPARALLEL LOGGING", (Object)"COMMENT ON TABLE TESTSCHEMA.SomeTable IS 'REALNAME:[SomeTable]'", (Object)"COMMENT ON COLUMN TESTSCHEMA.SomeTable.someField IS 'REALNAME:[someField]/TYPE:[STRING]'", (Object)"COMMENT ON COLUMN TESTSCHEMA.SomeTable.otherField IS 'REALNAME:[otherField]/TYPE:[DECIMAL]'");
    }

    protected String expectedHints1(int rowCount) {
        return "SELECT /*+ ORDERED FIRST_ROWS(" + rowCount + ") INDEX(Foo Foo_1) INDEX(aliased Foo_2) */ * FROM SCHEMA2.Foo INNER JOIN " + this.tableName("Bar") + " ON (a = b) LEFT OUTER JOIN " + this.tableName("Fo") + " ON (a = b) INNER JOIN " + this.tableName("Fum") + " Fumble ON (a = b) ORDER BY a NULLS FIRST";
    }

    protected String expectedHints2(int rowCount) {
        return "SELECT /*+ INDEX(Foo Foo_1) FIRST_ROWS(" + rowCount + ") ORDERED PARALLEL ENABLE_PARALLEL_DML */ a, b FROM " + this.tableName("Foo") + " ORDER BY a NULLS FIRST FOR UPDATE";
    }

    protected String expectedHints3() {
        return "UPDATE /*+ ENABLE_PARALLEL_DML PARALLEL */ " + this.tableName("Foo") + " SET a = b";
    }

    protected String expectedHints3a() {
        return "UPDATE /*+ ENABLE_PARALLEL_DML PARALLEL(5) */ " + this.tableName("Foo") + " SET a = b";
    }

    protected String expectedHints4() {
        return "INSERT /*+ APPEND */ INTO " + this.tableName("Foo") + " SELECT a, b FROM " + this.tableName("Foo_1");
    }

    protected String expectedHints4a() {
        return "INSERT /*+ NOAPPEND */ INTO " + this.tableName("Foo") + " SELECT a, b FROM " + this.tableName("Foo_1");
    }

    protected String expectedHints4b() {
        return "INSERT /*+ ENABLE_PARALLEL_DML PARALLEL */ INTO " + this.tableName("Foo") + " SELECT a, b FROM " + this.tableName("Foo_1");
    }

    protected String expectedHints4c() {
        return "INSERT /*+ ENABLE_PARALLEL_DML PARALLEL(5) */ INTO " + this.tableName("Foo") + " SELECT a, b FROM " + this.tableName("Foo_1");
    }

    protected String expectedHints6() {
        return "SELECT /*+ PARALLEL(5) */ a, b FROM " + this.tableName("Foo") + " ORDER BY a NULLS FIRST";
    }

    protected String expectedHints6a() {
        return "SELECT /*+ PARALLEL(5) ENABLE_PARALLEL_DML */ a, b FROM " + this.tableName("Foo") + " ORDER BY a NULLS FIRST";
    }

    protected String expectedHints7() {
        return "SELECT /*+ opt_param('optimizer_index_caching',100) opt_param('optimizer_index_cost_adj',50) optimizer_features_enable('12.1.0.2') ) */ * FROM SCHEMA2.Foo";
    }

    protected CustomHint provideCustomHint() {
        return new OracleCustomHint("opt_param('optimizer_index_caching',100) opt_param('optimizer_index_cost_adj',50) optimizer_features_enable('12.1.0.2') )");
    }

    protected boolean expectedUsesNVARCHARforStrings() {
        return true;
    }

    protected String nullOrderForDirection(Direction descending) {
        return Direction.ASCENDING.equals((Object)descending) ? this.nullOrder() : "NULLS LAST";
    }

    protected String expectedDeleteWithLimitAndWhere(String value) {
        return "DELETE FROM " + this.tableName("Test") + " WHERE (Test.stringField = " + this.stringLiteralPrefix() + value + ") AND ROWNUM <= 1000";
    }

    protected String expectedDeleteWithLimitAndComplexWhere(String value1, String value2) {
        return "DELETE FROM " + this.tableName("Test") + " WHERE ((Test.stringField = " + this.stringLiteralPrefix() + value1 + ") OR (Test.stringField = " + this.stringLiteralPrefix() + value2 + ")) AND ROWNUM <= 1000";
    }

    protected String expectedDeleteWithLimitWithoutWhere() {
        return "DELETE FROM " + this.tableName("Test") + " WHERE ROWNUM <= 1000";
    }

    protected String expectedSelectWithExcept() {
        return "SELECT stringField FROM TESTSCHEMA.Test MINUS SELECT stringField FROM TESTSCHEMA.Other ORDER BY stringField NULLS FIRST";
    }

    protected String expectedSelectWithDbLink() {
        return "SELECT stringField FROM TESTSCHEMA.Test@MYDBLINKREF";
    }

    protected String expectedSelectWithExceptAndDbLinkFormer() {
        return "SELECT stringField FROM TESTSCHEMA.Test@MYDBLINKREF MINUS SELECT stringField FROM TESTSCHEMA.Other ORDER BY stringField NULLS FIRST";
    }

    protected String expectedSelectWithExceptAndDbLinkLatter() {
        return "SELECT stringField FROM TESTSCHEMA.Test MINUS SELECT stringField FROM TESTSCHEMA.Other@MYDBLINKREF ORDER BY stringField NULLS FIRST";
    }
}

