/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.oracle;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.alfasoftware.morf.jdbc.DatabaseType;
import org.alfasoftware.morf.jdbc.RuntimeSqlException;
import org.alfasoftware.morf.metadata.Column;
import org.alfasoftware.morf.metadata.DataType;
import org.alfasoftware.morf.metadata.Index;
import org.alfasoftware.morf.metadata.Schema;
import org.alfasoftware.morf.metadata.View;
import org.alfasoftware.morf.sql.SelectStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestOracleMetaDataProvider {
    private final DataSource dataSource = (DataSource)Mockito.mock(DataSource.class, (Answer)Mockito.RETURNS_SMART_NULLS);
    private final Connection connection = (Connection)Mockito.mock(Connection.class, (Answer)Mockito.RETURNS_SMART_NULLS);
    private DatabaseType oracle;

    @Before
    public void setup() {
        this.oracle = DatabaseType.Registry.findByIdentifier((String)"ORACLE");
    }

    @Before
    public void before() throws SQLException {
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.connection);
    }

    @Test
    public void testIsEmptyDatabase() throws SQLException {
        PreparedStatement statement1 = this.mockGetTableKeysQuery(0, false, false);
        Schema oracleMetaDataProvider = this.oracle.openSchema(this.connection, "TESTDATABASE", "TESTSCHEMA");
        Assert.assertTrue((String)"Database should be reported empty", (boolean)oracleMetaDataProvider.isEmptyDatabase());
        PreparedStatement statement2 = this.mockGetTableKeysQuery(1, false, false);
        Assert.assertFalse((String)"Database should not be reported empty", (boolean)oracleMetaDataProvider.isEmptyDatabase());
        ((PreparedStatement)Mockito.verify((Object)statement1)).setString(1, "TESTSCHEMA");
        ((PreparedStatement)Mockito.verify((Object)statement2)).setString(1, "TESTSCHEMA");
    }

    @Test
    public void testIfCatchesWronglyNamedPrimaryKeyIndex() throws SQLException {
        this.mockGetTableKeysQuery(1, true, false);
        Schema oracleMetaDataProvider = this.oracle.openSchema(this.connection, "TESTDATABASE", "TESTSCHEMA");
        try {
            oracleMetaDataProvider.isEmptyDatabase();
            Assert.fail((String)"Exception expected");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)("Primary Key on table [AREALTABLE] column [dateColumn] backed with an index whose name does not end in _PK [PRIMARY_INDEX_NK]" + System.lineSeparator()));
        }
    }

    @Test
    public void testIfCatchesWronglyNamedPrimaryKeyIndexNull() throws SQLException {
        this.mockGetTableKeysQuery(1, false, true);
        Schema oracleMetaDataProvider = this.oracle.openSchema(this.connection, "TESTDATABASE", "TESTSCHEMA");
        try {
            oracleMetaDataProvider.isEmptyDatabase();
            Assert.fail((String)"Exception expected");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)("Primary Key on table [AREALTABLE] column [dateColumn] backed with an index whose name does not end in _PK [null]" + System.lineSeparator()));
        }
    }

    @Test
    public void testLoadViews() throws SQLException {
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        Mockito.when((Object)this.connection.prepareStatement("SELECT view_name FROM ALL_VIEWS WHERE owner=?")).thenReturn((Object)statement);
        Mockito.when((Object)statement.executeQuery()).thenAnswer((Answer)new ReturnMockResultSet(1, false, false, false));
        Schema oracleMetaDataProvider = this.oracle.openSchema(this.connection, "TESTDATABASE", "TESTSCHEMA");
        Assert.assertEquals((String)"View names", (Object)"[VIEW1]", (Object)oracleMetaDataProvider.viewNames().toString());
        View view = (View)oracleMetaDataProvider.views().iterator().next();
        Assert.assertEquals((String)"View name", (Object)"VIEW1", (Object)view.getName());
        try {
            SelectStatement selectStatement = view.getSelectStatement();
            Assert.fail((String)("Expected UnsupportedOperationException, got " + selectStatement));
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((String)"Message", (Object)"Cannot return SelectStatement as [VIEW1] has been loaded from the database", (Object)e.getMessage());
        }
        try {
            String[] dependencies = view.getDependencies();
            Assert.fail((String)("Expected UnsupportedOperationException, got " + dependencies));
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((String)"Message", (Object)"Cannot return dependencies as [VIEW1] has been loaded from the database", (Object)e.getMessage());
        }
        ((PreparedStatement)Mockito.verify((Object)statement)).setString(1, "TESTSCHEMA");
    }

    @Test
    public void testCloseStatementOnException() throws SQLException {
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        ((PreparedStatement)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("Test")}).when((Object)statement)).setFetchSize(Matchers.anyInt());
        Mockito.when((Object)this.connection.prepareStatement(Matchers.anyString())).thenReturn((Object)statement);
        Mockito.when((Object)statement.executeQuery()).thenAnswer((Answer)new ReturnMockResultSet(1, false, false, false));
        Schema oracleMetaDataProvider = this.oracle.openSchema(this.connection, "TESTDATABASE", "TESTSCHEMA");
        try {
            oracleMetaDataProvider.isEmptyDatabase();
            Assert.fail((String)"Exception expected");
        }
        catch (RuntimeSqlException e) {
            ((PreparedStatement)Mockito.verify((Object)statement)).close();
        }
    }

    @Test
    public void testIgnoreSystemTables() throws SQLException {
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        Mockito.when((Object)this.connection.prepareStatement(Matchers.anyString())).thenReturn((Object)statement);
        this.mockGetTableKeysQuery(0, false, false);
        Mockito.when((Object)statement.executeQuery()).thenAnswer((Answer)new ReturnTablesMockResultSet(1)).thenAnswer((Answer)new ReturnTablesMockResultSet(8));
        Schema oracleMetaDataProvider = this.oracle.openSchema(this.connection, "TESTDATABASE", "TESTSCHEMA");
        Assert.assertEquals((String)"Table names", (Object)"[AREALTABLE]", (Object)oracleMetaDataProvider.tableNames().toString());
        Assert.assertFalse((String)"Table names", (boolean)oracleMetaDataProvider.tableNames().toString().contains("DBMS"));
    }

    @Test
    public void testInvalidIndexHandling() throws Exception {
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        Mockito.when((Object)this.connection.prepareStatement(Matchers.anyString())).thenReturn((Object)statement);
        this.mockGetTableKeysQuery(0, false, false);
        Mockito.when((Object)statement.executeQuery()).thenAnswer((Answer)new ReturnTablesMockResultSet(1)).thenAnswer((Answer)new ReturnTablesMockResultSet(8));
        PreparedStatement statement1 = (PreparedStatement)Mockito.mock(PreparedStatement.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        Mockito.when((Object)this.connection.prepareStatement("select table_name, index_name, uniqueness, status from ALL_INDEXES where owner=? order by table_name, index_name")).thenReturn((Object)statement1);
        Mockito.when((Object)statement1.executeQuery()).thenAnswer(answer -> {
            ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class, (Answer)Mockito.RETURNS_SMART_NULLS);
            Mockito.when((Object)resultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, true, false});
            Mockito.when((Object)resultSet.getString(1)).thenReturn((Object)"AREALTABLE");
            Mockito.when((Object)resultSet.getString(2)).thenReturn((Object)"AREALTABLE_1", (Object[])new String[]{"AREALTABLE_2", "AREALTABLE_3", "AREALTABLE_4"});
            Mockito.when((Object)resultSet.getString(4)).thenReturn((Object)"VALID", (Object[])new String[]{"UNUSABLE", "N/A", "N/A"});
            return resultSet;
        });
        PreparedStatement statement2 = (PreparedStatement)Mockito.mock(PreparedStatement.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        Mockito.when((Object)this.connection.prepareStatement("select index_name, status from ALL_IND_PARTITIONS where index_owner=?")).thenReturn((Object)statement2);
        Mockito.when((Object)statement2.executeQuery()).thenAnswer(answer -> {
            ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class, (Answer)Mockito.RETURNS_SMART_NULLS);
            Mockito.when((Object)resultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, true, false});
            Mockito.when((Object)resultSet.getString(1)).thenReturn((Object)"AREALTABLE_3", (Object[])new String[]{"AREALTABLE_3", "AREALTABLE_4", "AREALTABLE_4"});
            Mockito.when((Object)resultSet.getString(2)).thenReturn((Object)"USABLE", (Object[])new String[]{"USABLE", "UNUSABLE", "USABLE"});
            return resultSet;
        });
        Schema oracleMetaDataProvider = this.oracle.openSchema(this.connection, "TESTDATABASE", "TESTSCHEMA");
        Assert.assertEquals((String)"Table names", (Object)"[AREALTABLE]", (Object)oracleMetaDataProvider.tableNames().toString());
        List indexes = oracleMetaDataProvider.getTable("AREALTABLE").indexes();
        Assert.assertEquals((Object)"AREALTABLE_1", (Object)((Index)indexes.get(0)).getName());
        Assert.assertEquals((Object)"AREALTABLE_2<UNUSABLE>", (Object)((Index)indexes.get(1)).getName());
        Assert.assertEquals((Object)"AREALTABLE_3", (Object)((Index)indexes.get(2)).getName());
        Assert.assertEquals((Object)"AREALTABLE_4<UNUSABLE>", (Object)((Index)indexes.get(3)).getName());
    }

    @Test
    public void testCorrectDataTypeMappingDate() throws SQLException {
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        Mockito.when((Object)this.connection.prepareStatement(Matchers.anyString())).thenReturn((Object)statement);
        this.mockGetTableKeysQuery(1, false, false);
        Mockito.when((Object)statement.executeQuery()).thenAnswer((Answer)new ReturnTablesWithDateColumnMockResultSet(2));
        Schema oracleMetaDataProvider = this.oracle.openSchema(this.connection, "TESTDATABASE", "TESTSCHEMA");
        Assert.assertEquals((String)"Table names", (Object)"[AREALTABLE]", (Object)oracleMetaDataProvider.tableNames().toString());
        Column dateColumn = (Column)Iterables.find((Iterable)oracleMetaDataProvider.getTable("AREALTABLE").columns(), (Predicate)new Predicate<Column>(){

            public boolean apply(Column input) {
                return "dateColumn".equalsIgnoreCase(input.getName());
            }
        });
        Assert.assertEquals((String)"Date column type", (Object)dateColumn.getType(), (Object)DataType.DATE);
    }

    private final PreparedStatement mockGetTableKeysQuery(int numberOfResultRows, boolean failPKConstraintCheck, boolean failNullPKConstraintCheck) throws SQLException {
        String query1 = "SELECT A.TABLE_NAME, A.COLUMN_NAME, C.INDEX_NAME FROM ALL_CONS_COLUMNS A JOIN ALL_CONSTRAINTS C  ON A.CONSTRAINT_NAME = C.CONSTRAINT_NAME AND A.OWNER = C.OWNER and A.TABLE_NAME = C.TABLE_NAME WHERE C.TABLE_NAME not like 'BIN$%' AND C.OWNER=? AND C.CONSTRAINT_TYPE = 'P' ORDER BY A.TABLE_NAME, A.POSITION";
        PreparedStatement statement1 = (PreparedStatement)Mockito.mock(PreparedStatement.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        Mockito.when((Object)this.connection.prepareStatement(query1)).thenReturn((Object)statement1);
        Mockito.when((Object)statement1.executeQuery()).thenAnswer((Answer)new ReturnMockResultSet(numberOfResultRows, true, failPKConstraintCheck, failNullPKConstraintCheck));
        return statement1;
    }

    private static final class ReturnMockResultSet
    implements Answer<ResultSet> {
        private final int numberOfResultRows;
        private final boolean isConstraintQuery;
        private final boolean failPKConstraintCheck;
        private final boolean failNullPKConstraintCheck;

        private ReturnMockResultSet(int numberOfResultRows, boolean isConstraintQuery, boolean failPKConstraintCheck, boolean failNullPKConstraintCheck) {
            this.numberOfResultRows = numberOfResultRows;
            this.isConstraintQuery = isConstraintQuery;
            this.failPKConstraintCheck = failPKConstraintCheck;
            this.failNullPKConstraintCheck = failNullPKConstraintCheck;
        }

        public ResultSet answer(InvocationOnMock invocation) throws Throwable {
            ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class, (Answer)Mockito.RETURNS_SMART_NULLS);
            Mockito.when((Object)resultSet.next()).thenAnswer((Answer)new Answer<Boolean>(){
                private int counter;

                public Boolean answer(InvocationOnMock invocation) throws Throwable {
                    return this.counter++ < numberOfResultRows;
                }
            });
            if (this.isConstraintQuery) {
                Mockito.when((Object)resultSet.getString(1)).thenReturn((Object)"AREALTABLE");
                Mockito.when((Object)resultSet.getString(2)).thenReturn((Object)"dateColumn");
                if (this.failNullPKConstraintCheck) {
                    Mockito.when((Object)resultSet.getString(3)).thenReturn(null);
                } else if (this.failPKConstraintCheck) {
                    Mockito.when((Object)resultSet.getString(3)).thenReturn((Object)"PRIMARY_INDEX_NK");
                } else {
                    Mockito.when((Object)resultSet.getString(3)).thenReturn((Object)"PRIMARY_INDEX_PK");
                }
            } else {
                Mockito.when((Object)resultSet.getString(1)).thenReturn((Object)"VIEW1");
                Mockito.when((Object)resultSet.getString(3)).thenReturn((Object)"SOMEPRIMARYKEYCOLUMN");
            }
            return resultSet;
        }
    }

    private static final class ReturnTablesWithDateColumnMockResultSet
    implements Answer<ResultSet> {
        private final int numberOfResultRows;
        private int counter;

        private ReturnTablesWithDateColumnMockResultSet(int numberOfResultRows) {
            this.numberOfResultRows = numberOfResultRows;
        }

        public ResultSet answer(InvocationOnMock invocation) throws Throwable {
            ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class, (Answer)Mockito.RETURNS_SMART_NULLS);
            Mockito.when((Object)resultSet.next()).thenAnswer((Answer)new Answer<Boolean>(){

                public Boolean answer(InvocationOnMock invocation) throws Throwable {
                    return counter++ < numberOfResultRows;
                }
            });
            Mockito.when((Object)resultSet.getString(1)).thenReturn((Object)"AREALTABLE");
            Mockito.when((Object)resultSet.getString(2)).thenReturn((Object)"TableComment");
            Mockito.when((Object)resultSet.getString(3)).thenReturn((Object)"dateColumn");
            Mockito.when((Object)resultSet.getString(4)).thenReturn((Object)"");
            Mockito.when((Object)resultSet.getString(5)).thenReturn((Object)"DATE");
            Mockito.when((Object)resultSet.getString(6)).thenReturn((Object)"");
            return resultSet;
        }
    }

    private static final class ReturnTablesMockResultSet
    implements Answer<ResultSet> {
        private final int numberOfResultRows;
        private int counter;

        private ReturnTablesMockResultSet(int numberOfResultRows) {
            this.numberOfResultRows = numberOfResultRows;
        }

        public ResultSet answer(InvocationOnMock invocation) throws Throwable {
            ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class, (Answer)Mockito.RETURNS_SMART_NULLS);
            Mockito.when((Object)resultSet.next()).thenAnswer((Answer)new Answer<Boolean>(){

                public Boolean answer(InvocationOnMock invocation) throws Throwable {
                    return counter++ < numberOfResultRows;
                }
            });
            Mockito.when((Object)resultSet.getString(1)).thenReturn((Object)"AREALTABLE").thenReturn((Object)"DBMS_TEST");
            Mockito.when((Object)resultSet.getString(2)).thenReturn((Object)"TableComment");
            Mockito.when((Object)resultSet.getString(3)).thenReturn((Object)"ID");
            Mockito.when((Object)resultSet.getString(4)).thenReturn((Object)"IDComment");
            Mockito.when((Object)resultSet.getString(5)).thenReturn((Object)"VARCHAR2");
            Mockito.when((Object)resultSet.getString(6)).thenReturn((Object)"10");
            return resultSet;
        }
    }
}

