/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.oracle;

import com.google.common.base.Suppliers;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfasoftware.morf.jdbc.DatabaseMetaDataProvider;
import org.alfasoftware.morf.jdbc.DatabaseMetaDataProviderUtils;
import org.alfasoftware.morf.jdbc.RuntimeSqlException;
import org.alfasoftware.morf.metadata.Column;
import org.alfasoftware.morf.metadata.ColumnType;
import org.alfasoftware.morf.metadata.DataType;
import org.alfasoftware.morf.metadata.Index;
import org.alfasoftware.morf.metadata.Schema;
import org.alfasoftware.morf.metadata.SchemaUtils;
import org.alfasoftware.morf.metadata.Table;
import org.alfasoftware.morf.metadata.View;
import org.alfasoftware.morf.sql.SelectStatement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OracleMetaDataProvider
implements Schema {
    private static final Log log = LogFactory.getLog(OracleMetaDataProvider.class);
    private static final Pattern realnameCommentMatcher = Pattern.compile(".*REALNAME:\\[([^\\]]*)\\](/TYPE:\\[([^\\]]*)\\])?.*");
    private Map<String, Table> tableMap;
    private Map<String, View> viewMap;
    private final Connection connection;
    private final String schemaName;

    public OracleMetaDataProvider(Connection connection, String schemaName) {
        this.connection = connection;
        this.schemaName = schemaName.toUpperCase();
    }

    private Map<String, Table> tableMap() {
        if (this.tableMap != null) {
            return this.tableMap;
        }
        this.tableMap = new TreeMap<String, Table>(String.CASE_INSENSITIVE_ORDER);
        this.readTableNames();
        return this.tableMap;
    }

    private Map<String, View> viewMap() {
        if (this.viewMap != null) {
            return this.viewMap;
        }
        this.viewMap = new TreeMap<String, View>(String.CASE_INSENSITIVE_ORDER);
        this.readViewMap();
        return this.viewMap;
    }

    private void readTableNames() {
        log.info((Object)"Starting read of table definitions");
        long start = System.currentTimeMillis();
        final Map<String, List<String>> primaryKeys = this.readTableKeys();
        String getColumnsSql = "select cols.table_name, tabcomments.comments as table_comment, cols.column_name, colcomments.COMMENTS, cols.data_type, cols.char_length, cols.data_length, cols.data_precision, cols.data_scale, cols.nullable, cols.DATA_DEFAULT from ALL_TAB_COLUMNS cols JOIN ALL_TAB_COMMENTS tabcomments ON cols.OWNER = tabcomments.OWNER AND cols.table_name = tabcomments.table_name JOIN ALL_COL_COMMENTS colcomments ON cols.OWNER = colcomments.OWNER AND cols.table_name = colcomments.table_name AND cols.column_name = colcomments.column_name JOIN ALL_TABLES tables on cols.OWNER = tables.OWNER and cols.table_name = tables.table_name where cols.owner=? and cols.table_name not like 'BIN$%' AND tables.TEMPORARY = 'N' order by cols.table_name, cols.column_id";
        this.runSQL("select cols.table_name, tabcomments.comments as table_comment, cols.column_name, colcomments.COMMENTS, cols.data_type, cols.char_length, cols.data_length, cols.data_precision, cols.data_scale, cols.nullable, cols.DATA_DEFAULT from ALL_TAB_COLUMNS cols JOIN ALL_TAB_COMMENTS tabcomments ON cols.OWNER = tabcomments.OWNER AND cols.table_name = tabcomments.table_name JOIN ALL_COL_COMMENTS colcomments ON cols.OWNER = colcomments.OWNER AND cols.table_name = colcomments.table_name AND cols.column_name = colcomments.column_name JOIN ALL_TABLES tables on cols.OWNER = tables.OWNER and cols.table_name = tables.table_name where cols.owner=? and cols.table_name not like 'BIN$%' AND tables.TEMPORARY = 'N' order by cols.table_name, cols.column_id", new ResultSetHandler(){

            @Override
            public void handle(ResultSet resultSet) throws SQLException {
                while (resultSet.next()) {
                    String tableName = resultSet.getString(1);
                    String tableComment = resultSet.getString(2);
                    String columnName = resultSet.getString(3);
                    String columnComment = resultSet.getString(4);
                    String dataTypeName = resultSet.getString(5);
                    if (OracleMetaDataProvider.this.isSystemTable(tableName)) continue;
                    try {
                        Integer dataLength = null;
                        dataLength = dataTypeName.contains("CHAR") ? Integer.valueOf(resultSet.getInt(6)) : Integer.valueOf(resultSet.getInt(7));
                        Integer dataPrecision = resultSet.getString(8) == null ? null : Integer.valueOf(resultSet.getInt(8));
                        Integer dataScale = resultSet.getInt(9);
                        String nullableStr = resultSet.getString(10);
                        String defaultValue = OracleMetaDataProvider.this.determineDefaultValue(columnName);
                        String actualDefaultValue = OracleMetaDataProvider.this.determineActualDefaultValue(resultSet.getString(11));
                        if (!defaultValue.equals(actualDefaultValue)) {
                            log.warn((Object)("DEFAULT value for " + tableName + "." + columnName + " expected to be [" + defaultValue + "], but was [" + actualDefaultValue + "]"));
                        }
                        this.handleTableColumnRow(primaryKeys, tableName, tableComment, columnName, columnComment, dataTypeName, dataLength, dataPrecision, dataScale, nullableStr, defaultValue);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Exception while reading metadata for table [" + tableName + "] column [" + columnName + "] datatype [" + dataTypeName + "]", e);
                    }
                }
            }

            private void handleTableColumnRow(Map<String, List<String>> primaryKeys2, String tableName, String tableComment, String columnName, String columnComment, String dataTypeName, Integer dataLength, Integer dataPrecision, Integer dataScale, String nullableStr, String defaultValue) {
                int autoIncrementFrom;
                Table currentTable;
                Matcher matcher;
                String commentType = null;
                if (tableComment != null && (matcher = realnameCommentMatcher.matcher(tableComment)).matches()) {
                    String tableNameFromComment = matcher.group(1);
                    if (tableNameFromComment.toUpperCase().equals(tableName)) {
                        tableName = tableNameFromComment;
                    } else {
                        throw new RuntimeException("Table name [" + tableNameFromComment + "] in comment does not match oracle table name [" + tableName + "]");
                    }
                }
                if (columnComment != null && (matcher = realnameCommentMatcher.matcher(columnComment)).matches()) {
                    columnName = matcher.group(1);
                    commentType = matcher.group(3);
                }
                if ((currentTable = (Table)OracleMetaDataProvider.this.tableMap.get(tableName)) == null) {
                    currentTable = SchemaUtils.table((String)tableName);
                    OracleMetaDataProvider.this.tableMap.put(tableName, currentTable);
                }
                boolean primaryKey = false;
                List<String> primaryKeyColumns = primaryKeys2.get(tableName.toUpperCase());
                if (primaryKeyColumns != null) {
                    primaryKey = primaryKeyColumns.contains(columnName.toUpperCase());
                }
                boolean isAutoIncrement = (autoIncrementFrom = DatabaseMetaDataProviderUtils.getAutoIncrementStartValue((String)columnComment)) != -1;
                autoIncrementFrom = autoIncrementFrom == -1 ? 0 : autoIncrementFrom;
                currentTable.columns().add(new DeferredTypeColumn(dataTypeName, dataLength, dataPrecision == null ? 0 : dataPrecision, dataScale == null ? 0 : dataScale, commentType, columnName, "Y".equals(nullableStr), primaryKey, isAutoIncrement, autoIncrementFrom, defaultValue));
            }
        });
        for (Map.Entry<String, Table> entry : this.tableMap.entrySet()) {
            List<String> primaryKeysForTable = primaryKeys.get(entry.getKey().toUpperCase());
            if (primaryKeysForTable == null) continue;
            Collections.sort(entry.getValue().columns(), new PrimaryKeyComparator(primaryKeysForTable));
        }
        long pointTwo = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loaded table column list in %dms", pointTwo - start));
            log.debug((Object)("Loading indexes: [" + this.tableMap.size() + "]"));
        }
        com.google.common.base.Supplier indexPartitions = Suppliers.memoize(() -> {
            HashMap result = new HashMap();
            this.runSQL("select index_name, status from ALL_IND_PARTITIONS where index_owner=?", resultSet -> {
                while (resultSet.next()) {
                    result.computeIfAbsent(resultSet.getString(1), k -> new HashSet()).add(resultSet.getString(2));
                }
            });
            return result;
        });
        String getIndexNamesSql = "select table_name, index_name, uniqueness, status from ALL_INDEXES where owner=? order by table_name, index_name";
        this.runSQL("select table_name, index_name, uniqueness, status from ALL_INDEXES where owner=? order by table_name, index_name", new ResultSetHandler((Supplier)indexPartitions){
            final /* synthetic */ Supplier val$indexPartitions;
            {
                this.val$indexPartitions = supplier;
            }

            @Override
            public void handle(ResultSet resultSet) throws SQLException {
                int indexCount = 0;
                while (resultSet.next()) {
                    String tableName = resultSet.getString(1);
                    String indexName = resultSet.getString(2);
                    String uniqueness = resultSet.getString(3);
                    String status = resultSet.getString(4);
                    Table currentTable = (Table)OracleMetaDataProvider.this.tableMap.get(tableName);
                    if (currentTable == null) {
                        log.warn((Object)String.format("Table [%s] was not in the table map - ignoring index [%s]", tableName, indexName));
                        continue;
                    }
                    if (DatabaseMetaDataProviderUtils.shouldIgnoreIndex((String)indexName)) {
                        log.info((Object)("Ignoring index: [" + indexName + "]"));
                        continue;
                    }
                    final boolean unique = "UNIQUE".equals(uniqueness);
                    boolean isValid = OracleMetaDataProvider.this.isValid(status, indexName, this.val$indexPartitions);
                    if (OracleMetaDataProvider.this.isPrimaryKeyIndex(indexName) && isValid) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Ignoring index [%s] on table [%s] as it is a primary key index", indexName, tableName));
                        }
                        if (unique) continue;
                        log.warn((Object)("Primary Key on table [" + tableName + "] is backed by non-unique index [" + indexName + "]"));
                        continue;
                    }
                    if (indexName.toUpperCase().startsWith(currentTable.getName().toUpperCase())) {
                        indexName = currentTable.getName() + indexName.substring(currentTable.getName().length());
                    }
                    if (!isValid) {
                        log.fatal((Object)("Index [" + indexName + "] is not in a valid state"));
                        indexName = indexName + "<UNUSABLE>";
                    }
                    final String indexNameFinal = indexName;
                    currentTable.indexes().add(new Index(){
                        private final List<String> columnNames = new ArrayList<String>();

                        public boolean isUnique() {
                            return unique;
                        }

                        public String getName() {
                            return indexNameFinal;
                        }

                        public List<String> columnNames() {
                            return this.columnNames;
                        }

                        public String toString() {
                            return this.toStringHelper();
                        }
                    });
                    ++indexCount;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Loaded %d indexes", indexCount));
                }
            }
        });
        long pointThree = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loaded index list in %dms", pointThree - pointTwo));
            log.debug((Object)"Loading index columns");
        }
        String getIndexColumnsSql = "select table_name, INDEX_NAME, COLUMN_NAME from ALL_IND_COLUMNS where INDEX_OWNER=? order by table_name, index_name, column_position";
        this.runSQL("select table_name, INDEX_NAME, COLUMN_NAME from ALL_IND_COLUMNS where INDEX_OWNER=? order by table_name, index_name, column_position", new ResultSetHandler(){

            @Override
            public void handle(ResultSet resultSet) throws SQLException {
                while (resultSet.next()) {
                    String tableName = resultSet.getString(1);
                    Table currentTable = (Table)OracleMetaDataProvider.this.tableMap.get(tableName);
                    if (currentTable == null) continue;
                    String indexName = resultSet.getString(2);
                    String columnName = resultSet.getString(3);
                    if (OracleMetaDataProvider.this.isPrimaryKeyIndex(indexName)) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)String.format("Ignoring index [%s] on table [%s] as it is a primary key index", indexName, tableName));
                        continue;
                    }
                    if (DatabaseMetaDataProviderUtils.shouldIgnoreIndex((String)indexName)) continue;
                    Index lastIndex = null;
                    for (Index currentIndex : currentTable.indexes()) {
                        if (!currentIndex.getName().equalsIgnoreCase(indexName)) continue;
                        lastIndex = currentIndex;
                        break;
                    }
                    if (lastIndex == null) {
                        log.warn((Object)String.format("Ignoring index details for index [%s] on table [%s] as no index definition exists", indexName, tableName));
                        continue;
                    }
                    for (Column currentColumn : currentTable.columns()) {
                        if (!currentColumn.getName().equalsIgnoreCase(columnName)) continue;
                        columnName = currentColumn.getName();
                        break;
                    }
                    lastIndex.columnNames().add(columnName);
                }
            }
        });
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loaded index column list in %dms", end - pointThree));
        }
        log.info((Object)String.format("Read table metadata in %dms; %d tables", end - start, this.tableMap.size()));
    }

    private boolean isValid(String status, String indexName, Supplier<Map<String, Set<String>>> indexPartitions) {
        if ("VALID".equals(status) || "true".equals(System.getProperty("org.alfasoftware.morf.jdbc.oracle.OracleMetaDataProvider.disableIndexValidation"))) {
            return true;
        }
        if ("UNUSABLE".equals(status)) {
            return false;
        }
        if (indexPartitions.get().containsKey(indexName)) {
            return !indexPartitions.get().get(indexName).contains("UNUSABLE");
        }
        log.warn((Object)("Unable to determine validity of index [" + indexName + "] based on status [" + status + "]"));
        return false;
    }

    private static DataType dataTypeForColumn(String columnName, String dataTypeName, String commentType) {
        if (StringUtils.isNotEmpty((CharSequence)commentType)) {
            for (DataType dataType : DataType.values()) {
                if (!dataType.toString().equals(commentType)) continue;
                return dataType;
            }
        }
        if ("NVARCHAR2".equals(dataTypeName) || "VARCHAR2".equals(dataTypeName)) {
            return DataType.STRING;
        }
        if ("NUMBER".equals(dataTypeName)) {
            return DataType.DECIMAL;
        }
        if ("BLOB".equals(dataTypeName)) {
            return DataType.BLOB;
        }
        if ("NCLOB".equals(dataTypeName)) {
            return DataType.CLOB;
        }
        if ("DATE".equals(dataTypeName)) {
            return DataType.DATE;
        }
        throw new DatabaseMetaDataProvider.UnexpectedDataTypeException("Unsupported data type [" + dataTypeName + "] in [" + columnName + "]");
    }

    private void readViewMap() {
        log.info((Object)"Starting read of view definitions");
        long start = System.currentTimeMillis();
        String viewsSql = "SELECT view_name FROM ALL_VIEWS WHERE owner=?";
        this.runSQL("SELECT view_name FROM ALL_VIEWS WHERE owner=?", new ResultSetHandler(){

            @Override
            public void handle(ResultSet resultSet) throws SQLException {
                while (resultSet.next()) {
                    final String viewName = resultSet.getString(1);
                    if (OracleMetaDataProvider.this.isSystemTable(viewName)) continue;
                    OracleMetaDataProvider.this.viewMap.put(viewName.toUpperCase(), new View(){

                        public String getName() {
                            return viewName;
                        }

                        public boolean knowsSelectStatement() {
                            return false;
                        }

                        public boolean knowsDependencies() {
                            return false;
                        }

                        public SelectStatement getSelectStatement() {
                            throw new UnsupportedOperationException("Cannot return SelectStatement as [" + viewName + "] has been loaded from the database");
                        }

                        public String[] getDependencies() {
                            throw new UnsupportedOperationException("Cannot return dependencies as [" + viewName + "] has been loaded from the database");
                        }
                    });
                }
            }
        });
        long end = System.currentTimeMillis();
        log.info((Object)String.format("Read view metadata in %dms; %d views", end - start, this.viewMap.size()));
    }

    public boolean isEmptyDatabase() {
        if (this.tableMap != null && !this.tableMap.isEmpty()) {
            return false;
        }
        return this.readTableKeys().isEmpty();
    }

    private Map<String, List<String>> readTableKeys() {
        log.info((Object)"Starting read of key definitions");
        long start = System.currentTimeMillis();
        final HashMap<String, List<String>> primaryKeys = new HashMap<String, List<String>>();
        final StringBuilder primaryKeysWithWrongIndex = new StringBuilder();
        String getConstraintSql = "SELECT A.TABLE_NAME, A.COLUMN_NAME, C.INDEX_NAME FROM ALL_CONS_COLUMNS A JOIN ALL_CONSTRAINTS C  ON A.CONSTRAINT_NAME = C.CONSTRAINT_NAME AND A.OWNER = C.OWNER and A.TABLE_NAME = C.TABLE_NAME WHERE C.TABLE_NAME not like 'BIN$%' AND C.OWNER=? AND C.CONSTRAINT_TYPE = 'P' ORDER BY A.TABLE_NAME, A.POSITION";
        this.runSQL("SELECT A.TABLE_NAME, A.COLUMN_NAME, C.INDEX_NAME FROM ALL_CONS_COLUMNS A JOIN ALL_CONSTRAINTS C  ON A.CONSTRAINT_NAME = C.CONSTRAINT_NAME AND A.OWNER = C.OWNER and A.TABLE_NAME = C.TABLE_NAME WHERE C.TABLE_NAME not like 'BIN$%' AND C.OWNER=? AND C.CONSTRAINT_TYPE = 'P' ORDER BY A.TABLE_NAME, A.POSITION", new ResultSetHandler(){

            @Override
            public void handle(ResultSet resultSet) throws SQLException {
                while (resultSet.next()) {
                    ArrayList<String> columns;
                    String tableName = resultSet.getString(1);
                    String columnName = resultSet.getString(2);
                    String pkIndexName = resultSet.getString(3);
                    if (pkIndexName == null || !pkIndexName.endsWith("_PK")) {
                        primaryKeysWithWrongIndex.append("Primary Key on table [" + tableName + "] column [" + columnName + "] backed with an index whose name does not end in _PK [" + pkIndexName + "]" + System.lineSeparator());
                    }
                    if ((columns = (ArrayList<String>)primaryKeys.get(tableName)) == null) {
                        columns = new ArrayList<String>();
                        primaryKeys.put(tableName, columns);
                    }
                    columns.add(columnName);
                }
            }
        });
        if (primaryKeysWithWrongIndex.length() > 0) {
            throw new RuntimeException(primaryKeysWithWrongIndex.toString());
        }
        long end = System.currentTimeMillis();
        log.info((Object)String.format("Read key metadata in %dms; %d tables", end - start, primaryKeys.size()));
        return primaryKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSQL(String sql, ResultSetHandler handler) {
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            statement.setFetchSize(100);
            statement.setString(1, this.schemaName);
            try (ResultSet resultSet = statement.executeQuery();){
                handler.handle(resultSet);
            }
        }
        catch (SQLException sqle) {
            throw new RuntimeSqlException("Error running SQL: " + sql, sqle);
        }
    }

    private boolean isSystemTable(String tableName) {
        return !tableName.matches("\\w+") || tableName.matches("DBMS_\\w+") || tableName.matches("SYS_\\w+");
    }

    private boolean isPrimaryKeyIndex(String indexName) {
        return indexName.endsWith("_PK");
    }

    public boolean tableExists(String name) {
        return this.tableMap().containsKey(name.toUpperCase());
    }

    public Table getTable(String name) {
        return this.tableMap().get(name.toUpperCase());
    }

    public Collection<String> tableNames() {
        return this.tableMap().keySet();
    }

    public Collection<Table> tables() {
        return this.tableMap().values();
    }

    private String determineDefaultValue(String columnName) {
        if (columnName.equals("VERSION")) {
            return "0";
        }
        return "";
    }

    private String determineActualDefaultValue(String actualDefaultValue) {
        if (actualDefaultValue == null) {
            return "";
        }
        String trimedActualDefaultValue = actualDefaultValue.trim();
        if ("NULL".equalsIgnoreCase(trimedActualDefaultValue)) {
            return "";
        }
        if ("''".equals(trimedActualDefaultValue)) {
            return "";
        }
        return trimedActualDefaultValue;
    }

    public boolean viewExists(String name) {
        return this.viewMap().containsKey(name.toUpperCase());
    }

    public View getView(String name) {
        return this.viewMap().get(name.toUpperCase());
    }

    public Collection<String> viewNames() {
        return this.viewMap().keySet();
    }

    public Collection<View> views() {
        return this.viewMap().values();
    }

    private static final class DeferredTypeColumn
    implements Column {
        private final String columnName;
        private final boolean nullable;
        private final boolean primaryKey;
        private final boolean autoIncrement;
        private final int autoIncrementFrom;
        private final String defaultValue;
        private final com.google.common.base.Supplier<ColumnType> columnType;

        DeferredTypeColumn(String dataTypeName, int dataLength, int precision, int scale, String commentType, String columName, boolean nullable, boolean primaryKey, boolean autoIncrement, int autoIncrementFrom, String defaultValue) {
            this.columnName = columName;
            this.nullable = nullable;
            this.primaryKey = primaryKey;
            this.autoIncrement = autoIncrement;
            this.autoIncrementFrom = autoIncrementFrom;
            this.defaultValue = defaultValue;
            this.columnType = Suppliers.memoize(() -> {
                DataType dataType = OracleMetaDataProvider.dataTypeForColumn(this.columnName, dataTypeName, commentType);
                if (commentType == null && dataType == DataType.DECIMAL) {
                    if (precision == 0) {
                        dataType = DataType.INTEGER;
                    } else if (precision == 19 && this.columnName.equalsIgnoreCase("id")) {
                        dataType = DataType.BIG_INTEGER;
                    }
                }
                return SchemaUtils.type((DataType)dataType, (int)(DataType.STRING == dataType ? dataLength : precision), (int)scale);
            });
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public boolean isAutoNumbered() {
            return this.autoIncrement;
        }

        public String getName() {
            return this.columnName;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public int getAutoNumberStart() {
            return this.autoIncrementFrom;
        }

        public DataType getType() {
            return ((ColumnType)this.columnType.get()).getType();
        }

        public int getWidth() {
            return ((ColumnType)this.columnType.get()).getWidth();
        }

        public int getScale() {
            return ((ColumnType)this.columnType.get()).getScale();
        }

        public String toString() {
            return this.toStringHelper();
        }
    }

    private static final class PrimaryKeyComparator
    implements Comparator<Column> {
        private final List<String> primaryKeysForTable;

        PrimaryKeyComparator(List<String> primaryKeysForTable) {
            this.primaryKeysForTable = primaryKeysForTable;
        }

        @Override
        public int compare(Column o1, Column o2) {
            String col1 = o1.getName().toUpperCase();
            String col2 = o2.getName().toUpperCase();
            if (this.primaryKeysForTable.contains(col1) && this.primaryKeysForTable.contains(col2)) {
                return this.primaryKeysForTable.indexOf(col1) < this.primaryKeysForTable.indexOf(col2) ? -1 : 1;
            }
            if (this.primaryKeysForTable.contains(col1)) {
                return -1;
            }
            if (this.primaryKeysForTable.contains(col2)) {
                return 1;
            }
            return 0;
        }
    }

    private static interface ResultSetHandler {
        public void handle(ResultSet var1) throws SQLException;
    }
}

