/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.postgresql;

import java.sql.Connection;
import java.util.Optional;
import java.util.Stack;
import javax.sql.XADataSource;
import org.alfasoftware.morf.jdbc.AbstractDatabaseType;
import org.alfasoftware.morf.jdbc.JdbcUrlElements;
import org.alfasoftware.morf.jdbc.SqlDialect;
import org.alfasoftware.morf.jdbc.postgresql.PostgreSQLDialect;
import org.alfasoftware.morf.jdbc.postgresql.PostgreSQLMetaDataProvider;
import org.alfasoftware.morf.metadata.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PostgreSQL
extends AbstractDatabaseType {
    private static final Log log = LogFactory.getLog(PostgreSQL.class);
    public static final String IDENTIFIER = "PGSQL";

    public PostgreSQL() {
        super("org.postgresql.Driver", IDENTIFIER);
    }

    public String formatJdbcUrl(JdbcUrlElements jdbcUrlElements) {
        return "jdbc:postgresql://" + jdbcUrlElements.getHostName() + (jdbcUrlElements.getPort() == 0 ? "" : ":" + jdbcUrlElements.getPort()) + "/" + jdbcUrlElements.getDatabaseName();
    }

    public Schema openSchema(Connection connection, String databaseName, String schemaName) {
        return new PostgreSQLMetaDataProvider(connection, schemaName);
    }

    public XADataSource getXADataSource(String jdbcUrl, String username, String password) {
        try {
            log.info((Object)"Initialising PostgreSQL XA data source...");
            XADataSource dataSource = (XADataSource)Class.forName("org.postgresql.xa.PGXADataSource").newInstance();
            dataSource.getClass().getMethod("setURL", String.class).invoke((Object)dataSource, jdbcUrl);
            dataSource.getClass().getMethod("setUser", String.class).invoke((Object)dataSource, username);
            dataSource.getClass().getMethod("setPassword", String.class).invoke((Object)dataSource, password);
            return dataSource;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create PostgreSQL XA data source", e);
        }
    }

    public SqlDialect sqlDialect(String schemaName) {
        return new PostgreSQLDialect(schemaName);
    }

    public boolean matchesProduct(String product) {
        return product.equalsIgnoreCase("PostgreSQL");
    }

    public Optional<JdbcUrlElements> extractJdbcUrl(String url) {
        Stack splitURL = this.splitJdbcUrl(url);
        String scheme = (String)splitURL.pop();
        if (!scheme.equalsIgnoreCase("postgresql")) {
            return Optional.empty();
        }
        if (!((String)splitURL.pop()).equals("://")) {
            throw new IllegalArgumentException("Expected '//' to follow the scheme name in [" + url + "]");
        }
        JdbcUrlElements.Builder connectionDetails = this.extractHostAndPort(splitURL);
        String path = this.extractPath(splitURL);
        connectionDetails.withDatabaseName(path);
        return Optional.of(connectionDetails.build());
    }
}

