/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.postgresql;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.alfasoftware.morf.jdbc.DatabaseType;
import org.alfasoftware.morf.jdbc.NamedParameterPreparedStatement;
import org.alfasoftware.morf.jdbc.SqlDialect;
import org.alfasoftware.morf.metadata.Column;
import org.alfasoftware.morf.metadata.DataType;
import org.alfasoftware.morf.metadata.DataValueLookup;
import org.alfasoftware.morf.metadata.Index;
import org.alfasoftware.morf.metadata.SchemaUtils;
import org.alfasoftware.morf.metadata.Table;
import org.alfasoftware.morf.metadata.View;
import org.alfasoftware.morf.sql.AbstractSelectStatement;
import org.alfasoftware.morf.sql.DeleteStatement;
import org.alfasoftware.morf.sql.DeleteStatementBuilder;
import org.alfasoftware.morf.sql.Hint;
import org.alfasoftware.morf.sql.MergeStatement;
import org.alfasoftware.morf.sql.OptimiseForRowCount;
import org.alfasoftware.morf.sql.ParallelQueryHint;
import org.alfasoftware.morf.sql.PostgreSQLCustomHint;
import org.alfasoftware.morf.sql.SelectFirstStatement;
import org.alfasoftware.morf.sql.SelectStatement;
import org.alfasoftware.morf.sql.SelectStatementBuilder;
import org.alfasoftware.morf.sql.SqlUtils;
import org.alfasoftware.morf.sql.UseImplicitJoinOrder;
import org.alfasoftware.morf.sql.UseIndex;
import org.alfasoftware.morf.sql.element.AliasedField;
import org.alfasoftware.morf.sql.element.AliasedFieldBuilder;
import org.alfasoftware.morf.sql.element.BlobFieldLiteral;
import org.alfasoftware.morf.sql.element.Cast;
import org.alfasoftware.morf.sql.element.ConcatenatedField;
import org.alfasoftware.morf.sql.element.Function;
import org.alfasoftware.morf.sql.element.SqlParameter;
import org.alfasoftware.morf.sql.element.TableReference;
import org.apache.commons.lang3.StringUtils;

class PostgreSQLDialect
extends SqlDialect {
    public PostgreSQLDialect(String schemaName) {
        super(schemaName);
    }

    public DatabaseType getDatabaseType() {
        return DatabaseType.Registry.findByIdentifier((String)"PGSQL");
    }

    public String schemaNamePrefix() {
        String schemaName = this.getSchemaName();
        if (StringUtils.isEmpty((CharSequence)schemaName)) {
            return "";
        }
        return schemaName + ".";
    }

    private String schemaNamePrefix(TableReference tableRef) {
        if (tableRef.isTemporary()) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)tableRef.getSchemaName())) {
            return this.schemaNamePrefix();
        }
        return tableRef.getSchemaName() + ".";
    }

    protected String schemaNamePrefix(Table table) {
        if (table.isTemporary()) {
            return "";
        }
        return this.schemaNamePrefix();
    }

    protected String getDataTypeRepresentation(DataType dataType, int width, int scale) {
        switch (dataType) {
            case STRING: {
                return String.format("VARCHAR(%d)", width);
            }
            case DECIMAL: {
                return String.format("DECIMAL(%d,%d)", width, scale);
            }
            case DATE: {
                return "DATE";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case BIG_INTEGER: {
                return "NUMERIC(19)";
            }
            case INTEGER: {
                return "INTEGER";
            }
            case BLOB: {
                return "BYTEA";
            }
            case CLOB: {
                return "TEXT";
            }
        }
        throw new UnsupportedOperationException("Cannot map column with type [" + dataType + "]");
    }

    protected String getColumnRepresentation(DataType dataType, int width, int scale) {
        if (dataType == DataType.STRING) {
            return this.getDataTypeRepresentation(dataType, width, scale) + " COLLATE \"POSIX\"";
        }
        return this.getDataTypeRepresentation(dataType, width, scale);
    }

    protected String getSqlFrom(Cast cast) {
        if (cast.getDataType() == DataType.STRING) {
            return super.getSqlFrom(cast) + " COLLATE \"POSIX\"";
        }
        return super.getSqlFrom(cast);
    }

    protected Collection<String> internalTableDeploymentStatements(Table table) {
        ArrayList<String> preStatements = new ArrayList<String>();
        ArrayList<String> postStatements = new ArrayList<String>();
        StringBuilder createTableStatement = new StringBuilder();
        createTableStatement.append("CREATE ");
        if (table.isTemporary()) {
            createTableStatement.append("TEMP ");
        }
        createTableStatement.append("TABLE ").append(this.schemaNamePrefix(table)).append(table.getName()).append(" (");
        ArrayList<String> primaryKeys = new ArrayList<String>();
        boolean first = true;
        for (Column column : table.columns()) {
            if (!first) {
                createTableStatement.append(", ");
            }
            createTableStatement.append(column.getName()).append(" ").append(this.sqlRepresentationOfColumnType(column));
            if (column.isAutoNumbered()) {
                int autoNumberStart = column.getAutoNumberStart() == -1 ? 1 : column.getAutoNumberStart();
                String autoNumberSequenceName = this.schemaNamePrefix() + table.getName() + "_" + column.getName() + "_seq";
                preStatements.add("DROP SEQUENCE IF EXISTS " + autoNumberSequenceName);
                preStatements.add("CREATE SEQUENCE " + autoNumberSequenceName + " START " + autoNumberStart);
                createTableStatement.append(" DEFAULT nextval('").append(autoNumberSequenceName).append("')");
                postStatements.add("ALTER SEQUENCE " + autoNumberSequenceName + " OWNED BY " + this.schemaNamePrefix() + table.getName() + "." + column.getName());
            }
            if (column.isPrimaryKey()) {
                primaryKeys.add(column.getName());
            }
            postStatements.add(this.addColumnComment(table, column));
            first = false;
        }
        if (!primaryKeys.isEmpty()) {
            createTableStatement.append(", CONSTRAINT ").append(table.getName()).append("_PK PRIMARY KEY(").append(Joiner.on((String)", ").join(primaryKeys)).append(")");
        }
        createTableStatement.append(")");
        return ImmutableList.builder().addAll(preStatements).add((Object)createTableStatement.toString()).add((Object)this.addTableComment(table)).addAll(postStatements).build();
    }

    private String addTableComment(Table table) {
        return "COMMENT ON TABLE " + this.schemaNamePrefix(table) + table.getName() + " IS '" + "REALNAME" + ":[" + table.getName() + "]'";
    }

    public Collection<String> renameTableStatements(Table from, Table to) {
        ImmutableList renameTable = ImmutableList.of((Object)("ALTER TABLE " + this.schemaNamePrefix(from) + from.getName() + " RENAME TO " + to.getName()));
        ImmutableList renamePk = SchemaUtils.primaryKeysForTable((Table)from).isEmpty() ? ImmutableList.of() : this.renameIndexStatements(from, from.getName() + "_pk", to.getName() + "_pk");
        ImmutableList renameSeq = SchemaUtils.autoNumbersForTable((Table)from).isEmpty() ? ImmutableList.of() : this.renameSequenceStatements(from.getName() + "_seq", to.getName() + "_seq");
        return ImmutableList.builder().addAll((Iterable)renameTable).addAll((Iterable)renamePk).addAll((Iterable)renameSeq).add((Object)this.addTableComment(to)).build();
    }

    public Collection<String> renameIndexStatements(Table table, String fromIndexName, String toIndexName) {
        return ImmutableList.builder().addAll((Iterable)super.renameIndexStatements(table, fromIndexName, toIndexName)).add((Object)this.addIndexComment(toIndexName)).build();
    }

    private Collection<String> renameSequenceStatements(String fromSeqName, String toSeqName) {
        return ImmutableList.of((Object)String.format("ALTER SEQUENCE %s RENAME TO %s", fromSeqName, toSeqName));
    }

    public Collection<String> changePrimaryKeyColumns(Table table, List<String> oldPrimaryKeyColumns, List<String> newPrimaryKeyColumns) {
        ArrayList<String> result = new ArrayList<String>();
        if (!oldPrimaryKeyColumns.isEmpty()) {
            result.add(this.dropPrimaryKeyConstraint(table));
        }
        if (!newPrimaryKeyColumns.isEmpty()) {
            result.add(this.addPrimaryKeyConstraint(table));
        }
        return result;
    }

    public Collection<String> viewDeploymentStatements(View view) {
        return ImmutableList.builder().addAll((Iterable)super.viewDeploymentStatements(view)).add((Object)this.addViewComment(view.getName())).build();
    }

    private String addViewComment(String viewName) {
        return "COMMENT ON VIEW " + viewName + " IS '" + "REALNAME" + ":[" + viewName + "]'";
    }

    public String connectionTestStatement() {
        return "SELECT 1";
    }

    public Collection<String> dropStatements(View view) {
        return ImmutableList.of((Object)("DROP VIEW IF EXISTS " + this.schemaNamePrefix() + view.getName() + " CASCADE"));
    }

    protected String getFromDummyTable() {
        return "";
    }

    protected String getSqlFrom(ConcatenatedField concatenatedField) {
        ArrayList<String> sql = new ArrayList<String>();
        for (AliasedField field : concatenatedField.getConcatenationFields()) {
            sql.add(this.getSqlFrom(field));
        }
        return "CONCAT(" + StringUtils.join(sql, (String)", ") + ")";
    }

    protected String getSqlFrom(BlobFieldLiteral field) {
        return String.format("E'\\x%s'", field.getValue());
    }

    protected String getSqlForDaysBetween(AliasedField toDate, AliasedField fromDate) {
        return "(" + this.getSqlFrom(toDate) + ") - (" + this.getSqlFrom(fromDate) + ")";
    }

    protected String getSqlForMonthsBetween(AliasedField toDate, AliasedField fromDate) {
        String toDateStr = this.getSqlFrom(toDate);
        String fromDateStr = this.getSqlFrom(fromDate);
        return "((EXTRACT(YEAR FROM " + toDateStr + ") - EXTRACT(YEAR FROM " + fromDateStr + ")) * 12 + (EXTRACT(MONTH FROM " + toDateStr + ") - EXTRACT(MONTH FROM " + fromDateStr + ")) + CASE WHEN " + toDateStr + " > " + fromDateStr + " THEN CASE WHEN EXTRACT(DAY FROM " + toDateStr + ") >= EXTRACT(DAY FROM " + fromDateStr + ") THEN 0 WHEN EXTRACT(MONTH FROM " + toDateStr + ") <> EXTRACT(MONTH FROM " + toDateStr + " + 1) THEN 0 ELSE -1 END ELSE CASE WHEN EXTRACT(MONTH FROM " + fromDateStr + ") <> EXTRACT(MONTH FROM " + fromDateStr + " + 1) THEN 0 WHEN EXTRACT(DAY FROM " + fromDateStr + ") >= EXTRACT(DAY FROM " + toDateStr + ") THEN 0 ELSE 1 END END)";
    }

    protected String getSqlForLastDayOfMonth(AliasedField date) {
        return String.format("(DATE_TRUNC('MONTH', (%s)) + INTERVAL '1 MONTH' - INTERVAL '1 DAY') :: DATE", this.getSqlFrom(date));
    }

    protected String getSqlForDateToYyyymmdd(Function function) {
        AliasedField field = (AliasedField)function.getArguments().get(0);
        return "TO_CHAR(" + this.getSqlFrom(field) + ",'YYYYMMDD') :: NUMERIC";
    }

    protected String getSqlForDateToYyyymmddHHmmss(Function function) {
        AliasedField field = (AliasedField)function.getArguments().get(0);
        return "TO_CHAR(" + this.getSqlFrom(field) + ",'YYYYMMDDHH24MISS') :: NUMERIC";
    }

    protected String getSqlForYYYYMMDDToDate(Function function) {
        AliasedField field = (AliasedField)function.getArguments().get(0);
        return "TO_DATE((" + this.getSqlFrom(field) + ") :: TEXT,'YYYYMMDD')";
    }

    protected String getSqlForNow(Function function) {
        return "NOW()";
    }

    protected String getSqlForAddDays(Function function) {
        AliasedField date = (AliasedField)function.getArguments().get(0);
        AliasedField days = (AliasedField)function.getArguments().get(1);
        return String.format("(((%s) + (%s) * INTERVAL '1 DAY') :: DATE)", this.getSqlFrom(date), this.getSqlFrom(days));
    }

    protected String getSqlForAddMonths(Function function) {
        AliasedField date = (AliasedField)function.getArguments().get(0);
        AliasedField months = (AliasedField)function.getArguments().get(1);
        return String.format("(((%s) + (%s) * INTERVAL '1 MONTH') :: DATE)", this.getSqlFrom(date), this.getSqlFrom(months));
    }

    protected String getSqlForRandomString(Function function) {
        String lengthSql = this.getSqlFrom((AliasedField)function.getArguments().get(0));
        String randomString = "MD5(RANDOM() :: TEXT)";
        return "UPPER(SUBSTRING(" + randomString + ", 1, (" + lengthSql + ") :: INT))";
    }

    protected String getSqlForRandom() {
        return "RANDOM()";
    }

    protected String getSqlForRound(Function function) {
        return "ROUND((" + this.getSqlFrom((AliasedField)function.getArguments().get(0)) + ") :: NUMERIC, " + this.getSqlFrom((AliasedField)function.getArguments().get(1)) + ")";
    }

    protected String getSqlFrom(MergeStatement statement) {
        if (StringUtils.isBlank((CharSequence)statement.getTable().getName())) {
            throw new IllegalArgumentException("Cannot create SQL for a blank table");
        }
        this.checkSelectStatementHasNoHints(statement.getSelectStatement(), "MERGE may not be used with SELECT statement hints");
        Iterable destinationFields = Iterables.transform((Iterable)statement.getSelectStatement().getFields(), AliasedField::getImpliedName);
        Iterable updateExpressions = this.getMergeStatementUpdateExpressions(statement);
        String updateExpressionsSql = this.getMergeStatementAssignmentsSql(updateExpressions);
        Iterable keyFields = Iterables.transform((Iterable)statement.getTableUniqueKey(), AliasedField::getImpliedName);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("INSERT INTO ").append(this.tableNameWithSchemaName(statement.getTable())).append(" (").append(Joiner.on((String)", ").join(destinationFields)).append(") ").append(this.getSqlFrom(statement.getSelectStatement())).append(" ON CONFLICT (").append(Joiner.on((String)",").join(keyFields)).append(")");
        if (this.getNonKeyFieldsFromMergeStatement(statement).iterator().hasNext()) {
            sqlBuilder.append(" DO UPDATE SET ").append(updateExpressionsSql);
        } else {
            sqlBuilder.append(" DO NOTHING");
        }
        return sqlBuilder.toString();
    }

    protected String getSqlFrom(MergeStatement.InputField field) {
        return "EXCLUDED." + field.getName();
    }

    protected String getSqlFrom(SelectFirstStatement stmt) {
        StringBuilder result = new StringBuilder("SELECT ");
        result.append(this.getSqlFrom((AliasedField)stmt.getFields().get(0)));
        this.appendFrom(result, (AbstractSelectStatement)stmt);
        this.appendJoins(result, (AbstractSelectStatement)stmt, this.innerJoinKeyword((AbstractSelectStatement)stmt));
        this.appendWhere(result, (AbstractSelectStatement)stmt);
        this.appendOrderBy(result, (AbstractSelectStatement)stmt);
        result.append(" LIMIT 1 OFFSET 0");
        return result.toString().trim();
    }

    protected String selectStatementPreFieldDirectives(SelectStatement selectStatement) {
        StringBuilder builder = new StringBuilder();
        for (Hint hint : selectStatement.getHints()) {
            if (hint instanceof OptimiseForRowCount) {
                // empty if block
            }
            if (hint instanceof UseIndex) {
                UseIndex useIndex = (UseIndex)hint;
                builder.append(" IndexScan(").append(StringUtils.isEmpty((CharSequence)useIndex.getTable().getAlias()) ? useIndex.getTable().getName() : useIndex.getTable().getAlias()).append(" ").append(useIndex.getIndexName().toLowerCase()).append(")");
            }
            if (hint instanceof UseImplicitJoinOrder) {
                // empty if block
            }
            if (hint instanceof ParallelQueryHint) {
                // empty if block
            }
            if (!(hint instanceof PostgreSQLCustomHint)) continue;
            builder.append(" ").append(((PostgreSQLCustomHint)hint).getCustomHint());
        }
        if (builder.length() == 0) {
            return super.selectStatementPreFieldDirectives(selectStatement);
        }
        return "/*+" + builder.append(" */ ").toString();
    }

    public Collection<String> alterTableAddColumnStatements(Table table, Column column) {
        return ImmutableList.of((Object)("ALTER TABLE " + this.schemaNamePrefix(table) + table.getName() + " ADD COLUMN " + column.getName() + " " + this.sqlRepresentationOfColumnType(column, true)), (Object)this.addColumnComment(table, column));
    }

    public Collection<String> getSqlForAnalyseTable(Table table) {
        return ImmutableList.of((Object)("ANALYZE " + this.schemaNamePrefix(table) + table.getName()));
    }

    public Collection<String> alterTableChangeColumnStatements(Table table, Column oldColumn, Column newColumn) {
        boolean alterDefaultValue;
        boolean recreatePrimaryKey;
        ArrayList<String> statements = new ArrayList<String>();
        Table oldTable = this.oldTableForChangeColumn(table, oldColumn, newColumn);
        boolean bl = recreatePrimaryKey = oldColumn.isPrimaryKey() || newColumn.isPrimaryKey();
        if (recreatePrimaryKey && !SchemaUtils.primaryKeysForTable((Table)oldTable).isEmpty()) {
            statements.add(this.dropPrimaryKeyConstraint(table));
        }
        if (oldColumn.isAutoNumbered() && !newColumn.isAutoNumbered()) {
            String autoNumberSequenceName = this.schemaNamePrefix() + table.getName() + "_" + oldColumn.getName() + "_seq";
            statements.add("DROP SEQUENCE IF EXISTS " + autoNumberSequenceName + " CASCADE");
        }
        if (!oldColumn.getName().equalsIgnoreCase(newColumn.getName())) {
            statements.add("ALTER TABLE " + this.schemaNamePrefix(table) + table.getName() + " RENAME " + oldColumn.getName() + " TO " + newColumn.getName());
        }
        boolean alterNullable = oldColumn.isNullable() != newColumn.isNullable();
        boolean alterType = oldColumn.getType() != newColumn.getType() || oldColumn.getScale() != newColumn.getScale() || oldColumn.getWidth() != newColumn.getWidth();
        boolean bl2 = alterDefaultValue = oldColumn.getDefaultValue() != newColumn.getDefaultValue();
        if (alterNullable || alterType || alterDefaultValue) {
            statements.add(this.addAlterTableConstraint(table, newColumn, alterNullable, alterType, alterDefaultValue));
        }
        if (recreatePrimaryKey && !SchemaUtils.primaryKeysForTable((Table)table).isEmpty()) {
            statements.add(this.addPrimaryKeyConstraint(table));
        }
        statements.add(this.addColumnComment(table, newColumn));
        return statements;
    }

    private String addAlterTableConstraint(Table table, Column newColumn, boolean alterNullable, boolean alterType, boolean alterDefaultValue) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("ALTER TABLE " + this.schemaNamePrefix(table) + table.getName() + (alterNullable ? " ALTER COLUMN " + newColumn.getName() + (newColumn.isNullable() ? " DROP NOT NULL" : " SET NOT NULL") : "") + (alterNullable && alterType ? "," : "") + (alterType ? " ALTER COLUMN " + newColumn.getName() + " TYPE " + this.sqlRepresentationOfColumnType(newColumn, false, false, true) : "") + (alterDefaultValue && (alterNullable || alterType) ? "," : "") + (alterDefaultValue ? " ALTER COLUMN " + newColumn.getName() + (!newColumn.getDefaultValue().isEmpty() ? " SET DEFAULT " + this.sqlForDefaultClauseLiteral(newColumn) : " DROP DEFAULT") : ""));
        return sqlBuilder.toString();
    }

    private String addColumnComment(Table table, Column column) {
        StringBuilder comment = new StringBuilder("COMMENT ON COLUMN " + this.schemaNamePrefix(table) + table.getName() + "." + column.getName() + " IS '" + "REALNAME" + ":[" + column.getName() + "]/TYPE:[" + column.getType().toString() + "]");
        if (column.isAutoNumbered()) {
            int autoNumberStart = column.getAutoNumberStart() == -1 ? 1 : column.getAutoNumberStart();
            comment.append("/AUTONUMSTART:[" + autoNumberStart + "]");
        }
        comment.append("'");
        return comment.toString();
    }

    private String dropPrimaryKeyConstraint(Table table) {
        return "ALTER TABLE " + this.schemaNamePrefix(table) + table.getName() + " DROP CONSTRAINT " + table.getName() + "_PK";
    }

    private String addPrimaryKeyConstraint(Table table) {
        return "ALTER TABLE " + this.schemaNamePrefix(table) + table.getName() + " ADD CONSTRAINT " + table.getName() + "_PK PRIMARY KEY(" + Joiner.on((String)", ").join((Iterable)SchemaUtils.namesOfColumns((List)SchemaUtils.primaryKeysForTable((Table)table))) + ")";
    }

    public Collection<String> alterTableDropColumnStatements(Table table, Column column) {
        return ImmutableList.of((Object)("ALTER TABLE " + this.schemaNamePrefix(table) + table.getName() + " DROP COLUMN " + column.getName()));
    }

    protected Collection<String> indexDeploymentStatements(Table table, Index index) {
        StringBuilder statement = new StringBuilder();
        statement.append("CREATE ");
        if (index.isUnique()) {
            statement.append("UNIQUE ");
        }
        statement.append("INDEX ").append(index.getName()).append(" ON ").append(this.schemaNamePrefix(table)).append(table.getName()).append(" (").append(Joiner.on((String)", ").join((Iterable)index.columnNames())).append(")");
        return ImmutableList.builder().add((Object)statement.toString()).add((Object)this.addIndexComment(index.getName())).build();
    }

    private String addIndexComment(String indexName) {
        return "COMMENT ON INDEX " + indexName + " IS '" + "REALNAME" + ":[" + indexName + "]'";
    }

    public void prepareStatementParameters(NamedParameterPreparedStatement statement, DataValueLookup values, SqlParameter parameter) throws SQLException {
        switch (parameter.getMetadata().getType()) {
            case BLOB: {
                byte[] blobVal = values.getByteArray(parameter.getImpliedName());
                if (blobVal == null) {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
                    statement.setBinaryStream(parameter, (InputStream)inputStream);
                } else {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(blobVal);
                    statement.setBinaryStream(parameter, (InputStream)inputStream);
                }
                return;
            }
        }
        super.prepareStatementParameters(statement, values, parameter);
    }

    protected String getSqlFrom(Boolean literalValue) {
        return literalValue != false ? "TRUE" : "FALSE";
    }

    protected String getSqlForSome(Function function) {
        return "BOOL_OR(" + this.getSqlFrom((AliasedField)function.getArguments().get(0)) + ")";
    }

    protected String getSqlForEvery(Function function) {
        return "BOOL_AND(" + this.getSqlFrom((AliasedField)function.getArguments().get(0)) + ")";
    }

    protected String getSqlFrom(DeleteStatement statement) {
        if (!statement.getLimit().isPresent()) {
            return super.getSqlFrom(statement);
        }
        StringBuilder sqlBuilder = new StringBuilder();
        DeleteStatementBuilder deleteStatement = DeleteStatement.delete((TableReference)statement.getTable());
        sqlBuilder.append(super.getSqlFrom(deleteStatement.build()));
        sqlBuilder.append(" WHERE ctid IN (");
        SelectStatementBuilder selectStatement = (SelectStatementBuilder)((SelectStatementBuilder)SelectStatement.select((AliasedFieldBuilder[])new AliasedFieldBuilder[0]).fields(new AliasedFieldBuilder[]{SqlUtils.field((String)"ctid")})).from(statement.getTable());
        if (statement.getWhereCriterion() != null) {
            selectStatement = (SelectStatementBuilder)selectStatement.where(statement.getWhereCriterion());
        }
        sqlBuilder.append(this.getSqlFrom(selectStatement.build()));
        sqlBuilder.append(" LIMIT " + statement.getLimit().get() + ")");
        return sqlBuilder.toString();
    }

    protected String tableNameWithSchemaName(TableReference tableRef) {
        if (StringUtils.isEmpty((CharSequence)tableRef.getDblink())) {
            return this.schemaNamePrefix(tableRef) + tableRef.getName();
        }
        return tableRef.getDblink() + "." + tableRef.getName();
    }
}

