/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.postgresql;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfasoftware.morf.jdbc.DatabaseMetaDataProvider;
import org.alfasoftware.morf.jdbc.DatabaseMetaDataProviderUtils;
import org.alfasoftware.morf.jdbc.RuntimeSqlException;
import org.alfasoftware.morf.metadata.DataType;
import org.alfasoftware.morf.metadata.SchemaUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PostgreSQLMetaDataProvider
extends DatabaseMetaDataProvider {
    private static final Log log = LogFactory.getLog(PostgreSQLMetaDataProvider.class);
    private static final Pattern REALNAME_COMMENT_MATCHER = Pattern.compile(".*REALNAME:\\[([^\\]]*)\\](/TYPE:\\[([^\\]]*)\\])?.*");
    private final Supplier<Map<DatabaseMetaDataProvider.AName, DatabaseMetaDataProvider.RealName>> allIndexNames = Suppliers.memoize(this::loadAllIndexNames);

    public PostgreSQLMetaDataProvider(Connection connection, String schemaName) {
        super(connection, schemaName);
    }

    protected boolean isPrimaryKeyIndex(DatabaseMetaDataProvider.RealName indexName) {
        return indexName.getDbName().endsWith("_pk");
    }

    protected DataType dataTypeFromSqlType(int sqlType, String typeName, int width) {
        if (sqlType == 12) {
            if (typeName.equals("text")) {
                return DataType.CLOB;
            }
            return super.dataTypeFromSqlType(sqlType, typeName, width);
        }
        return super.dataTypeFromSqlType(sqlType, typeName, width);
    }

    protected SchemaUtils.ColumnBuilder setAdditionalColumnMetadata(DatabaseMetaDataProvider.RealName tableName, SchemaUtils.ColumnBuilder columnBuilder, ResultSet columnMetaData) throws SQLException {
        Optional dataTypeComment;
        if ((columnBuilder = super.setAdditionalColumnMetadata(tableName, columnBuilder, columnMetaData)).isAutoNumbered()) {
            int startValue = DatabaseMetaDataProviderUtils.getAutoIncrementStartValue((String)columnMetaData.getString(12));
            columnBuilder = columnBuilder.autoNumbered(startValue == -1 ? 1 : startValue);
        }
        if ((dataTypeComment = DatabaseMetaDataProviderUtils.getDataTypeFromColumnComment((String)columnMetaData.getString(12))).isPresent() && ((String)dataTypeComment.get()).equals("BIG_INTEGER")) {
            columnBuilder = columnBuilder.dataType(DataType.BIG_INTEGER);
        }
        return columnBuilder;
    }

    protected DatabaseMetaDataProvider.RealName readColumnName(ResultSet columnResultSet) throws SQLException {
        String columnName = columnResultSet.getString(4);
        String comment = columnResultSet.getString(12);
        String realName = this.matchComment(comment);
        return StringUtils.isNotBlank((CharSequence)realName) ? PostgreSQLMetaDataProvider.createRealName((String)columnName, (String)realName) : super.readColumnName(columnResultSet);
    }

    protected DatabaseMetaDataProvider.RealName readTableName(ResultSet tableResultSet) throws SQLException {
        String tableName = tableResultSet.getString(3);
        String comment = tableResultSet.getString(5);
        String realName = this.matchComment(comment);
        return StringUtils.isNotBlank((CharSequence)realName) ? PostgreSQLMetaDataProvider.createRealName((String)tableName, (String)realName) : super.readTableName(tableResultSet);
    }

    protected DatabaseMetaDataProvider.RealName readViewName(ResultSet viewResultSet) throws SQLException {
        String viewName = viewResultSet.getString(3);
        String comment = viewResultSet.getString(5);
        String realName = this.matchComment(comment);
        return StringUtils.isNotBlank((CharSequence)realName) ? PostgreSQLMetaDataProvider.createRealName((String)viewName, (String)realName) : super.readViewName(viewResultSet);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Map<DatabaseMetaDataProvider.AName, DatabaseMetaDataProvider.RealName> loadAllIndexNames() {
        ImmutableMap.Builder indexNames = ImmutableMap.builder();
        String schema = StringUtils.isNotBlank((CharSequence)this.schemaName) ? " JOIN pg_catalog.pg_namespace n ON n.oid = ci.relnamespace AND n.nspname = '" + this.schemaName + "'" : "";
        String sql = "SELECT ci.relname AS indexName, d.description AS indexRemark FROM pg_catalog.pg_index i JOIN pg_catalog.pg_class ci ON ci.oid = i.indexrelid" + schema + " JOIN pg_description d ON d.objoid = ci.oid";
        try (Statement createStatement = this.connection.createStatement(1003, 1007);){
            ImmutableMap immutableMap;
            block16: {
                ResultSet indexResultSet = createStatement.executeQuery(sql);
                try {
                    while (indexResultSet.next()) {
                        String indexName = indexResultSet.getString(1);
                        String comment = indexResultSet.getString(2);
                        String realName = this.matchComment(comment);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Found index [" + indexName + "] with remark [" + comment + "] parsed as [" + realName + "] in schema [" + this.schemaName + "]"));
                        }
                        if (!StringUtils.isNotBlank((CharSequence)realName)) continue;
                        DatabaseMetaDataProvider.RealName realIndexName = PostgreSQLMetaDataProvider.createRealName((String)indexName, (String)realName);
                        indexNames.put((Object)realIndexName, (Object)realIndexName);
                    }
                    immutableMap = indexNames.build();
                    if (indexResultSet == null) break block16;
                }
                catch (Throwable throwable) {
                    if (indexResultSet != null) {
                        try {
                            indexResultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                indexResultSet.close();
            }
            return immutableMap;
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    protected DatabaseMetaDataProvider.RealName readIndexName(ResultSet indexResultSet) throws SQLException {
        DatabaseMetaDataProvider.RealName readIndexName = super.readIndexName(indexResultSet);
        return this.allIndexNames.get().getOrDefault(readIndexName, readIndexName);
    }

    private String matchComment(String comment) {
        Matcher matcher;
        if (StringUtils.isNotBlank((CharSequence)comment) && (matcher = REALNAME_COMMENT_MATCHER.matcher(comment)).matches()) {
            return matcher.group(1);
        }
        return null;
    }
}

