/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.pipeline;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import org.allenai.pipeline.Artifact;
import org.allenai.pipeline.S3Artifact;
import org.allenai.pipeline.S3Config;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class S3Artifact$class {
    public static URI url(S3Artifact $this) {
        return new URI("s3", $this.bucket(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.path()})), null);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean exists(S3Artifact $this) {
        Throwable throwable;
        Throwable throwable22;
        block3: {
            void var1_6;
            boolean bl;
            try {
                ObjectMetadata resp = $this.service().getObjectMetadata($this.bucket(), $this.path());
                bl = true;
            }
            catch (Throwable throwable22) {
                boolean bl2;
                AmazonServiceException amazonServiceException;
                throwable = throwable22;
                if (!(throwable instanceof AmazonServiceException) || (amazonServiceException = (AmazonServiceException)throwable).getStatusCode() != 404) break block3;
                bl = bl2 = false;
            }
            boolean result = bl;
            return (boolean)var1_6;
        }
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            throw exception;
        }
        throw throwable22;
    }

    public static String contentType(S3Artifact $this) {
        return (String)$this.contentTypeOverride().getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Artifact $outer;

            public final String apply() {
                return this.$outer.defaultContentType();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static String defaultContentType(S3Artifact $this) {
        String string = $this.path();
        String string2 = string.endsWith(".html") ? "text/html" : (string.endsWith(".txt") ? "text/plain" : (string.endsWith(".json") ? "application/json" : "application/octet-stream"));
        return string2;
    }

    public static void upload(S3Artifact $this, File file) {
        $this.logger().debug((Function0)new Serializable($this, file){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Artifact $outer;
            private final File file$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Uploading ", " to ", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1, this.$outer.bucket(), this.$outer.path()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.file$1 = file$1;
            }
        });
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType($this.contentType());
        PutObjectRequest request = new PutObjectRequest($this.bucket(), $this.path(), file).withMetadata(metadata);
        request.setCannedAcl(CannedAccessControlList.PublicRead);
        $this.service().putObject(request);
    }

    public static Artifact getCachedArtifact(S3Artifact $this) {
        Option option;
        block6: {
            Artifact artifact;
            block5: {
                block4: {
                    Artifact f;
                    option = $this.cachedFile();
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    artifact = f = (Artifact)some.x();
                    break block5;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                File f = new File(System.getProperty("java.io.tmpdir"), "pipeline-cache");
                Object object = f.exists() && !f.isDirectory() ? BoxesRunTime.boxToBoolean((boolean)f.delete()) : BoxedUnit.UNIT;
                Object object2 = f.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)f.mkdirs());
                File cacheDir = f;
                Predef$.MODULE$.require(cacheDir.exists() && cacheDir.isDirectory(), (Function0)new Serializable($this, cacheDir){
                    public static final long serialVersionUID = 0L;
                    private final File cacheDir$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to create cache directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cacheDir$1.getCanonicalPath()}));
                    }
                    {
                        this.cacheDir$1 = cacheDir$1;
                    }
                });
                File downloadFile = new File(cacheDir, $this.path().replaceAll("/", "\\$"));
                if ($this.exists() && !downloadFile.exists()) {
                    $this.logger().debug((Function0)new Serializable($this, downloadFile){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ S3Artifact $outer;
                        private final File downloadFile$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downloading ", "/", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.bucket(), this.$outer.path(), this.downloadFile$1}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.downloadFile$1 = downloadFile$1;
                        }
                    });
                    File tmpFile = File.createTempFile(downloadFile.getName(), "tmp", downloadFile.getParentFile());
                    tmpFile.deleteOnExit();
                    FileOutputStream os = new FileOutputStream(tmpFile);
                    S3ObjectInputStream is = $this.service().getObject($this.bucket(), $this.path()).getObjectContent();
                    byte[] buffer = new byte[$this.org$allenai$pipeline$S3Artifact$$BUFFER_SIZE()];
                    package$.MODULE$.Iterator().continually((Function0)new Serializable($this, is, buffer){
                        public static final long serialVersionUID = 0L;
                        private final S3ObjectInputStream is$1;
                        private final byte[] buffer$1;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return this.is$1.read(this.buffer$1);
                        }
                        {
                            void var3_3;
                            this.is$1 = is$1;
                            this.buffer$1 = var3_3;
                        }
                    }).takeWhile((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(int x$2) {
                            return this.apply$mcZI$sp(x$2);
                        }

                        public boolean apply$mcZI$sp(int x$2) {
                            return x$2 != -1;
                        }
                    }).foreach((Function1)new Serializable($this, os, buffer){
                        public static final long serialVersionUID = 0L;
                        private final FileOutputStream os$1;
                        private final byte[] buffer$1;

                        public final void apply(int n) {
                            this.apply$mcVI$sp(n);
                        }

                        public void apply$mcVI$sp(int n) {
                            this.os$1.write(this.buffer$1, 0, n);
                        }
                        {
                            void var3_3;
                            this.os$1 = os$1;
                            this.buffer$1 = var3_3;
                        }
                    });
                    is.close();
                    os.close();
                    Predef$.MODULE$.require(tmpFile.renameTo(downloadFile), (Function0)new Serializable($this, downloadFile){
                        public static final long serialVersionUID = 0L;
                        private final File downloadFile$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to create download file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.downloadFile$1.getCanonicalPath()}));
                        }
                        {
                            this.downloadFile$1 = downloadFile$1;
                        }
                    });
                }
                $this.cachedFile_$eq(new Some($this.makeLocalArtifact(downloadFile)));
                artifact = (Artifact)$this.cachedFile().get();
            }
            return artifact;
        }
        throw new MatchError(option);
    }

    public static void $init$(S3Artifact $this) {
        S3Config s3Config = $this.config();
        if (s3Config != null) {
            AmazonS3Client service = s3Config.service();
            String bucket = s3Config.bucket();
            Tuple2 tuple2 = new Tuple2((Object)service, (Object)bucket);
            $this.org$allenai$pipeline$S3Artifact$_setter_$org$allenai$pipeline$S3Artifact$$x$1_$eq(tuple2);
            $this.org$allenai$pipeline$S3Artifact$_setter_$service_$eq((AmazonS3Client)$this.org$allenai$pipeline$S3Artifact$$x$1()._1());
            $this.org$allenai$pipeline$S3Artifact$_setter_$bucket_$eq((String)$this.org$allenai$pipeline$S3Artifact$$x$1()._2());
            $this.cachedFile_$eq(None$.MODULE$);
            $this.org$allenai$pipeline$S3Artifact$_setter_$org$allenai$pipeline$S3Artifact$$BUFFER_SIZE_$eq(0x100000);
            return;
        }
        throw new MatchError((Object)s3Config);
    }
}

