/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.nlpstack.parse.poly.polyparser;

import org.allenai.nlpstack.parse.poly.core.BrownClustersTaggerInitializer;
import org.allenai.nlpstack.parse.poly.core.FactoriePostaggerInitializer;
import org.allenai.nlpstack.parse.poly.core.KeywordTaggerInitializer;
import org.allenai.nlpstack.parse.poly.core.LexicalPropertiesTaggerInitializer$;
import org.allenai.nlpstack.parse.poly.core.SentenceTaggerInitializer;
import org.allenai.nlpstack.parse.poly.core.StanfordPostaggerInitializer;
import org.allenai.nlpstack.parse.poly.core.TokenPositionTaggerInitializer$;
import org.allenai.nlpstack.parse.poly.core.WordClusters$;
import org.allenai.nlpstack.parse.poly.decisiontree.OmnibusTrainer;
import org.allenai.nlpstack.parse.poly.fsm.BaseCostRerankingFunction$;
import org.allenai.nlpstack.parse.poly.fsm.DTCostFunctionTrainer;
import org.allenai.nlpstack.parse.poly.fsm.SculptureTrainingVectorSource;
import org.allenai.nlpstack.parse.poly.fsm.StateCostFunctionFactory;
import org.allenai.nlpstack.parse.poly.ml.BrownClusters;
import org.allenai.nlpstack.parse.poly.ml.BrownClusters$;
import org.allenai.nlpstack.parse.poly.polyparser.ArcHybridTransitionSystemFactory;
import org.allenai.nlpstack.parse.poly.polyparser.ConllX;
import org.allenai.nlpstack.parse.poly.polyparser.ConllX$;
import org.allenai.nlpstack.parse.poly.polyparser.InMemoryPolytreeParseSource$;
import org.allenai.nlpstack.parse.poly.polyparser.MultiPolytreeParseSource;
import org.allenai.nlpstack.parse.poly.polyparser.ParseFile$;
import org.allenai.nlpstack.parse.poly.polyparser.ParserConfiguration;
import org.allenai.nlpstack.parse.poly.polyparser.ParserTrainingConfig;
import org.allenai.nlpstack.parse.poly.polyparser.ParserTrainingConfig$;
import org.allenai.nlpstack.parse.poly.polyparser.PolytreeParseSource;
import org.allenai.nlpstack.parse.poly.polyparser.RerankingTransitionParser;
import org.allenai.nlpstack.parse.poly.polyparser.Training$;
import org.allenai.nlpstack.parse.poly.polyparser.TransitionParser$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Symbol;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scopt.OptionParser;
import scopt.Read$;

public final class Training$ {
    public static final Training$ MODULE$;

    static {
        new Training$();
    }

    public void main(String[] args) {
        Seq seq;
        OptionParser<ParserTrainingConfig> optionParser = new OptionParser<ParserTrainingConfig>(){
            {
                this.opt('t', "train", Read$.MODULE$.stringRead()).required().valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ParserTrainingConfig apply(String x, ParserTrainingConfig c) {
                        String x$2 = x;
                        Option<String> x$3 = c.copy$default$1();
                        Option<String> x$4 = c.copy$default$2();
                        String x$5 = c.copy$default$4();
                        String x$6 = c.copy$default$5();
                        String x$7 = c.copy$default$6();
                        return c.copy(x$3, x$4, x$2, x$5, x$6, x$7);
                    }
                }).text("the path to the training files (in ConllX format, comma-separated filenames)");
                this.opt('c', "clusters", Read$.MODULE$.stringRead()).valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ParserTrainingConfig apply(String x, ParserTrainingConfig c) {
                        return c.copy((Option<String>)new Some((Object)x), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6());
                    }
                }).text("the path to the Brown cluster files (in Liang format, comma-separated filenames)");
                this.opt('n', "feature-taggers-config", Read$.MODULE$.stringRead()).valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ParserTrainingConfig apply(String x, ParserTrainingConfig c) {
                        Some x$8 = new Some((Object)x);
                        Option<String> x$9 = c.copy$default$1();
                        String x$10 = c.copy$default$3();
                        String x$11 = c.copy$default$4();
                        String x$12 = c.copy$default$5();
                        String x$13 = c.copy$default$6();
                        return c.copy(x$9, (Option<String>)x$8, x$10, x$11, x$12, x$13);
                    }
                }).text("the path to a config filecontaining config information required for the required taggers. Currently containsdatastore location info to access Verbnet resources for the Verbnet tagger.");
                this.opt('o', "output", Read$.MODULE$.stringRead()).required().valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ParserTrainingConfig apply(String x, ParserTrainingConfig c) {
                        String x$14 = x;
                        Option<String> x$15 = c.copy$default$1();
                        Option<String> x$16 = c.copy$default$2();
                        String x$17 = c.copy$default$3();
                        String x$18 = c.copy$default$5();
                        String x$19 = c.copy$default$6();
                        return c.copy(x$15, x$16, x$17, x$14, x$18, x$19);
                    }
                }).text("where to direct the output files");
                this.opt('x', "test", Read$.MODULE$.stringRead()).required().valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ParserTrainingConfig apply(String x, ParserTrainingConfig c) {
                        String x$20 = x;
                        Option<String> x$21 = c.copy$default$1();
                        Option<String> x$22 = c.copy$default$2();
                        String x$23 = c.copy$default$3();
                        String x$24 = c.copy$default$4();
                        String x$25 = c.copy$default$6();
                        return c.copy(x$21, x$22, x$23, x$24, x$20, x$25);
                    }
                }).text("the path to the test file (in ConllX format)");
                this.opt('d', "datasource", Read$.MODULE$.stringRead()).required().valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ParserTrainingConfig apply(String x, ParserTrainingConfig c) {
                        String x$26 = x;
                        Option<String> x$27 = c.copy$default$1();
                        Option<String> x$28 = c.copy$default$2();
                        String x$29 = c.copy$default$3();
                        String x$30 = c.copy$default$4();
                        String x$31 = c.copy$default$5();
                        return c.copy(x$27, x$28, x$29, x$30, x$31, x$26);
                    }
                }).text("the location of the data ('datastore','local')").validate((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Either<String, BoxedUnit> apply(String x) {
                        return ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"datastore", "local"}))).contains((Object)x) ? this.$outer.success() : this.$outer.failure("unsupported input format");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
        };
        ParserTrainingConfig trainingConfig = (ParserTrainingConfig)optionParser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new ParserTrainingConfig(ParserTrainingConfig$.MODULE$.apply$default$1(), ParserTrainingConfig$.MODULE$.apply$default$2(), ParserTrainingConfig$.MODULE$.apply$default$3(), ParserTrainingConfig$.MODULE$.apply$default$4(), ParserTrainingConfig$.MODULE$.apply$default$5(), ParserTrainingConfig$.MODULE$.apply$default$6())).get();
        MultiPolytreeParseSource trainingSource = new MultiPolytreeParseSource((Iterable<PolytreeParseSource>)((Iterable)Predef$.MODULE$.refArrayOps((Object[])trainingConfig.trainingPath().split(",")).map((Function1)new Serializable(trainingConfig){
            public static final long serialVersionUID = 0L;
            private final ParserTrainingConfig trainingConfig$1;

            public final PolytreeParseSource apply(String path) {
                return InMemoryPolytreeParseSource$.MODULE$.getParseSource(path, new ConllX(true, ConllX$.MODULE$.apply$default$2()), this.trainingConfig$1.dataSource());
            }
            {
                this.trainingConfig$1 = trainingConfig$1;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
        Option<String> option = trainingConfig.clustersPath();
        if (option instanceof Some) {
            Some some = (Some)option;
            String clustersPath = (String)some.x();
            seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])clustersPath.split(",")).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BrownClusters apply(String path) {
                    return BrownClusters$.MODULE$.fromLiangFormat(path);
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        Seq clusters = seq;
        Set keywords = (Set)WordClusters$.MODULE$.keyWords().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Symbol x$1) {
                return x$1.toString();
            }
        }, Set$.MODULE$.canBuildFrom());
        Seq taggers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{LexicalPropertiesTaggerInitializer$.MODULE$, TokenPositionTaggerInitializer$.MODULE$, new KeywordTaggerInitializer((Set<String>)keywords), new BrownClustersTaggerInitializer((Seq<BrownClusters>)clusters), new FactoriePostaggerInitializer(true), new StanfordPostaggerInitializer(true), new FactoriePostaggerInitializer(false), new StanfordPostaggerInitializer(false)}));
        ArcHybridTransitionSystemFactory transitionSystemFactory = new ArcHybridTransitionSystemFactory((Seq<SentenceTaggerInitializer>)taggers);
        Predef$.MODULE$.println((Object)"Training parser.");
        OmnibusTrainer classifierTrainer = new OmnibusTrainer();
        SculptureTrainingVectorSource trainingVectorSource = new SculptureTrainingVectorSource(trainingSource, transitionSystemFactory, (Option<StateCostFunctionFactory>)None$.MODULE$);
        DTCostFunctionTrainer trainer = new DTCostFunctionTrainer(classifierTrainer, transitionSystemFactory, trainingVectorSource, (Option<StateCostFunctionFactory>)None$.MODULE$);
        StateCostFunctionFactory parsingCostFunctionFactory = trainer.costFunctionFactory();
        int parsingNbestSize = 5;
        ParserConfiguration parserConfig = new ParserConfiguration(parsingCostFunctionFactory, BaseCostRerankingFunction$.MODULE$, parsingNbestSize);
        RerankingTransitionParser parser = new RerankingTransitionParser(parserConfig);
        Predef$.MODULE$.println((Object)"Saving models.");
        TransitionParser$.MODULE$.save(parser, trainingConfig.outputPath());
        ParseFile$.MODULE$.fullParseEvaluation(parser, trainingConfig.testPath(), new ConllX(true, ConllX$.MODULE$.apply$default$2()), trainingConfig.dataSource(), 0);
    }

    private Training$() {
        MODULE$ = this;
    }
}

