/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.nlpstack.parse.poly.reranking;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import org.allenai.common.Config;
import org.allenai.common.Config$;
import org.allenai.nlpstack.parse.poly.core.Token;
import org.allenai.nlpstack.parse.poly.core.WordClusters$;
import org.allenai.nlpstack.parse.poly.fsm.RerankingFunction;
import org.allenai.nlpstack.parse.poly.fsm.RerankingFunction$;
import org.allenai.nlpstack.parse.poly.ml.FeatureVector;
import org.allenai.nlpstack.parse.poly.ml.TrainingData;
import org.allenai.nlpstack.parse.poly.ml.Verbnet;
import org.allenai.nlpstack.parse.poly.ml.WrapperClassifier;
import org.allenai.nlpstack.parse.poly.polyparser.ConllX;
import org.allenai.nlpstack.parse.poly.polyparser.InMemoryParsePoolSource;
import org.allenai.nlpstack.parse.poly.polyparser.InMemoryPolytreeParseSource$;
import org.allenai.nlpstack.parse.poly.polyparser.Neighborhood;
import org.allenai.nlpstack.parse.poly.polyparser.ParseFile$;
import org.allenai.nlpstack.parse.poly.polyparser.ParsePool;
import org.allenai.nlpstack.parse.poly.polyparser.ParsePoolSource;
import org.allenai.nlpstack.parse.poly.polyparser.PolytreeParse;
import org.allenai.nlpstack.parse.poly.polyparser.PolytreeParseSource;
import org.allenai.nlpstack.parse.poly.polyparser.TransitionParser;
import org.allenai.nlpstack.parse.poly.polyparser.TransitionParser$;
import org.allenai.nlpstack.parse.poly.reranking.AllChildrenExtractor$;
import org.allenai.nlpstack.parse.poly.reranking.ArclabelNhTransform$;
import org.allenai.nlpstack.parse.poly.reranking.CardinalityNhTransform$;
import org.allenai.nlpstack.parse.poly.reranking.DirectionNhTransform$;
import org.allenai.nlpstack.parse.poly.reranking.EachChildExtractor$;
import org.allenai.nlpstack.parse.poly.reranking.EachParentExtractor$;
import org.allenai.nlpstack.parse.poly.reranking.KeywordNhTransform;
import org.allenai.nlpstack.parse.poly.reranking.NeighborhoodExtractor;
import org.allenai.nlpstack.parse.poly.reranking.NeighborhoodTransform;
import org.allenai.nlpstack.parse.poly.reranking.PRTCommandLine;
import org.allenai.nlpstack.parse.poly.reranking.PRTCommandLine$;
import org.allenai.nlpstack.parse.poly.reranking.ParseNodeFeature;
import org.allenai.nlpstack.parse.poly.reranking.ParseNodeFeatureUnion;
import org.allenai.nlpstack.parse.poly.reranking.ParseRerankerTraining$;
import org.allenai.nlpstack.parse.poly.reranking.ParseRerankerTraining$$anonfun$10$$anonfun$apply$3$;
import org.allenai.nlpstack.parse.poly.reranking.ParseRerankerTraining$$anonfun$10$$anonfun$apply$3$$anonfun$apply$4$;
import org.allenai.nlpstack.parse.poly.reranking.ParseRerankerTraining$$anonfun$13$;
import org.allenai.nlpstack.parse.poly.reranking.PropertyNhTransform;
import org.allenai.nlpstack.parse.poly.reranking.RerankingFunctionTrainer;
import org.allenai.nlpstack.parse.poly.reranking.SelfAndSpecificChildExtractor;
import org.allenai.nlpstack.parse.poly.reranking.SelfAndSpecificParentExtractor;
import org.allenai.nlpstack.parse.poly.reranking.SelfExtractor$;
import org.allenai.nlpstack.parse.poly.reranking.SpecificChildExtractor;
import org.allenai.nlpstack.parse.poly.reranking.SpecificParentExtractor;
import org.allenai.nlpstack.parse.poly.reranking.SuffixNhTransform;
import org.allenai.nlpstack.parse.poly.reranking.TransformedNeighborhoodFeature;
import org.allenai.nlpstack.parse.poly.reranking.VerbnetTransform;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scopt.OptionParser;
import scopt.Read$;

public final class ParseRerankerTraining$ {
    public static final ParseRerankerTraining$ MODULE$;
    private static Symbol symbol$1;

    static {
        symbol$1 = Symbol$.MODULE$.apply("cpos");
        new ParseRerankerTraining$();
    }

    public void main(String[] args) {
        OptionParser<PRTCommandLine> optionParser = new OptionParser<PRTCommandLine>(){
            {
                this.opt('g', "goldfile", Read$.MODULE$.stringRead()).required().valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PRTCommandLine apply(String x, PRTCommandLine c) {
                        String x$6 = x;
                        String x$7 = c.copy$default$1();
                        String x$8 = c.copy$default$2();
                        String x$9 = c.copy$default$3();
                        String x$10 = c.copy$default$5();
                        String x$11 = c.copy$default$6();
                        String x$12 = c.copy$default$7();
                        String x$13 = c.copy$default$8();
                        Option<String> x$14 = c.copy$default$9();
                        return c.copy(x$7, x$8, x$9, x$6, x$10, x$11, x$12, x$13, x$14);
                    }
                }).text("the file containing the gold parses");
                this.opt('h', "othergoldfile", Read$.MODULE$.stringRead()).required().valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PRTCommandLine apply(String x, PRTCommandLine c) {
                        String x$15 = x;
                        String x$16 = c.copy$default$1();
                        String x$17 = c.copy$default$2();
                        String x$18 = c.copy$default$3();
                        String x$19 = c.copy$default$4();
                        String x$20 = c.copy$default$5();
                        String x$21 = c.copy$default$6();
                        String x$22 = c.copy$default$7();
                        Option<String> x$23 = c.copy$default$9();
                        return c.copy(x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$15, x$23);
                    }
                }).text("the file containing the other gold parses");
                this.opt('p', "parser", Read$.MODULE$.stringRead()).required().valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PRTCommandLine apply(String x, PRTCommandLine c) {
                        String x$24 = x;
                        String x$25 = c.copy$default$1();
                        String x$26 = c.copy$default$2();
                        String x$27 = c.copy$default$4();
                        String x$28 = c.copy$default$5();
                        String x$29 = c.copy$default$6();
                        String x$30 = c.copy$default$7();
                        String x$31 = c.copy$default$8();
                        Option<String> x$32 = c.copy$default$9();
                        return c.copy(x$25, x$26, x$24, x$27, x$28, x$29, x$30, x$31, x$32);
                    }
                }).text("the file containing the JSON configuration for the parser");
                this.opt('c', "clusters", Read$.MODULE$.stringRead()).valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PRTCommandLine apply(String x, PRTCommandLine c) {
                        String x$33 = x;
                        String x$34 = c.copy$default$1();
                        String x$35 = c.copy$default$2();
                        String x$36 = c.copy$default$3();
                        String x$37 = c.copy$default$4();
                        String x$38 = c.copy$default$5();
                        String x$39 = c.copy$default$7();
                        String x$40 = c.copy$default$8();
                        Option<String> x$41 = c.copy$default$9();
                        return c.copy(x$34, x$35, x$36, x$37, x$38, x$33, x$39, x$40, x$41);
                    }
                }).text("the path to the Brown cluster files (in Liang format, comma-separated filenames)");
                this.opt('o', "outputfile", Read$.MODULE$.stringRead()).required().valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PRTCommandLine apply(String x, PRTCommandLine c) {
                        String x$42 = x;
                        String x$43 = c.copy$default$1();
                        String x$44 = c.copy$default$2();
                        String x$45 = c.copy$default$3();
                        String x$46 = c.copy$default$4();
                        String x$47 = c.copy$default$5();
                        String x$48 = c.copy$default$6();
                        String x$49 = c.copy$default$8();
                        Option<String> x$50 = c.copy$default$9();
                        return c.copy(x$43, x$44, x$45, x$46, x$47, x$48, x$42, x$49, x$50);
                    }
                }).text("where to write the reranking function");
                this.opt('d', "datasource", Read$.MODULE$.stringRead()).required().valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PRTCommandLine apply(String x, PRTCommandLine c) {
                        String x$51 = x;
                        String x$52 = c.copy$default$1();
                        String x$53 = c.copy$default$2();
                        String x$54 = c.copy$default$3();
                        String x$55 = c.copy$default$4();
                        String x$56 = c.copy$default$6();
                        String x$57 = c.copy$default$7();
                        String x$58 = c.copy$default$8();
                        Option<String> x$59 = c.copy$default$9();
                        return c.copy(x$52, x$53, x$54, x$55, x$51, x$56, x$57, x$58, x$59);
                    }
                }).text("the location of the data ('datastore','local')").validate((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Either<String, BoxedUnit> apply(String x) {
                        return ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"datastore", "local"}))).contains((Object)x) ? this.$outer.success() : this.$outer.failure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported data source: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.opt('t', "feature-taggers-config", Read$.MODULE$.stringRead()).valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PRTCommandLine apply(String x, PRTCommandLine c) {
                        Some x$60 = new Some((Object)x);
                        String x$61 = c.copy$default$1();
                        String x$62 = c.copy$default$2();
                        String x$63 = c.copy$default$3();
                        String x$64 = c.copy$default$4();
                        String x$65 = c.copy$default$5();
                        String x$66 = c.copy$default$6();
                        String x$67 = c.copy$default$7();
                        String x$68 = c.copy$default$8();
                        return c.copy(x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, (Option<String>)x$60);
                    }
                }).text("the path to a config filecontaining config information required for the required taggers. Currently contains datastore location info to access Verbnet resources for the Verbnet tagger.");
            }
        };
        PRTCommandLine clArgs = (PRTCommandLine)optionParser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new PRTCommandLine(PRTCommandLine$.MODULE$.apply$default$1(), PRTCommandLine$.MODULE$.apply$default$2(), PRTCommandLine$.MODULE$.apply$default$3(), PRTCommandLine$.MODULE$.apply$default$4(), PRTCommandLine$.MODULE$.apply$default$5(), PRTCommandLine$.MODULE$.apply$default$6(), PRTCommandLine$.MODULE$.apply$default$7(), PRTCommandLine$.MODULE$.apply$default$8(), PRTCommandLine$.MODULE$.apply$default$9())).get();
        Predef$.MODULE$.println((Object)"Creating reranker.");
        Option taggersConfigOption = clArgs.taggersConfigPathOption().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Config apply(String x) {
                return ConfigFactory.parseFile((File)new File(x));
            }
        });
        Option verbnetTransformOption = taggersConfigOption.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Tuple2<String, VerbnetTransform>> apply(Config taggersConfig) {
                return Config$.MODULE$.EnhancedConfig(taggersConfig).get("verbnet", Config.ConfigReader$.MODULE$.typesafeConfigReader()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<Tuple2<String, VerbnetTransform>> apply(Config verbnetConfig) {
                        return Config$.MODULE$.EnhancedConfig(verbnetConfig).get("group", Config.ConfigReader$.MODULE$.stringReader()).flatMap((Function1)new Serializable(this, verbnetConfig){
                            public static final long serialVersionUID = 0L;
                            public final Config verbnetConfig$1;

                            public final Option<Tuple2<String, VerbnetTransform>> apply(String groupName) {
                                return Config$.MODULE$.EnhancedConfig(this.verbnetConfig$1).get("name", Config.ConfigReader$.MODULE$.stringReader()).flatMap((Function1)new Serializable(this, groupName){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$10$$anonfun$apply$3$$anonfun$apply$4 $outer;
                                    public final String groupName$1;

                                    public final Option<Tuple2<String, VerbnetTransform>> apply(String artifactName) {
                                        return Config$.MODULE$.EnhancedConfig(this.$outer.verbnetConfig$1).get("version", Config.ConfigReader$.MODULE$.intReader()).map((Function1)new Serializable(this, artifactName){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$10$$anonfun$apply$3$$anonfun$apply$4$$anonfun$apply$5 $outer;
                                            private final String artifactName$1;

                                            public final Tuple2<String, VerbnetTransform> apply(int version) {
                                                return new Tuple2((Object)"verbnet", (Object)new VerbnetTransform(new Verbnet(this.$outer.groupName$1, this.artifactName$1, version)));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.artifactName$1 = artifactName$1;
                                            }
                                        });
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.groupName$1 = groupName$1;
                                    }
                                });
                            }
                            {
                                this.verbnetConfig$1 = verbnetConfig$1;
                            }
                        });
                    }
                });
            }
        });
        ParseNodeFeatureUnion feature = this.defaultParseNodeFeature((Option<Tuple2<String, VerbnetTransform>>)verbnetTransformOption);
        RerankingFunctionTrainer rerankingFunctionTrainer = new RerankingFunctionTrainer(feature);
        PolytreeParseSource goldParseSource = InMemoryPolytreeParseSource$.MODULE$.getParseSource(clArgs.goldParseFilename(), new ConllX(true, true), clArgs.dataSource());
        int nbestSize = 20;
        TransitionParser parser = TransitionParser$.MODULE$.load(clArgs.parserFilename());
        Predef$.MODULE$.println((Object)"Creating training data.");
        InMemoryParsePoolSource trainingPools = new InMemoryParsePoolSource(ParseFile$.MODULE$.nbestParseTestSet(parser, goldParseSource, nbestSize));
        Predef$.MODULE$.println((Object)"Training reranker.");
        Tuple2<RerankingFunction, WrapperClassifier> tuple2 = rerankingFunctionTrainer.trainRerankingFunction(goldParseSource, trainingPools);
        if (tuple2 != null) {
            RerankingFunction rerankingFunction = (RerankingFunction)tuple2._1();
            WrapperClassifier classifier = (WrapperClassifier)tuple2._2();
            if (rerankingFunction != null) {
                Tuple2 tuple22;
                RerankingFunction rerankingFunction2 = rerankingFunction;
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)rerankingFunction2, (Object)classifier);
                RerankingFunction rerankingFunction3 = (RerankingFunction)tuple23._1();
                WrapperClassifier classifier2 = (WrapperClassifier)tuple23._2();
                Predef$.MODULE$.println((Object)"Creating test data.");
                PolytreeParseSource otherGoldParseSource = InMemoryPolytreeParseSource$.MODULE$.getParseSource(clArgs.otherGoldParseFilename(), new ConllX(true, true), clArgs.dataSource());
                InMemoryParsePoolSource testPools = new InMemoryParsePoolSource(ParseFile$.MODULE$.nbestParseTestSet(parser, otherGoldParseSource, nbestSize));
                TrainingData testData = this.createTrainingData(otherGoldParseSource, testPools, feature);
                Predef$.MODULE$.println((Object)"Evaluating test vectors.");
                this.evaluate(testData, classifier2);
                Predef$.MODULE$.println((Object)"Saving reranking function.");
                RerankingFunction$.MODULE$.save(rerankingFunction3, clArgs.rerankerFilename());
                return;
            }
        }
        throw new MatchError(tuple2);
    }

    public ParseNodeFeatureUnion defaultParseNodeFeature(Option<Tuple2<String, VerbnetTransform>> verbnetTransformOption) {
        return new ParseNodeFeatureUnion((Seq<ParseNodeFeature>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransformedNeighborhoodFeature[]{new TransformedNeighborhoodFeature((Seq<Tuple2<String, NeighborhoodExtractor>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"children", (Object)AllChildrenExtractor$.MODULE$)}))), (Seq<Tuple2<String, NeighborhoodTransform>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"card", (Object)CardinalityNhTransform$.MODULE$)})))), new TransformedNeighborhoodFeature((Seq<Tuple2<String, NeighborhoodExtractor>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"self", (Object)SelfExtractor$.MODULE$), new Tuple2((Object)"parent", (Object)EachParentExtractor$.MODULE$), new Tuple2((Object)"child", (Object)EachChildExtractor$.MODULE$), new Tuple2((Object)"parent1", (Object)new SpecificParentExtractor(0)), new Tuple2((Object)"parent2", (Object)new SpecificParentExtractor(1)), new Tuple2((Object)"parent3", (Object)new SpecificParentExtractor(2)), new Tuple2((Object)"parent4", (Object)new SpecificParentExtractor(3)), new Tuple2((Object)"child1", (Object)new SpecificChildExtractor(0)), new Tuple2((Object)"child2", (Object)new SpecificChildExtractor(1)), new Tuple2((Object)"child3", (Object)new SpecificChildExtractor(2)), new Tuple2((Object)"child4", (Object)new SpecificChildExtractor(3)), new Tuple2((Object)"child5", (Object)new SpecificChildExtractor(4))}))), (Seq<Tuple2<String, NeighborhoodTransform>>)((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"cpos", (Object)new PropertyNhTransform(symbol$1)), new Tuple2((Object)"suffix", (Object)new SuffixNhTransform((Seq<String>)((Seq)WordClusters$.MODULE$.suffixes().toSeq().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Symbol x$2) {
                return x$2.name();
            }
        }, Seq$.MODULE$.canBuildFrom())))), new Tuple2((Object)"keyword", (Object)new KeywordNhTransform((Seq<String>)((Seq)WordClusters$.MODULE$.stopWords().toSeq().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Symbol x$3) {
                return x$3.name();
            }
        }, Seq$.MODULE$.canBuildFrom()))))}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(verbnetTransformOption), Seq$.MODULE$.canBuildFrom()))), new TransformedNeighborhoodFeature((Seq<Tuple2<String, NeighborhoodExtractor>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"parent1", (Object)new SelfAndSpecificParentExtractor(0)), new Tuple2((Object)"parent2", (Object)new SelfAndSpecificParentExtractor(1)), new Tuple2((Object)"parent3", (Object)new SelfAndSpecificParentExtractor(2)), new Tuple2((Object)"parent4", (Object)new SelfAndSpecificParentExtractor(3)), new Tuple2((Object)"child1", (Object)new SelfAndSpecificChildExtractor(0)), new Tuple2((Object)"child2", (Object)new SelfAndSpecificChildExtractor(1)), new Tuple2((Object)"child3", (Object)new SelfAndSpecificChildExtractor(2)), new Tuple2((Object)"child4", (Object)new SelfAndSpecificChildExtractor(3)), new Tuple2((Object)"child5", (Object)new SelfAndSpecificChildExtractor(4))}))), (Seq<Tuple2<String, NeighborhoodTransform>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"alabel", (Object)ArclabelNhTransform$.MODULE$), new Tuple2((Object)"direction", (Object)DirectionNhTransform$.MODULE$)}))))}))));
    }

    public TrainingData createTrainingData(PolytreeParseSource goldParseSource, ParsePoolSource parsePools, ParseNodeFeature feature) {
        Predef$.MODULE$.println((Object)"Creating gold parse map.");
        Map goldParseMap = goldParseSource.parseIterator().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, PolytreeParse> apply(PolytreeParse parse2) {
                return new Tuple2((Object)parse2.sentence().asWhitespaceSeparatedString(), (Object)parse2);
            }
        }).toMap(Predef$.MODULE$.$conforms());
        Predef$.MODULE$.println((Object)"Creating negative (non-weird) examples.");
        Iterable positiveExamples = parsePools.poolIterator().flatMap((Function1)new Serializable(feature, goldParseMap){
            public static final long serialVersionUID = 0L;
            public final ParseNodeFeature feature$1;
            private final Map goldParseMap$1;

            public final IndexedSeq<Tuple2<FeatureVector, Object>> apply(ParsePool parsePool) {
                Tuple2 parse2 = (Tuple2)parsePool.parses().head();
                PolytreeParse goldParse = (PolytreeParse)this.goldParseMap$1.apply((Object)((PolytreeParse)parse2._1()).sentence().asWhitespaceSeparatedString());
                return (IndexedSeq)((TraversableLike)package$.MODULE$.Range().apply(0, goldParse.sentence().tokens().size()).filter((Function1)new Serializable(this, goldParse){
                    public static final long serialVersionUID = 0L;
                    private final PolytreeParse goldParse$1;
                    private static Symbol symbol$2;
                    private static Symbol symbol$3;

                    static {
                        symbol$2 = Symbol$.MODULE$.apply("cpos");
                        symbol$3 = Symbol$.MODULE$.apply(".");
                    }

                    public final boolean apply(int tokenIndex) {
                        return this.apply$mcZI$sp(tokenIndex);
                    }

                    public boolean apply$mcZI$sp(int tokenIndex) {
                        Symbol symbol = ((Token)this.goldParse$1.sentence().tokens().apply(tokenIndex)).getDeterministicProperty(symbol$2);
                        Symbol symbol2 = symbol$3;
                        return symbol != null ? !symbol.equals(symbol2) : symbol2 != null;
                    }
                    {
                        this.goldParse$1 = goldParse$1;
                    }
                })).map((Function1)new Serializable(this, goldParse){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.12 $outer;
                    private final PolytreeParse goldParse$1;

                    public final Tuple2<FeatureVector, Object> apply(int tokenIndex) {
                        return new Tuple2(this.$outer.feature$1.apply(this.goldParse$1, BoxesRunTime.boxToInteger((int)tokenIndex)), (Object)BoxesRunTime.boxToInteger((int)0));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.goldParse$1 = goldParse$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.feature$1 = feature$1;
                this.goldParseMap$1 = goldParseMap$1;
            }
        }).toIterable();
        Predef$.MODULE$.println((Object)"Creating positive (weird) examples.");
        Iterable negativeExamples = (Iterable)package$.MODULE$.Range().apply(0, 3).flatMap((Function1)new Serializable(parsePools, feature, goldParseMap){
            public static final long serialVersionUID = 0L;
            private final ParsePoolSource parsePools$1;
            public final ParseNodeFeature feature$1;
            public final Map goldParseMap$1;

            public final Iterator<Tuple2<FeatureVector, Object>> apply(int x$4) {
                Iterator parsePairs = this.parsePools$1.poolIterator().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.13 $outer;

                    public final GenTraversableOnce<Tuple2<PolytreeParse, PolytreeParse>> apply(ParsePool parsePool) {
                        return (GenTraversableOnce)package$.MODULE$.Range().apply(0, 1).map((Function1)new Serializable(this, parsePool){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$13$$anonfun$14 $outer;
                            private final ParsePool parsePool$1;

                            public final Tuple2<PolytreeParse, PolytreeParse> apply(int i) {
                                PolytreeParse randomParse = this.parsePool$1.chooseRandomParse();
                                return new Tuple2((Object)randomParse, this.$outer.org$allenai$nlpstack$parse$poly$reranking$ParseRerankerTraining$$anonfun$$anonfun$$$outer().goldParseMap$1.apply((Object)randomParse.sentence().asWhitespaceSeparatedString()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.parsePool$1 = parsePool$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                    }

                    public /* synthetic */ anonfun.13 org$allenai$nlpstack$parse$poly$reranking$ParseRerankerTraining$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return parsePairs.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.13 $outer;

                    public final Set<Tuple2<FeatureVector, Object>> apply(Tuple2<PolytreeParse, PolytreeParse> x0$1) {
                        Tuple2<PolytreeParse, PolytreeParse> tuple2 = x0$1;
                        if (tuple2 != null) {
                            PolytreeParse candidateParse = (PolytreeParse)tuple2._1();
                            PolytreeParse goldParse = (PolytreeParse)tuple2._2();
                            Set badTokens = (Set)((SetLike)candidateParse.families().toSet().$minus$minus((GenTraversableOnce)goldParse.families().toSet())).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(Neighborhood x0$2) {
                                    Neighborhood neighborhood = x0$2;
                                    int n = BoxesRunTime.unboxToInt((Object)neighborhood.tokens().head());
                                    return n;
                                }
                            }, Set$.MODULE$.canBuildFrom());
                            Set set = (Set)((SetLike)badTokens.filter((Function1)new Serializable(this, goldParse){
                                public static final long serialVersionUID = 0L;
                                private final PolytreeParse goldParse$2;
                                private static Symbol symbol$4;
                                private static Symbol symbol$5;

                                static {
                                    symbol$4 = Symbol$.MODULE$.apply("cpos");
                                    symbol$5 = Symbol$.MODULE$.apply(".");
                                }

                                public final boolean apply(int tokenIndex) {
                                    return this.apply$mcZI$sp(tokenIndex);
                                }

                                public boolean apply$mcZI$sp(int tokenIndex) {
                                    Symbol symbol = ((Token)this.goldParse$2.sentence().tokens().apply(tokenIndex)).getDeterministicProperty(symbol$4);
                                    Symbol symbol2 = symbol$5;
                                    return symbol != null ? !symbol.equals(symbol2) : symbol2 != null;
                                }
                                {
                                    this.goldParse$2 = goldParse$2;
                                }
                            })).map((Function1)new Serializable(this, candidateParse){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$13$$anonfun$apply$9 $outer;
                                private final PolytreeParse candidateParse$1;

                                public final Tuple2<FeatureVector, Object> apply(int badToken) {
                                    return new Tuple2(this.$outer.org$allenai$nlpstack$parse$poly$reranking$ParseRerankerTraining$$anonfun$$anonfun$$$outer().feature$1.apply(this.candidateParse$1, BoxesRunTime.boxToInteger((int)badToken)), (Object)BoxesRunTime.boxToInteger((int)1));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.candidateParse$1 = candidateParse$1;
                                }
                            }, Set$.MODULE$.canBuildFrom());
                            return set;
                        }
                        throw new MatchError(tuple2);
                    }

                    public /* synthetic */ anonfun.13 org$allenai$nlpstack$parse$poly$reranking$ParseRerankerTraining$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.parsePools$1 = parsePools$1;
                this.feature$1 = feature$1;
                this.goldParseMap$1 = goldParseMap$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " positive examples "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)positiveExamples.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and ", " negative examples"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)negativeExamples.size())}))).toString());
        return new TrainingData((Iterable<Tuple2<FeatureVector, Object>>)((IterableLike)positiveExamples.$plus$plus((GenTraversableOnce)negativeExamples, Iterable$.MODULE$.canBuildFrom())).toIterable());
    }

    public void evaluate(TrainingData trainingData, WrapperClassifier classifier) {
        int numCorrect = trainingData.labeledVectors().count((Function1)new Serializable(classifier){
            public static final long serialVersionUID = 0L;
            private final WrapperClassifier classifier$1;

            public final boolean apply(Tuple2<FeatureVector, Object> x0$3) {
                Tuple2<FeatureVector, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    FeatureVector vec = (FeatureVector)tuple2._1();
                    int outcome2 = tuple2._2$mcI$sp();
                    boolean bl = this.classifier$1.classify(vec)._1$mcI$sp() == outcome2;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.classifier$1 = classifier$1;
            }
        });
        int total = trainingData.labeledVectors().size();
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)numCorrect));
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)total));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Accuracy: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)numCorrect / (float)total))})));
    }

    private ParseRerankerTraining$() {
        MODULE$ = this;
    }
}

