/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.nlpstack.parse.poly.polyparser;

import org.allenai.nlpstack.parse.poly.eval.ParseEvaluator$;
import org.allenai.nlpstack.parse.poly.eval.ParseStatistic;
import org.allenai.nlpstack.parse.poly.eval.PathAccuracy$;
import org.allenai.nlpstack.parse.poly.eval.UnlabeledBreadcrumbAccuracy$;
import org.allenai.nlpstack.parse.poly.polyparser.ConllX;
import org.allenai.nlpstack.parse.poly.polyparser.ConllX$;
import org.allenai.nlpstack.parse.poly.polyparser.FileBasedPolytreeParseSource$;
import org.allenai.nlpstack.parse.poly.polyparser.OracleRerankingFunction;
import org.allenai.nlpstack.parse.poly.polyparser.ParseFile$;
import org.allenai.nlpstack.parse.poly.polyparser.ParseFileConfig;
import org.allenai.nlpstack.parse.poly.polyparser.ParseFileConfig$;
import org.allenai.nlpstack.parse.poly.polyparser.ParserConfiguration;
import org.allenai.nlpstack.parse.poly.polyparser.PolytreeParse;
import org.allenai.nlpstack.parse.poly.polyparser.PolytreeParseFileFormat;
import org.allenai.nlpstack.parse.poly.polyparser.PolytreeParseSource;
import org.allenai.nlpstack.parse.poly.polyparser.RerankingTransitionParser;
import org.allenai.nlpstack.parse.poly.polyparser.TransitionParser;
import org.allenai.nlpstack.parse.poly.polyparser.TransitionParser$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.compat.Platform$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scopt.OptionParser;
import scopt.Read$;

public final class ParseFile$ {
    public static final ParseFile$ MODULE$;
    private final int defaultOracleNbest;

    static {
        new ParseFile$();
    }

    public int defaultOracleNbest() {
        return this.defaultOracleNbest;
    }

    public void main(String[] args) {
        OptionParser<ParseFileConfig> optionParser = new OptionParser<ParseFileConfig>(){
            {
                this.opt('c', "config", Read$.MODULE$.stringRead()).required().valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ParseFileConfig apply(String x, ParseFileConfig c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4());
                    }
                }).text("the file containing the JSON  configuration for the parser");
                this.opt('t', "test", Read$.MODULE$.stringRead()).required().valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ParseFileConfig apply(String x, ParseFileConfig c) {
                        String x$2 = x;
                        String x$3 = c.copy$default$1();
                        String x$4 = c.copy$default$3();
                        int x$5 = c.copy$default$4();
                        return c.copy(x$3, x$2, x$4, x$5);
                    }
                }).text("the file containing the test parses to parse and compare against (in ConllX format, comma-separated filenames)");
                this.opt('d', "datasource", Read$.MODULE$.stringRead()).required().valueName("<file>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ParseFileConfig apply(String x, ParseFileConfig c) {
                        String x$6 = x;
                        String x$7 = c.copy$default$1();
                        String x$8 = c.copy$default$2();
                        int x$9 = c.copy$default$4();
                        return c.copy(x$7, x$8, x$6, x$9);
                    }
                }).text("the location of the data ('datastore','local')").validate((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Either<String, BoxedUnit> apply(String x) {
                        return ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"datastore", "local"}))).contains((Object)x) ? this.$outer.success() : this.$outer.failure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported data source: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.opt('o', "oraclenbest", Read$.MODULE$.intRead()).required().valueName("<int>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ParseFileConfig apply(int x, ParseFileConfig c) {
                        int x$10 = x;
                        String x$11 = c.copy$default$1();
                        String x$12 = c.copy$default$2();
                        String x$13 = c.copy$default$3();
                        return c.copy(x$11, x$12, x$13, x$10);
                    }
                }).text("n-best list size for oracle evaluation");
            }
        };
        ParseFileConfig config = (ParseFileConfig)optionParser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new ParseFileConfig(ParseFileConfig$.MODULE$.apply$default$1(), ParseFileConfig$.MODULE$.apply$default$2(), ParseFileConfig$.MODULE$.apply$default$3(), ParseFileConfig$.MODULE$.apply$default$4())).get();
        TransitionParser parser = TransitionParser$.MODULE$.load(config.configFilename());
        this.fullParseEvaluation(parser, config.testFilename(), new ConllX(true, ConllX$.MODULE$.apply$default$2()), config.dataSource(), config.oracleNbest());
    }

    public void parseTestSet(TransitionParser parser, PolytreeParseSource parseSource) {
        Predef$.MODULE$.println((Object)"Parsing test set.");
        long startTime = Platform$.MODULE$.currentTime();
        Iterator candidateParses = parseSource.parseIterator().map((Function1)new Serializable(parser){
            public static final long serialVersionUID = 0L;
            private final TransitionParser parser$2;

            public final Option<PolytreeParse> apply(PolytreeParse parse) {
                return this.parser$2.parse(parse.sentence(), this.parser$2.parse$default$2());
            }
            {
                this.parser$2 = parser$2;
            }
        });
        UnlabeledBreadcrumbAccuracy$ stat = UnlabeledBreadcrumbAccuracy$.MODULE$;
        stat.reset();
        PathAccuracy$.MODULE$.reset();
        ParseEvaluator$.MODULE$.evaluate((Iterator<Option<PolytreeParse>>)candidateParses, parseSource.parseIterator(), (Set<ParseStatistic>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParseStatistic[]{stat, PathAccuracy$.MODULE$}))));
        double parsingDurationInSeconds = (double)(Platform$.MODULE$.currentTime() - startTime) / 1000.0;
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Parsed %d sentences in %.1f seconds, an average of %.1f sentences per second.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stat.numParses()), BoxesRunTime.boxToDouble((double)parsingDurationInSeconds), BoxesRunTime.boxToDouble((double)(1.0 * (double)stat.numParses() / parsingDurationInSeconds))})));
    }

    public void oracleParseTestSet(TransitionParser parser, PolytreeParseSource parseSource, int oracleNbestSize) {
        TransitionParser transitionParser = parser;
        if (transitionParser instanceof RerankingTransitionParser) {
            RerankingTransitionParser rerankingTransitionParser = (RerankingTransitionParser)transitionParser;
            OracleRerankingFunction oracleRerankingFunction = new OracleRerankingFunction(parseSource.parseIterator());
            ParserConfiguration oracleParserConfig = new ParserConfiguration(rerankingTransitionParser.config().parsingCostFunction(), oracleRerankingFunction, oracleNbestSize);
            RerankingTransitionParser parser2 = new RerankingTransitionParser(oracleParserConfig);
            this.parseTestSet(parser2, parseSource);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Predef$.MODULE$.println((Object)"Must use RerankingTransitionParser to do oracle parsing.");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void fullParseEvaluation(TransitionParser parser, String testFiles, PolytreeParseFileFormat testFileFormat, String dataSource, int oracleNbestSize) {
        Map testSources = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])testFiles.split(",")).map((Function1)new Serializable(testFileFormat, dataSource){
            public static final long serialVersionUID = 0L;
            private final PolytreeParseFileFormat testFileFormat$1;
            private final String dataSource$1;

            public final Tuple2<String, PolytreeParseSource> apply(String path) {
                return new Tuple2((Object)path, (Object)FileBasedPolytreeParseSource$.MODULE$.getParseSource(path, this.testFileFormat$1, this.dataSource$1));
            }
            {
                this.testFileFormat$1 = testFileFormat$1;
                this.dataSource$1 = dataSource$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        testSources.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, PolytreeParseSource> check$ifrefutable$1) {
                Tuple2<String, PolytreeParseSource> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(parser, oracleNbestSize){
            public static final long serialVersionUID = 0L;
            private final TransitionParser parser$1;
            private final int oracleNbestSize$1;

            public final void apply(Tuple2<String, PolytreeParseSource> x$1) {
                Tuple2<String, PolytreeParseSource> tuple2 = x$1;
                if (tuple2 != null) {
                    String sourcePath = (String)tuple2._1();
                    PolytreeParseSource testSource = (PolytreeParseSource)tuple2._2();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking parser accuracy on test set ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourcePath})));
                    ParseFile$.MODULE$.parseTestSet(this.parser$1, testSource);
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking oracle accuracy on test set ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourcePath})));
                    ParseFile$.MODULE$.oracleParseTestSet(this.parser$1, testSource, this.oracleNbestSize$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.parser$1 = parser$1;
                this.oracleNbestSize$1 = oracleNbestSize$1;
            }
        });
    }

    private ParseFile$() {
        MODULE$ = this;
        this.defaultOracleNbest = 50;
    }
}

