/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.AlluxioURI;
import alluxio.CommonTestUtils;
import alluxio.ConfigurationRule;
import alluxio.PropertyKey;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.URIStatus;
import alluxio.client.lineage.LineageContext;
import alluxio.exception.status.UnavailableException;
import alluxio.hadoop.FaultTolerantFileSystem;
import alluxio.hadoop.FileSystem;
import alluxio.hadoop.HadoopClientTestUtils;
import alluxio.hadoop.HadoopUtils;
import alluxio.wire.FileInfo;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={FileSystemContext.class, FileSystemMasterClient.class, UserGroupInformation.class})
@PowerMockIgnore(value={"javax.security.*"})
public class AbstractFileSystemTest {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileSystemTest.class);
    private FileSystemContext mMockFileSystemContext;
    private FileSystemContext mMockFileSystemContextCustomized;
    private FileSystemMasterClient mMockFileSystemMasterClient;
    @Rule
    public ExpectedException mExpectedException = ExpectedException.none();

    @Before
    public void before() throws Exception {
        this.mockFileSystemContextAndMasterClient();
        this.mockUserGroupInformation("");
        if (HadoopClientTestUtils.isHadoop1x()) {
            LOG.debug("Running Alluxio FS tests against hadoop 1x");
        } else if (HadoopClientTestUtils.isHadoop2x()) {
            LOG.debug("Running Alluxio FS tests against hadoop 2x");
        } else {
            LOG.warn("Running Alluxio FS tests against untargeted Hadoop version: " + HadoopClientTestUtils.getHadoopVersion());
        }
    }

    @After
    public void after() {
        HadoopClientTestUtils.resetClient();
    }

    @Test
    public void hadoopShouldLoadFaultTolerantFileSystemWhenConfigured() throws Exception {
        Configuration conf = new Configuration();
        if (HadoopClientTestUtils.isHadoop1x()) {
            conf.set("fs.alluxio-ft.impl", FaultTolerantFileSystem.class.getName());
        }
        URI uri = URI.create("alluxio-ft://localhost:19998/tmp/path.txt");
        try (Closeable c = new ConfigurationRule((Map)ImmutableMap.of((Object)PropertyKey.MASTER_HOSTNAME, (Object)uri.getHost(), (Object)PropertyKey.MASTER_RPC_PORT, (Object)Integer.toString(uri.getPort()), (Object)PropertyKey.ZOOKEEPER_ENABLED, (Object)"true")).toResource();){
            org.apache.hadoop.fs.FileSystem fs = org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
            Assert.assertTrue((boolean)(fs instanceof FaultTolerantFileSystem));
        }
    }

    @Test
    public void loadFaultTolerantSystemWhenUsingNoAuthority() throws Exception {
        Configuration conf = new Configuration();
        if (HadoopClientTestUtils.isHadoop1x()) {
            conf.set("fs.alluxio-ft.impl", FaultTolerantFileSystem.class.getName());
        }
        URI uri = URI.create("alluxio-ft:///tmp/path.txt");
        try (Closeable c = new ConfigurationRule(PropertyKey.ZOOKEEPER_ENABLED, "true").toResource();){
            org.apache.hadoop.fs.FileSystem fs = org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
            Assert.assertTrue((boolean)(fs instanceof FaultTolerantFileSystem));
        }
    }

    @Test
    public void hadoopShouldLoadFileSystemWhenConfigured() throws Exception {
        Configuration conf = this.getConf();
        URI uri = URI.create("alluxio://localhost:19998/tmp/path.txt");
        try (Closeable c = new ConfigurationRule((Map)ImmutableMap.of((Object)PropertyKey.MASTER_HOSTNAME, (Object)uri.getHost(), (Object)PropertyKey.MASTER_RPC_PORT, (Object)Integer.toString(uri.getPort()), (Object)PropertyKey.ZOOKEEPER_ENABLED, (Object)"false")).toResource();){
            org.apache.hadoop.fs.FileSystem fs = org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
            Assert.assertTrue((boolean)(fs instanceof FileSystem));
        }
    }

    @Test
    public void resetContext() throws Exception {
        URI uri = URI.create("alluxio://otherhost:410/");
        org.apache.hadoop.fs.FileSystem fileSystem = org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)this.getConf());
        InetSocketAddress newAddress = new InetSocketAddress("otherhost", 410);
        Assert.assertEquals((Object)newAddress, (Object)CommonTestUtils.getInternalState((Object)LineageContext.INSTANCE, (String[])new String[]{"mLineageMasterClientPool", "mMasterAddress"}));
    }

    @Test
    public void concurrentInitialize() throws Exception {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        final Configuration conf = this.getConf();
        Mockito.when((Object)this.mMockFileSystemContext.getMasterAddress()).thenReturn((Object)new InetSocketAddress("randomhost", 410));
        for (int i = 0; i < 100; ++i) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    URI uri = URI.create("alluxio://randomhost:410/");
                    try {
                        org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
                    }
                    catch (IOException e) {
                        Assert.fail();
                    }
                }
            });
            threads.add(t);
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
    }

    @Test
    public void initializeFailToConnect() throws Exception {
        ((FileSystemMasterClient)Mockito.doThrow((Throwable)new UnavailableException("test")).when((Object)this.mMockFileSystemMasterClient)).connect();
        URI uri = URI.create("alluxio://randomhost:400/");
        this.mExpectedException.expect(UnavailableException.class);
        org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)this.getConf());
    }

    @Test
    public void reinitializeWithDifferentURI() throws Exception {
        String[] newURIs;
        Configuration conf = this.getConf();
        String originalURI = "host1:1";
        URI uri = URI.create("alluxio://" + originalURI);
        org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
        Mockito.when((Object)this.mMockFileSystemContext.getMasterAddress()).thenReturn((Object)new InetSocketAddress("host1", 1));
        for (String newURI : newURIs = new String[]{"host2:1", "host1:2", "host2:2"}) {
            uri = URI.create("alluxio://" + newURI);
            org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
        }
    }

    @Test
    public void listStatus() throws Exception {
        FileInfo fileInfo1 = new FileInfo().setLastModificationTimeMs(111L).setFolder(false).setOwner("user1").setGroup("group1").setMode(493);
        FileInfo fileInfo2 = new FileInfo().setLastModificationTimeMs(222L).setFolder(true).setOwner("user2").setGroup("group2").setMode(420);
        Path path = new Path("/dir");
        alluxio.client.file.FileSystem alluxioFs = (alluxio.client.file.FileSystem)Mockito.mock(alluxio.client.file.FileSystem.class);
        Mockito.when((Object)alluxioFs.listStatus(new AlluxioURI(HadoopUtils.getPathWithoutScheme((Path)path)))).thenReturn((Object)Lists.newArrayList((Object[])new URIStatus[]{new URIStatus(fileInfo1), new URIStatus(fileInfo2)}));
        FileSystem alluxioHadoopFs = new FileSystem(alluxioFs);
        FileStatus[] fileStatuses = alluxioHadoopFs.listStatus(path);
        this.assertFileInfoEqualsFileStatus(fileInfo1, fileStatuses[0]);
        this.assertFileInfoEqualsFileStatus(fileInfo2, fileStatuses[1]);
        alluxioHadoopFs.close();
    }

    @Test
    public void getStatus() throws Exception {
        FileInfo fileInfo = new FileInfo().setLastModificationTimeMs(111L).setFolder(false).setOwner("user1").setGroup("group1").setMode(493);
        Path path = new Path("/dir");
        alluxio.client.file.FileSystem alluxioFs = (alluxio.client.file.FileSystem)Mockito.mock(alluxio.client.file.FileSystem.class);
        Mockito.when((Object)alluxioFs.getStatus(new AlluxioURI(HadoopUtils.getPathWithoutScheme((Path)path)))).thenReturn((Object)new URIStatus(fileInfo));
        FileSystem alluxioHadoopFs = new FileSystem(alluxioFs);
        FileStatus fileStatus = alluxioHadoopFs.getFileStatus(path);
        this.assertFileInfoEqualsFileStatus(fileInfo, fileStatus);
    }

    @Test
    public void initializeWithCustomizedUgi() throws Exception {
        this.mockUserGroupInformation("testuser");
        Configuration conf = this.getConf();
        URI uri = URI.create("alluxio://host:1");
        org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
    }

    @Test
    public void initializeWithFullPrincipalUgi() throws Exception {
        this.mockUserGroupInformation("testuser@ALLUXIO.COM");
        Configuration conf = this.getConf();
        URI uri = URI.create("alluxio://host:1");
        org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
    }

    private Configuration getConf() throws Exception {
        Configuration conf = new Configuration();
        if (HadoopClientTestUtils.isHadoop1x()) {
            conf.set("fs.alluxio.impl", FileSystem.class.getName());
        }
        return conf;
    }

    private void mockFileSystemContextAndMasterClient() throws Exception {
        this.mMockFileSystemContext = (FileSystemContext)PowerMockito.mock(FileSystemContext.class);
        this.mMockFileSystemContextCustomized = (FileSystemContext)PowerMockito.mock(FileSystemContext.class);
        PowerMockito.mockStatic(FileSystemContext.class, (Class[])new Class[0]);
        Whitebox.setInternalState(FileSystemContext.class, (String)"INSTANCE", (Object)this.mMockFileSystemContext);
        PowerMockito.when((Object)FileSystemContext.create((Subject)((Subject)Mockito.any(Subject.class)))).thenReturn((Object)this.mMockFileSystemContextCustomized);
        this.mMockFileSystemMasterClient = (FileSystemMasterClient)Mockito.mock(FileSystemMasterClient.class);
        Mockito.when((Object)this.mMockFileSystemContext.acquireMasterClient()).thenReturn((Object)this.mMockFileSystemMasterClient);
        Mockito.when((Object)this.mMockFileSystemContextCustomized.acquireMasterClient()).thenReturn((Object)this.mMockFileSystemMasterClient);
        ((FileSystemMasterClient)Mockito.doNothing().when((Object)this.mMockFileSystemMasterClient)).connect();
        Mockito.when((Object)this.mMockFileSystemContext.getMasterAddress()).thenReturn((Object)new InetSocketAddress("defaultHost", 1));
    }

    private void mockUserGroupInformation(String username) throws IOException {
        PowerMockito.mockStatic(UserGroupInformation.class, (Class[])new Class[0]);
        UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)UserGroupInformation.getCurrentUser()).thenReturn((Object)ugi);
        Mockito.when((Object)ugi.getUserName()).thenReturn((Object)username);
        Mockito.when((Object)ugi.getShortUserName()).thenReturn((Object)username.split("@")[0]);
    }

    private void assertFileInfoEqualsFileStatus(FileInfo info, FileStatus status) {
        Assert.assertEquals((Object)info.getOwner(), (Object)status.getOwner());
        Assert.assertEquals((Object)info.getGroup(), (Object)status.getGroup());
        Assert.assertEquals((long)info.getMode(), (long)status.getPermission().toShort());
        Assert.assertEquals((long)info.getLastModificationTimeMs(), (long)status.getModificationTime());
        Assert.assertEquals((Object)info.isFolder(), (Object)status.isDir());
    }
}

