/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.client.file.FileSystemContext;
import alluxio.client.lineage.LineageContext;
import alluxio.hadoop.AbstractFileSystem;
import java.net.URL;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.reflect.Whitebox;

public final class HadoopClientTestUtils {
    public static void resetClient() {
        try {
            FileSystemContext.INSTANCE.reset();
            LineageContext.INSTANCE.reset();
            Whitebox.setInternalState(AbstractFileSystem.class, (String)"sInitialized", (Object)false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isHadoop1x() {
        return HadoopClientTestUtils.getHadoopVersion().startsWith("1");
    }

    public static boolean isHadoop2x() {
        return HadoopClientTestUtils.getHadoopVersion().startsWith("2");
    }

    public static String getHadoopVersion() {
        return "2.2.0";
    }

    private static URL getSourcePath(Class<?> clazz) {
        try {
            clazz = HadoopClientTestUtils.getClassLoader(clazz).loadClass(clazz.getName());
            return clazz.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)("Unable to find class " + clazz.getName()));
        }
    }

    private static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof MockClassLoader) {
            cl = cl.getParent();
        }
        return cl;
    }
}

