/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.Configuration;
import alluxio.ConfigurationTestUtils;
import alluxio.PropertyKey;
import alluxio.hadoop.HadoopConfigurationUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public final class HadoopConfigurationUtilsTest {
    private static final String TEST_S3_ACCCES_KEY = "TEST ACCESS KEY";
    private static final String TEST_S3_SECRET_KEY = "TEST SECRET KEY";
    private static final String TEST_ALLUXIO_PROPERTY = "alluxio.unsupported.parameter";
    private static final String TEST_ALLUXIO_VALUE = "alluxio.unsupported.value";

    @After
    public void after() {
        ConfigurationTestUtils.resetConfiguration();
    }

    @Test
    public void mergeEmptyHadoopConfiguration() {
        org.apache.hadoop.conf.Configuration hadoopConfig = new org.apache.hadoop.conf.Configuration();
        long beforeSize = Configuration.toMap().size();
        HadoopConfigurationUtils.mergeHadoopConfiguration((org.apache.hadoop.conf.Configuration)hadoopConfig);
        long afterSize = Configuration.toMap().size();
        Assert.assertEquals((long)beforeSize, (long)afterSize);
    }

    @Test
    public void mergeHadoopConfiguration() {
        org.apache.hadoop.conf.Configuration hadoopConfig = new org.apache.hadoop.conf.Configuration();
        hadoopConfig.set(PropertyKey.S3N_ACCESS_KEY.toString(), TEST_S3_ACCCES_KEY);
        hadoopConfig.set(PropertyKey.S3N_SECRET_KEY.toString(), TEST_S3_SECRET_KEY);
        hadoopConfig.set(TEST_ALLUXIO_PROPERTY, TEST_ALLUXIO_VALUE);
        hadoopConfig.set("hadoop.config.parameter", "hadoop config value");
        long beforeSize = Configuration.toMap().size();
        HadoopConfigurationUtils.mergeHadoopConfiguration((org.apache.hadoop.conf.Configuration)hadoopConfig);
        long afterSize = Configuration.toMap().size();
        Assert.assertEquals((long)(beforeSize + 2L), (long)afterSize);
        Assert.assertEquals((Object)TEST_S3_ACCCES_KEY, (Object)Configuration.get((PropertyKey)PropertyKey.S3N_ACCESS_KEY));
        Assert.assertEquals((Object)TEST_S3_SECRET_KEY, (Object)Configuration.get((PropertyKey)PropertyKey.S3N_SECRET_KEY));
    }
}

