/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.hadoop.HadoopConfigurationUtils;
import alluxio.util.ConfigurationUtils;
import java.io.IOException;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class HadoopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtils.class);

    public static String getPathWithoutScheme(Path path) {
        return path.toUri().getPath();
    }

    public static String getAlluxioFileName(String path) {
        if (path.isEmpty()) {
            return "/";
        }
        while (path.contains(":")) {
            int index = path.indexOf(":");
            path = path.substring(index + 1);
        }
        while (!path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public static String toStringHadoopFileSplit(FileSplit fs) {
        String[] locs;
        StringBuilder sb = new StringBuilder();
        sb.append("HadoopFileSplit: Path: ").append(fs.getPath());
        sb.append(" , Start: ").append(fs.getStart());
        sb.append(" , Length: ").append(fs.getLength());
        sb.append(" , Hosts: ");
        try {
            locs = fs.getLocations();
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            locs = new String[]{};
        }
        for (String loc : locs) {
            sb.append(loc).append("; ");
        }
        return sb.toString();
    }

    public static String toStringHadoopFileStatus(FileStatus fs) {
        StringBuilder sb = new StringBuilder();
        sb.append("HadoopFileStatus: Path: ").append(fs.getPath());
        sb.append(" , Length: ").append(fs.getLen());
        sb.append(" , IsDir: ").append(fs.isDir());
        sb.append(" , BlockReplication: ").append(fs.getReplication());
        sb.append(" , BlockSize: ").append(fs.getBlockSize());
        sb.append(" , ModificationTime: ").append(fs.getModificationTime());
        sb.append(" , AccessTime: ").append(fs.getAccessTime());
        sb.append(" , Permission: ").append(fs.getPermission());
        sb.append(" , Owner: ").append(fs.getOwner());
        sb.append(" , Group: ").append(fs.getGroup());
        return sb.toString();
    }

    public static void addSwiftCredentials(Configuration configuration) {
        PropertyKey[] propertyNames = new PropertyKey[]{PropertyKey.SWIFT_TENANT_KEY, PropertyKey.SWIFT_USER_KEY, PropertyKey.SWIFT_AUTH_URL_KEY, PropertyKey.SWIFT_AUTH_METHOD_KEY, PropertyKey.SWIFT_PASSWORD_KEY, PropertyKey.SWIFT_SIMULATION, PropertyKey.SWIFT_REGION_KEY};
        HadoopUtils.setConfigurationFromSystemProperties(configuration, propertyNames);
    }

    private static void setConfigurationFromSystemProperties(Configuration configuration, PropertyKey[] propertyNames) {
        for (PropertyKey propertyName : propertyNames) {
            HadoopUtils.setConfigurationFromSystemProperty(configuration, propertyName.toString());
        }
    }

    private static void setConfigurationFromSystemProperty(Configuration configuration, String propertyName) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null && configuration.get(propertyName) == null) {
            configuration.set(propertyName, propertyValue);
        }
    }

    public static Path toPath(AlluxioURI alluxioURI) {
        return new Path(alluxioURI.toString());
    }

    public static AlluxioConfiguration toAlluxioConf(Configuration conf) {
        Map<String, Object> hadoopConfProperties = HadoopConfigurationUtils.getConfigurationFromHadoop(conf);
        AlluxioProperties alluxioProps = ConfigurationUtils.defaults();
        alluxioProps.merge(hadoopConfProperties, Source.RUNTIME);
        return new InstancedConfiguration(alluxioProps);
    }

    private HadoopUtils() {
    }
}

